// toevoegen tekstblok
function addTekstblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = parseInt(document.querySelectorAll(".va-custom-post-artikelblokken-item").length) + 1;

    artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "Titel van de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "Tekst van de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));
    // artikelblokContent.appendChild(createCustomPostInput("selectTekstblok", "Soort tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_typeTekstblok", arrValue["typeTekstblok"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen tekstblok column
function addTekstblokColumn(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = parseInt(document.querySelectorAll(".va-custom-post-artikelblokken-item").length) + 1;

    artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "Titel van de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "Tekst van de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));
    artikelblokContent.appendChild(createCustomPostInput("input", "Quote van de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_quote", arrValue["quote"]));
    artikelblokContent.appendChild(createCustomPostInput("selectTekstblokColumn", "Uitlijning van de tekst:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_typeTekstblokColumn", arrValue["typeTekstblokColumn"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen linkblok
function addLinkblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "Titel van de linkblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("input", "Url of e-mailadres voor de linkblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_url", arrValue["url"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "Tekst van de linkblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));
    artikelblokContent.appendChild(createCustomPostInput("selectLinkblok", "Soort linkblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_typeLinkblok", arrValue["typeLinkblok"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen documentblok
function addDocumentblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "Titel van het document:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("fileUpload", "Het bestand voor achter de link:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_file", arrValue["file"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "Tekst van de documentblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen afbeeldingblok met tekst
function addAfbeeldingblokTekst(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "Titel van de tekstblok naast de afbeeldingblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "Tekst van de tekstblok naast de afbeeldingblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));
    artikelblokContent.appendChild(createCustomPostInput("singleImage", "De afbeelding voor naast de tekstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_afbeelding", arrValue["afbeelding"]));
    artikelblokContent.appendChild(createCustomPostInput("selectAfbeeldingblok", "Soort afbeelding:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_typeAfbeeldingblok", arrValue["typeAfbeeldingblok"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen afbeeldingblok
function addAfbeeldingblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("singleImage", "De afbeelding van de afbeeldingblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_afbeelding", arrValue["afbeelding"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen videoblok youtube
function addVideoblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue);

    artikelblokContent.appendChild(createCustomPostInput("input", "De url van de YouTube video:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_videourl", arrValue["videourl"]));

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen galerijblok
function addGalerijblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue),
        artikelblokImageContainer = document.createElement("div"),
        artikelblokControls = document.createElement("div"),
        artikelblokAddImageRow = document.createElement("div");

    artikelblokImageContainer.classList.add("va-custom-post-galerij-container");
    artikelblokControls.classList.add("va-custom-post-galerij-controls");
    artikelblokAddImageRow.classList.add("va-custom-post-galerij-control-add-image-row");
    artikelblokAddImageRow.setAttribute("onclick", "addImageRowToGallerijblok(this)");
    artikelblokAddImageRow.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';

    artikelblokControls.appendChild(artikelblokAddImageRow);

    if (arrValue["afbeeldingen"] == "") {
        artikelblokImageContainer.appendChild(createCustomPostInput("galerijImage", "De afbeeldingen voor de galerijblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_galerijItems_0", { imgId: "", name: "", url: "" }));
    } else {
        for (let i = 0; i < arrValue["afbeeldingen"].length; i++) {
            if (i == 0) {
                artikelblokImageContainer.appendChild(createCustomPostInput("galerijImage", "De afbeeldingen voor de galerijblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_galerijItems_" + i, arrValue["afbeeldingen"][i]));
            } else {
                artikelblokImageContainer.appendChild(createCustomPostInput("galerijImage", "none", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_galerijItems_" + i, arrValue["afbeeldingen"][i]));
            }
        }
    }

    artikelblokContent.appendChild(artikelblokImageContainer);
    artikelblokContent.appendChild(artikelblokControls);

    addToContainer(artikelblokContent, artikelPositie);
}

// toevoegen lijstblok
function addLijstblok(custompostname, arrValue) {
    let artikelPositie = getArtikelPositie(),
        artikelblokContent = createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue),
        artikelblokLijstContainer = document.createElement("div"),
        artikelblokControls = document.createElement("div"),
        artikelblokAddLijstRow = document.createElement("div");

    artikelblokLijstContainer.classList.add("va-custom-post-lijst-container");
    artikelblokControls.classList.add("va-custom-post-lijst-controls");
    artikelblokAddLijstRow.classList.add("va-custom-post-lijst-control-add-lijst-row");
    artikelblokAddLijstRow.setAttribute("onclick", "addLijstItemRowToLijstblok(this)");
    artikelblokAddLijstRow.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';

    artikelblokControls.appendChild(artikelblokAddLijstRow);

    if (arrValue["lijstitems"] == "") {
        artikelblokLijstContainer.appendChild(createCustomPostInput("lijstItem", "none", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_lijstItems_0", { titel: "", text: "" }));
    } else {
        for (let i = 0; i < arrValue["lijstitems"].length; i++) {
            if (i == 0) {
                artikelblokLijstContainer.appendChild(createCustomPostInput("lijstItem", "none", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_lijstItems_" + i, arrValue["lijstitems"][i]));
            } else {
                artikelblokLijstContainer.appendChild(createCustomPostInput("lijstItem", "none", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_lijstItems_" + i, arrValue["lijstitems"][i]));
            }
        }
    }

    artikelblokContent.appendChild(createCustomPostInput("input", "De overkoepelende titel van de lijstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_titel", arrValue["titel"]));
    artikelblokContent.appendChild(createCustomPostInput("textarea", "De overkoepelende tekst van de lijstblok:", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_text", arrValue["text"]));

    // artikelblokLijstContainer.appendChild(createCustomPostInput('lijstItem', 'none', 'va'+custompostname+"Artikelblokken_"+artikelPositie+"_lijstItems_0", {'titel': arrValue['titel'], 'text': arrValue['text']}));

    artikelblokContent.appendChild(artikelblokLijstContainer);
    artikelblokContent.appendChild(artikelblokControls);

    addToContainer(artikelblokContent, artikelPositie);
}

// ophalen van positie van element die moet aangemaakt worden
function getArtikelPositie() {
    let artikelPositie;

    if (document.querySelectorAll(".va-custom-post-artikelblokken-item").length == 0) {
        artikelPositie = 0;
    } else {
        artikelPositie = document.querySelectorAll(".va-custom-post-artikelblokken-item").length;
    }

    return artikelPositie;
}

// aanmaken default container met hidden inputs
function createCustomPostDefaultContainer(artikelPositie, custompostname, arrValue) {
    let artikelblokContent = document.createElement("div"),
        artikelblokPositie = document.createElement("input"),
        artikelblokType = document.createElement("input");

    artikelblokContent.classList.add("va-custom-post-artikelblokken-content");

    artikelblokPositie.setAttribute("type", "hidden");
    artikelblokPositie.classList.add("artikelblokPositieInput");
    artikelblokPositie.setAttribute("name", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_position");
    artikelblokPositie.setAttribute("value", artikelPositie);

    artikelblokType.setAttribute("type", "hidden");
    artikelblokType.classList.add("artikelblokTypeInput");
    artikelblokType.setAttribute("name", "va" + custompostname + "Artikelblokken_" + artikelPositie + "_type");
    artikelblokType.setAttribute("value", arrValue["type"]);

    artikelblokContent.appendChild(artikelblokPositie);
    artikelblokContent.appendChild(artikelblokType);

    return artikelblokContent;
}

// aanmaken van verschillende mogelijke velden aan de hand van properties
function createCustomPostInput(type, label, name, value) {
    let customPostInputContainer = document.createElement("div"),
        customPostLabel = document.createElement("label"),
        customPostField;

    customPostInputContainer.classList.add("va-custom-post-input");

    if (label != "none") {
        customPostLabel.innerText = label;
        customPostInputContainer.appendChild(customPostLabel);
    }

    if (type == "input") {
        customPostField = document.createElement("input");
        customPostField.setAttribute("name", name);
        customPostField.setAttribute("value", value);
        customPostField.setAttribute("autocomplete", "off");
    }

    if (type == "textarea") {
        customPostField = document.createElement("textarea");
        customPostField.setAttribute("name", name);
        customPostField.setAttribute("id", name);
        customPostField.setAttribute("rows", 5);
        customPostField.innerText = value;
    }

    if (type == "selectTekstblok") {
        customPostField = document.createElement("select");
        customPostField.setAttribute("name", name);
        let customPostOption1 = document.createElement("option"),
            customPostOption2 = document.createElement("option"),
            customPostOption3 = document.createElement("option"),
            customPostOption4 = document.createElement("option");

        customPostOption1.setAttribute("value", "tekstblok-normaal");
        customPostOption1.innerText = "Een normale tekstblok";
        customPostOption2.setAttribute("value", "tekstblok-sterk");
        customPostOption2.innerText = "Een opvallende tekstblok";
        customPostOption3.setAttribute("value", "tekstblok-extra-sterk");
        customPostOption3.innerText = "Een extra opvallende tekstblok";
        customPostOption4.setAttribute("value", "tekstblok-quote");
        customPostOption4.innerText = "Een quote";

        if (value == "tekstblok-normaal") customPostOption1.selected = "selected";
        if (value == "tekstblok-sterk") customPostOption2.selected = "selected";
        if (value == "tekstblok-extra-sterk") customPostOption3.selected = "selected";
        if (value == "tekstblok-quote") customPostOption4.selected = "selected";

        customPostField.appendChild(customPostOption1);
        customPostField.appendChild(customPostOption2);
        customPostField.appendChild(customPostOption3);
        customPostField.appendChild(customPostOption4);
    }

    if (type == "selectTekstblokColumn") {
        customPostField = document.createElement("select");
        customPostField.setAttribute("name", name);
        let customPostOption1 = document.createElement("option"),
            customPostOption2 = document.createElement("option");

        customPostOption1.setAttribute("value", "tekstblok-left");
        customPostOption1.innerText = "Tekst links uitlijnen";
        customPostOption2.setAttribute("value", "tekstblok-right");
        customPostOption2.innerText = "Tekst rechts uitlijnen";

        if (value == "tekstblok-left") customPostOption1.selected = "selected";
        if (value == "tekstblok-right") customPostOption2.selected = "selected";

        customPostField.appendChild(customPostOption1);
        customPostField.appendChild(customPostOption2);
    }

    if (type == "selectLinkblok") {
        customPostField = document.createElement("select");
        customPostField.setAttribute("name", name);
        let customPostOption1 = document.createElement("option"),
            customPostOption2 = document.createElement("option"),
            customPostOption3 = document.createElement("option");

        customPostOption1.setAttribute("value", "linkblok-intern");
        customPostOption1.innerText = "Een interne link (binnen deze website)";
        customPostOption2.setAttribute("value", "linkblok-extern");
        customPostOption2.innerText = "Een externe link (buiten deze website)";
        customPostOption3.setAttribute("value", "linkblok-mail");
        customPostOption3.innerText = "Een e-mail link";

        if (value == "linkblok-intern") customPostOption1.selected = "selected";
        if (value == "linkblok-extern") customPostOption2.selected = "selected";
        if (value == "linkblok-mail") customPostOption3.selected = "selected";

        customPostField.appendChild(customPostOption1);
        customPostField.appendChild(customPostOption2);
        customPostField.appendChild(customPostOption3);
    }

    if (type == "selectAfbeeldingblok") {
        customPostField = document.createElement("select");
        customPostField.setAttribute("name", name);
        let customPostOption1 = document.createElement("option"),
            customPostOption2 = document.createElement("option");

        customPostOption1.setAttribute("value", "text-left");
        customPostOption1.innerText = "Tekst links";
        customPostOption2.setAttribute("value", "text-right");
        customPostOption2.innerText = "Tekst rechts";

        if (value == "text-left") customPostOption1.selected = "selected";
        if (value == "text-right") customPostOption2.selected = "selected";

        customPostField.appendChild(customPostOption1);
        customPostField.appendChild(customPostOption2);
    }

    if (type == "singleImage") {
        value = value.replace("[", "").replace("]", "").split(",");
        let customPostImage = document.createElement("div"),
            customPostImageRow = document.createElement("div"),
            customPostImageRowPreview = document.createElement("div"),
            customPostImageRowPreviewInner = document.createElement("div"),
            customPostImageRowName = document.createElement("label"),
            customPostImageRowInput = document.createElement("input"),
            customPostImageRowControls = document.createElement("div"),
            customPostImageRowControlEdit = document.createElement("div"),
            customPostImageRowControlDelete = document.createElement("div");

        customPostImage.classList.add("va-custom-post-image");
        customPostImageRow.classList.add("va-custom-post-image-row");
        customPostImageRowPreview.classList.add("va-custom-post-image-row-preview");
        customPostImageRowPreviewInner.classList.add("va-custom-post-image-row-preview-inner");
        customPostImageRowName.classList.add("va-custom-post-image-row-name");
        customPostImageRowControls.classList.add("va-custom-post-image-row-controls");
        customPostImageRowControlEdit.classList.add("va-custom-post-image-row-control-edit");
        customPostImageRowControlDelete.classList.add("va-custom-post-image-row-control-delete");

        customPostImageRowInput.setAttribute("name", name);
        customPostImageRowInput.setAttribute("type", "hidden");
        customPostImageRowInput.setAttribute("value", value[0]);

        if (value == "") {
            customPostImageRowName.innerHTML = "Geen afbeelding gekozen";
        } else {
            customPostImageRowPreviewInner.style.backgroundImage = "url(" + value[2] + ")";
            customPostImageRowName.innerText = value[1];
        }

        customPostImageRowControlEdit.setAttribute("onclick", "add_image_uploader(this)");
        customPostImageRowControlEdit.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';
        customPostImageRowControlDelete.setAttribute("onclick", "remove_image_uploader(this)");
        customPostImageRowControlDelete.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path><path d="M0 0h24v24H0z" fill="none"></path></svg>';

        customPostImageRowPreview.appendChild(customPostImageRowPreviewInner);
        customPostImageRow.appendChild(customPostImageRowPreview);

        customPostImageRow.appendChild(customPostImageRowName);
        customPostImageRow.appendChild(customPostImageRowInput);

        customPostImageRowControls.appendChild(customPostImageRowControlEdit);
        customPostImageRowControls.appendChild(customPostImageRowControlDelete);
        customPostImageRow.appendChild(customPostImageRowControls);

        customPostImage.appendChild(customPostImageRow);
        customPostField = customPostImage;
    }

    if (type == "galerijImage") {
        let customPostImage = document.createElement("div"),
            customPostImageRow = document.createElement("div"),
            customPostImageRowPreview = document.createElement("div"),
            customPostImageRowPreviewInner = document.createElement("div"),
            customPostImageRowName = document.createElement("label"),
            customPostImageRowInput = document.createElement("input"),
            customPostImageRowControls = document.createElement("div"),
            customPostImageRowControlEdit = document.createElement("div"),
            customPostImageRowControlDelete = document.createElement("div");

        customPostImage.classList.add("va-custom-post-image");
        customPostImageRow.classList.add("va-custom-post-image-row");
        customPostImageRowPreview.classList.add("va-custom-post-image-row-preview");
        customPostImageRowPreviewInner.classList.add("va-custom-post-image-row-preview-inner");
        customPostImageRowName.classList.add("va-custom-post-image-row-name");
        customPostImageRowControls.classList.add("va-custom-post-image-row-controls");
        customPostImageRowControlEdit.classList.add("va-custom-post-image-row-control-edit");
        customPostImageRowControlDelete.classList.add("va-custom-post-image-row-control-delete");

        customPostImageRowInput.setAttribute("name", name);
        customPostImageRowInput.setAttribute("type", "hidden");
        customPostImageRowInput.setAttribute("value", value["imgId"]);

        if (value["name"] == "") {
            customPostImageRowName.innerHTML = "Geen afbeelding gekozen";
        } else {
            customPostImageRowPreviewInner.style.backgroundImage = "url(" + value["url"] + ")";
            customPostImageRowName.innerText = value["name"];
        }

        customPostImageRowControlEdit.setAttribute("onclick", "add_image_galerij_uploader(this)");
        customPostImageRowControlEdit.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';
        customPostImageRowControlDelete.setAttribute("onclick", "remove_image_uploader(this)");
        customPostImageRowControlDelete.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path><path d="M0 0h24v24H0z" fill="none"></path></svg>';

        customPostImageRowPreview.appendChild(customPostImageRowPreviewInner);
        customPostImageRow.appendChild(customPostImageRowPreview);

        customPostImageRow.appendChild(customPostImageRowName);
        customPostImageRow.appendChild(customPostImageRowInput);

        customPostImageRowControls.appendChild(customPostImageRowControlEdit);
        customPostImageRowControls.appendChild(customPostImageRowControlDelete);
        customPostImageRow.appendChild(customPostImageRowControls);

        customPostImage.appendChild(customPostImageRow);
        customPostField = customPostImage;
    }

    if (type == "fileUpload") {
        value = value.replace("[", "").replace("]", "").split(",");
        let customPostFile = document.createElement("div"),
            customPostFileRow = document.createElement("div"),
            customPostFileRowIcon = document.createElement("div"),
            customPostFileRowName = document.createElement("label"),
            customPostFileRowInput = document.createElement("input"),
            customPostFileRowControls = document.createElement("div"),
            customPostFileRowControlEdit = document.createElement("div"),
            customPostFileRowControlDelete = document.createElement("div");

        customPostFile.classList.add("va-custom-post-file");
        customPostFileRow.classList.add("va-custom-post-file-row");
        customPostFileRowIcon.classList.add("va-custom-post-file-row-icon");
        customPostFileRowName.classList.add("va-custom-post-file-row-name");
        customPostFileRowControls.classList.add("va-custom-post-file-row-controls");
        customPostFileRowControlEdit.classList.add("va-custom-post-file-row-control-edit");
        customPostFileRowControlDelete.classList.add("va-custom-post-file-row-control-delete");

        customPostFileRowInput.setAttribute("name", name);
        customPostFileRowInput.setAttribute("type", "hidden");
        customPostFileRowInput.setAttribute("value", value[0]);

        if (value == "") {
            customPostFileRowName.innerHTML = "Geen bestand gekozen";
        } else {
            customPostFileRowIcon.classList.add("uploaded");
            customPostFileRowName.innerText = value[1];
        }

        customPostFileRowIcon.innerHTML =
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M16.5 6v11.5c0 2.21-1.79 4-4 4s-4-1.79-4-4V5a2.5 2.5 0 0 1 5 0v10.5c0 .55-.45 1-1 1s-1-.45-1-1V6H10v9.5a2.5 2.5 0 0 0 5 0V5c0-2.21-1.79-4-4-4S7 2.79 7 5v12.5c0 3.04 2.46 5.5 5.5 5.5s5.5-2.46 5.5-5.5V6h-1.5z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';

        customPostFileRowControlEdit.setAttribute("onclick", "add_file_uploader(this)");
        customPostFileRowControlEdit.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';
        customPostFileRowControlDelete.setAttribute("onclick", "remove_file_uploader(this)");
        customPostFileRowControlDelete.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path><path d="M0 0h24v24H0z" fill="none"></path></svg>';

        customPostFileRow.appendChild(customPostFileRowIcon);
        customPostFileRow.appendChild(customPostFileRowName);
        customPostFileRow.appendChild(customPostFileRowInput);

        customPostFileRowControls.appendChild(customPostFileRowControlEdit);
        customPostFileRowControls.appendChild(customPostFileRowControlDelete);
        customPostFileRow.appendChild(customPostFileRowControls);

        customPostFile.appendChild(customPostFileRow);
        customPostField = customPostFile;
    }

    if (type == "lijstItem") {
        let customPostLijst = document.createElement("div"),
            customPostLijstRow = document.createElement("div"),
            customPostLijstRowContent = document.createElement("div");
        (customPostLijstRowControls = document.createElement("div")), (customPostLijstRowControlDelete = document.createElement("div"));

        customPostLijst.classList.add("va-custom-post-lijst");
        customPostLijstRow.classList.add("va-custom-post-lijst-row");
        customPostLijstRowContent.classList.add("va-custom-post-lijst-row-content");
        customPostLijstRowControls.classList.add("va-custom-post-lijst-row-controls");
        customPostLijstRowControlDelete.classList.add("va-custom-post-lijst-row-control-delete");

        customPostLijstRowControlDelete.setAttribute("onclick", "remove_lijst_item(this)");
        customPostLijstRowControlDelete.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path><path d="M0 0h24v24H0z" fill="none"></path></svg>';

        customPostLijstRowContent.appendChild(createCustomPostInput("input", "Titel van het lijst item:", name + "_titel", value["titel"]));
        customPostLijstRowContent.appendChild(createCustomPostInput("textarea", "Tekst van het lijst item:", name + "_text", value["text"]));
        customPostLijstRow.appendChild(customPostLijstRowContent);

        customPostLijstRowControls.appendChild(customPostLijstRowControlDelete);
        customPostLijstRow.appendChild(customPostLijstRowControls);

        customPostLijst.appendChild(customPostLijstRow);
        customPostField = customPostLijst;
    }

    customPostInputContainer.appendChild(customPostField);

    return customPostInputContainer;
}

// plaats element in container en voeg controls toe
function addToContainer(artikelblokContent, artikelPositie) {
    let artikelblokItem = document.createElement("div"),
        artikelblokControls = document.createElement("div"),
        artikelblokControlMoveUp = document.createElement("div"),
        artikelblokControlMoveDown = document.createElement("div"),
        artikelblokControlDelete = document.createElement("div");

    artikelblokItem.classList.add("va-custom-post-artikelblokken-item");
    artikelblokItem.setAttribute("artikelPositie", artikelPositie);
    artikelblokControls.classList.add("va-custom-post-artikelblokken-controls");
    artikelblokControlMoveUp.classList.add("va-custom-post-artikelblokken-control-move-up");
    artikelblokControlMoveDown.classList.add("va-custom-post-artikelblokken-control-move-down");
    artikelblokControlDelete.classList.add("va-custom-post-artikelblokken-control-delete");

    artikelblokControlMoveUp.setAttribute("onclick", "moveElementUp(this)");
    artikelblokControlMoveUp.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';
    artikelblokControlMoveDown.setAttribute("onclick", "moveElementDown(this)");
    artikelblokControlMoveDown.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';
    artikelblokControlDelete.setAttribute("onclick", "removeElement(this)");
    artikelblokControlDelete.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/><path d="M0 0h24v24H0z" fill="none"/></svg>';

    artikelblokControls.appendChild(artikelblokControlMoveUp);
    artikelblokControls.appendChild(artikelblokControlMoveDown);
    artikelblokControls.appendChild(artikelblokControlDelete);

    artikelblokItem.appendChild(artikelblokContent);
    artikelblokItem.appendChild(artikelblokControls);

    document.querySelector(".va-custom-post-artikelblokken-container .va-custom-post-artikelblokken-elementen").appendChild(artikelblokItem);

    let artikelblokTextareaList = document.querySelectorAll(".va-custom-post-artikelblokken-container .va-custom-post-artikelblokken-elementen textarea");

    if (artikelblokTextareaList.length > 0) {
        artikelblokTextareaList.forEach(function (artikelblokTextarea) {
            let target = artikelblokTextarea;
            (artikelblokTextareaId = artikelblokTextarea.getAttribute("id")), (typeArtikelblok = "");

            while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
                target = target.parentNode;
            }

            if (target != null && target != undefined && target != artikelblokTextarea) {
                typeArtikelblok = target.querySelector('.artikelblokTypeInput[type="hidden"]');

                if (typeArtikelblok.value == "tekstblok" || typeArtikelblok.value == "tekstblokcolumn" || typeArtikelblok.value == "afbeeldingbloktekst" || typeArtikelblok.value == "lijstblok") {
                    if (!CKEDITOR.instances[artikelblokTextareaId]) {
                        CKEDITOR.replace(artikelblokTextareaId);
                    }
                }
            }
        });
    }
}

// verplaats indien mogelijk het element 1 positie naar boven
function moveElementUp(evt) {
    let target = evt,
        artikelPositie,
        elementToSwitch,
        elementToSwitchInnerHtml,
        elementToSwitchInputPositie,
        elementToSwitchWith,
        elementToSwitchWithInnerHtml,
        elementToSwitchWithInputPositie,
        arrElementCKeditor = [];

    while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
        target = target.parentNode;
    }

    artikelPositie = target.getAttribute("artikelPositie");

    if (artikelPositie != null && artikelPositie != undefined && document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + (parseInt(artikelPositie) - 1) + '"]') != null) {
        elementToSwitch = document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + artikelPositie + '"]');
        elementToSwitchWith = document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + (parseInt(artikelPositie) - 1) + '"]');

        elementToSwitchInputPositie = elementToSwitch.querySelector(".artikelblokPositieInput");
        elementToSwitchWithInputPositie = elementToSwitchWith.querySelector(".artikelblokPositieInput");

        elementToSwitchInputPositie.setAttribute("value", parseInt(artikelPositie) - 1);
        elementToSwitchWithInputPositie.setAttribute("value", artikelPositie);

        elementToSwitch.querySelectorAll('[name*="Artikelblokken_' + artikelPositie + '_"]').forEach(function (element) {
            let oldName = element.getAttribute("name"),
                newName = oldName.replace("Artikelblokken_" + artikelPositie + "_", "Artikelblokken_" + (parseInt(artikelPositie) - 1) + "_");

            if (element.tagName.toLowerCase() == "select") {
                element.options[element.selectedIndex].setAttribute("selected", "selected");
            }

            if (element.tagName.toLowerCase() == "textarea") {
                let editor = CKEDITOR.instances[oldName];
                if (editor != undefined) {
                    arrElementCKeditor.push(newName);
                    CKEDITOR.instances[oldName].destroy();
                }

                element.setAttribute("id", newName);
            }
            element.removeAttribute("name");
            element.setAttribute("name", newName);
        });

        elementToSwitchWith.querySelectorAll('[name*="Artikelblokken_' + (parseInt(artikelPositie) - 1) + '_"]').forEach(function (element) {
            let oldName = element.getAttribute("name"),
                newName = oldName.replace("Artikelblokken_" + (parseInt(artikelPositie) - 1) + "_", "Artikelblokken_" + artikelPositie + "_");

            if (element.tagName.toLowerCase() == "select") {
                element.options[element.selectedIndex].setAttribute("selected", "selected");
            }

            if (element.tagName.toLowerCase() == "textarea") {
                let editor = CKEDITOR.instances[oldName];
                if (editor != undefined) {
                    arrElementCKeditor.push(newName);
                    CKEDITOR.instances[oldName].destroy();
                }

                element.setAttribute("id", newName);
            }

            element.removeAttribute("name");
            element.setAttribute("name", newName);
        });

        elementToSwitchInnerHtml = elementToSwitch.innerHTML;
        elementToSwitchWithInnerHtml = elementToSwitchWith.innerHTML;

        elementToSwitch.innerHTML = elementToSwitchWithInnerHtml;
        elementToSwitchWith.innerHTML = elementToSwitchInnerHtml;

        for (let i = 0; i < arrElementCKeditor.length; i++) {
            CKEDITOR.replace(arrElementCKeditor[i]);
        }
    }
}

// verplaats indien mogelijk het element 1 positie naar onder
function moveElementDown(evt) {
    let target = evt,
        artikelPositie,
        elementToSwitch,
        elementToSwitchInnerHtml,
        elementToSwitchInputPositie,
        elementToSwitchWith,
        elementToSwitchWithInnerHtml,
        elementToSwitchWithInputPositie,
        arrElementCKeditor = [];

    while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
        target = target.parentNode;
    }

    artikelPositie = target.getAttribute("artikelPositie");

    if (artikelPositie != null && artikelPositie != undefined && document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + (parseInt(artikelPositie) + 1) + '"]') != null) {
        elementToSwitch = document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + artikelPositie + '"]');
        elementToSwitchWith = document.querySelector('.va-custom-post-artikelblokken-item[artikelPositie="' + (parseInt(artikelPositie) + 1) + '"]');

        elementToSwitchInputPositie = elementToSwitch.querySelector(".artikelblokPositieInput");
        elementToSwitchWithInputPositie = elementToSwitchWith.querySelector(".artikelblokPositieInput");

        elementToSwitchInputPositie.setAttribute("value", parseInt(artikelPositie) + 1);
        elementToSwitchWithInputPositie.setAttribute("value", artikelPositie);

        elementToSwitch.querySelectorAll('[name*="Artikelblokken_' + artikelPositie + '_"]').forEach(function (element) {
            let oldName = element.getAttribute("name"),
                newName = oldName.replace("Artikelblokken_" + artikelPositie + "_", "Artikelblokken_" + (parseInt(artikelPositie) + 1) + "_");

            if (element.tagName.toLowerCase() == "select") {
                element.options[element.selectedIndex].setAttribute("selected", "selected");
            }

            if (element.tagName.toLowerCase() == "textarea") {
                let editor = CKEDITOR.instances[oldName];
                if (editor != undefined) {
                    arrElementCKeditor.push(newName);
                    CKEDITOR.instances[oldName].destroy();
                }

                element.setAttribute("id", newName);
            }

            element.removeAttribute("name");
            element.setAttribute("name", newName);
        });

        elementToSwitchWith.querySelectorAll('[name*="Artikelblokken_' + (parseInt(artikelPositie) + 1) + '_"]').forEach(function (element) {
            let oldName = element.getAttribute("name"),
                newName = oldName.replace("Artikelblokken_" + (parseInt(artikelPositie) + 1) + "_", "Artikelblokken_" + artikelPositie + "_");

            if (element.tagName.toLowerCase() == "select") {
                element.options[element.selectedIndex].setAttribute("selected", "selected");
            }

            if (element.tagName.toLowerCase() == "textarea") {
                let editor = CKEDITOR.instances[oldName];
                if (editor != undefined) {
                    arrElementCKeditor.push(newName);
                    CKEDITOR.instances[oldName].destroy();
                }

                element.setAttribute("id", newName);
            }

            element.removeAttribute("name");
            element.setAttribute("name", newName);
        });

        elementToSwitchInnerHtml = elementToSwitch.innerHTML;
        elementToSwitchWithInnerHtml = elementToSwitchWith.innerHTML;

        elementToSwitch.innerHTML = elementToSwitchWithInnerHtml;
        elementToSwitchWith.innerHTML = elementToSwitchInnerHtml;

        for (let i = 0; i < arrElementCKeditor.length; i++) {
            CKEDITOR.replace(arrElementCKeditor[i]);
        }
    }
}

// vraag om bevestiging en verwijder indien ok het element uit de lijst
function removeElement(evt) {
    if (confirm("Bent u zeker dat u dit artikelblok wil gaan verwijderen?")) {
        let target = evt,
            parentElement,
            listElements,
            listLength;
        while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
            target = target.parentNode;
        }

        parentElement = target.parentNode;

        if (parentElement != null && parentElement != undefined && target != null && target != undefined) {
            listElements = parentElement.querySelectorAll(".va-custom-post-artikelblokken-item");
            listLength = listElements.length;

            for (let i = target.getAttribute("artikelpositie"); parseInt(i) + 1 < listLength; i++) {
                listElements[parseInt(i) + 1].querySelectorAll('[name*="Artikelblokken_' + (parseInt(i) + 1) + '_"]').forEach(function (element) {
                    let oldName = element.getAttribute("name"),
                        newName = oldName.replace("Artikelblokken_" + (parseInt(i) + 1) + "_", "Artikelblokken_" + i + "_");

                    if (element.tagName.toLowerCase() == "select") {
                        element.options[element.selectedIndex].setAttribute("selected", "selected");
                    }

                    element.removeAttribute("name");
                    element.setAttribute("name", newName);
                });
                listElements[parseInt(i) + 1].querySelector('[name*="Artikelblokken_' + i + '_position"]').setAttribute("value", i);
                listElements[parseInt(i) + 1].setAttribute("artikelpositie", i);
            }
            parentElement.removeChild(target);
        }
    }
}

// toevoegen van een extra foto aan de galerij
function addImageRowToGallerijblok(evt) {
    let target = evt,
        artikelblokImageContainer,
        nameattr;

    while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
        target = target.parentNode;
    }

    artikelblokImageContainer = target.querySelector(".va-custom-post-galerij-container");
    nameattr = artikelblokImageContainer.querySelector(".va-custom-post-image-row input[type=hidden]").getAttribute("name").split("_");

    nameattr = nameattr[0] + "_" + nameattr[1];

    artikelblokImageContainer.appendChild(createCustomPostInput("galerijImage", "none", nameattr + "_galerijItems_" + artikelblokImageContainer.querySelectorAll(".va-custom-post-image-row").length, { imgId: "", name: "", url: "" }));
}

// toevoegen van een extra foto aan de galerij
function addImageRowToSingleGallerijblok(evt) {
    let target = evt,
        artikelblokImageContainer,
        nameattr;

    while (!target.classList.contains("va-single-galerij-container")) {
        target = target.parentNode;
    }

    artikelblokImageContainer = target.querySelector(".va-custom-post-galerij-container");
    nameattr = artikelblokImageContainer.querySelector(".va-custom-post-image-row input[type=hidden]").getAttribute("name").split("_");

    nameattr = nameattr[0] + "_" + nameattr[1];

    artikelblokImageContainer.appendChild(createCustomPostInput("galerijImage", "none", nameattr + "_galerijItems_" + artikelblokImageContainer.querySelectorAll(".va-custom-post-image-row").length, { imgId: "", name: "", url: "" }));
}

// open file uploader van wordpress en bij selecteren foto + naam tonen
function add_image_uploader(evt) {
    let target = evt,
        imagePreview,
        imageLabel,
        imageInput;

    while (!target.classList.contains("va-custom-post-image-row")) {
        target = target.parentNode;
    }

    imagePreview = target.querySelector(".va-custom-post-image-row-preview-inner");
    imageLabel = target.querySelector(".va-custom-post-image-row-name");
    imageInput = target.querySelector("input[type=hidden]");

    custom_postimage_uploader = wp.media.frames.file_frame = wp.media({
        title: "Afbeelding toevoegen",
        library: {
            type: "image",
        },
        button: {
            text: "Deze foto gebruiken",
        },
        multiple: false,
    });
    custom_postimage_uploader.on("select", function () {
        let attachment = custom_postimage_uploader.state().get("selection").first().toJSON(),
            img_url = attachment["url"],
            img_id = attachment["id"];
        img_title = attachment["title"];

        imageLabel.innerText = img_title;
        imageInput.setAttribute("value", img_id);
        imagePreview.style.backgroundImage = "url(" + img_url + ")";
    });
    custom_postimage_uploader.on("open", function () {
        let selection = custom_postimage_uploader.state().get("selection"),
            selected = imageInput.value;
        if (selected) {
            selection.add(wp.media.attachment(selected));
        }
    });
    custom_postimage_uploader.open();
    return false;
}

// verwijder foto en preview
function remove_image_uploader(evt) {
    let target = evt,
        imagePreview,
        imageLabel,
        imageInput;

    while (!target.classList.contains("va-custom-post-image-row")) {
        target = target.parentNode;
    }

    imagePreview = target.querySelector(".va-custom-post-image-row-preview-inner");
    imageLabel = target.querySelector(".va-custom-post-image-row-name");
    imageInput = target.querySelector("input[type=hidden]");

    imageLabel.innerText = "Geen afbeelding gekozen";
    imageInput.removeAttribute("value");
    imagePreview.style.backgroundImage = "none";
}

// open file uploader van wordpress en bij selecteren foto + naam tonen
function add_image_galerij_uploader(evt) {
    let target = evt,
        imagePreview,
        imageLabel,
        imageInput;

    while (!target.classList.contains("va-custom-post-image-row")) {
        target = target.parentNode;
    }

    imagePreview = target.querySelector(".va-custom-post-image-row-preview-inner");
    imageLabel = target.querySelector(".va-custom-post-image-row-name");
    imageInput = target.querySelector("input[type=hidden]");

    custom_postimage_uploader = wp.media.frames.file_frame = wp.media({
        title: "Afbeelding toevoegen",
        library: {
            type: "image",
        },
        button: {
            text: "Deze foto gebruiken",
        },
        multiple: false,
    });
    custom_postimage_uploader.on("select", function () {
        let attachment = custom_postimage_uploader.state().get("selection").first().toJSON(),
            img_url = attachment["url"],
            img_id = attachment["id"];
        img_title = attachment["title"];

        imageLabel.innerText = img_title;
        imageInput.setAttribute("value", img_id);
        imagePreview.style.backgroundImage = "url(" + img_url + ")";
    });
    custom_postimage_uploader.on("open", function () {
        let selection = custom_postimage_uploader.state().get("selection"),
            selected = imageInput.value;
        if (selected) {
            selection.add(wp.media.attachment(selected));
        }
    });
    custom_postimage_uploader.open();
    return false;
}

// verwijder foto en preview
function remove_image_galerij_uploader(evt) {
    let target = evt,
        imagePreview,
        imageLabel,
        imageInput,
        positie,
        parentElement,
        listElements,
        listLength;

    while (!target.classList.contains("va-custom-post-input")) {
        target = target.parentNode;
    }

    positie = target.querySelector('[name*="Artikelblokken_"]').getAttribute("name").split("_")[3];

    parentElement = target.parentNode;

    if (parentElement != null && parentElement != undefined && target != null && target != undefined) {
        listElements = parentElement.querySelectorAll(".va-custom-post-input");
        listLength = listElements.length;

        if (listLength > 1) {
            for (let i = positie; parseInt(i) + 1 < listLength; i++) {
                let element = listElements[parseInt(i) + 1].querySelector('[name*="galerijItems_' + (parseInt(i) + 1) + '"]'),
                    oldName = element.getAttribute("name"),
                    newName = oldName.replace("galerijItems_" + (parseInt(i) + 1), "galerijItems_" + i);

                element.removeAttribute("name");
                element.setAttribute("name", newName);
            }
            parentElement.removeChild(target);
        } else {
            target = evt;
            while (!target.classList.contains("va-custom-post-image-row")) {
                target = target.parentNode;
            }

            imagePreview = target.querySelector(".va-custom-post-image-row-preview-inner");
            imageLabel = target.querySelector(".va-custom-post-image-row-name");
            imageInput = target.querySelector("input[type=hidden]");

            imageLabel.innerText = "Geen afbeelding gekozen";
            imageInput.removeAttribute("value");
            imagePreview.style.backgroundImage = "none";
        }
    }
}

// open file uploader van wordpress en bij selecteren naam tonen + icon wijzigen van kleur
function add_file_uploader(evt) {
    let target = evt,
        filePreview,
        fileLabel,
        fileInput;

    while (!target.classList.contains("va-custom-post-file-row")) {
        target = target.parentNode;
    }

    fileIcon = target.querySelector(".va-custom-post-file-row-icon");
    fileLabel = target.querySelector(".va-custom-post-file-row-name");
    fileInput = target.querySelector("input[type=hidden]");

    custom_postfile_uploader = wp.media.frames.file_frame = wp.media({
        title: "Bestand toevoegen",
        library: {
            type: "",
        },
        button: {
            text: "Dit bestand gebruiken",
        },
        multiple: false,
    });
    custom_postfile_uploader.on("select", function () {
        let attachment = custom_postfile_uploader.state().get("selection").first().toJSON(),
            file_id = attachment["id"];
        file_title = attachment["title"];

        fileLabel.innerText = file_title;
        fileInput.setAttribute("value", file_id);
        if (!fileIcon.classList.contains("uploaded")) {
            fileIcon.classList.add("uploaded");
        }
    });
    custom_postfile_uploader.on("open", function () {
        let selection = custom_postfile_uploader.state().get("selection"),
            selected = fileInput.value;
        if (selected) {
            selection.add(wp.media.attachment(selected));
        }
    });
    custom_postfile_uploader.open();
    return false;
}

// verwijder bestand en zet icon naar standaard kleur
function remove_file_uploader(evt) {
    let target = evt,
        fileIcon,
        fileLabel,
        fileInput;

    while (!target.classList.contains("va-custom-post-file-row")) {
        target = target.parentNode;
    }

    fileIcon = target.querySelector(".va-custom-post-file-row-icon");
    fileLabel = target.querySelector(".va-custom-post-file-row-name");
    fileInput = target.querySelector("input[type=hidden]");

    fileLabel.innerText = "Geen bestand gekozen";
    fileInput.removeAttribute("value");
    if (fileIcon.classList.contains("uploaded")) {
        fileIcon.classList.remove("uploaded");
    }
}

// toevoegen van een lijst item aan de lijstblok
function addLijstItemRowToLijstblok(evt) {
    let target = evt,
        artikelblokLijstContainer,
        nameattr;

    while (!target.classList.contains("va-custom-post-artikelblokken-item")) {
        target = target.parentNode;
    }

    artikelblokLijstContainer = target.querySelector(".va-custom-post-lijst-container");
    nameattr = artikelblokLijstContainer.querySelector(".va-custom-post-lijst-row input").getAttribute("name").split("_");

    nameattr = nameattr[0] + "_" + nameattr[1];

    nameattr = nameattr + "_lijstItems_" + artikelblokLijstContainer.querySelectorAll(".va-custom-post-lijst-row").length;

    artikelblokLijstContainer.appendChild(createCustomPostInput("lijstItem", "none", nameattr, { titel: "", text: "" }));

    if (artikelblokLijstContainer.querySelector("#" + nameattr + "_text") != null && artikelblokLijstContainer.querySelector("#" + nameattr + "_text") != undefined) {
        CKEDITOR.replace(nameattr + "_text");
    }
}

// verwijderen van een lijst item in de lijstblok en alle elementen naar boven verplaatsen
function remove_lijst_item(evt) {
    let target = evt,
        positie,
        parentElement,
        listElements,
        listLength,
        inputTitel,
        inputText;

    while (!target.classList.contains("va-custom-post-input")) {
        target = target.parentNode;
    }

    positie = target.querySelector('[name*="Artikelblokken_"]').getAttribute("name").split("_")[3];

    parentElement = target.parentNode;

    if (parentElement != null && parentElement != undefined && target != null && target != undefined) {
        listElements = parentElement.querySelectorAll(".va-custom-post-lijst-row");
        listLength = listElements.length;
        if (listLength > 1) {
            for (let i = positie; parseInt(i) + 1 < listLength; i++) {
                listElements[parseInt(i) + 1].querySelectorAll('[name*="lijstItems_' + (parseInt(i) + 1) + '_"]').forEach(function (element) {
                    let oldName = element.getAttribute("name"),
                        newName = oldName.replace("lijstItems_" + (parseInt(i) + 1), "lijstItems_" + i);

                    element.removeAttribute("name");
                    element.setAttribute("name", newName);
                });
            }
            parentElement.removeChild(target);
        } else {
            target = evt;
            while (!target.classList.contains("va-custom-post-image-row")) {
                target = target.parentNode;
            }

            target.querySelector('[name*="_titel"]').removeAttribute("value");
            target.querySelector('[name*="_text"]').innerText = "";
        }
    }
}
