<?php
/*
	==========================================
	 Update administrator role
	==========================================
*/

function va_add_administrator_role() {
    // Get the administrator role
    $role = get_role("administrator");

	// Configure custom post "service" capabilities
    $role->add_cap("read_private_references", true); // allow user to read private service
    $role->add_cap("edit_references", true); // allows editing of the userís own service
    $role->add_cap("edit_others_references", true); // allows the user to edit everyone else's service
    $role->add_cap("edit_published_references", true); // allows the user to edit published service
    $role->add_cap("edit_private_references", true); // allows the user to edit private service
    $role->add_cap("delete_published_references", true); // allows the user to delete published service
    $role->add_cap("delete_private_references", true); // allows the user to edit delete private service
    $role->add_cap("delete_references", true); // allows to delete service written by that user
    $role->add_cap("delete_others_references", true); // allows to delete service written by other users
    $role->add_cap("publish_references", true); // allows the user to publish service, otherwise posts stays in draft mode
}

add_action( "admin_init", "va_add_administrator_role");
?>