<?php
/*
	==========================================
	 Custom Post Type Reference
	==========================================
*/

function va_init_reference(){
	$labels = array(
        "name" => "Referenties",
        "singular_name" => "Referenties",
        "add_new" => "Referentie toevoegen",
        "all_items" => "Alle referenties",
        "add_new_item" => "Referentie toevoegen",
        "edit_item" => "Referentie wijzigen",
        "new_item" => "Referentie toevoegen",
        "view_item" => "Bekijk deze referentie",
        "search_item" => "Zoeken in de referenties",
        "not_found" => "Geen referenties gevonden",
        "not_found_in_trash" => "Geen referenties gevonden bij de verwijderde items",
        "parent_item_colon" => "Bovenliggende referentie"
	);
	$args = array(
        "labels" => $labels,
        "public" => true,
        "has_archive" => false,
        "publicly_queryable" => true,
        "query_var" => true,
        "rewrite" => array(
            "slug" => "referentie"
        ),
        "capability_type" => "post",
        "hierarchical" => false,
        "supports" => array(
            "title"
        ),
        "capabilities" => array(
            "edit_post" => "edit_reference",
            "edit_posts" => "edit_references",
            "edit_others_posts" => "edit_others_references",
            "edit_published_posts"=>"edit_published_references",
            "edit_private_posts"=>"edit_private_references",
            "publish_posts" => "publish_references",
            "read_post" => "read_references",
            "read_private_posts" => "read_private_references",
            "delete_post" => "delete_reference",
            "delete_posts"=>"delete_references",
            "delete_others_posts"=>"delete_others_references",
            "delete_published_posts"=>"delete_published_references",
            "delete_private_posts"=>"delete_private_references"
        ),
        "map_meta_cap" => true,
        "menu_icon"   => "dashicons-welcome-learn-more",
        "menu_position" => 5,
        "show_ui" => true,
        "exclude_from_search" => false
    );
    register_post_type("reference", $args);
}

function va_init_reference_meta_box(){
    add_meta_box("reference-info-meta-box", "Referentie info", "va_reference_info_meta_box_html", "reference", "normal", "high");
}

function va_reference_info_meta_box_html(){
    global $post;
	// ophalen data
	if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) return $post_id;
    
    $vaCustomValue = get_post_custom($post->ID);

    $vaReferenceCategory = $vaCustomValue["referenceCategory"][0];
    $vaReferenceTeaser = $vaCustomValue["referenceTeaser"][0];
    $vaReferenceImageList = $vaCustomValue["referenceImageList"][0];
    ?>
	<div class="va-custom-post-input">
		<label>De categorie waar deze referentie onder geplaatst wordt:</label>
        <select name="referenceCategory">
            <option value="">Selecteer een categorie</option>
            <option value="folder" <?php if($vaReferenceCategory == "folder"): echo "selected"; endif; ?>>folder</option>
            <option value="advertentie" <?php if($vaReferenceCategory == "advertentie"): echo "selected"; endif; ?>>advertentie</option>
            <option value="logo" <?php if($vaReferenceCategory == "logo"): echo "selected"; endif; ?>>logo</option>
            <option value="mailing" <?php if($vaReferenceCategory == "mailing"): echo "selected"; endif; ?>>mailing</option>
            <option value="interior" <?php if($vaReferenceCategory == "interior"): echo "selected"; endif; ?>>interior</option>
        </select>
    </div>
    <div class="va-custom-post-input">
        <label>De afbeelding voor deze referentie, deze afbeelding wordt weergegeven in de slider en als eerste beeld bij het klikken op de afbeelding:</label>
        <div class="va-custom-post-image">
            <div class="va-custom-post-image-row">
                <?php
                    if(!empty($vaReferenceTeaser) && $vaReferenceTeaser != ""){
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($vaReferenceTeaser, "thumbnail"); ?>');"></div>
                        </div>
                        <label class="va-custom-post-image-row-name"><?php echo va_file_name($vaReferenceTeaser); ?></label>
                        <input name="referenceTeaser" type="hidden" value="<?php echo $vaReferenceTeaser; ?>">
                        <?php
                    }else{
                        ?>
                        <div class="va-custom-post-image-row-preview">
                            <div class="va-custom-post-image-row-preview-inner"></div>
                        </div>
                        <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                        <input name="referenceTeaser" type="hidden" value="">
                        <?php
                    }
                ?>
                <div class="va-custom-post-image-row-controls">
                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                            <path d="M0 0h24v24H0z" fill="none"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="va-single-galerij-container">
        <div class="va-custom-post-galerij-container">
            <div class="va-custom-post-input">
                <label>Eventuele extra afbeeldingen voor de referentie, deze afbeeldingen worden achteraan het bestaande beeld toegevoegd en zijn zichtbaar na het klikken op bovenstaande afbeelding:</label>
                <div class="va-custom-post-image">
                    <?php
                    if(!empty($vaReferenceImageList) && $vaReferenceImageList != ""){
                        $vaReferenceImageList = json_decode($vaReferenceImageList, true);
                        foreach ($vaReferenceImageList as $key => $value) {
                            ?>
                            <div class="va-custom-post-image-row">
                                <div class="va-custom-post-image-row-preview">
                                    <div class="va-custom-post-image-row-preview-inner" style="background-image: url('<?php echo va_media_url($value, 'thumbnail'); ?>');"></div>
                                </div>
                                <label class="va-custom-post-image-row-name"><?php echo va_file_name($value); ?></label>
                                <input name="referenceImageList_<?php echo $key; ?>" type="hidden" value="<?php echo $value; ?>">
                                <div class="va-custom-post-image-row-controls">
                                    <div class="va-custom-post-image-row-control-edit" onclick="add_image_galerij_uploader(this)">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                                            <path d="M0 0h24v24H0z" fill="none"></path>
                                        </svg>
                                    </div>
                                    <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                                            <path d="M0 0h24v24H0z" fill="none"></path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    }else{
                        ?>
                        <div class="va-custom-post-image-row">
                            <div class="va-custom-post-image-row-preview">
                                <div class="va-custom-post-image-row-preview-inner"></div>
                            </div>
                            <label class="va-custom-post-image-row-name">Geen afbeelding gekozen</label>
                            <input name="referenceImageList_0" type="hidden" value="">
                            <div class="va-custom-post-image-row-controls">
                                <div class="va-custom-post-image-row-control-edit" onclick="add_image_galerij_uploader(this)">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                        <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                                        <path d="M0 0h24v24H0z" fill="none"></path>
                                    </svg>
                                </div>
                                <div class="va-custom-post-image-row-control-delete" onclick="remove_image_uploader(this)">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                        <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                                        <path d="M0 0h24v24H0z" fill="none"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
        <div class="va-custom-post-galerij-controls">
            <div class="va-custom-post-galerij-control-add-image-row" onclick="addImageRowToSingleGallerijblok(this)">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"></path>
                    <path d="M0 0h24v24H0z" fill="none"></path>
                </svg>
            </div>
        </div>
    </div>
    <?php
}

function va_reference_save(){
    global $post;

    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE) {
        return $post_id;
    } else {
        $vaReferenceImageList_array = array();
        $vaReferenceImageList_json = "";

        foreach($_POST as $key => $value){
            if($value != ""){
                $needle = "referenceImageList_";
                if(strpos($key, $needle) !== false){
                    array_push($vaReferenceImageList_array, $value);
                }
            }
        }
        
        if($vaReferenceImageList_array){
            $vaReferenceImageList_json = json_encode($vaReferenceImageList_array);
        }

        update_post_meta($post->ID, "referenceCategory", $_POST["referenceCategory"]);
        update_post_meta($post->ID, "referenceTeaser", $_POST["referenceTeaser"]);
        update_post_meta($post->ID, "referenceImageList", $vaReferenceImageList_json);
    }
}

function va_reference_edit_columns($columns){
    $columns = array(
        "cb" => "<input type=\"checkbox\" />",
        "title" => "Referentie",
        "referenceCategory" => "Categorie",
        "referenceTeaser" => "Afbeeldingen",
        "postVolgorde" => "Volgorde",
    );

    return $columns;
}

add_filter("manage_edit-reference_columns", "va_reference_edit_columns");
?>